<?php

namespace App\Models;

use App\BaseModels\BaseTemplateModel;
use App\Helpers\ApiConstant;
use Illuminate\Support\Facades\DB;

class TemplateModel extends BaseTemplateModel
{
    public function isTemplateExist($data)
    {
        $response = null;
        $response = $this::where('templates.name',$data['name']);
        if (!empty($data['id'])) {
            $response = $response->where('templates.id','<>',$data['id']);
        }
        $response = $response->first();
        return $response;
    }

    public function addTemplate($data)
    {
        $response = null;
        $this->name = $data['name'];
        $this->description = $data['description'];
        $this->subject = $data['subject'];
        if ($this->save()) {
            $response = $this;
        }
        return $response;
    }

    public function editTemplate($data)
    {
        $response = null;
        $id = $data['id'];
        $locationName = $data['name'];
        $subject = $data['subject'];
        $description = $data['description'];
        $response = $this::where('id', $id)->update(
            [
                'name' => $locationName,
                'description' => $description,
                'subject' => $subject,
            ]
        );
        return $response;
    }

    public function viewTemplates($limit)
    {
        $response = null;
        $response = $this::select('templates.id','templates.name','templates.subject','templates.description')
            ->orderBy('templates.id', 'desc')
            ->paginate($limit);
        return $response;
    }

    public function viewAllTemplatesData()
    {
        $response = null;
        $response = $this::select('templates.id','templates.name','templates.subject','templates.description')
            ->orderBy('templates.id', 'desc')
            ->get();
        return $response;
    }

    public function getTemplateById($data)
    {
        $response = null;
        $id = $data['id'];
        $response = $this::where('id', $id)
            ->select('templates.id','templates.name','templates.description','templates.subject')
            ->get();
        return $response;
    }

    public function deleteTemplate($id)
    {
        $response = null;
        $response = $this::where('templates.id', $id)->delete();
        return $response;
    }

    // function is used to view Item by search string from Items table.
    public function viewTemplatesBySearch ($data) {
        $searchInput = trim($data['search_input']);
        $response = null;
        $dataCount = null;
        $response = $this;
        if (isset($data['search_input']) && !empty($data['search_input'])) {
            $response = $response->where(function($query) use ($searchInput){

                $query->where('templates.name', 'LIKE', '%' . $searchInput . '%')
                    ->orWhere('templates.description', 'LIKE', '%' . $searchInput . '%')
                    ->orWhere('templates.subject', 'LIKE', '%' . $searchInput . '%');
            });
        }
        $response = $response->select('templates.description','templates.id','templates.name','templates.subject')
            ->paginate($data['limit']);
        return $response;
    }

    public function viewTemplateForGraph()
    {   $totalCount = 0;
        $response = BaseTemplateModel::join('rounds','rounds.id','=','templates.id_round')
            ->orderBy('templates.id', 'desc')
            ->select('templates.name', DB::raw('0 as total'))
            ->groupBy('templates.id')
            ->get();
        return array($response,$totalCount);
    }


    public function viewTemplateByRound($templateData)
    {
        $roundId = $templateData;
        $response = BaseTemplateModel::orderBy('templates.id', 'desc')->where('id_round', $roundId)->select('*')->get();
        return $response;
    }

    public function getTemplateDetailsById($templateId)
    {
        $response = BaseTemplateModel::where('id', $templateId)->first();
        return $response;
    }

}
