<?php
/**
 * Created by PhpStorm.
 * User: lt-73
 * Date: 22/1/18
 * Time: 4:01 PM
 */

namespace App\Models;

use App\BaseModels\BaseItemQuantityModel;
use App\BaseModels\BaseItemTagModel;
use App\BaseModels\BasePaymentFrequencyModel;
use App\BaseModels\BaseTagModel;
use App\BaseModels\BasePurchaseOrderModel;
use App\BaseModels\BasePurchaseOrderDetailsModel;
use App\Helpers\ApiConstant;
use Illuminate\Support\Facades\DB;
use File;

class PurchaseOrderModel extends BasePurchaseOrderModel
{
    public function savePurchaseOrder($data)
    {
        $returnData = null;
        $error = null;
        $vendorId = $data['vendor_id'] ?? null;
        $total_without_gst = $data['total_without_gst'] ?? null;
        $amount = $data['total_amount'] ?? null;
        $terms = $data['terms_data'] ?? null;
        $status = $data['status'] ?? null;
        $company_unit_id = $data['company_unit_id'] ?? null;
        $frequency = $data['frequency'] ?? null;
        $po_type = $data['po_type'] ?? null;
        $buyer = $data['buyer'] ?? null;
        $created_at = $data['created_date'] ?? null;
            $this->terms = $terms;
            $this->vendor_id = $vendorId;
            $this->total_amount = $amount;
            $this->total_without_gst = $total_without_gst;
            $this->frequency = $frequency;
            $this->po_type = $po_type;
            $this->status = $status;
            $this->company_unit_id = $company_unit_id;
            $this->buyer = $buyer;
            $this->created_date = $created_at;
            if ($this->save()) {
                return $this;
            } else {
                return false;
            }
    }

    public function updatePurchaseOrder($data)
    {
        $returnData = null;
        $error = null;
        $purchaseDetailsObj = null;
        $vendorId = $data['vendor_id'] ?? null;
        $amount = $data['total_amount'] ?? null;
        $total_without_gst = $data['total_without_gst'] ?? null;
        $terms = $data['terms_data'] ?? null;
        $purchaseId = $data['purchase_id'] ?? null;
        $buyer = $data['buyer'] ?? null;
        $status = $data['status'] ?? null;
        $frequency = $data['frequency'] ?? null;
        $company_unit_id = $data['company_unit_id'] ?? null;
        $unit_po_id = $data['unit_po_id'] ?? null;
        $po_type = $data['po_type'] ?? null;
        $createdDate = $data['created_date'] ?? null;
        $result = $this::where('vendor_id', $vendorId)
            ->where('id', $purchaseId)->update([
            'total_amount' => $amount,
            'total_without_gst' => $total_without_gst,
            'terms' => $terms,
            'frequency' => $frequency,
            'company_unit_id' => $company_unit_id,
            'unit_po_id' => $unit_po_id,
            'po_type' => $po_type,
            'status' => $status,
            'buyer' => $buyer,
            'created_date' => $createdDate
        ]);
        if ($result) {
            return $result = $this::where('purchase_orders.id', $purchaseId)
                ->join('po_statuses','purchase_orders.status', 'po_statuses.id' )
                ->first();
        }
    }



//    public function sendTestPurchaseOrder($data)
//    {
//
//    }
    public function getPurchaseOrder($data)
    {
        $result = null;
        $purchaseId = $data['purchase_id'] ?? null;
        $vendorId = $data['vendor_id'] ?? null;
        $result = $this::where('vendor_id', $vendorId)
            ->where('id', $purchaseId)->select('pdf_name')->first();
        return $result;
    }

    public function sendPurchaseOrder($data)
    {
        $error = null;
        $vendorId = $data['vendor_id'] ?? null;
        $pdf = $data['pdf_file'] ?? null;
        $purchaseId = $data['purchase_id'] ?? null;
        $status = 2;
        $result = $this::where('vendor_id', $vendorId)
            ->where('id', $purchaseId)->first();
        if($result) {
            $result->status = $status;
            $result->pdf_name = $pdf;
            $result->save();
        }
        return $result;
    }

    public function sendTestPurchaseOrder($data)
    {
        $error = null;
        $vendorId = $data['vendor_id'] ?? null;
        $pdf = $data['pdf_file'] ?? null;
        $purchaseId = $data['purchase_id'] ?? null;
        $status = 1;
        $result = $this::where('vendor_id', $vendorId)
            ->where('id', $purchaseId)->first();
        if($result) {
            $result->status = $status;
            $result->pdf_name = $pdf;
            $result->save();
        }
        return $result;
    }

    public function checkItemEntry($data)
    {
        $purchaseDetailsObj = new BasePurchaseOrderDetailsModel();
        $response = null;
        $response = $purchaseDetailsObj::where('purchase_id',$data['purchase_id'])->where('id_item',$data['id_item'])->first();
        return $response;
    }

    public function deletePurchaseOrderDetails($data)
    {
        $returnData = null;
        $error = null;
        $result = null;
        $deleteData = null;
        $purchaseDetailsObj = new BasePurchaseOrderDetailsModel();
        $deleteData['purchase_id'] = $data['purchase_id'];
        $deleteData['id_item'] = $data['id_item'];
        $result = $purchaseDetailsObj::where('purchase_id', $deleteData['purchase_id'])
            ->where('id_item', $deleteData['id_item']);
        if ($result->first()) {
            $result = $result->delete();
        }
        return $result;
    }

    public function updatePurchaseOrderDetails($data)
    {
        $returnData = null;
        $error = null;
        $result = null;
        $purchaseData = null;
        $purchaseData['price'] = $data['price'] ?? null;
        $purchaseData['purchase_id'] = $data['purchase_id'] ?? null;
        $purchaseData['id_item'] = $data['id_item'] ?? null;
        $purchaseData['quantity'] = isset($data['quantity']) ? $data['quantity'] : 0;
        $purchaseData['total'] = isset($data['total']) ? $data['total'] : 0;
        $purchaseData['gst'] = isset($data['gst']) ? $data['gst'] : 0;
        $purchaseDetailsObj = null;
        $purchaseDetailsObj = new BasePurchaseOrderDetailsModel();
            $result = $purchaseDetailsObj::where('purchase_id', $purchaseData['purchase_id'])
                ->where('id_item', $purchaseData['id_item'])->first();
            if ($result) {
              $result->total = $purchaseData['total'];
              $result->quantity = $purchaseData['quantity'];
              $result->price = $purchaseData['price'];
              $result->gst = $purchaseData['gst'];
              $result->save();
            } else {
                $result = $this->savePurchaseOrderDetails($purchaseData, $purchaseData['purchase_id']);
            }
            return ($result) ? true : false;
    }

    public function savePurchaseOrderDetails($data, $purchaseId)
    {
        $returnData = null;
        $error = null;
        $purchaseDetailsObj = null;
        $purchaseDetailsObj = new BasePurchaseOrderDetailsModel();
        $itemId = $data['id_item'] ?? null;
        $price = $data['price'] ?? null;
        $quantity = $data['quantity'] ?? null;
        $gst = $data['gst'] ?? 0;
        $total = $data['total'] ?? null;
        $purchaseDetailsObj->id_item = $itemId;
        $purchaseDetailsObj->price = $price;
        $purchaseDetailsObj->quantity = $quantity;
        $purchaseDetailsObj->gst = $gst;
        $purchaseDetailsObj->total = $total;
        $purchaseDetailsObj->purchase_id = $purchaseId;
        if ($purchaseDetailsObj->save()) {
            return true;
        } else {
            return false;
        }
    }

    public function viewPurchaseOrdersByDates($data, $frequency)
    {
        $responseData = null;
        $data['limit'] = isset($data['limit']) ? $data['limit'] : '';
        $createDate1 = date_create(str_replace("/","-",$data['from_date']));
        $createDate2 = date_create(str_replace("/","-",$data['to_date']));
        $from_date = date_format($createDate1, 'Y-m-d');
        $to_date = date_format($createDate2 , 'Y-m-d');
        $response = $this;

        if (isset($data['from_date']) && isset($data['from_date']) && !empty($data['from_date']) && !empty($data['from_date'])) {
            $response = $response->whereBetween(DB::raw("Date_format(STR_TO_DATE(replace(purchase_orders.created_date, '/', '-'), '%d-%m-%Y'), '%Y-%m-%d')"), [$from_date, $to_date]);
        }

        $response = $response->where('purchase_orders.po_type','Recurring')
            ->where('purchase_orders.frequency', $frequency)
            ->leftjoin('po_statuses','purchase_orders.status','po_statuses.id')
            ->leftjoin('vendors','vendors.id_user','purchase_orders.vendor_id')
            ->select('purchase_orders.frequency','purchase_orders.buyer','purchase_orders.vendor_id', 'vendors.company_name', 'purchase_orders.created_date', DB::raw("Exists(select id from purchase_order_details pod where pod.purchase_id = purchase_orders.id ) as isExist"),'purchase_orders.id', 'purchase_orders.vendor_id as vendorId', 'purchase_orders.total_amount','purchase_orders.po_type','purchase_orders.amount_recieved','po_statuses.name as status')
            ->orderBy('purchase_orders.id', 'desc')
            ->distinct('purchase_orders.id');
        $count = $response->get()->count();
        if(!empty($data['limit'])) {
            $responseData = $response->paginate($data['limit']);
        } else {
            $responseData = $response->get();
        }

        return Array($responseData, $count);
    }

    public function viewPurchaseOrderByFilters($data)
    {
        $response = $this;

        if ($data['status_id'] != 0) {
            $response = $response->where('purchase_orders.status',$data['status_id']);
        }

        if ($data['vendor_id'] != 0) {
            $response = $response->where('purchase_orders.vendor_id',$data['vendor_id']);
        }

        if ($data['unit_id'] != 0) {
            $response = $response->where('purchase_orders.company_unit_id',$data['unit_id']);
        }

        $response = $response->leftjoin('po_statuses','purchase_orders.status','po_statuses.id')
            ->leftjoin('vendors','vendors.id_user','purchase_orders.vendor_id')
            ->leftjoin('company_unit','purchase_orders.company_unit_id','company_unit.id')
            ->select('vendors.company_name', 'purchase_orders.created_date', DB::raw("Exists(select id from purchase_order_details pod where pod.purchase_id = purchase_orders.id ) as isExist"),'purchase_orders.id', 'purchase_orders.vendor_id as vendorId', 'purchase_orders.total_amount','purchase_orders.amount_recieved','po_statuses.name as status', 'company_unit.unit_name','company_unit.unit_suffix', 'purchase_orders.unit_po_id')
            ->orderBy('purchase_orders.id', 'desc')
            ->distinct('purchase_orders.id');
            $count = $response->get()->count();
        $responseData = $response->paginate($data['limit']);
        return Array($responseData, $count);
    }

    public function viewPurchaseOrder($data)
    {
        $response = null;
        $count = null;
        $hasDraft = null;

        $responseData = null;
        $response = $this::where('purchase_orders.vendor_id',$data['vendor_id'])
            ->leftjoin('po_statuses','purchase_orders.status','po_statuses.id')
            ->leftjoin('company_unit','purchase_orders.company_unit_id','company_unit.id')
            ->select(DB::raw("Exists(select id from purchase_order_details pod where pod.purchase_id = purchase_orders.id ) as isExist"),'purchase_orders.id', 'purchase_orders.total_amount','purchase_orders.amount_recieved','po_statuses.name as status', 'company_unit.unit_name', 'purchase_orders.created_date', 'company_unit.unit_suffix', 'purchase_orders.unit_po_id')
            ->orderBy('purchase_orders.id', 'desc')
            ->distinct('purchase_orders.id');
        $count = $response->get()->count();
        $responseData = $response->paginate(10);
        $draftResponse = $this::where('purchase_orders.vendor_id',$data['vendor_id'])
            ->where('purchase_orders.status',1)
            ->first();
        $hasDraft['hasDraft'] = empty($draftResponse) ? false : true;
        return array($responseData, $count, $hasDraft);
    }

    public function viewAllPurchaseOrder($data) {
        $response = null;
        $response = $this::where('purchase_orders.vendor_id',$data['vendor_id'])
            ->leftjoin('po_statuses','purchase_orders.status','po_statuses.id')
            ->select(DB::raw("Exists(select id from purchase_order_details pod where pod.purchase_id = purchase_orders.id ) as isExist"),'purchase_orders.id', 'purchase_orders.total_amount','purchase_orders.amount_recieved','po_statuses.name as status')
            ->orderBy('purchase_orders.id', 'desc')
            ->distinct('purchase_orders.id')
            ->get();
        return $response;
    }

    public function viewPurchaseOrderDetailsByPOId($id) {
        $response = null;
        $pucrhaseOrderDetaislObj = new BasePurchaseOrderDetailsModel;
        $response = $pucrhaseOrderDetaislObj->where('purchase_id',$id)
            ->get();
        return $response;
    }

    public function viewRecurringPoByVendor($data) {
        $response = null;
        $response = $this::where('purchase_orders.vendor_id',$data['vendor_id'])
            ->where('purchase_orders.po_type', 'Recurring')
            ->leftjoin('vendors', 'purchase_orders.vendor_id', 'vendors.id_user')
            ->leftjoin('po_statuses','purchase_orders.status','po_statuses.id')
            ->leftjoin('company_unit','purchase_orders.company_unit_id','company_unit.id')
            ->select(DB::raw("IFNULL(vendors.tds, 0) as tds_percentage"),
                DB::raw("Exists(select id from purchase_order_details pod where pod.purchase_id = purchase_orders.id ) as isExist"),'purchase_orders.id', 'purchase_orders.total_amount','purchase_orders.amount_recieved','po_statuses.name as status', 'company_unit.unit_suffix', 'purchase_orders.unit_po_id')
            ->orderBy('purchase_orders.id', 'desc')
            ->distinct('purchase_orders.id')
            ->get();
        return $response;
    }

    public function viewRecurringPoByFrequency($data) {
        $response = null;
        $response = $this::where('purchase_orders.frequency',$data)
            ->where('purchase_orders.po_type', 'Recurring')
            ->leftjoin('po_statuses','purchase_orders.status','po_statuses.id')
            ->select(DB::raw("Exists(select id from purchase_order_details pod where pod.purchase_id = purchase_orders.id ) as isExist"),'purchase_orders.id as purchase_id','purchase_orders.created_date', 'purchase_orders.total_amount','purchase_orders.amount_recieved as amount_paid','purchase_orders.vendor_id','purchase_orders.buyer','po_statuses.name as status')
            ->orderBy('purchase_orders.id', 'desc')
            ->distinct('purchase_orders.id')
            ->get();
        return $response;
    }

    public function viewNormalPoByVendor($data) {
        $response = null;
        $response = $this::where('purchase_orders.vendor_id',$data['vendor_id'])
            ->where('purchase_orders.po_type', 'Normal')
            ->leftjoin('po_statuses','purchase_orders.status','po_statuses.id')
            ->select(DB::raw("Exists(select id from purchase_order_details pod where pod.purchase_id = purchase_orders.id ) as isExist"),'purchase_orders.id', 'purchase_orders.total_amount','purchase_orders.amount_recieved','po_statuses.name as status')
            ->orderBy('purchase_orders.id', 'desc')
            ->distinct('purchase_orders.id')
            ->get();
        return $response;
    }

    public function viewPaymentFrequency() {
        $response = null;
        $paymentFrquencyObj = new BasePaymentFrequencyModel();
        $response = $paymentFrquencyObj->select('id', 'name')->get();
        return $response;
    }

    public function viewPurchaseDetailsByItemId($data) {
        $purchaseResponse = null;
        $response = null;
        $quantity = null;
        $purchaseDetailsObj = new BasePurchaseOrderDetailsModel();
        $purchaseResponse = $purchaseDetailsObj::where('purchase_id', $data['purchase_id'])
            ->where('id_item', $data['id_item'])->first();
//        dd($purchaseResponse->quantity);
        $itemLogsObject = new BaseItemQuantityModel();
        $response = $itemLogsObject::where('purchase_id',$data['purchase_id'])
            ->where('item_id', $data['id_item'])->select(DB::raw("SUM(item_quantity_logs.quantity) as quantity"))->first();
        $quantity = $purchaseResponse->quantity - $response->quantity;
        $purchaseResponse->quantity = $quantity;
        return $purchaseResponse;
    }

    public function viewPurchaseOrderById($data)
    {
        $response = null;
        $response = $this::where('purchase_orders.id',$data['purchase_id'])
            ->join('purchase_order_details','purchase_orders.id','purchase_order_details.purchase_id')
            ->join('items','purchase_order_details.id_item','items.id')
            ->leftJoin('units','items.unit','units.id')
            ->leftJoin('company_unit','purchase_orders.company_unit_id','company_unit.id')
            ->select('purchase_orders.*','purchase_order_details.*','items.name as item_name', 'units.unit', 'units.id', 'company_unit.unit_name as company_unit_name', 'company_unit.terms as company_unit_terms', 'company_unit.id as company_unit_id', 'company_unit.address as company_unit_address', 'company_unit.pan_number as company_unit_pan_number', 'company_unit.gst_number as company_unit_gst_number', 'company_unit.uin as company_uin_number', 'company_unit.unit_suffix')
            ->orderBy('purchase_orders.id', 'desc')
            ->distinct('purchase_orders.id', 'desc')
            ->get();

        $total = $this::where('purchase_orders.id',$data['purchase_id'])
            ->select('purchase_orders.total_amount')
            ->first();

        $terms = $this::where('purchase_orders.id',$data['purchase_id'])
            ->select('purchase_orders.terms')
            ->first();
        return array($response,$total,$terms);
    }

    public function viewPurchaseOrderDateById($data)
    {
        $response = null;
        $response = $this::where('id',$data['id'])
            ->select('created_date')->first();
        return $response;
    }

    public function checkPurchaseStatus($data)
    {
        $response = null;
        $vendorId = $data['vendor_id'];
        $response = $this::where('purchase_orders.status',1)
            ->where('purchase_orders.vendor_id',$vendorId)
            ->select(DB::raw("Exists(select id from purchase_order_details pod where pod.purchase_id = purchase_orders.id ) as isExist"),
                'purchase_orders.id','purchase_orders.vendor_id')
            ->first();
        return $response;
    }

    public function deletePurchaseOrderById($data)
    {
        $response = null;
        $purchaseDetailsObj = new BasePurchaseOrderDetailsModel();

        $responsePurchase = $this::where('purchase_orders.id',$data['purchase_id'])
            ->where('purchase_orders.vendor_id',$data['vendor_id'])
            ->delete();

        if(empty($responsePurchase)) {
            return $response = ApiConstant::ID_NOT_FOUND;
        }

        $responseDetails = $purchaseDetailsObj::where('purchase_order_details.purchase_id',$data['purchase_id'])
            ->delete();

        if ($responseDetails || $responsePurchase) {
            return $response = array("message" => ApiConstant::PURCHASE_DELETED);
        } else {
            return $response = ApiConstant::ID_NOT_FOUND;
        }

    }

}
