<?php
/**
 * Created by PhpStorm.
 * User: lt-73
 * Date: 19/2/18
 * Time: 8:14 PM
 */

namespace App\Models;

use App\BaseModels\BasePaymentFrequencyModel;
use App\BaseModels\BasePurchaseOrderModel;
use App\BaseModels\BaseVendorModel;
use File;
use App\BaseModels\BasePaymentDetailsModel;
use Illuminate\Support\Facades\DB;


class PaymentDetailsModel extends BasePaymentDetailsModel
{
    public function savePaymentDetails($data)
    {
        $response = null;
        $error = null;
        $paymentId = null;
        $amountToSave = null;
        $totalDeductions = null;
        $totalAmount = null;
        $purchaseObj = new BasePurchaseOrderModel();
        $this->payment_mode = $data['payment_mode'] ?? null;
        $this->payment_amount = $data['payment_amount'] ?? 0;
        $this->vendor_id = $data['vendor_id'] ?? null;
        $this->purchase_id = $data['purchase_id'] ?? null;
        $this->remark = $data['remark'];
        $this->tds_amount = $data['tds_amount'] ? $data['tds_amount'] : 0;
        $this->tds_percentage = $data['tds_percentage'] ? $data['tds_percentage'] : 0;
        $this->deductions = $data['deduction'];
        $this->transaction_number = $data['transaction_number'];
        $this->date = $data['date'] ?? null;
        $response = ($this->save()) ? $this : false;
        if ($response) {
            $paymentId = $response->id;
            $response = $this::where('purchase_id',$data['purchase_id'])
                ->where('vendor_id',$data['vendor_id']);
            $totalAmount = $response->sum('payment_details.payment_amount');
            $totalDeductions = $response->sum('payment_details.deductions');
            $totalTDS = $response->sum('payment_details.tds_amount');
            $amountToSave = $totalAmount - $totalDeductions - ($totalTDS ? $totalTDS : 0);
            $response = $purchaseObj::where('id',$data['purchase_id'])
                ->where('vendor_id',$data['vendor_id'])
                ->update(['amount_recieved' => $amountToSave]);
        }

        return $response;
    }

    public function updatePaymentAmount($data) {
        $amountToSave = $data['amount_paid'];
        $vendorId = $data['vendor_id'];
        $purchaseId = $data['purchase_id'];
        $response = null;
        $error = null;
        $purchaseObj = new BasePurchaseOrderModel();
        $response = $purchaseObj::where('id',$purchaseId)
            ->where('vendor_id',$vendorId)
            ->update(['amount_recieved' => $amountToSave]);
        return $response = $response ? $this : false;
    }

    public function updatePaymentDetails($data)
    {
        $returnData = null;
        $error = null;
        $response = null;
        $date = $data['date'] ?? null;
        $paymentMode = $data['payment_mode'] ?? null;
        $paymentId = $data['payment_id'] ?? null;
        $paymenAmount = $data['payment_amount'] ?? 0;
        $response = $this::where('id',$paymentId)->update([
            'date' => $date,
            'payment_mode' => $paymentMode,
            'payment_amount' => $paymenAmount,
        ]);
        return $response = ($response) ? true : false;
    }

    public function deletePayment($data)
    {
        $returnData = null;
        $error = null;
        $user = null;
        $deleteResponse = null;
        $response = null;
        $paymentId = $data['payment_id'] ?? null;
        $paymentObj = new BasePaymentDetailsModel();
        $response = $this::where('id', $paymentId)->first();
        $user['purchase_id'] = $response['purchase_id'];
        $user['vendor_id'] = $response['vendor_id'];
        // First delete the record from payment details table
        $deleteResponse = $this::where('id', $paymentId)->delete();
        if ($deleteResponse) {
            $response = $paymentObj::where('payment_details.vendor_id',$user['vendor_id'])
                ->where('payment_details.purchase_id',$user['purchase_id']);
            // calculated the sum for total and deductions
            $deduction = $response->sum('payment_details.deductions');
            $totalAmount = $response->sum('payment_details.payment_amount');
            $user['amount_paid'] = $totalAmount - $deduction;
            // update payment in the purchase order table.
            $response = $this::updatePaymentAmount($user);
        }
        return $response;
    }

    public function viewAllPaymentDetails($data)
    {
        $response = null;
        $response = $this::join('purchase_orders','payment_details.purchase_id', 'purchase_orders.id')
            ->leftjoin('vendors', 'purchase_orders.vendor_id', 'vendors.id_user')
            ->leftjoin('users', 'vendors.id_user', 'users.id')
            ->join('purchase_order_details', 'purchase_orders.id', 'purchase_order_details.purchase_id')
            ->leftjoin('company_unit','purchase_orders.company_unit_id', 'company_unit.id')
            ->select('users.email', 'purchase_order_details.id', 'purchase_orders.unit_po_id','users.name as contact_person_name','vendors.company_name', 'payment_details.deductions', 'purchase_orders.total_amount as total_amount_with_gst',
                DB::raw('sum(payment_amount) as payment_amount'),
                DB::raw('CONCAT(company_unit.unit_suffix, purchase_orders.unit_po_id) AS po_unit_id'), 'purchase_order_details.gst',
                DB::raw('round(purchase_orders.total_amount - round(sum((purchase_order_details.price) * (purchase_order_details.gst/100)),2)) as total_excluding_gst'),
                DB::raw('round(sum(purchase_order_details.total * (purchase_order_details.gst/100)),2) as gst_amount'),
                DB::raw('(payment_amount - payment_details.tds_amount) as actual_amount_paid'),
                'payment_details.payment_amount', 'payment_details.tds_amount', 'payment_details.tds_percentage', 'purchase_orders.id as po_id')
            ->groupBy('payment_details.id', 'purchase_orders.unit_po_id')
            ->orderby('purchase_orders.id','desc')
//            ->orderby('payment_details.id','desc')
            ->paginate($data['limit']);
        return $response;
    }

    public function viewPaymentDetails($data)
    {
        $vendorId = $data['vendor_id'];
        $PurchaseId = $data['purchase_id'];
        $response = null;
        $remainingAmount = null;
        $purchaseOrder = new BasePurchaseOrderModel();
        $vendorTable = new BaseVendorModel();
        $tds_percentage = $vendorTable::where('vendors.id_user', $vendorId)->select('vendors.tds')->first();

        $amounts['total_without_gst'] = $purchaseOrder::where('purchase_orders.id',$PurchaseId)
            ->leftjoin('purchase_order_details', 'purchase_orders.id', 'purchase_order_details.purchase_id')
            ->sum(\DB::raw('purchase_order_details.price * purchase_order_details.quantity'));

        $total = $purchaseOrder::where('purchase_orders.id',$PurchaseId)->where('vendor_id',$vendorId)
            ->leftjoin('company_unit', 'purchase_orders.company_unit_id', 'company_unit.id')
            ->select('purchase_orders.total_amount', 'company_unit.unit_suffix', 'purchase_orders.unit_po_id')->first();
        $amounts['deductions'] = $this::where('vendor_id',$vendorId)->where('purchase_id',$PurchaseId)->sum('deductions');
        $amounts['paid_amount'] = $this::where('vendor_id',$vendorId)->where('purchase_id',$PurchaseId)->sum('payment_amount');
        $amounts['tds_amount'] = $this::where('vendor_id',$vendorId)->where('purchase_id',$PurchaseId)->sum('tds_amount');

        $response = $this::where('payment_details.vendor_id',$vendorId)
            ->where('payment_details.purchase_id',$PurchaseId)
            ->leftjoin('purchase_orders', 'payment_details.purchase_id', 'purchase_orders.id')
            ->leftjoin('company_unit', 'purchase_orders.company_unit_id', 'company_unit.id')
            ->select('payment_details.*', 'company_unit.unit_suffix', 'purchase_orders.unit_po_id')
            ->orderBy('id', 'desc')
            ->paginate(10);



        $amounts['tds_percentage'] = isset($tds_percentage) ? $tds_percentage['tds'] : 0;

        $amounts['net_amount'] = $amounts['paid_amount'] - $amounts['deductions'] - $amounts['tds_amount'];

        $amounts['remaining'] = $total['total_amount'] - $amounts['paid_amount'];
        return array($response, $total, $amounts);
    }

    public function getPaymentDetails()
    {
        $response = null;
        $purchaseOrder = new BasePaymentFrequencyModel();
        $response = $purchaseOrder::select('payment_frequency.id','payment_frequency.name')->get();
        return $response;
    }
}
