<?php
/**
 * Created by PhpStorm.
 * User: lt-73
 * Date: 30/3/18
 * Time: 3:20 PM
 */

namespace App\Models;


use App\BaseModels\BaseItemLocationModel;
use App\BaseModels\BaseItemModel;

class ItemLocationModel extends BaseItemLocationModel
{

    public function getItemLocationById($data)
    {
        $response = null;
        $id = $data['id'];
        $response = $this::where('id', $id)
            ->select('items_location.id','items_location.name','items_location.description')
            ->get();
        return $response;
    }

    public function viewItemLocations($limit)
    {
        $response = null;
        $response = $this::select('items_location.id','items_location.name','items_location.description')
            ->orderBy('items_location.id', 'desc')
            ->paginate($limit);
        return $response;
    }

    public function viewAllItemLocations()
    {
        $response = null;
        $response = $this::select('items_location.id','items_location.name','items_location.description')
            ->orderBy('items_location.id', 'desc')
            ->get();
        return $response;
    }

    public function isItemLocationExist($data) {
        $response = null;
        $response = $this::where('items_location.name',$data['location_name']);
        if (!empty($data['id'])) {
            $response = $response->where('items_location.id','<>',$data['id']);
        }
        $response = $response->first();
        return $response;
    }

    public function addItemLocation($data)
    {
        $response = null;
        $this->name = $data['location_name'];
        $this->description = $data['description'];
        if ($this->save()) {
            $response = $this;
        }
        return $response;
    }

    public function editItemLocation($data)
    {
        $response = null;
        $id = $data['id'];
        $locationName = $data['location_name'];
        $description = $data['description'];
        $response = $this::where('id', $id)->update(
            [
                'name' => $locationName,
                'description' => $description,
            ]
        );
        return $response;
    }

    public function isItemLocationUsed($data)
    {
        $itemObject = new BaseItemModel;
        return $response = $itemObject::where('id', $data['id_item'])->where('location_id', $data['id'])->first();
    }

    public function deleteItemLocation($data)
    {
        $response = null;
        $id = $data['id'];
        $response = $this::where('id', $id)->delete();
        return $response;
    }
}