<?php
/**
 * Created by PhpStorm.
 * User: lt-73
 * Date: 12/7/18
 * Time: 9:53 PM
 */

namespace App\Models;


use App\BaseModels\BaseExpenseModel;
use App\BaseModels\BaseExpenseDetailsModel;
use App\BaseModels\BasePaymentDetailsModel;
use App\Helpers\ApiConstant;
use Illuminate\Support\Facades\DB;

class ExpenseModel extends BaseExpenseModel
{
    public function saveItemExpenseDetails($data, $expenseId)
    {
        $returnData = null;
        $unit = isset($data['unit_id']) ? $data['unit_id'] : 0;
        $gst = $data['gst'] ? $data['gst'] : 0;
        $expenseDetailsTable = new BaseExpenseDetailsModel;
        $expenseDetailsTable->item_id = $data['id_item'];
        $expenseDetailsTable->expense_id = $expenseId;
        $expenseDetailsTable->price = $data['price'];
        $expenseDetailsTable->quantity = $data['quantity'];
        $expenseDetailsTable->gst = $gst;
        $expenseDetailsTable->unit = $unit;
        if ($expenseDetailsTable->save()) {
            return $expenseDetailsTable;
        } else {
            return false;
        }
    }

    public function updateItemExpenseDetails($data, $expenseId)
    {
        $returnData = null;
        $expenseDetailsTable = new BaseExpenseDetailsModel;
        $data['id_item'] = isset($data['item_id']) ? $data['item_id'] : $data['id_item'];
        $data['item_id'] = isset($data['id_item']) ? $data['id_item'] : $data['item_id'];
        $unit = isset($data['unit_id']) ? $data['unit_id'] : 0;
        $gst = $data['gst'] ? $data['gst'] : 0;
        $result = $expenseDetailsTable::where('expense_details.expense_id', $expenseId)
            ->where('item_id', $data['item_id'])->first();
        if ($result) {
            $result->item_id = $data['item_id'];
            $result->quantity = $data['quantity'];
            $result->price = $data['price'];
            $result->gst = $gst;
            $result->unit = $unit;
            $result->save();
        } else {
            $data['id_item'] = $data['item_id'];
            $result = $this->saveItemExpenseDetails($data, $expenseId);
        }
        if ($result) {
            $returnData = ApiConstant::UPDATED_SUCCESSFULLY;
        }
        return $returnData;
    }

    public function saveExpenseDetails($data)
    {
        $returnData = null;
        $this->vendor_id = $data['vendor_id'];
        $this->purchase_id = $data['purchase_id'];
        $this->net_amount = $data['net_amount'];
        $this->item_id = 0;
        $this->price = 0;
        $this->quantity = 0;
        $this->cron_generated = isset($data['cron_generated']) ? $data['cron_generated'] : null;
        $this->gst = 0;
        $this->po_amount = 0;
        $this->payment_mode = $data['payment_mode'];
        $this->from_date = $data['from_date'];
        $this->to_date = $data['to_date'];
        $this->bill_date = $data['bill_date'];
        $this->payment_frequency = $data['payment_frequency'];
        $this->paid_by = $data['paid_by'];
        $this->invoice_number = $data['invoice_number'];
        $this->transaction_number = $data['transaction_number'];
        $this->remark = $data['remark'];
        $this->deductions = $data['deductions'];
        $this->is_paid = $data['is_paid'];
        $this->tds_percentage = $data['tds_percentage'];
        if ($this->save()) {
            return $this;
        } else {
            return false;
        }
    }

    public function updateExpenseDetails($data)
    {
        $returnData = null;
        $update = $this::where('id', $data['expense_id'])->update([
            'vendor_id' => $data['vendor_id'],
            'purchase_id' => $data['po_number'],
            'payment_mode' => $data['payment_mode'],
            'from_date' => $data['from_date'],
            'to_date' => $data['to_date'],
            'bill_date' => $data['bill_date'],
            'payment_frequency' => $data['payment_frequency'],
            'paid_by' => $data['paid_by'],
            'invoice_number' => $data['invoice_no'],
            'transaction_number' => $data['transaction_no'],
            'remark' => $data['remark'],
            'net_amount' => $data['net_amount'],
            'deductions' => $data['deductions'],
            'is_paid' => $data['payment_status'],
        ]);
        if ($update) {
            $returnData = ApiConstant::UPDATED_SUCCESSFULLY;
        }
        return $returnData;
    }

    public function viewExpenseDetails($limit) {
        $response = null;
        $response = $this::leftJoin('vendors', 'expenses.vendor_id','vendors.id_user')
        ->leftJoin('items', 'expenses.item_id','items.id')
        ->leftJoin('users', 'expenses.paid_by','users.id')
            ->select('expenses.*', 'vendors.company_name', 'items.name as item_name','users.name as paid_by_name')
            ->orderBy('id','desc')
            ->paginate($limit);
        return $response;
    }

    public function deleteExpenseDetails($deleteId)
    {
        $response = null;
        $expenseDetailsObj = new BaseExpenseDetailsModel();
        $response = $this::where('expenses.id', $deleteId)->delete();
        if ($response) {
            $response = $expenseDetailsObj::where('expense_details.expense_id', $deleteId)->delete();
        }
        return $response;
    }

    public function checkExpenseAvailableWithinDates($dates, $purchaseId) {
        $response = null;
        $response = $this->whereBetween(DB::raw("Date_format(STR_TO_DATE(replace(expenses.bill_date, '/', '-'), '%d-%m-%Y'), '%Y-%m-%d')"), [$dates['from_date'], $dates['to_date']])
            ->where('expenses.purchase_id', $purchaseId)
            ->first();
        return $response;
    }

    public function deleteExpenseItemDetails($itemId, $expenseId) {
        $response = null;
        $expenseDetailsObj = new BaseExpenseDetailsModel();
        $response = $expenseDetailsObj::where('expense_details.item_id', $itemId)
            ->where('expense_details.expense_id', $expenseId)->delete();
        return $response;
    }

    public function viewExpenseById($data) {
        $response = null;
        $expesneDetailsObj = new BaseExpenseDetailsModel();
        $response = $this::where('expenses.id', $data['expense_id'])
            ->leftJoin('vendors', 'expenses.vendor_id','vendors.id_user')
            ->select('expenses.vendor_id', 'expenses.purchase_id', 'expenses.payment_mode',
                'expenses.from_date', 'expenses.to_date', 'expenses.bill_date',
                'expenses.payment_frequency', 'expenses.payment_frequency', 'expenses.is_paid',
                'expenses.paid_by', 'expenses.remark', 'expenses.transaction_number', 'expenses.invoice_number',
                'expenses.net_amount','expenses.tds_percentage', 'expenses.deductions', 'vendors.company_name' )
            ->orderBy('expenses.id','desc')
            ->first();

        $response['items_data'] = $expesneDetailsObj::where('expense_details.expense_id', $data['expense_id'])
            ->leftJoin('units','expense_details.unit', 'units.id')
            ->leftJoin('items', 'expense_details.item_id', 'items.id')
            ->select('items.name as item_name', 'expense_details.*', 'expense_details.unit as unit_id', 'units.unit')
            ->get();
//        dd($response);
        return $response;
    }

    public function viewNormalExpensesByFilters($data) {
        $searchInput = trim($data['search_input']);
        $response = null;
        $dataCount = null;
        $createDate1 = date_create(str_replace("/","-",$data['from_date']));
        $createDate2 = date_create(str_replace("/","-",$data['to_date']));
        $from_date = date_format($createDate1, 'Y-m-d');
        $to_date = date_format($createDate2 , 'Y-m-d');
        $paymentDetailsObj = new BasePaymentDetailsModel();
        $response = $paymentDetailsObj;

        if (isset($data['from_date']) && isset($data['from_date']) && !empty($data['from_date']) && !empty($data['from_date'])) {
            $response = $response->whereBetween(DB::raw("Date_format(STR_TO_DATE(replace(payment_details.date, '/', '-'), '%d-%m-%Y'), '%Y-%m-%d')"), [$from_date, $to_date]);
        }

        if (isset($data['unitId']) && !empty($data['unitId'])) {
            $response = $response->where('purchase_orders.company_unit_id', $data['unitId']);
        }

        if (isset($data['search_input']) && !empty($data['search_input'])) {
            $response = $response->where(function($query) use ($searchInput){

                $query->orWhere('vendors.company_name', 'LIKE', '%' . $searchInput . '%')
                    ->orWhere('payment_details.purchase_id', 'LIKE', '%' . $searchInput . '%')
                    ->orWhere('payment_details.date', 'LIKE', '%' . $searchInput . '%')
                    ->orWhere('payment_details.payment_amount', 'LIKE', '%' . $searchInput . '%');
            });
        }

        $response = $response->where('purchase_orders.po_type','Normal')
            ->leftJoin('vendors', 'payment_details.vendor_id','vendors.id_user')
            ->leftJoin('purchase_orders', 'payment_details.purchase_id','purchase_orders.id')
            ->leftJoin('company_unit', 'purchase_orders.company_unit_id','company_unit.id')
            ->select('payment_details.*', 'vendors.company_name', 'purchase_orders.unit_po_id', 'company_unit.unit_suffix')
            ->orderBy('id','desc')
            ->paginate($data['limit']);
        return $response;
    }


    public function getMonthlyExpenses($data) {
        $response = null;
        $dataCount = null;
        $createDate1 = date_create(str_replace("/","-",$data['from_date']));
        $createDate2 = date_create(str_replace("/","-",$data['to_date']));
        $from_date = date_format($createDate1, 'Y-m-d');
        $to_date = date_format($createDate2 , 'Y-m-d');


        $response = $this;

        if (isset($data['from_date']) && isset($data['from_date']) && !empty($data['from_date']) && !empty($data['from_date'])) {
            $response = $response->whereBetween(DB::raw("Date_format(STR_TO_DATE(replace(expenses.bill_date, '/', '-'), '%d-%m-%Y'), '%Y-%m-%d')"), [$from_date, $to_date]);
        }

        $response = $response->where('purchase_orders.po_type','Recurring')
            ->where('expenses.payment_frequency', 3)
            ->leftJoin('expense_details', 'expenses.id', 'expense_details.expense_id')
            ->leftJoin('vendors', 'expenses.vendor_id','vendors.id_user')
            ->leftJoin('items', 'expenses.item_id','items.id')
            ->leftJoin('purchase_orders', 'expenses.purchase_id','purchase_orders.id')
            ->leftJoin('company_unit', 'purchase_orders.company_unit_id','company_unit.id')
            ->leftJoin('users', 'expenses.paid_by','users.id')
            ->select('expenses.*', 'vendors.company_name', 'items.name as item_name','users.name as paid_by_name', DB::raw('(CASE WHEN expenses.is_paid = "1" THEN "Paid" WHEN expenses.is_paid = "2" THEN "Unpaid" ELSE "" END) AS payment_status'), 'company_unit.unit_suffix', 'purchase_orders.unit_po_id',
                DB::raw('(sum(expense_details.price * expense_details.quantity) - expenses.deductions) * (expenses.tds_percentage/100) as tds_amount'))
            ->groupBy('expense_details.id')
            ->orderBy('id','desc')
            ->get();
        return $response;
    }

    public function getExpensesBydate($frequencyId, $date) {
        $response = $this::where('purchase_orders.po_type','Recurring')
            ->where('expenses.payment_frequency', '=', $frequencyId)
            ->where(DB::raw("Date_format(STR_TO_DATE(replace(expenses.bill_date, '/', '-'), '%d-%m-%Y'), '%Y-%m-%d')"), $date)
            ->leftJoin('payment_frequency', 'expenses.payment_frequency','payment_frequency.id')
            ->leftJoin('vendors', 'expenses.vendor_id','vendors.id_user')
            ->leftJoin('items', 'expenses.item_id','items.id')
            ->leftJoin('purchase_orders', 'expenses.purchase_id','purchase_orders.id')
            ->leftJoin('users', 'expenses.paid_by','users.id')
            ->select('expenses.*', 'vendors.company_name', 'items.name as item_name','users.name as paid_by_name', DB::raw('(CASE WHEN expenses.is_paid = "1" THEN "Paid" WHEN expenses.is_paid = "2" THEN "Unpaid" ELSE "" END) AS payment_status'))
            ->groupBy('expenses.id')
            ->orderBy('id','desc')
            ->get();
        return $response;
    }

    public function viewLatestRecurringExpensesByPOId($purchase_id) {
        $response = null;
        $response = $this::where('purchase_id', $purchase_id)->orderBy('id', 'desc')->first();
        return $response;
    }

    public function viewRecurringExpensesByFilters($data) {
        $searchInput = trim($data['search_input']);
        $response = null;
        $dataCount = null;
        $createDate1 = date_create(str_replace("/","-",$data['from_date']));
        $createDate2 = date_create(str_replace("/","-",$data['to_date']));
        $from_date = date_format($createDate1, 'Y-m-d');
        $to_date = date_format($createDate2 , 'Y-m-d');


        $response = $this;
        if (isset($data['payment_status']) && !empty($data['payment_status'])) {
            $response = $response->where('expenses.is_paid', $data['payment_status']);
        }

        if (isset($data['unitId']) && !empty($data['unitId'])) {
            $response = $response->where('purchase_orders.company_unit_id', $data['unitId']);
        }

        if (isset($data['from_date']) && isset($data['from_date']) && !empty($data['from_date']) && !empty($data['from_date'])) {
            $response = $response->whereBetween(DB::raw("Date_format(STR_TO_DATE(replace(expenses.bill_date, '/', '-'), '%d-%m-%Y'), '%Y-%m-%d')"), [$from_date, $to_date]);
        }

        if (isset($data['search_input']) && !empty($data['search_input'])) {
            $response = $response->where(function($query) use ($searchInput){

                $query->orWhere('vendors.company_name', 'LIKE', '%' . $searchInput . '%')
                    ->orWhere('expenses.purchase_id', 'LIKE', '%' . $searchInput . '%')
                    ->orWhere('expenses.net_amount', 'LIKE', '%' . $searchInput . '%')
                    ->orWhere('expenses.deductions', 'LIKE', '%' . $searchInput . '%')
                    ->orWhere('expenses.from_date', 'LIKE', '%' . $searchInput . '%')
                    ->orWhere('expenses.to_date', 'LIKE', '%' . $searchInput . '%')
                    ->orWhere('expenses.bill_date', 'LIKE', '%' . $searchInput . '%')
                    ->orWhere('users.name', 'LIKE', '%' . $searchInput . '%');
            });
        }

        $response = $response->where('purchase_orders.po_type','Recurring')
            ->leftJoin('expense_details', 'expenses.id', 'expense_details.expense_id')
            ->leftJoin('vendors', 'expenses.vendor_id','vendors.id_user')
            ->leftJoin('items', 'expenses.item_id','items.id')
            ->leftJoin('purchase_orders', 'expenses.purchase_id','purchase_orders.id')
            ->leftJoin('company_unit', 'purchase_orders.company_unit_id','company_unit.id')
            ->leftJoin('users', 'expenses.paid_by','users.id')
            ->select('expenses.*', 'vendors.company_name','purchase_orders.unit_po_id', 'company_unit.unit_suffix', 'items.name as item_name','users.name as paid_by_name', DB::raw('(CASE WHEN expenses.is_paid = "1" THEN "Paid" WHEN expenses.is_paid = "2" THEN "Unpaid" ELSE "" END) AS payment_status'),
                DB::raw('(sum(expense_details.price * expense_details.quantity) - expenses.deductions) * (expenses.tds_percentage/100) as tds_amount'))
            ->groupBy('expense_details.id')
            ->orderBy('id','desc')
            ->paginate($data['limit']);
        return $response;
    }
}
