<?php
/**
 * Created by PhpStorm.
 * User: lt-100
 * Date: 15/6/19
 * Time: 5:05 PM
 */

namespace App\Models;


use App\BaseModels\BaseCompanyUnitModel;
use App\BaseModels\BasePurchaseOrderModel;

class CompanyUnitModel extends BaseCompanyUnitModel
{
    public function isCompanyUnitExist($data)
    {
        $response = null;
        $response = $this::where('unit_name',$data['unit_name']);
        if (!empty($data['id'])) {
            $response = $response->where('company_unit.id','<>',$data['id']);
        }
        $response = $response->first();
        return $response;
    }

    public function addCompanyUnit($data)
    {
        $response = null;
        $this->unit_name = $data['unit_name'];
        $this->uin = $data['uin'];
        $this->pan_number = $data['pan_number'];
        $this->gst_number = $data['gst_number'];
        $this->address = $data['address'];
        $this->unit_suffix = $data['unit_suffix'];
        $this->terms = $data['description'];
        if ($this->save()) {
            $response = $this;
        }
        return $response;
    }

    public function editCompanyUnit($data)
    {
        $response = null;
        $id = (int)$data['id'];
        $unit_name = $data['unit_name'];
        $uin = $data['uin'];
        $pan_number = $data['pan_number'];
        $gst_number = $data['gst_number'];
        $address = $data['address'];
        $unit_suffix = $data['unit_suffix'];
        $description = $data['description'];
        $response = $this::where('id', $id)->update(
            [
                'unit_name' => $unit_name,
                'uin' => $uin,
                'pan_number' => $pan_number,
                'gst_number' => $gst_number,
                'unit_suffix' => $unit_suffix,
                'address' => $address,
                'terms' => $description,
            ]
        );
        return $response;
    }

    public function viewCompanyUnits($limit)
    {
        $response = null;
        $response = $this::select('company_unit.id', 'company_unit.unit_name', 'company_unit.gst_number', 'company_unit.pan_number', 'company_unit.address', 'company_unit.terms', 'company_unit.unit_suffix')
            ->orderBy('company_unit.id', 'desc')
            ->paginate($limit);
        return $response;
    }

    public function viewAllCompanyUnitsData()
    {
        $response = null;
        $response = $this::select('company_unit.id', 'company_unit.unit_name', 'company_unit.gst_number', 'company_unit.pan_number', 'company_unit.address', 'company_unit.terms')
            ->orderBy('company_unit.id', 'desc')
            ->get();
        return $response;
    }

    public function getCompanyUnitById($data)
    {
        $response = null;
        $id = $data['id'];
        $response = $this::where('id', $id)
            ->select('company_unit.id','company_unit.uin', 'company_unit.unit_name', 'company_unit.gst_number', 'company_unit.pan_number', 'company_unit.address', 'company_unit.terms','company_unit.unit_suffix')
            ->get();
        return $response;
    }

    public function getLatestPOCountBasedOnUnit($data) {
        $response = null;
        $id = $data['id'];
        $response = BasePurchaseOrderModel::where('purchase_orders.company_unit_id',$id)->orderBy('purchase_orders.id', 'desc')->first();
        return $response;
    }

//    public function getCompanyUnitByPurchaseId($data)
//    {
//        $response = null;
//        $id = $data['purchase_id'];
//        $poModel = new PurchaseOrderModel();
//        $response = $poModel::where('purchase_orders.id', $id)
//            ->select('company_unit.id','company_unit.uin', 'company_unit.unit_name', 'company_unit.gst_number', 'company_unit.pan_number', 'company_unit.address', 'company_unit.terms', 'purchase_orders.terms as po_terms')
//            ->get();
//        return $response;
//    }

    public function deleteCompanyUnit($id)
    {
        $response = null;
        $response = $this::where('company_unit.id', $id)->delete();
        return $response;
    }
}
