<?php
/**
 * Created by PhpStorm.
 * User: lt-73
 * Date: 5/12/17
 * Time: 8:40 PM
 */

namespace App\Http\Controllers;

use App\BaseModels\BasePaymentFrequencyModel;
use App\BaseModels\BasePurchaseOrderModel;
use App\Models\CandidateTagModel;
use App\Models\ExpenseModel;
use App\Models\PurchaseOrderModel;
use App\Models\TagModel;
use App\Models\TermModel;
use App\Models\UserModel;
use App\Models\UserRoleModel;
use App\Models\VendorItemsModel;
use App\Models\VendorModel;
use App\Helpers\ApiConstant;
use App\Models\VendorTagModel;
//use Faker\Provider\cs_CZ\DateTime;
use Illuminate\Http\Request;
use App\Helpers\AppUtility;
use Maatwebsite\Excel\Facades\Excel;
use Illuminate\Support\Facades\DB;
use Imagick;
use DateTime;
use Symfony\Component\Routing\Loader\AnnotationClassLoader;


class VendorController extends AppController
{

    // API is used to save tags
    public function loadMpdf()
    {
        require '../../../vendor/autoload.php';
    }

    public function addVendorTags(Request $request)
    {
        $response = null;
        $message = null;
        $userData = $request->input();
        $user['name'] = $userData['name'];
        $user['description'] = $userData['description'];
        $error = null;
        try {
            if (!empty($user)) {
                $tagModelObj = new TagModel();
                $tagResponse = $tagModelObj->isTagExistAndSave($user);
                if ($tagResponse) {
                    $response = array("message" => ApiConstant::TAG_ADDED_SUCCESSFULLY);
                } else {
                    $error = ApiConstant::TAG_EXIST;
                    $response = array("message" => ApiConstant::TAG_ALREADY_EXIST);
                }
            }
        } catch (\Exception $e) {
            $message = $e->getMessage();
            $error = ApiConstant::EXCEPTION_OCCURED;
        }
        return $this->returnableResponseData($response, $error, $message);
    }

    public function copyPurchaseOrder(Request $request)
    {
        $response = null;
        $message = null;
        $poResponse = null;
        DB::beginTransaction();
        $userData = $request->input();
        $todaysDate = getDate();  // this date format consist
        $dateToSave = $todaysDate['mday'].'/'.$todaysDate['mon'].'/'.$todaysDate['year'];
        $user['created_date'] = $dateToSave;
        $user['purchase_id'] = $userData['purchase_id'];
        $user['vendor_id'] = $userData['copyToId'];
        $user['buyer'] = $userData['buyer_id'];
        $user['status'] = 1;
        $error = null;
        try {
            if (!empty($user)) {
                $userModelObj = new PurchaseOrderModel();
                $purchaseOrderDetails = $userModelObj->viewPurchaseOrderById($user);
                if ($purchaseOrderDetails) {
                    $user['total_amount'] = $purchaseOrderDetails[1]->total_amount;
                    $user['total_without_gst'] = $purchaseOrderDetails[1]->total_without_gst;
                    $user['terms_data'] = $purchaseOrderDetails[2]->terms;
                    $user['purchase_data'] = $purchaseOrderDetails[0];
                    $todaysDate = getDate();  // this date format consist
                    $dateToSave = $todaysDate['mday'].'/'.$todaysDate['mon'].'/'.$todaysDate['year'];
                    $user['created_date'] = $dateToSave;
                    $purchaseModelObj = new PurchaseOrderModel();
                    $poResponse = $purchaseModelObj->savePurchaseOrder($user);
                    foreach ($user['purchase_data'] as $data) {
                        $data['purchase_id'] = $poResponse->id;
                        $tagResponse = $purchaseModelObj->updatePurchaseOrderDetails($data);
                        if ($tagResponse) {
                            $response = array("message" => ApiConstant::PURCHASE_ADDED_SUCCESSFULLY);
                            DB::commit();
                        } else {
                            $error = ApiConstant::ADD_PURCHASE_FAIL;
                        }
                    }
                    $response = array("message" => ApiConstant::TAG_ADDED_SUCCESSFULLY,
                        'purchase_id' => $data['purchase_id'],
                        'vendor_id' => $user['vendor_id']);
                } else {
                    $error = ApiConstant::TAG_EXIST;
                    $response = array("message" => ApiConstant::TAG_ALREADY_EXIST);
                }
            }
        } catch (\Exception $e) {
            DB::rollback();
            $message = $e->getMessage();
            $error = ApiConstant::EXCEPTION_OCCURED;
        }
        return $this->returnableResponseData($response, $error, $message);
    }


    public function editTags(Request $request)
    {
        $response = null;
        $message = null;
        $userData = $request->input();
        $user['name'] = $userData['name'];
        $user['id'] = $userData['id'];
        $user['description'] = $userData['description'];
        $error = null;
        try {
            if (!empty($user)) {
                $tagModelObj = new TagModel();
                $tagResponse = $tagModelObj->isTagExistAndUpdate($user);
                if ($tagResponse) {
                    $response = array("message" => ApiConstant::TAG_ADDED_SUCCESSFULLY);
                } else {
                    $error = ApiConstant::TAG_EXIST;
                    $response = array("message" => ApiConstant::TAG_ALREADY_EXIST);
                }
            }
        } catch (\Exception $e) {
            $message = $e->getMessage();
            $error = ApiConstant::EXCEPTION_OCCURED;
        }
        return $this->returnableResponseData($response, $error, $message);
    }

    // API is used to delete tags
    public function deleteVendorTags(Request $request)
    {
        $authenticatedUser = $request->user->id_user;
        $response = null;
        $error = null;
        $userData = $request->input();
        try {
            DB::beginTransaction();
            $userRoleModelObj = new UserRoleModel();
            $userRole = $userRoleModelObj->getUserRole($authenticatedUser);
            if ($userRole->id_role == 1 || $userRole->id_role == 2) {
                    $tagObj = new TagModel();
                    $response = $tagObj->deleteTag($userData['tag']);
                    if ($response == ApiConstant::ID_NOT_FOUND) {
                        $error = ApiConstant::ID_NOT_FOUND;
                    }
            }
        } catch (\Exception $e) {
            $error = ApiConstant::EXCEPTION_OCCURED;
            DB::rollback();
        }
        return $this->returnableResponseData($response, $error);
    }

    // API is used to add vendor to users table and vendors table.
    public function addVendor(Request $request)
    {
        $response = null;
        $error = null;
        $userData = $request->input();
        $userModelObj = new UserModel();
        $message = null;
        $email = AppUtility::check_email_address($userData['email']);
        if ($userData['alternate_email']){
            $alternateEmail = AppUtility::check_email_address($userData['alternate_email']);
        } else {
            $alternateEmail = true;
        }
        if ($email && $alternateEmail) {
                $user['name'] = $userData['vendor_name'];
                $user['company_name'] = $userData['company_name'];
                $user['email'] = $userData['email'];
                $user['alternate_email'] = $userData['alternate_email'];
                $user['address_one'] = $userData['address_one'];
                $user['address_two'] = $userData['address_two'];
                $user['contact_number'] = $userData['contact_number'];
                $user['alternate_contact_number'] = $userData['alternate_contact_number'];
                $user['city'] = $userData['city'];
                $user['state'] = $userData['state'];
                $user['pin_code'] = $userData['pin_code'];
                $user['tags'] = $userData['tags'];
                $user['role'] = 3;
//            } else {
//                $error = ApiConstant::EMAIL_NOT_VALID;
//            }
        } else {
            $error = ApiConstant::EMAIL_NOT_VALID;
        }
        try {
            if (!empty($user)) {
                $isUserEmailAlreadyExist = $userModelObj->isUserEmailValid($userData);
                $isUserContactAlreadyExist = $userModelObj->isUserContactValid($userData);
                if ($isUserEmailAlreadyExist == ApiConstant::EMAIL_ALREADY_EXIST) {
                    $error = $isUserEmailAlreadyExist;
                } else {
                    if ($isUserContactAlreadyExist == ApiConstant::CONTACT_NOT_FOUND) {
                        $error = $isUserContactAlreadyExist;
                    } else {
                        $userDetails = $userModelObj->saveUserDetails($user);
                        foreach ($user['tags'] as $tag) {
                            $trimTag = trim($tag);
                            $tagModelObj = new TagModel();
                            $tagResponse = $tagModelObj->isTagIdExist($trimTag);
                            if (!$tagResponse) {
                                $response = array("message" => ApiConstant::TAG_NOT_EXIST);
                            } else {
                                $user['id_tag'] = $tagResponse['id'];
                                $user['id'] = $userDetails['id'];
                                $candidateTagModelObj = new VendorTagModel();
                                $candidateTagResponse = $candidateTagModelObj->saveCandidateTag($user);
                                if ($candidateTagResponse) {
                                    $response = array("message" => ApiConstant::VENDOR_UPDATED_SUCCESSFULLY);
                                }
                            }
                        }
                        if ($userDetails == ApiConstant::DATA_NOT_SAVED) {
                            $error = $userDetails;
                        } else {

                            $userRoleModelObj = new UserRoleModel();
                            $userRole = $userRoleModelObj->insertUserRoleId($userDetails['id'], $user['role'], 'Active');
                            if ($userRole) {
                                $user['id'] = $userDetails['id'];
                                $userModelObj = new VendorModel();
                                $userDetails = $userModelObj->saveVendor($user);
                                if ($userDetails) {
                                    $response['vendor_id'] = $user['id'];
                                } else {
                                    $error = ApiConstant::APPLY_FAILED;
                                }
                            } else {
                                $error = ApiConstant::APPLY_FAILED;
                            }
                        }
                    }
                }
            }
        } catch (\Exception $e) {
            $message = $e->getMessage();
            $error = ApiConstant::EXCEPTION_OCCURED;
        }
        return $this->returnableResponseData($response, $error, $message);
    }

    // API is used to add vendor Items to vendors_item table.
    public function addVendorItems(Request $request)
    {
        $user = null;
        $response = null;
        $message = null;
        $userData = $request->input();
        $user['id_item'] = $userData['item_id'];
        $user['vendor_id'] = $userData['id'];
        $user['price'] = $userData['price'];
        $error = null;
        try {
            if (!empty($user)) {
                $tagModelObj = new VendorItemsModel();
                $tagResponse = $tagModelObj->saveVendorItem($user);
                if ($tagResponse == ApiConstant::ITEM_EXIST) {
                    $response = array("message" => ApiConstant::VENDOR_ITEM_ALREADY_EXIST);
                    $error = ApiConstant::ITEM_EXIST;
                } else {
                    $response = $tagResponse;
                }
            }
        } catch (\Exception $e) {
            $message = $e->getMessage();
            $error = ApiConstant::EXCEPTION_OCCURED;
        }
        return $this->returnableResponseData($response, $error, $message);
    }

    // API is used to view vendor Items from vendors_item table.
    public function viewAllVendorItems(Request $request)
    {
        $authenticatedUser = $request->user->id_user;
        $response = null;
        $error = null;
        try {
            $userModelObj = new VendorItemsModel();
            $userRoleModelObj = new UserRoleModel();
            $userRole = $userRoleModelObj->getUserRole($authenticatedUser);
            $inputData = $request->input();
            $data['id'] = $inputData['id'];
            if ($userRole->id_role == 1 || $userRole->id_role == 2 || $userRole->id_role == 3) {
                $response = $userModelObj->viewAllVendorItems($data);
            } else {
                $error = ApiConstant::USER_HAS_NO_PRIVILEGES;
            }
        } catch (\Exception $e) {
            print_r($e->getMessage());
            $error = ApiConstant::EXCEPTION_OCCURED;
        }
        return $this->returnableResponseData($response, $error);
    }

    // API is used to view vendor Items from vendors_item table.
    public function viewVendorItems(Request $request)
    {
        $authenticatedUser = $request->user->id_user;
        $response = null;
        $error = null;
        try {
            $userModelObj = new VendorItemsModel();
            $userRoleModelObj = new UserRoleModel();
            $userRole = $userRoleModelObj->getUserRole($authenticatedUser);
            $inputData = $request->input();
            $data['id'] = $inputData['id'];
            if ($userRole->id_role == 1 || $userRole->id_role == 2 || $userRole->id_role == 3) {
                $response = $userModelObj->viewVendorItems($data);
            } else {
                $error = ApiConstant::USER_HAS_NO_PRIVILEGES;
            }
        } catch (\Exception $e) {
            print_r($e->getMessage());
            $error = ApiConstant::EXCEPTION_OCCURED;
        }
        return $this->returnableResponseData($response, $error);
    }

    // API is used to view all vendor related to item from vendors Item table.
    public function viewItemVendors(Request $request)
    {
        $authenticatedUser = $request->user->id_user;
        $response = null;
        $error = null;
        try {
            $userModelObj = new VendorItemsModel();
            $userRoleModelObj = new UserRoleModel();
            $userRole = $userRoleModelObj->getUserRole($authenticatedUser);
            $inputData = $request->input();
            $data['id'] = $inputData['id'];
            if ($userRole->id_role == 1 || $userRole->id_role == 2 || $userRole->id_role == 3) {
                $response = $userModelObj->viewItemVendors($data);
            } else {
                $error = ApiConstant::USER_HAS_NO_PRIVILEGES;
            }
        } catch (\Exception $e) {
            print_r($e->getMessage());
            $error = ApiConstant::EXCEPTION_OCCURED;
        }
        return $this->returnableResponseData($response, $error);
    }

    // API is used to delete vendor Items from vendors_item table.
    public function deleteVendorItems(Request $request)
    {
        $authenticatedUser = $request->user->id_user;
        $response = null;
        $error = null;
        $userData = $request->input();
        $user['id_item'] = $userData['id'];
        $user['vendor_id'] = $userData['vendor_id'];
        try {
            $userRoleModelObj = new UserRoleModel();
            $userRole = $userRoleModelObj->getUserRole($authenticatedUser);
            if ($userRole->id_role == 1 || $userRole->id_role == 2) {
                $VendorItemModelObj = new VendorItemsModel();
                $response = $VendorItemModelObj->deleteVendorItem($user);
                if ($response == ApiConstant::ID_NOT_FOUND) {
                    $error = ApiConstant::ID_NOT_FOUND;
                }
            }
        } catch (\Exception $e) {
            $error = ApiConstant::EXCEPTION_OCCURED;
        }
        return $this->returnableResponseData($response, $error);
    }

    // API is used to view vendor names from vendors_item table.
    public function viewVendorNames(Request $request)
    {
        $authenticatedUser = $request->user->id_user;
        $response = null;
        $error = null;
        try {
            $userModelObj = new VendorModel();
            $userRoleModelObj = new UserRoleModel();
            $userRole = $userRoleModelObj->getUserRole($authenticatedUser);
            if ($userRole->id_role == 1 || $userRole->id_role == 2 || $userRole->id_role == 3) {
                $response = $userModelObj->viewVendorNames();
                if (!$response) {
                    $error = ApiConstant::GET_VENDOR_NAMES_FAIL;
                }
            } else {
                $error = ApiConstant::USER_HAS_NO_PRIVILEGES;
            }
        } catch (\Exception $e) {
            print_r($e->getMessage());
            $error = ApiConstant::EXCEPTION_OCCURED;
        }
        return $this->returnableResponseData($response, $error);
    }

    // API is used to view vendor names from vendors_item table.
    public function viewVendorsNoDraft(Request $request)
    {
        $authenticatedUser = $request->user->id_user;
        $response = null;
        $error = null;
        try {
            $userModelObj = new VendorModel();
            $userRoleModelObj = new UserRoleModel();
            $userRole = $userRoleModelObj->getUserRole($authenticatedUser);
            if ($userRole->id_role == 1 || $userRole->id_role == 2 || $userRole->id_role == 3) {
                $response = $userModelObj->viewVendorNamesNoDraft();
                if (!$response) {
                    $error = ApiConstant::GET_VENDOR_NAMES_FAIL;
                }
            } else {
                $error = ApiConstant::USER_HAS_NO_PRIVILEGES;
            }
        } catch (\Exception $e) {
            print_r($e->getMessage());
            $error = ApiConstant::EXCEPTION_OCCURED;
        }
        return $this->returnableResponseData($response, $error);
    }

    public function viewVendorNamesByItemId(Request $request)
    {
        $authenticatedUser = $request->user->id_user;
        $response = null;
        $error = null;
        $itemData = $request->input();
        $user['id_item'] = $itemData['id_item'];
        try {
            $userModelObj = new VendorModel();
            $userRoleModelObj = new UserRoleModel();
            $userRole = $userRoleModelObj->getUserRole($authenticatedUser);
            if ($userRole->id_role == 1 || $userRole->id_role == 2 || $userRole->id_role == 3) {
                $response = $userModelObj->viewVendorByItemId($user);
                if (!$response) {
                    $error = ApiConstant::GET_VENDOR_ITEM_FAIL;
                }
            } else {
                $error = ApiConstant::USER_HAS_NO_PRIVILEGES;
            }
        } catch (\Exception $e) {
            print_r($e->getMessage());
            $error = ApiConstant::EXCEPTION_OCCURED;
        }
        return $this->returnableResponseData($response, $error);
    }

    public function addPurchaseOrder(Request $request)
    {
        $response = null;
        $message = null;
        $data = null;
        $purchase_id = null;
        $purchaseStatus = $request->input();
        $user['status'] = $purchaseStatus['status'];
        $user['vendor_id'] = $purchaseStatus['vendor_id'];
        $user['total_amount'] = isset($purchaseStatus['total_amount']) ?? 0;
        $user['total_without_gst'] = isset($purchaseStatus['total_without_gst']) ?? 0;
        $user['company_unit_id'] = isset($purchaseStatus['company_unit_id']) ?? 0;
        $user['terms_data'] = isset($purchaseStatus['terms_data']) ?? '';
        $user['po_type'] = isset($purchaseStatus['po_type']) ?? '';
        $user['frequency'] = isset($purchaseStatus['frequency']) ?? 0;
        $error = null;
        $user['created_date'] = date('d/m/Y');
        try {
            if (!empty($user)) {
                DB::beginTransaction();
                $purchaseModelObj = new PurchaseOrderModel();
                $statusResponse = $purchaseModelObj->checkPurchaseStatus($user);
                // dd($statusResponse);
                if (!$statusResponse) {
                    $userModelObj = new VendorModel();
                    $statusResponse = $userModelObj->isTermsAssignedToVendor($user);
                    if ($statusResponse) {
                        if ($statusResponse->terms_tag) {
                            $statusResponse = $userModelObj->isVendorItemAttachedToVendor($user);
                            if (!empty($statusResponse)) {
                                $tagResponse = $purchaseModelObj->savePurchaseOrder($user);
                                if ($tagResponse) {
                                    $purchase_id = $tagResponse->id;
                                    $message = array("message" => ApiConstant::PURCHASE_ADDED_SUCCESSFULLY);
                                    $response['purchase_id'] = $purchase_id;
                                    DB::commit();
                                } else {
                                    $error = ApiConstant::ADD_PURCHASE_FAIL;
                                }
                            } else {
                                $error = ApiConstant::NO_VENDOR_ITEMS_ASSIGNED;
                            }
                        } else {
                            $error = ApiConstant::NO_TERMS_ASSIGNED;
                        }

                    } else {
                        $error = ApiConstant::ADD_PURCHASE_FAIL;
                    }

                } else {
                    $response = array("po_already_created" => '1', "message" => ApiConstant::PURCHASE_ORDER_ALREADY_CREATED,
                        "purchase_id" => $statusResponse->id,
                        "vendor_id" => $statusResponse->vendor_id,
                        "is_draft_submitted" => $statusResponse->isExist);
                }
            }
        } catch (\Exception $e) {
            $message = $e->getMessage();
            $error = ApiConstant::EXCEPTION_OCCURED;
            DB::rollback();
        }
        return $this->returnableResponseData($response, $error, $message);
    }

    public function editPurchaseOrder(Request $request)
    {
        $response = null;
        $result = null;
        $message = null;
        $purchaseStatus = $request->input();
        $user['status'] = $purchaseStatus['status'];
        $user['vendor_id'] = $purchaseStatus['vendor_id'];
        $user['purchase_id'] = $purchaseStatus['purchase_id'];
        $user['company_unit_id'] = isset($purchaseStatus['company_unit_id']) ? $purchaseStatus['company_unit_id'] : 0;
        $purchase_data = $purchaseStatus['purchase_data'];
        $delete_data = isset($purchaseStatus['delete_data']) ? $purchaseStatus['delete_data'] : '';
        $user['total_amount'] = $purchaseStatus['total_amount'];
        $user['total_without_gst'] = isset($purchaseStatus['total_without_gst']) ? $purchaseStatus['total_without_gst'] : 0;
        $user['unit_po_id'] = isset($purchaseStatus['unit_po_id']) ? $purchaseStatus['unit_po_id'] : 0;
        $user['terms_data'] = $purchaseStatus['terms_data'];
        $user['buyer'] = $purchaseStatus['buyer'];
        $user['po_type'] = isset($purchaseStatus['po_type']) ? $purchaseStatus['po_type'] : '';
        $user['frequency'] = isset($purchaseStatus['frequency']) ? $purchaseStatus['frequency'] : 0;
        $user['created_date'] = isset($purchaseStatus['created_date']) ? $purchaseStatus['created_date'] : '';

        $error = null;
        try {
            if (!empty($user)) {
                DB::beginTransaction();
                $purchaseOrderObj = new BasePurchaseOrderModel;
                $result = $purchaseOrderObj::where('id', $user['purchase_id'])->first();
                $purchaseModelObj = new PurchaseOrderModel();
                $tagResponse = $purchaseModelObj->updatePurchaseOrder($user);
                if ($tagResponse->status != $result->status) {
                    $message = 'Purchase order ' . strtolower($tagResponse->Name)  . ' successfully';
                } else {
                    $message = ApiConstant::PURCHASE_EDITED_SUCCESSFULLY;
                }
                if ($tagResponse) {
                    if($delete_data) {
                        foreach ($delete_data as $data) {
                            $tagResponse = $purchaseModelObj->deletePurchaseOrderDetails($data);
                            if (!$tagResponse) {
                                $error = ApiConstant::ADD_PURCHASE_FAIL;
                            }
                        }
                    }
                    foreach ($purchase_data as $data) {
                        $data['purchase_id'] = $user['purchase_id'];
                        $tagResponse = $purchaseModelObj->updatePurchaseOrderDetails($data);
                        if ($tagResponse) {
                            $response = array("message" => $message);
                            DB::commit();
                        } else {
                            $error = ApiConstant::ADD_PURCHASE_FAIL;
                        }
                    }
                } else {
                    $error = ApiConstant::ADD_PURCHASE_FAIL;
                }
            }
        } catch (\Exception $e) {
            $message = $e->getMessage();
            $error = ApiConstant::EXCEPTION_OCCURED;
            DB::rollback();
        }
        return $this->returnableResponseData($response, $error, $message);
    }

    public function buyItemsFromVendor(Request $request)
    {
        $response = null;
        $termsData = null;
        $updateResponse = null;
        $message = null;
        $itemsList = $request->input();
        $user['total_amount'] = '';
        $user['terms_data'] = '';
        $user['items_list'] = $itemsList['id_item_array'];
        $user['vendor_id'] = $itemsList['vendor_id'];
        $user['total_amount'] = isset($itemsList['total_amount']) ? $itemsList['total_amount'] : 0;
        $user['total_without_gst'] = isset($itemsList['total_without_gst']) ? $itemsList['total_without_gst'] : 0;
        $user['terms_data'] = isset($itemsList['terms_data']) ? $itemsList['terms_data'] : '';
        $user['created_date'] = date('d/m/Y');
        $error = null;
        $vendorObject = new VendorModel();
        try {
            $termsData = $vendorObject::where('id_user',$user['vendor_id'])->select('vendors.terms')->first();
            if (!empty($termsData->terms)) {
                if (!empty($user)) {
                    $purchaseModelObj = new PurchaseOrderModel();
                    $purchaseBaseModelObj = new BasePurchaseOrderModel();
                    $response = $purchaseModelObj->checkPurchaseStatus($user);
                    if (!$response) {
                        $user['status'] = 1;
                        $user['created_date'] = date('d/m/Y');
                        $response = $purchaseModelObj->savePurchaseOrder($user);
                        if (!$response) {
                            $error = ApiConstant::ADD_PURCHASE_FAIL;
                            return $this->returnableResponseData($response, $error, $message);
                        }
                    } else {
                        $user['purchase_id'] = $response->id;
                        $result = $purchaseBaseModelObj::where('id', $user['purchase_id'])->update([
                            'terms' => $user['terms_data'],
                        ]);
                        if (!$result) {
                            $error = ApiConstant::ADD_PURCHASE_FAIL;
                            return $this->returnableResponseData($response, $error, $message);
                        }
                    }
                    $user['total_amount'] = $response->total_amount;
                    $user['terms_data'] = $response->terms;
                    $user['purchase_id'] = $response->id;
                    foreach ($user['items_list'] as $data) {
                        $data['purchase_id'] = $user['purchase_id'];
                        $check = $purchaseModelObj->checkItemEntry($data);
                        if (empty($check)) {
                            $tagResponse = $purchaseModelObj->updatePurchaseOrderDetails($data);
                            if ($tagResponse) {
                                $response['purchase_id'] = $data['purchase_id'];
                                $response['message'] = array("message" => ApiConstant::PURCHASE_ADDED_SUCCESSFULLY);
                            } else {
                                $error = ApiConstant::ADD_PURCHASE_FAIL;
                            }
                        }
                    }
                } else {
                    $error = ApiConstant::EXCEPTION_OCCURED;
                }
            } else {
                $error = ApiConstant::NO_TERMS_ASSIGNED;
            }
        } catch (\Exception $e) {
            $message = $e->getMessage();
            $error = ApiConstant::EXCEPTION_OCCURED;
        }
        return $this->returnableResponseData($response, $error, $message);
    }

    public function downloadPurchaseOrder(Request $request)
    {
        $response = null;
        $message = null;
        $error = null;
        $data = $request->input();
        $sendData['purchase_data'] = isset($data['purchase_data']) ? $data['purchase_data'] : '';
        $sendData['total_amount'] = isset($data['total_amount']) ? $data['total_amount'] : '';
        $sendData['purchase_id'] = isset($data['purchase_id']) ? $data['purchase_id'] : '';
        $sendData['vendor_data'] = isset($data['vendor_data']) ? $data['vendor_data'] : '';
        $sendData['header'] = $data['header'];
        if ($sendData['purchase_id']) {
            $poObject = new BasePurchaseOrderModel();
            $terms = $poObject::where('purchase_orders.id',$sendData['purchase_id'])
                ->select('purchase_orders.terms','purchase_orders.created_date')
                ->first();
            $sendData['terms'] = $terms->terms;
            $sendData['created_date'] = $terms->created_date;
        }
        $pdfFileName = AppUtility::printPoTemplate($sendData);
        try {
            if (!empty($sendData)) {
                $file = public_path('purchase_orders/' . $pdfFileName. '.pdf');
                if ($file) {
                    $response = $pdfFileName;
                    $message = array("message" => ApiConstant::PURCHASE_DOWNLOAD_SUCCESSFULLY);
                } else {
                    $error = ApiConstant::EMPTY_VALUE;
                }
            }
        } catch (\Exception $e) {
            $message = $e->getMessage();
            $error = ApiConstant::EXCEPTION_OCCURED;
        }
        return $this->returnableResponseData($response, $error, $message);
    }

    public function sendPurchaseOrderBackend(Request $request)
    {
        $response = null;
        $now = new DateTime();
        $TodayDate = $now->getTimestamp();
        $data = $request->input();
        $message = null;
        $error = null;
        $pdfFileName = '';
        $terms = null;
        $hash = 1;
        $sendData['mailStatus']  = $data['mailStatus'] ? $data['mailStatus'] : null;
        $sendData['upload_files_array']  = isset($data['uploadFilesArray']) ? $data['uploadFilesArray'] : null;
        $sendData['vendor_id'] = $data['vendor_id'];
        $sendData['status'] = $data['status'];
        $subject = $data['subject'];
        if ($sendData['mailStatus'] == 'PO') {
            $fileName = 'pdf' . $TodayDate . '.pdf';
            $pdfFileName = 'pdf' . $TodayDate;
            $data['pdf_file'] = $pdfFileName;
            $sendData['purchase_data'] = isset($data['purchase_data']) ? $data['purchase_data'] : '';
            $sendData['total_amount'] = isset($data['total_amount']) ? $data['total_amount'] : '';
            $sendData['purchase_id'] = isset($data['purchase_id']) ? $data['purchase_id'] : '';
            $sendData['vendor_data'] = isset($data['vendor_data']) ? $data['vendor_data'] : '';
            if ($sendData['purchase_id']) {
                $poObject = new BasePurchaseOrderModel();
                $terms = $poObject::where('purchase_orders.id',$sendData['purchase_id'])
                    ->select('purchase_orders.terms','purchase_orders.created_date')
                    ->first();
                $sendData['terms'] = $terms->terms;
                $sendData['created_date'] = $terms->created_date;
            }
            $pdfFileName = AppUtility::purchaseOrderTemplate($sendData);
        }
        $poTemplate = $data['template'];
        $sendData['cc_array'] = $data['cc_array'];
        $sendData['email_array'] = $data['email_array'];


        try {
            if (!empty($data)) {
                $purchaseModelObj = new PurchaseOrderModel();
                $mailResponse = AppUtility::sendEmail($subject, $poTemplate, $sendData['email_array'], $sendData['cc_array'], $hash, $pdfFileName , $sendData['upload_files_array']);

                if ($mailResponse) {

                    if($sendData['mailStatus'] == 'PO') {
                        if ($sendData['status'] == 'Test') {
                            $mailResponse = $purchaseModelObj->sendTestPurchaseOrder($data);
                        } else {
                            $mailResponse = $purchaseModelObj->sendPurchaseOrder($data);
                        }
                    }

                    if ($mailResponse) {
                        $response = array("message" => ApiConstant::PURCHASE_ADDED_SUCCESSFULLY);
                    } else {
                        $error = ApiConstant::ADD_PURCHASE_FAIL;
                    }
                } else {
                    $error = ApiConstant::ADD_PURCHASE_FAIL;
                }
            } else {
                $error = ApiConstant::ADD_PURCHASE_FAIL;
            }
        } catch (\Exception $e) {
            $message = $e->getMessage();
            $error = ApiConstant::EXCEPTION_OCCURED;
        }
        return $this->returnableResponseData($response, $error, $message);

    }

    public function sendPurchaseOrder(Request $request)
    {
        $response = null;
        $message = null;
        $testMail = null;
        $hash = 1;
        $now = new DateTime();
        $TodayDate = $now->getTimestamp();
        $purchaseStatus = $request->input();
        $user['vendor_id'] = $purchaseStatus['vendor_id'];
        $user['purchase_id'] = $purchaseStatus['purchase_id'];
        $user['pdf'] = $purchaseStatus['pdf'];
        $subject = $purchaseStatus['subject'];
        $body = $purchaseStatus['template'];
        $emailList = $purchaseStatus['email'];
        $testMail = 'admin@tudip.com';
        $error = null;
        try {
            if ($user['pdf']) {
                $pdfSaved = null;
                $b64file = $user['pdf'];
                list($type, $b64file) = explode(';', $b64file);
                list(, $b64file) = explode(',', $b64file);
                $data = base64_decode($b64file);
                $pngFileName = 'image' . $TodayDate . '.png';
                $pdfFileName = 'pdf' . $TodayDate;
                file_put_contents($pngFileName, $data);
                $image = new Imagick($pngFileName);
                $image->setImageFormat('pdf');
                $pdfSaved = $image->writeImage(public_path('purchase_orders/' . $pdfFileName . '.pdf'));
                if ($pdfSaved) {
                    if (!empty($user)) {
                        $user['pdf_file'] = $pdfFileName;
                        $purchaseModelObj = new PurchaseOrderModel();
                        $mailResponse = AppUtility::sendEmail($subject, $body, $emailList, $hash, $pdfFileName . '.pdf');
                        if ($mailResponse) {
                            if ($emailList == $testMail) {
                                $mailResponse = $purchaseModelObj->sendTestPurchaseOrder($user);
                            } else {
                                $mailResponse = $purchaseModelObj->sendPurchaseOrder($user);
                            }

                            if ($mailResponse) {
                                $response = array("message" => ApiConstant::PURCHASE_ADDED_SUCCESSFULLY);
                            } else {
                                $error = ApiConstant::ADD_PURCHASE_FAIL;
                            }
                        } else {
                            $error = ApiConstant::ADD_PURCHASE_FAIL;
                        }

//                        if ($user['mail_status'] == 'Test') {
//                            $mailResponse = $purchaseModelObj->sendTestPurchaseOrder($user);
//                        } else {
//                            $mailResponse = $purchaseModelObj->sendPurchaseOrder($user);
//                        }
//                        if ($mailResponse) {
//                            $response = array("message" => ApiConstant::PURCHASE_ADDED_SUCCESSFULLY);
//                        } else {
//                            $error = ApiConstant::ADD_PURCHASE_FAIL;
//                        }
                    } else {
                        $error = ApiConstant::ADD_PURCHASE_FAIL;
                    }
                } else {
                    $error = ApiConstant::ADD_PURCHASE_FAIL;
                }
            }


        } catch (\Exception $e) {
            $message = $e->getMessage();
            $error = ApiConstant::EXCEPTION_OCCURED;
        }
        return $this->returnableResponseData($response, $error, $message);
    }

    public function viewPurchaseOrders(Request $request)
    {
        $authenticatedUser = $request->user->id_user;
        $response = null;
        $error = null;
        try {
            $purchaseModelObj = new PurchaseOrderModel();
            $userRoleModelObj = new UserRoleModel();
            $userRole = $userRoleModelObj->getUserRole($authenticatedUser);
            $inputData = $request->input();
            $data['vendor_id'] = $inputData['vendor_id'];
            if ($userRole->id_role == 1 || $userRole->id_role == 2 || $userRole->id_role == 3) {
                $response = $purchaseModelObj->viewPurchaseOrder($data);
                if (!$response) {
                    $error = ApiConstant::GET_PURCHASE_FAIL;
                }
            } else {
                $error = ApiConstant::USER_HAS_NO_PRIVILEGES;
            }
        } catch (\Exception $e) {
            print_r($e->getMessage());
            $error = ApiConstant::EXCEPTION_OCCURED;
        }
        return $this->returnableResponseData($response, $error);
    }

    public function viewPaymentFrequency(Request $request) {
        $authenticatedUser = $request->user->id_user;
        $response = null;
        $error = null;
        try {
            $purchaseModelObj = new PurchaseOrderModel();
            $userRoleModelObj = new UserRoleModel();
            $userRole = $userRoleModelObj->getUserRole($authenticatedUser);
            if ($userRole->id_role == 1 || $userRole->id_role == 2 || $userRole->id_role == 3) {
                $response = $purchaseModelObj->viewPaymentFrequency();
            } else {
                $error = ApiConstant::USER_HAS_NO_PRIVILEGES;
            }
        } catch (\Exception $e) {
            $error = ApiConstant::EXCEPTION_OCCURED;
        }
        return $this->returnableResponseData($response, $error);
    }


    public function viewAllPurchaseOrdersByVendor(Request $request)
    {
        $authenticatedUser = $request->user->id_user;
        $response = null;
        $response = null;
        $error = null;
        try {
            $purchaseModelObj = new PurchaseOrderModel();
            $userRoleModelObj = new UserRoleModel();
            $userRole = $userRoleModelObj->getUserRole($authenticatedUser);
            $inputData = $request->input();
            $data['vendor_id'] = $inputData['vendor_id'];
            if ($userRole->id_role == 1 || $userRole->id_role == 2 || $userRole->id_role == 3) {
                $response = $purchaseModelObj->viewAllPurchaseOrder($data);
                if (!$response) {
                    $error = ApiConstant::GET_PURCHASE_FAIL;
                }
            } else {
                $error = ApiConstant::USER_HAS_NO_PRIVILEGES;
            }
        } catch (\Exception $e) {
            print_r($e->getMessage());
            $error = ApiConstant::EXCEPTION_OCCURED;
        }
        return $this->returnableResponseData($response, $error);
    }


    public function viewRecurringPurchaseOrdersByVendorId(Request $request)
    {
        $authenticatedUser = $request->user->id_user;
        $response = null;
        $response = null;
        $error = null;
        try {
            $purchaseModelObj = new PurchaseOrderModel();
            $userRoleModelObj = new UserRoleModel();
            $userRole = $userRoleModelObj->getUserRole($authenticatedUser);
            $inputData = $request->input();
            $data['vendor_id'] = $inputData['vendor_id'];
            if ($userRole->id_role == 1 || $userRole->id_role == 2 || $userRole->id_role == 3) {
                $response = $purchaseModelObj->viewRecurringPoByVendor($data);
                if (!$response) {
                    $error = ApiConstant::GET_PURCHASE_FAIL;
                }
            } else {
                $error = ApiConstant::USER_HAS_NO_PRIVILEGES;
            }
        } catch (\Exception $e) {
            print_r($e->getMessage());
            $error = ApiConstant::EXCEPTION_OCCURED;
        }
        return $this->returnableResponseData($response, $error);
    }

    public function viewNormalPurchaseOrdersByVendorId(Request $request)
    {
        $authenticatedUser = $request->user->id_user;
        $response = null;
        $response = null;
        $error = null;
        try {
            $purchaseModelObj = new PurchaseOrderModel();
            $userRoleModelObj = new UserRoleModel();
            $userRole = $userRoleModelObj->getUserRole($authenticatedUser);
            $inputData = $request->input();
            $data['vendor_id'] = $inputData['vendor_id'];
            if ($userRole->id_role == 1 || $userRole->id_role == 2 || $userRole->id_role == 3) {
                $response = $purchaseModelObj->viewNormalPoByVendor($data);
                if (!$response) {
                    $error = ApiConstant::GET_PURCHASE_FAIL;
                }
            } else {
                $error = ApiConstant::USER_HAS_NO_PRIVILEGES;
            }
        } catch (\Exception $e) {
            print_r($e->getMessage());
            $error = ApiConstant::EXCEPTION_OCCURED;
        }
        return $this->returnableResponseData($response, $error);
    }

    public function viewPurchaseOrdersByFilters(Request $request)
    {
        $authenticatedUser = $request->user->id_user;
        $response = null;
        $response = null;
        $error = null;
        try {
            $purchaseModelObj = new PurchaseOrderModel();
            $userRoleModelObj = new UserRoleModel();
            $userRole = $userRoleModelObj->getUserRole($authenticatedUser);
            $inputData = $request->input();
            $data['limit'] = $inputData['limit'];
            $data['status_id'] = isset($inputData['status_id']) ? $inputData['status_id'] : 0;
            $data['vendor_id'] = isset($inputData['vendor_id']) ? $inputData['vendor_id'] : 0;
            $data['unit_id'] = isset($inputData['unit_id']) ? $inputData['unit_id'] : 0;
            if ($userRole->id_role == 1 || $userRole->id_role == 2 || $userRole->id_role == 3) {
                $response = $purchaseModelObj->viewPurchaseOrderByFilters($data);
                if (!$response) {
                    $error = ApiConstant::GET_PURCHASE_FAIL;
                }
            } else {
                $error = ApiConstant::USER_HAS_NO_PRIVILEGES;
            }
        } catch (\Exception $e) {
            print_r($e->getMessage());
            $error = ApiConstant::EXCEPTION_OCCURED;
        }
        return $this->returnableResponseData($response, $error);
    }

    public function deletePurchaseOrder(Request $request)
    {
        $authenticatedUser = $request->user->id_user;
        $response = null;
        $error = null;
        $userData = $request->input();
        $user['purchase_id'] = $userData['purchase_id'];
        $user['vendor_id'] = $userData['vendor_id'];

        try {
            $userRoleModelObj = new UserRoleModel();
            $userRole = $userRoleModelObj->getUserRole($authenticatedUser);
            if ($userRole->id_role == 1 || $userRole->id_role == 2) {
                $purchaseModelObj = new PurchaseOrderModel();
                $response = $purchaseModelObj->deletePurchaseOrderById($user);
                if ($response == ApiConstant::ID_NOT_FOUND) {
                    $error = ApiConstant::ID_NOT_FOUND;
                }
            }
        } catch (\Exception $e) {
            $error = ApiConstant::EXCEPTION_OCCURED;
        }
        return $this->returnableResponseData($response, $error);
    }

    public function viewPurchaseOrderById(Request $request)
    {
        $authenticatedUser = $request->user->id_user;
        $response = null;
        $response = null;
        $error = null;
        try {
            $purchaseModelObj = new PurchaseOrderModel();
            $userRoleModelObj = new UserRoleModel();
            $userRole = $userRoleModelObj->getUserRole($authenticatedUser);
            $inputData = $request->input();
            $data['purchase_id'] = $inputData['purchase_id'];
            if ($userRole->id_role == 1 || $userRole->id_role == 2 || $userRole->id_role == 3) {
                $response = $purchaseModelObj->viewPurchaseOrderById($data);
                if (!$response) {
                    $error = ApiConstant::GET_PURCHASE_FAIL;
                }
            } else {
                $error = ApiConstant::USER_HAS_NO_PRIVILEGES;
            }
        } catch (\Exception $e) {
            print_r($e->getMessage());
            $error = ApiConstant::EXCEPTION_OCCURED;
        }
        return $this->returnableResponseData($response, $error);
    }

    public function viewPurchaseOrderDateById(Request $request)
    {
        $authenticatedUser = $request->user->id_user;
        $response = null;
        $response = null;
        $error = null;
        try {
            $purchaseModelObj = new PurchaseOrderModel();
            $userRoleModelObj = new UserRoleModel();
            $userRole = $userRoleModelObj->getUserRole($authenticatedUser);
            $inputData = $request->input();
            $data['id'] = $inputData['id'];
            if ($userRole->id_role == 1 || $userRole->id_role == 2 || $userRole->id_role == 3) {
                $response = $purchaseModelObj->viewPurchaseOrderDateById($data);
                if (!$response) {
                    $error = ApiConstant::GET_PURCHASE_FAIL;
                }
            } else {
                $error = ApiConstant::USER_HAS_NO_PRIVILEGES;
            }
        } catch (\Exception $e) {
            print_r($e->getMessage());
            $error = ApiConstant::EXCEPTION_OCCURED;
        }
        return $this->returnableResponseData($response, $error);
    }

    public function viewPurchaseDetailsByItemId(Request $request) {
        $authenticatedUser = $request->user->id_user;
        $response = null;
        $response = null;
        $error = null;
        try {
            $purchaseModelObj = new PurchaseOrderModel();
            $userRoleModelObj = new UserRoleModel();
            $userRole = $userRoleModelObj->getUserRole($authenticatedUser);
            $inputData = $request->input();
            $data['purchase_id'] = $inputData['purchase_id'];
            $data['id_item'] = $inputData['id_item'];
            if ($userRole->id_role == 1 || $userRole->id_role == 2 || $userRole->id_role == 3) {
                $response = $purchaseModelObj->viewPurchaseDetailsByItemId($data);
                if (!$response) {
                    $error = ApiConstant::EXCEPTION_OCCURED;
                }
            } else {
                $error = ApiConstant::USER_HAS_NO_PRIVILEGES;
            }
        } catch (\Exception $e) {
            print_r($e->getMessage());
            $error = ApiConstant::EXCEPTION_OCCURED;
        }
        return $this->returnableResponseData($response, $error);
    }

    public function viewExpensesById(Request $request) {
        $authenticatedUser = $request->user->id_user;
        $response = null;
        $response = null;
        $error = null;
        try {
            $expenseModelObj = new ExpenseModel();
            $userRoleModelObj = new UserRoleModel();
            $userRole = $userRoleModelObj->getUserRole($authenticatedUser);
            $inputData = $request->input();
            $data['expense_id'] = $inputData['expense_id'];
            if ($userRole->id_role == 1 || $userRole->id_role == 2 || $userRole->id_role == 3) {
                $response = $expenseModelObj->viewExpenseById($data);
                if (!$response) {
                    $error = ApiConstant::EXCEPTION_OCCURED;
                }
            } else {
                $error = ApiConstant::USER_HAS_NO_PRIVILEGES;
            }
        } catch (\Exception $e) {
            print_r($e->getMessage());
            $error = ApiConstant::EXCEPTION_OCCURED;
        }
        return $this->returnableResponseData($response, $error);
    }

    // API is used to view items by serach string from Item table.
    public function viewRecurringExpensesByFilters(Request $request)
    {
        $authenticatedUser = $request->user->id_user;
        $response = null;
        $error = null;
        $user = null;
        $userData = $request->input();
        $user['search_input'] = $userData['search_input'];
        $user['from_date'] = isset($userData['from_date']) ? $userData['from_date'] : '';
        $user['to_date'] = isset($userData['to_date']) ? $userData['to_date'] : '';
        $user['payment_status'] = isset($userData['payment_status']) ? $userData['payment_status'] : '';
        $user['unitId'] = isset($userData['unitId']) ? $userData['unitId'] : '';
        $user['limit'] = $userData['limit'];
        try {
            $userModelObj = new ExpenseModel();
            $userRoleModelObj = new UserRoleModel();
            $userRole = $userRoleModelObj->getUserRole($authenticatedUser);
            if ($userRole->id_role == 1 || $userRole->id_role == 2 || $userRole->id_role == 3) {
                $response = $userModelObj->viewRecurringExpensesByFilters($user);
                if (!$response) {
                    $response = ApiConstant::GET_ITEMTAGS_FAIL;
                }
            } else {
                $error = ApiConstant::USER_HAS_NO_PRIVILEGES;
            }
        } catch (\Exception $e) {
            print_r($e->getMessage());
            $error = ApiConstant::EXCEPTION_OCCURED;
        }
        return $this->returnableResponseData($response, $error);
    }


    // API is used to view items by serach string from Item table.
    public function viewNormalExpensesByFilters(Request $request)
    {
        $authenticatedUser = $request->user->id_user;
        $response = null;
        $error = null;
        $user = null;
        $userData = $request->input();
        $user['search_input'] = $userData['search_input'];
        $user['from_date'] = isset($userData['from_date']) ? $userData['from_date'] : '';
        $user['to_date'] = isset($userData['to_date']) ? $userData['to_date'] : '';
        $user['limit'] = $userData['limit'];
        $user['unitId'] = isset($userData['unitId']) ? $userData['unitId'] : '';
        try {
            $userModelObj = new ExpenseModel();
            $userRoleModelObj = new UserRoleModel();
            $userRole = $userRoleModelObj->getUserRole($authenticatedUser);
            if ($userRole->id_role == 1 || $userRole->id_role == 2 || $userRole->id_role == 3) {
                $response = $userModelObj->viewNormalExpensesByFilters($user);
                if (!$response) {
                    $response = ApiConstant::GET_ITEMTAGS_FAIL;
                }
            } else {
                $error = ApiConstant::USER_HAS_NO_PRIVILEGES;
            }
        } catch (\Exception $e) {
            print_r($e->getMessage());
            $error = ApiConstant::EXCEPTION_OCCURED;
        }
        return $this->returnableResponseData($response, $error);
    }


    // API is used to view items by serach string from Item table.
    public function getMonthlyRecurringReport(Request $request)
    {
        $authenticatedUser = $request->user->id_user;
        $response = null;
        $error = null;
        $user = null;
        $userData = $request->input();
        $user['from_date'] = isset($userData['from_date']) ? $userData['from_date'] : '';
        $user['to_date'] = isset($userData['to_date']) ? $userData['to_date'] : '';
        try {
            $userModelObj = new ExpenseModel();
            $userRoleModelObj = new UserRoleModel();
            $userRole = $userRoleModelObj->getUserRole($authenticatedUser);
            if ($userRole->id_role == 1 || $userRole->id_role == 2 || $userRole->id_role == 3) {
                $response = $userModelObj->getMonthlyExpenses($user);
                $user['category_item_data'] = $response;
                $path = public_path('category_items/');
                $now = new DateTime();
                $TodayDate = $now->getTimestamp();
                $excelFileName = 'monthly_report_'. $TodayDate;
                $response = Excel::create($excelFileName, function($excel) use ($response) {
                    $excel->sheet('mySheet', function($sheet) use ($response)
                    {
//                              // Add row headers
                        $data = array('Purchase Id', 'Vendor Name',  'Bill From Date', 'Bill To Date', 'Bill Date', 'Deductions', 'TDS (%)', 'TDS Amount', 'Net Amount', 'Transaction Number' );
                        $sheet->fromArray(array($data), null, 'A1', false, false);

                        // Add data rows
                        foreach ($response as $row) {
                            $data = array(($row->unit_suffix.$row->unit_po_id), $row->company_name, $row->from_date,$row->to_date,$row->bill_date, $row->deductions, $row->tds_percentage, $row->tds_amount, $row->net_amount, $row->transaction_number );
                            $sheet->fromArray(array($data), null, 'A1', false, false);
                        }
                    });

                })->store('xls', $path);
                if ($response) {
                    $response = array("fileName" => $excelFileName .'.xls', 'status' => 'excel');
                }
                if (!$response) {
                    $response = ApiConstant::GET_ITEMTAGS_FAIL;
                }
            } else {
                $error = ApiConstant::USER_HAS_NO_PRIVILEGES;
            }
        } catch (\Exception $e) {
            print_r($e->getMessage());
            $error = ApiConstant::EXCEPTION_OCCURED;
        }
        return $this->returnableResponseData($response, $error);
    }

    public function addTermsConditions(Request $request)
    {
        $user = null;
        $response = null;
        $message = null;
        $tagResponse = null;
        $userData = $request->input();
        $user['terms'] = $userData['terms'];
        $user['categories'] = $userData['categories'];
//        print_r($user);die;
        $error = null;
        try {
            DB::beginTransaction();
            if (!empty($user)) {
                $termModelObj = new TermModel();
                $termResponse = $termModelObj->saveTerms($user['terms']);
//                print_r($tagResponse);die;
                if ($termResponse == ApiConstant::ITEM_EXIST) {
                    $response = array("message" => ApiConstant::VENDOR_ITEM_ALREADY_EXIST);
                    $error = ApiConstant::ITEM_EXIST;
                } else {
                    //$termModelObj = new TagModel();
//                    DB::commit();
                    foreach ($user['categories'] as $tag) {
                        $tagModelObj = new TagModel();
                        $tagResponse = $tagModelObj->saveTermsDetails($tag, $termResponse->id);
                    }
                    if ($tagResponse) {
                        DB::commit();
                        $response = $tagResponse;
                    } else {
                        $error = ApiConstant::ADD_TERMS_FAIL;
                    }

                }

            }
        } catch (\Exception $e) {
            $message = $e->getMessage();
            $error = ApiConstant::EXCEPTION_OCCURED;
            DB::rollback();
        }
        return $this->returnableResponseData($response, $error, $message);
    }

    public function editTermsConditions(Request $request)
    {
        $user = null;
        $response = null;
        $message = null;
        $tagResponse = null;
        $userData = $request->input();
        $user['terms'] = $userData['terms'];
        $user['term_id'] = $userData['term_id'];
        $user['categories'] = $userData['categories'];
        $user['delete_categories'] = $userData['delete_categories'] ?? null;
//        print_r($user);die;
        $error = null;
        try {
            DB::beginTransaction();
            if (!empty($user)) {
                $termModelObj = new TermModel();
                $termResponse = $termModelObj->updateTerms($user);
//                print_r($tagResponse);die;
                if ($termResponse == ApiConstant::ITEM_EXIST) {
                    $response = array("message" => ApiConstant::VENDOR_ITEM_ALREADY_EXIST);
                    $error = ApiConstant::ITEM_EXIST;
                } else {
                    //$termModelObj = new TagModel();
//                    DB::commit();
                    if ($user['delete_categories']) {
                        foreach ($user['delete_categories'] as $deleteTag) {
                            $tagModelObj = new TagModel();
                            $tagResponse = $tagModelObj->updateTermsEntry($deleteTag);
                        }
                    }
                    foreach ($user['categories'] as $tag) {
                        $tagModelObj = new TagModel();
                        $tagResponse = $tagModelObj->saveTermsDetails($tag, $user['term_id']);
                    }
                    if ($tagResponse) {
                        DB::commit();
                        $response = $tagResponse;
                    } else {
                        $error = ApiConstant::ADD_TERMS_FAIL;
                    }

                }

            }
        } catch (\Exception $e) {
            $message = $e->getMessage();
            $error = ApiConstant::EXCEPTION_OCCURED;
            DB::rollback();
        }
        return $this->returnableResponseData($response, $error, $message);
    }

    public function viewTermsAndTagDetails(Request $request)
    {
        $authenticatedUser = $request->user->id_user;
        $inputData = $request->input();
        $data = null;
        $response = null;
        $error = null;
        $data['page_number'] = isset($inputData['page_number']) ? ($inputData['page_number'] - 1) : 0;
        $data['limit'] = isset($inputData['limit']) ? $inputData['limit'] : 25;
        try {
            $userModelObj = new TagModel();
            $userRoleModelObj = new UserRoleModel();
            $userRole = $userRoleModelObj->getUserRole($authenticatedUser);
            if ($userRole->id_role == 1 || $userRole->id_role == 2 || $userRole->id_role == 3) {
                $response = $userModelObj->viewTerms($data);
                if (!$response) {
                    $response = ApiConstant::ADD_TERMS_FAIL;
                }
            } else {
                $error = ApiConstant::USER_HAS_NO_PRIVILEGES;
            }
        } catch (\Exception $e) {
            print_r($e->getMessage());
            $error = ApiConstant::EXCEPTION_OCCURED;
        }
        return $this->returnableResponseData($response, $error);
    }

    public function viewExpenseDetails(Request $request)
    {
        $authenticatedUser = $request->user->id_user;
        $inputData = $request->input();
        $data = null;
        $response = null;
        $error = null;
        $data['limit'] = isset($inputData['limit']) ? $inputData['limit'] : 25;
        try {
            $userModelObj = new ExpenseModel();
            $userRoleModelObj = new UserRoleModel();
            $userRole = $userRoleModelObj->getUserRole($authenticatedUser);
            if ($userRole->id_role == 1 || $userRole->id_role == 2 || $userRole->id_role == 3) {
                $response = $userModelObj->viewExpenseDetails($data['limit']);
                if (!$response) {
                    $response = ApiConstant::ADD_TERMS_FAIL;
                }
            } else {
                $error = ApiConstant::USER_HAS_NO_PRIVILEGES;
            }
        } catch (\Exception $e) {
            print_r($e->getMessage());
            $error = ApiConstant::EXCEPTION_OCCURED;
        }
        return $this->returnableResponseData($response, $error);
    }

    public function addExpenseDetails(Request $request)
    {
        DB::beginTransaction();
        $authenticatedUser = $request->user->id_user;
        $inputData = $request->input();
        $data = null;
        $response = null;
        $error = null;
        $data['vendor_id'] = $inputData['vendor_id'];
        $data['purchase_id'] = $inputData['po_number'] ? $inputData['po_number'] : 0;
        $data['payment_frequency'] = $inputData['payment_frequency'] ?? '';
        $data['invoice_number'] = $inputData['invoice_no'] ?? 0;
        $data['from_date'] = $inputData['from_date'] ?? '';
        $data['to_date'] = $inputData['to_date'] ?? '';
        $data['bill_date'] = $inputData['bill_date'] ?? '';
        $data['is_paid'] = $inputData['payment_status'] ?? null;
        $data['payment_mode'] = $inputData['payment_mode'] ?? '';
        $data['transaction_number'] = $inputData['transaction_no'] ?? '';
        $data['remark'] = $inputData['remark'] ?? '';
        $data['paid_by'] = $inputData['paid_by'] ?? '';
        $data['item_data'] = $inputData['item_details'] ?? [];
        $data['deductions'] = $inputData['deductions'] ?? 0;
        $data['net_amount'] = $inputData['net_amount'] ?? 0;
        $data['deductions'] = $inputData['deductions'] ?? 0;
        $data['tds_percentage'] = $inputData['tds_percentage'] ?? 0;
        try {
            $expenseModelObj = new ExpenseModel();
            $userRoleModelObj = new UserRoleModel();
            $userRole = $userRoleModelObj->getUserRole($authenticatedUser);
            if ($userRole->id_role == 1 || $userRole->id_role == 2 || $userRole->id_role == 3) {
                $response = $expenseModelObj->saveExpenseDetails($data);
                $data['expense_id'] = $response->id;
                if (!empty($response)) {
                    foreach ($data['item_data'] as $item) {
                        $response = $expenseModelObj->saveItemExpenseDetails($item, $data['expense_id']);
                        if ($response) {
                           DB::commit();
                        }
                    }
                } else {
                    $response = ApiConstant::ADD_TERMS_FAIL;
                }
//                if (!$response) {
//                    $response = ApiConstant::ADD_TERMS_FAIL;
//                }
            } else {
                $error = ApiConstant::USER_HAS_NO_PRIVILEGES;
            }
        } catch (\Exception $e) {
            DB::rollback();
            print_r($e->getMessage());
            $error = ApiConstant::EXCEPTION_OCCURED;
        }
        return $this->returnableResponseData($response, $error);
    }

    public function editExpenseDetails(Request $request)
    {
        $authenticatedUser = $request->user->id_user;
        $inputData = $request->input();
        $data = null;
        $response = null;
        $error = null;
        $data['expense_id'] = $inputData['expense_id'];
        $data['vendor_id'] = $inputData['vendor_id'];
        $data['po_number'] = $inputData['po_number'] ? $inputData['po_number'] : 0;
        $data['payment_frequency'] = $inputData['payment_frequency'] ?? '';
        $data['invoice_no'] = $inputData['invoice_no'] ?? 0;
        $data['from_date'] = $inputData['from_date'] ?? '';
        $data['to_date'] = $inputData['to_date'] ?? '';
        $data['bill_date'] = $inputData['bill_date'] ?? '';
        $data['payment_status'] = $inputData['payment_status'] ?? null;
        $data['payment_mode'] = $inputData['payment_mode'] ?? '';
        $data['transaction_no'] = $inputData['transaction_no'] ?? '';
        $data['remark'] = $inputData['remark'] ?? '';
        $delete_data = $inputData['delete_data'] ?? '';
        $data['paid_by'] = $inputData['paid_by'] ?? '';
        $data['item_data'] = $inputData['item_details'] ?? [];
        $data['deductions'] = $inputData['deductions'] ?? 0;
        $data['net_amount'] = $inputData['net_amount'] ?? 0;
        $data['deductions'] = $inputData['deductions'] ?? 0;
        try {
            $expenseModelObj = new ExpenseModel();
            $userRoleModelObj = new UserRoleModel();
            $userRole = $userRoleModelObj->getUserRole($authenticatedUser);
            if ($userRole->id_role == 1 || $userRole->id_role == 2 || $userRole->id_role == 3) {
                $response = $expenseModelObj->updateExpenseDetails($data);
                if (!empty($response)) {
                    if($delete_data) {
                        foreach ($delete_data as $itemData) {
                            $itemData['id_item'] = isset($itemData['item_id']) ? $itemData['item_id'] : $itemData['id_item'];
                            $itemData['item_id'] = isset($itemData['id_item']) ? $itemData['id_item'] : $itemData['item_id'];
                            $tagResponse = $expenseModelObj->deleteExpenseItemDetails($itemData['item_id'], $data['expense_id']);
                        }
                    }
                    foreach ($data['item_data'] as $item) {
                        $response = $expenseModelObj->updateItemExpenseDetails($item, $data['expense_id']);
                        if ($response) {
                            $response = array("message" => 'Expense edited successfully.');
                            DB::commit();
                        }
                    }
                } else {
                    $response = ApiConstant::ADD_TERMS_FAIL;
                }
            } else {
                $error = ApiConstant::USER_HAS_NO_PRIVILEGES;
            }
        } catch (\Exception $e) {
            print_r($e->getMessage());
            $error = ApiConstant::EXCEPTION_OCCURED;
        }
        return $this->returnableResponseData($response, $error);
    }

    public function deleteExpenses(Request $request)
    {
        $authenticatedUser = $request->user->id_user;
        $response = null;
        $error = null;
        $userData = $request->input();
        $user['expense_id'] = $userData['expense_id'];
        $expenseModelObj = new ExpenseModel();
        try {
            $userRoleModelObj = new UserRoleModel();
            $userRole = $userRoleModelObj->getUserRole($authenticatedUser);
            if ($userRole->id_role == 1 || $userRole->id_role == 2) {
                $response = $expenseModelObj->deleteExpenseDetails($user['expense_id']);
                if (empty($response)) {
                    $error = ApiConstant::ID_NOT_FOUND;
                }
            }
        } catch (\Exception $e) {
            $error = ApiConstant::EXCEPTION_OCCURED;
        }
        return $this->returnableResponseData($response, $error);
    }

    public function deleteTermsAndTagDetails(Request $request)
    {
        $authenticatedUser = $request->user->id_user;
        $response = null;
        $error = null;
        $userData = $request->input();
        $user['id_term'] = $userData['id_term'];
        $user['id_tag'] = $userData['id_tag'];
        try {
            DB::beginTransaction();
            $userRoleModelObj = new UserRoleModel();
            $userRole = $userRoleModelObj->getUserRole($authenticatedUser);
            if ($userRole->id_role == 1 || $userRole->id_role == 2) {
                $userModelObj = new TagModel();
                foreach ($user['id_tag'] as $tag) {
                    $response = $userModelObj->deleteTermsEntry($user['id_term'], $tag);
                }
                if ($response == ApiConstant::ID_NOT_FOUND) {
                    $error = ApiConstant::ID_NOT_FOUND;
                }
            }
        } catch (\Exception $e) {
            $error = ApiConstant::EXCEPTION_OCCURED;
            DB::rollback();
        }
        return $this->returnableResponseData($response, $error);
    }

    public function viewTermsAndTagDetailsById(Request $request)
    {
        $authenticatedUser = $request->user->id_user;
        $response = null;
        $error = null;
        try {
            $userModelObj = new VendorItemsModel();
            $userRoleModelObj = new UserRoleModel();
            $userRole = $userRoleModelObj->getUserRole($authenticatedUser);
            $inputData = $request->input();
            $data['id_term'] = $inputData['id_term'];
            if ($userRole->id_role == 1 || $userRole->id_role == 2 || $userRole->id_role == 3) {
                $tagObj = new TagModel();
                $termObj = new TermModel();
                $response = $termObj->isTermExist($data['id_term']);
                if ($response != ApiConstant::TAG_NOT_EXIST) {
                    $response[0] = $tagObj->viewTagsInTermsById($data['id_term']);
                    $response[1] = $termObj->viewTermsDataById($data['id_term']);
                } else {
                    $response = ApiConstant::TAG_NOT_EXIST;
                }
            } else {
                $error = ApiConstant::USER_HAS_NO_PRIVILEGES;
            }
        } catch (\Exception $e) {
            print_r($e->getMessage());
            $error = ApiConstant::EXCEPTION_OCCURED;
        }
        return $this->returnableResponseData($response, $error);
    }

    public function viewTermsDataByTagId(Request $request)
    {
        $authenticatedUser = $request->user->id_user;
        $response = null;
        $error = null;
        try {
            $inputData = $request->input();
            $data['id_tag'] = $inputData['id_tag'];
            $userModelObj = new TagModel();
            $userRoleModelObj = new UserRoleModel();
            $userRole = $userRoleModelObj->getUserRole($authenticatedUser);
            if ($userRole->id_role == 1 || $userRole->id_role == 2 || $userRole->id_role == 3) {
                $response = $userModelObj->viewTermsByTag($data['id_tag']);
                if (!$response) {
                    $error = ApiConstant::EXCEPTION_OCCURED;
                }
            } else {
                $error = ApiConstant::USER_HAS_NO_PRIVILEGES;
            }
        } catch (\Exception $e) {
            print_r($e->getMessage());
            $error = ApiConstant::EXCEPTION_OCCURED;
        }
        return $this->returnableResponseData($response, $error);
    }


}
