<?php

namespace App\Http\Controllers;

use App\Helpers\ApiConstant;
use App\Models\TemplateModel;
use App\Models\UserRoleModel;
use Illuminate\Http\Request;

class TemplateController extends AppController
{
    public function addTemplate(Request $request)
    {
        $response = null;
        $error = null;
        $userData = $request->input();
        $message = null;
        $template['name'] = $userData['name'];
        $template['subject'] = $userData['subject'];
        $template['description'] = $userData['description'];
        try {
            $templateModelObj = new TemplateModel();
            $isTemplateExist = $templateModelObj->isTemplateExist($template);
            if (empty($isTemplateExist)) {
                $templateDetails = $templateModelObj->addTemplate($template);
                if ($templateDetails) {
                    $message = array("message" => "Template added successfully");
                } else {
                    $error = ApiConstant::EXCEPTION_OCCURED;
                }
            } else {
                $error = ApiConstant::DUPLICATE_TEMPLATE;
            }

        } catch (\Exception $e) {
            $message = $e->getMessage();
            $error = ApiConstant::EXCEPTION_OCCURED;
        }
        return $this->returnableResponseData($response, $error, $message);
    }

    public function editTemplate(Request $request)
    {
        $response = null;
        $error = null;
        $userData = $request->input();
        $message = null;
        $template['id'] = $userData['id'];
        $template['name'] = $userData['name'];
        $template['subject'] = $userData['subject'];
        $template['description'] = $userData['description'];
        try {
            $templateModelObj = new TemplateModel();
            $isTemplateExist = $templateModelObj->isTemplateExist($template);
            if (empty($isTemplateExist)) {
                $templateDetails = $templateModelObj->editTemplate($template);
                if ($templateDetails) {
                    $message = array("message" => "Template edited successfully");
                } else {
                    $error = ApiConstant::EXCEPTION_OCCURED;
                }
            } else {
                $error = ApiConstant::DUPLICATE_TEMPLATE;
            }
        } catch (\Exception $e) {
            $message = $e->getMessage();
            $error = ApiConstant::EXCEPTION_OCCURED;
        }
        return $this->returnableResponseData($response, $error, $message);
    }

    public function getTemplates(Request $request)
    {
        $response = null;
        $error = null;
        $message = null;
        $userData = $request->input();
        try {
            $templateModelObj = new TemplateModel();
            $response = $templateModelObj->viewTemplates($userData['limit']);
            if(!$response) {
                $error = ApiConstant::EXCEPTION_OCCURED;
            }
        }catch (\Exception $e) {
            $message = $e->getMessage();
            $error = ApiConstant::EXCEPTION_OCCURED;
        }
        return $this->returnableResponseData($response, $error, $message);
    }

    public function getAllTemplates(Request $request)
    {
        $response = null;
        $error = null;
        $message = null;
        try {
            $templateModelObj = new TemplateModel();
            $response = $templateModelObj->viewAllTemplatesData();
            if(!$response) {
                $error = ApiConstant::EXCEPTION_OCCURED;
            }
        }catch (\Exception $e) {
            $message = $e->getMessage();
            $error = ApiConstant::EXCEPTION_OCCURED;
        }
        return $this->returnableResponseData($response, $error, $message);
    }

    public function getTemplatesById(Request $request)
    {
        $response = null;
        $error = null;
        $userData = $request->input();
        $message = null;
        $user['id'] = $userData['id'];
        try {
            $templateModelObj = new TemplateModel();
            $response = $templateModelObj->getTemplateById($user);
            if(!$response) {
                $error = ApiConstant::EXCEPTION_OCCURED;
            }
        }catch (\Exception $e) {
            $message = $e->getMessage();
            $error = ApiConstant::EXCEPTION_OCCURED;
        }
        return $this->returnableResponseData($response, $error, $message);
    }

    // API is used to view items by serach string from Item table.
    public function viewTemplatesBySearch(Request $request)
    {
        $authenticatedUser = $request->user->id_user;
        $response = null;
        $error = null;
        $user = null;
        $userData = $request->input();
        $user['search_input'] = $userData['search_input'];
        $user['limit'] = $userData['limit'];
        try {
            $userRoleModelObj = new UserRoleModel();
            $userRole = $userRoleModelObj->getUserRole($authenticatedUser);
            if ($userRole->id_role == 1 || $userRole->id_role == 2 || $userRole->id_role == 3) {
                $templateModelObj = new TemplateModel();
                $response = $templateModelObj->viewTemplatesBySearch($user);
                if (!$response) {
                    $response = ApiConstant::GET_ITEMTAGS_FAIL;
                }
            } else {
                $error = ApiConstant::USER_HAS_NO_PRIVILEGES;
            }
        } catch (\Exception $e) {
            print_r($e->getMessage());
            $error = ApiConstant::EXCEPTION_OCCURED;
        }
        return $this->returnableResponseData($response, $error);
    }


    public function view(Request $request)
    {
        $authenticatedUser = $request->user->id_user;
        $response = null;
        $error = null;
        try {
            $userRoleModelObj = new UserRoleModel();
            $userRole = $userRoleModelObj->getUserRole($authenticatedUser);
            if ($userRole->id_role == 1 || $userRole->id_role == 2 || $userRole->id_role == 4) {
                $template = new TemplateModel();
                $response = $template->viewTemplate();
            } else {
                $error = ApiConstant::USER_HAS_NO_PRIVILEGES;
            }
        } catch (\Exception $e) {
            $error = ApiConstant::EXCEPTION_OCCURED;
        }

        return $this->returnableResponseData($response, $error);
    }

    public function viewTemplateByRound(Request $request)
    {
        $authenticatedUser = $request->user->id_user;
        $response = null;
        $error = null;
        $templateData = $request->input();
        $roundId = $templateData['id_round'];
        try {
            $userRoleModelObj = new UserRoleModel();
            $userRole = $userRoleModelObj->getUserRole($authenticatedUser);
            if ($userRole->id_role == 1 || $userRole->id_role == 2 || $userRole->id_role == 4) {
                $template = new TemplateModel();
                $response = $template->viewTemplateByRound($roundId);
            } else {
                $error = ApiConstant::USER_HAS_NO_PRIVILEGES;
            }
        } catch (\Exception $e) {
            $error = ApiConstant::EXCEPTION_OCCURED;
        }

        return $this->returnableResponseData($response, $error);
    }

    public function getTemplateById(Request $request)
    {
        $authenticatedUser = $request->user->id_user;
        $response = null;
        $error = null;
        $templateInput = $request->input();
        $templateId = $templateInput['id'];

        try {
            $userRoleModelObj = new UserRoleModel();
            $userRole = $userRoleModelObj->getUserRole($authenticatedUser);
            if ($userRole->id_role == 1 || $userRole->id_role == 2 || $userRole->id_role == 4) {
                $template = new TemplateModel();
                $response = $template->getTemplateById($templateId);
            } else {
                $error = ApiConstant::USER_HAS_NO_PRIVILEGES;
            }
        } catch (\Exception $e) {
            $error = ApiConstant::EXCEPTION_OCCURED;
        }

        return $this->returnableResponseData($response, $error);
    }

    public function deleteTemplate(Request $request)
    {
        $authenticatedUser = $request->user->id_user;
        $response = null;
        $error = null;
        $templateInput = $request->input();
        $templateId = $templateInput['id'];

        try {
            $userRoleModelObj = new UserRoleModel();
            $userRole = $userRoleModelObj->getUserRole($authenticatedUser);
            if ($userRole->id_role == 1 || $userRole->id_role == 2 || $userRole->id_role == 4) {
                $template = new TemplateModel();
                $response = $template->deleteTemplate($templateId);
                if ($response) {
                    $message = array("message" => "Template deleted successfully");
                } else {
                    $error = ApiConstant::DELETE_FAIL;
                }
            } else {
                $error = ApiConstant::USER_HAS_NO_PRIVILEGES;
            }
        } catch (\Exception $e) {
            $error = ApiConstant::EXCEPTION_OCCURED;
        }
        return $this->returnableResponseData($response, $error);
    }

}
