<?php
/**
 * Created by PhpStorm.
 * User: lt-73
 * Date: 19/2/18
 * Time: 8:24 PM
 */

namespace App\Http\Controllers;
use App\Models\PaymentDetailsModel;
use App\Helpers\ApiConstant;
use DateTime;
use Illuminate\Http\Request;
use Maatwebsite\Excel\Facades\Excel;

class PaymentDetailsController extends AppController
{
    // API is used to add payment details of purchase order.
    public function addPaymentDetails(Request $request)
    {
        $response = null;
        $message = null;
        $userData = $request->input();
        $user['purchase_id'] = $userData['purchase_id'];
        $user['vendor_id'] = $userData['vendor_id'];
        $user['date'] = $userData['date'];
        $user['payment_mode'] = $userData['payment_mode'];
        $user['payment_amount'] = $userData['payment_amount'];
        $user['amount_received'] = $userData['amount_received'];
        $user['tds_amount'] = isset($userData['tds_amount']) ? $userData['tds_amount'] : 0;
        $user['tds_percentage'] = isset($userData['tds_percentage']) ? $userData['tds_percentage'] : 0;
        $user['remark'] = isset($userData['remark']) ? $userData['remark']: '';
        $user['deduction'] = isset($userData['deduction']) ? $userData['deduction'] : '';
        $user['transaction_number'] = isset($userData['transaction_number']) ? $userData['transaction_number'] : '';
        $user['amount_received'] = $userData['amount_received'];
        $error = null;
        try {
            if (!empty($user)) {
                $tagModelObj = new PaymentDetailsModel();
                $tagResponse = $tagModelObj->savePaymentDetails($user);
                if($tagResponse) {
                    $response = array("message" => ApiConstant::PAYMENT_ADDED_SUCCESSFULLY);
                } else {
                    $error = ApiConstant::ADD_PAYMENT_FAIL;
                }
            }
        } catch (\Exception $e) {
            $message = $e->getMessage();
            $error = ApiConstant::EXCEPTION_OCCURED;
        }
        return $this->returnableResponseData($response, $error, $message);
    }

    public function viewReportsByType(Request $request) {
//        viewReports
        $response = null;
        $message = null;
        $userData = $request->input();
        $error = null;
        try {
            $paymentModelObj = new PaymentDetailsModel();
            $tagResponse = $paymentModelObj->viewAllPaymentDetails($userData);
            if($tagResponse) {
                $response = $tagResponse;
            } else {
                $error = ApiConstant::ADD_PAYMENT_FAIL;
            }
        }
        catch (\Exception $e) {
            $message = $e->getMessage();
            $error = ApiConstant::EXCEPTION_OCCURED;
        }
        return $this->returnableResponseData($response, $error, $message);
    }

    public function exportTDSReportsByType(Request $request) {
//        viewReports
        $response = null;
        $message = null;
        $userData = $request->input();
        $error = null;
        try {
            $paymentModelObj = new PaymentDetailsModel();
            $response = $paymentModelObj->viewAllPaymentDetails($userData);
            $path = public_path('tds_reports/');
            $now = new DateTime();
            $TodayDate = $now->getTimestamp();
            $excelFileName = 'tds_report'. $TodayDate;
            if($userData['type'] == 'TDS') {
                $response = Excel::create($excelFileName, function($excel) use ($response) {
                    $excel->sheet('mySheet', function($sheet) use ($response)
                    {
//                              // Add row headers
                        $data = array('Vendor Name', 'PO Number', 'Amount without GST', 'GST Amount', 'Deductions', 'TDS (%)', 'TDS Amount', 'Paid Amount', 'Actual Paid Amount', 'Remaining Amount');
                        $sheet->fromArray(array($data), null, 'A1', false, false);

                        // Add data rows
                        foreach ($response as $row) {
                            $data = array($row->company_name, ($row->unit_suffix.$row->unit_po_id), $row->total_excluding_gst, $row->gst_amount, $row->deductions, $row->tds_percentage, $row->tds_amount, $row->payment_amount,$row->actual_amount_paid);
                            $sheet->fromArray(array($data), null, 'A1', false, false);
                        }
                    });

                })->store('xls', $path);
            } else {
                $response = Excel::create($excelFileName, function($excel) use ($response) {
                    $excel->sheet('mySheet', function($sheet) use ($response)
                    {
//                              // Add row headers
                        $data = array('Vendor Name', 'Contact Person Name', 'Email', 'PO Number', 'Amount without GST', 'GST Amount', 'Deductions', 'TDS (%)', 'TDS Amount', 'Paid Amount', 'Actual Paid Amount', 'Remaining Amount');
                        $sheet->fromArray(array($data), null, 'A1', false, false);

                        // Add data rows
                        foreach ($response as $row) {
                            $data = array($row->company_name, $row->contact_person_name, $row->email, ($row->unit_suffix.$row->unit_po_id), $row->total_excluding_gst, $row->gst_amount, $row->deductions, $row->tds_percentage, $row->tds_amount, $row->payment_amount,$row->actual_amount_paid);
                            $sheet->fromArray(array($data), null, 'A1', false, false);
                        }
                    });

                })->store('xls', $path);
            }

            if ($response) {
                $response = array("fileName" => $excelFileName .'.xls', 'status' => 'excel');
            }
            if (!$response) {
                $response = ApiConstant::ADD_PAYMENT_FAIL;
            }
        }
        catch (\Exception $e) {
            $message = $e->getMessage();
            $error = ApiConstant::EXCEPTION_OCCURED;
        }
        return $this->returnableResponseData($response, $error, $message);
    }

    // API is used to delete payment details of purchase order.
    public function deletePaymentDetails(Request $request)
    {
        $response = null;
        $message = null;
        $userData = $request->input();
        $user['payment_id'] = $userData['payment_id'];
        $error = null;
        try {
            if (!empty($user)) {
                $tagModelObj = new PaymentDetailsModel();
                $tagResponse = $tagModelObj->deletePayment($user);
                if($tagResponse) {
                    $response = array("message" => ApiConstant::PAYMENT_DELETED_SUCCESSFULLY);
                } else {
                    $error = ApiConstant::ADD_PAYMENT_FAIL;
                }
            }
        } catch (\Exception $e) {
            $message = $e->getMessage();
            $error = ApiConstant::EXCEPTION_OCCURED;
        }
        return $this->returnableResponseData($response, $error, $message);
    }

    // API is used to edit payment details of purchase order.
    public function editPaymentDetails(Request $request)
    {
        $response = null;
        $message = null;
        $userData = $request->input();
        $user['payment_id'] = $userData['payment_id'];
        $user['date'] = $userData['date'];
        $user['payment_mode'] = $userData['payment_mode'];
        $user['payment_amount'] = $userData['payment_amount'];
        $error = null;
        try {
            if (!empty($user)) {
                $tagModelObj = new PaymentDetailsModel();
                $tagResponse = $tagModelObj->updatePaymentDetails($user);
                if($tagResponse) {
                    $response = array("message" => ApiConstant::PAYMENT_ADDED_SUCCESSFULLY);
                } else {
                    $error = ApiConstant::ADD_PAYMENT_FAIL;
                }
            }
        } catch (\Exception $e) {
            $message = $e->getMessage();
            $error = ApiConstant::EXCEPTION_OCCURED;
        }
        return $this->returnableResponseData($response, $error, $message);
    }

    // API is used to get payment details of purchase order by vendor_id and purchase_id.
    public function getPaymentDetails(Request $request)
    {
        $response = null;
        $message = null;
        $error = null;
        $tagResponse = null;
        $userData = $request->input();
        $user['vendor_id'] = $userData['vendor_id'];
        $user['purchase_id'] = $userData['purchase_id'];
        try {
            if (!empty($user)) {
                $tagModelObj = new PaymentDetailsModel();
                $response = $tagModelObj->viewPaymentDetails($user);
                if($response) {
                    $message = array("message" => ApiConstant::PAYMENT_ADDED_SUCCESSFULLY);
                } else {
                    $error = ApiConstant::ADD_PAYMENT_FAIL;
                }
            }
        } catch (\Exception $e) {
            $message = $e->getMessage();
            $error = ApiConstant::EXCEPTION_OCCURED;
        }
        return $this->returnableResponseData($response, $error, $message);
    }

}
