<?php
/**
 * Created by PhpStorm.
 * User: lt-100
 * Date: 15/6/19
 * Time: 4:33 PM
 */

namespace App\Http\Controllers;


use App\BaseModels\BaseCompanyUnitModel;
use App\Helpers\ApiConstant;
use App\Models\CompanyUnitModel;
use App\Models\PurchaseOrderModel;
use App\Models\UserRoleModel;
use Illuminate\Http\Request;

class CompanyUnitController extends AppController
{
    public function addCompanyUnit(Request $request)
    {
        $response = null;
        $error = null;
        $userData = $request->input();
        $message = null;
        $unit['unit_name'] = $userData['unit_name'];
        $unit['uin'] = $userData['uin'];
        $unit['pan_number'] = $userData['pan_number'];
        $unit['gst_number'] = $userData['gst_number'];
        $unit['address'] = $userData['address'];
        $unit['unit_suffix'] = $userData['unit_suffix'];
        $unit['description'] = $userData['terms_conditions'];
        try {
            $templateModelObj = new CompanyUnitModel();
            $isTemplateExist = $templateModelObj->isCompanyUnitExist($unit);
            if (empty($isTemplateExist)) {
                $templateDetails = $templateModelObj->addCompanyUnit($unit);
                if ($templateDetails) {
                    $message = array("message" => "Unit added successfully");
                } else {
                    $error = ApiConstant::EXCEPTION_OCCURED;
                }
            } else {
                $error = ApiConstant::DUPLICATE_TEMPLATE;
            }

        } catch (\Exception $e) {
            $message = $e->getMessage();
            $error = ApiConstant::EXCEPTION_OCCURED;
        }
        return $this->returnableResponseData($response, $error, $message);
    }

    public function editCompanyUnit(Request $request)
    {
        $response = null;
        $error = null;
        $userData = $request->input();
        $message = null;
        $unit['unit_name'] = $userData['unit_name'];
        $unit['uin'] = $userData['uin'];
        $unit['id'] = $userData['id'];
        $unit['pan_number'] = $userData['pan_number'];
        $unit['gst_number'] = $userData['gst_number'];
        $unit['address'] = $userData['address'];
        $unit['unit_suffix'] = $userData['unit_suffix'];
        $unit['description'] = $userData['terms_conditions'];
        try {
            $templateModelObj = new CompanyUnitModel();
            $isTemplateExist = $templateModelObj->isCompanyUnitExist($unit);
            if (empty($isTemplateExist)) {
                $templateDetails = $templateModelObj->editCompanyUnit($unit);
                $message = array("message" => "Unit edited successfully");
            } else {
                $error = ApiConstant::DUPLICATE_TEMPLATE;
            }

        } catch (\Exception $e) {
            $message = $e->getMessage();
            $error = ApiConstant::EXCEPTION_OCCURED;
        }
        return $this->returnableResponseData($response, $error, $message);
    }

    public function getCompanyUnits(Request $request)
    {
        $response = null;
        $error = null;
        $message = null;
        $userData = $request->input();
        try {
            $templateModelObj = new CompanyUnitModel();
            $response = $templateModelObj->viewCompanyUnits($userData['limit']);
            if(!$response) {
                $error = ApiConstant::EXCEPTION_OCCURED;
            }
        }   catch (\Exception $e) {
            $message = $e->getMessage();
            $error = ApiConstant::EXCEPTION_OCCURED;
        }
        return $this->returnableResponseData($response, $error, $message);
    }

    public function viewAllCompanyUnits(Request $request)
    {
        $response = null;
        $error = null;
        $message = null;
        try {
            $templateModelObj = new CompanyUnitModel();
            $response = $templateModelObj->viewAllCompanyUnitsData();
            if(!$response) {
                $error = ApiConstant::EXCEPTION_OCCURED;
            }
        }catch (\Exception $e) {
            $message = $e->getMessage();
            $error = ApiConstant::EXCEPTION_OCCURED;
        }
        return $this->returnableResponseData($response, $error, $message);
    }

    public function getCompanyUnitById(Request $request)
    {
        $response = null;
        $companyResponse = null;
        $checkTerms = null;
        $error = null;
        $userData = $request->input();
        $message = null;
        $user['id'] = $userData['id'];
        $user['purchase_id'] = isset($userData['purchase_id']) ? $userData['purchase_id'] : 0;
        try {
            $templateModelObj = new CompanyUnitModel();
            $response = $templateModelObj->getCompanyUnitById($user);
            $LastPoCount = $templateModelObj->getLatestPOCountBasedOnUnit($user);
            if (!empty($user['purchase_id'])) {
                $purchaseOrder = new PurchaseOrderModel();
                $poResponse = $purchaseOrder->viewPurchaseOrderById($user);
                $companyTerms = (sizeof($response) > 0) ? $response[0]['terms'] : '';
                $poTerms = (sizeof($poResponse) > 0) ? $poResponse[0][0]['terms'] : '';
                $response[0]['terms'] = $poTerms . $companyTerms;
            }
            $response[0]['updated_po_number'] = ($LastPoCount['unit_po_id']) ? $LastPoCount['unit_po_id'] : 0;
            if(!$response) {
                $error = ApiConstant::EXCEPTION_OCCURED;
            }
        }catch (\Exception $e) {
            $message = $e->getMessage();
            $error = ApiConstant::EXCEPTION_OCCURED;
        }
        return $this->returnableResponseData($response, $error, $message);
    }

    public function deleteCompanyUnit(Request $request)
    {
        $authenticatedUser = $request->user->id_user;
        $response = null;
        $error = null;
        $templateInput = $request->input();
        $templateId = $templateInput['id'];

        try {
            $userRoleModelObj = new UserRoleModel();
            $userRole = $userRoleModelObj->getUserRole($authenticatedUser);
            if ($userRole->id_role == 1 || $userRole->id_role == 2 || $userRole->id_role == 4) {
                $template = new CompanyUnitModel();
                $response = $template->deleteCompanyUnit($templateId);
                if ($response) {
                    $message = array("message" => "Unit deleted successfully");
                } else {
                    $error = ApiConstant::DELETE_FAIL;
                }
            } else {
                $error = ApiConstant::USER_HAS_NO_PRIVILEGES;
            }
        } catch (\Exception $e) {
            $error = ApiConstant::EXCEPTION_OCCURED;
        }
        return $this->returnableResponseData($response, $error);
    }
}
