<?php
/**
 * Created by PhpStorm.
 * User: supravat
 * Date: 28/12/15
 * Time: 5:56 PM
 */

namespace App\Helpers;
//use Mailgun\Mailgun;
use App\BaseModels\BasePurchaseOrderModel;
use App\BaseModels\BaseUserModel;
use App\Models\SenderModel;
use App\Models\UserModel;
use SendGrid\Mail;
use App\Models\StaticReplacementModel;
use SparkPost\SparkPost;
use GuzzleHttp\Client;
use Http\Adapter\Guzzle6\Client as GuzzleAdapter;
use Carbon\Carbon;
use DateTime;

class AppUtility {

    /**
     * @param $str
     * @return bool
     */

    public static function sendTestMail($template = null, $subject = null, $body = null, $to = null, $fromName = null, $fromEmail = null, $attachment =null, $path=null){

        Mail::send($template, array('data' => $body), function ($message) use ($to,$subject,$fromEmail,$fromName,$attachment,$path){
            $message->from($fromEmail, $fromName);
            $message->to($to)->subject($subject);
            if($attachment){
                $message->attach($attachment);
            }
        });
        if(count(Mail::failures()) > 0){
            $result  = false;
        }
        else{
            $result  = true;
        }

        return $result;
    }

    public static function getConstants( $text , $start, $end){
        $regex = "/".$start."([a-zA-Z0-9_.@-]*)".$end."/";
        preg_match_all($regex,$text, $matches);
        return $matches[1];
    }

    public static function dateDifference($createdDate)
    {
        $todayDate = Carbon::now();
        $currentDate = Carbon::parse($todayDate);
        $now = date_format($currentDate , 'Y-m-d H:i:s');
        $date1 = strtotime($now);
        $date2 = strtotime($createdDate);
        $dateDiff = ($date1 - $date2)/60;
        return round($dateDiff);
    }

    public static function extract_unit($string, $start, $end)
    {
        $pos = stripos($string, $start);
        if($pos > 0)
        {
            $str = substr($string, $pos);
            $str_two = substr($str, strlen($start));
            $second_pos = stripos($str_two, $end);

            $str_three = substr($str_two, 0, $second_pos);

            $unit = trim($str_three);
            return $unit;
        }
        else{
            return 0;
        }
    }
    public static function renderEmail($templateContent){
        $mailText = $templateContent;
        $constants = AppUtility::getConstants($mailText, '__', '__');
        foreach ($constants as $index=>$constant ) {
            $settingModelObj = new StaticReplacementModel();
            $result = $settingModelObj->isStaticDataAlreadyExist($constant);
            if(!empty($result)){
                $constantsArray[$constant] = $result['value'];
            }else{
                $constantsArray[$constant] = null;
            }
            $newMail = str_replace( '__'.$constant.'__', $constantsArray[$constant] ,$mailText);
            $mailText = $newMail;
        }
        return $mailText;
    }

    public static function renderTemplate($templateData,$constantValues)
    {
        $mailText = $templateData;
        $values['USER_NAME'] = $constantValues['USER_NAME'] ?? '';
        $values['USER_PASSWORD'] = $constantValues['USER_PASSWORD']?? '';
        $values['USER_EMAIL'] = $constantValues['USER_EMAIL']?? '';
        $values['DATE_TIME_INFROMATION'] = $constantValues['DATE_TIME_INFROMATION']?? '';
        $values['BCRYPT_ID'] = $constantValues['BCRYPT_ID'] ?? '';
        $constants = AppUtility::getConstants($mailText, '%%', '%%');
        foreach ($constants as $index=>$constant ) {
            if(!empty($values[$constant])){
                $newMail = str_replace( '%%'.$constant.'%%', $values[$constant] ,$mailText);
            }else{
                $newMail = str_replace( '%%'.$constant.'%%', null ,$mailText);
            }
            $mailText = $newMail;
        }
        return $mailText;
    }

    // for purchase order template
    public static function fileToPdf($filename) {
        $file = null;
        $basePath = public_path('purchase_orders/');
        $file['name'] = $filename;
        $file['type'] = mime_content_type($basePath.$filename);
        $file['data'] = base64_encode(file_get_contents($basePath.$filename));
        return $file;
    }

    public static function purchaseOrderTemplate($data)
    {
        $sendData = null;
        $response = null;
        $TodayDate = null;
        $now = new DateTime();
        $TimeStamp = $now->getTimestamp();
        $TodayDate = $now->format('d/m/Y');
        $fileName = 'pdf' . $TimeStamp;
        $sendData['purchase_data'] = $data['purchase_data'];
        $sendData['total_amount'] = round($data['total_amount'], 2);
        $sendData['purchase_id'] = $data['purchase_id'];
        $sendData['vendor_data'] = $data['vendor_data'];
        $sendData['terms'] = $data['terms'];
        $buyerId = $sendData['purchase_data'][0]['buyer'];
        $sendData['created_date'] = $data['created_date'];
        if ($buyerId) {
            $userObj = new BaseUserModel();
            $nameResponse = $userObj::where('id',$buyerId)->select('users.name')->first();
            $sendData['buyer_name'] = $nameResponse->name;
        }
        $basePath = public_path('purchase_orders/');
        $html = null;
//        $html = '<html>
//<head>
//<style>
//td, th {
//padding: 5px 15px 5px 25px;
//text-align: left;
//font-size: 10px;
//word-break: break-all;
//}
//
//</style>
//</head><body><div style="background-color: white">
//        <div style="padding: 10px 50px  10px 50px "><a class="al-logo clearfix"><img style="width: 120px; height: 52.5px;"
//                                                        src="data:image/png;base64,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"></a>
//                        <div>
//                            <h3 style="margin-top: 0; color: #3b5998; font-weight: bold">Integrity Innovation Serenity</h3>
//                        </div><div>
//                        	<p><img alt="" src="data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAAO0AAAAECAYAAABiBrjFAAAACXBIWXMAAA7IAAAN8wFwqNANAAAAMElEQVR4nGORdsz/zzAKRsEoGDKAZaAdMApGwSggDYxm2lEwCoYYGM20o2AUDDEAACYTAdvLTgm6AAAAAElFTkSuQmCCAA==" style="height:6px; width:50%" /><img alt="" src="data:image/jpeg;base64,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" style="height:6px; width:50%" /></p>
//
//                        </div>';
        $html = '<html>
<head>
<style>
td, th {
padding: 5px 15px 5px 25px; 
text-align: left; 
font-size: 10px;
word-break: break-all;
}

</style>
</head><body><div style="background-color: white">
        <div style="padding: 10px 50px  0 50px ">';
        if ((int)$sendData['purchase_data'][0]['company_unit_id'] == 4) {
            $tudipHeader = '<div>
                            <h1 style="text-align: center; margin-top: 0; color: #3b5998; font-weight: bold">Pesh Infotech</h1>
                        </div>
                        <div>
                        	<p><img alt="" src="data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAAO0AAAAECAYAAABiBrjFAAAACXBIWXMAAA7IAAAN8wFwqNANAAAAMElEQVR4nGORdsz/zzAKRsEoGDKAZaAdMApGwSggDYxm2lEwCoYYGM20o2AUDDEAACYTAdvLTgm6AAAAAElFTkSuQmCCAA==" style="height:6px; width:50%" /><img alt="" src="data:image/jpeg;base64,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" style="height:6px; width:50%" /></p>
                        </div>';
        } else {
            $tudipHeader = '<a class="al-logo clearfix"><img style="width: 120px; height: 52.5px;"
                                                        src="data:image/png;base64,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">
                                                        </a>
                        <div>
                            <h3 style="margin-top: 0; color: #3b5998; font-weight: bold">Integrity Innovation Serenity</h3>
                        </div>
                        <div>
                        	<p><img alt="" src="data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAAO0AAAAECAYAAABiBrjFAAAACXBIWXMAAA7IAAAN8wFwqNANAAAAMElEQVR4nGORdsz/zzAKRsEoGDKAZaAdMApGwSggDYxm2lEwCoYYGM20o2AUDDEAACYTAdvLTgm6AAAAAElFTkSuQmCCAA==" style="height:6px; width:50%" /><img alt="" src="data:image/jpeg;base64,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" style="height:6px; width:50%" /></p>
                        </div>';
        }
        if($sendData['purchase_data'][0]['company_uin_number']) {
            $html = $tudipHeader . '<div style="font-size: 10px">'. $sendData['purchase_data'][0]['company_uin_number'] .'</div>';
        }

                       $html = $html. '<table border="1" cellpadding="0" cellspacing="0" style="margin-bottom: 10px; margin-top: 30px; border-collapse: collapse;width: 100%" *ngFor="let vendor of vendorData" >
                            <thead>
                            <tr>
                                <th style="width: 50%; padding: 5px 5px 5px 25px" colspan="2"><b>Vendor Information</b></th>
                                <th style="width: 50%; padding: 5px 5px 5px 25px" colspan="2"><b>Buyer Information</b></th>
                            </tr>
                            </thead>
                            <tbody>
                            <tr>
                                <td>Vendor Name</td>
                                <td>' . $sendData['vendor_data'][0]['company_name'] . '</td>
                                <td>PO Number</td>
                                <td>' . $sendData['purchase_data'][0]['unit_suffix'].$sendData['purchase_data'][0]['unit_po_id']. '</td>
                            </tr>
                            <tr>
                                <td>Contact Person Name</td>
                                <td>' . $sendData['vendor_data'][0]['name'] . '</td>
                                <td>Date</td>
                                <td>' . $sendData['created_date'] . '</td>
                            </tr>
                            <tr>
                                <td>Contact No.</td>
                                <td>' . $sendData['vendor_data'][0]['contact_number'] . '</td>
                                <td>Company Name</td>
                                <td>'.$sendData['purchase_data'][0]['company_unit_name'].'</td>
                            </tr>
                            <tr>
                                <td>Email</td>
                                <td>' . $sendData['vendor_data'][0]['email'] . '</td>
                                 <td>Company PAN Number</td>
                                <td>'.strtoupper($sendData['purchase_data'][0]['company_unit_pan_number']).'</td>
                            </tr>
                            <tr>
                                <td>Address</td>
                                <td>' . (($sendData['vendor_data'][0]['address_line_one'] . $sendData['vendor_data'][0]['address_line_two']) ? $sendData['vendor_data'][0]['address_line_one'] . ' ' . $sendData['vendor_data'][0]['address_line_two'] : ' ') . ' ' . $sendData['vendor_data'][0]['city'] . ' ' . $sendData['vendor_data'][0]['state'] . ' ' . (($sendData['vendor_data'][0]['pin_code']) ? ($sendData['vendor_data'][0]['pin_code']) : '') . '</td>
                                <td>Company GST Number</td>
                                <td>'.strtoupper($sendData['purchase_data'][0]['company_unit_gst_number']).'</td>
                            </tr>
                            <tr style="border-bottom: 1px solid lightgray">
                                <td>GST Number</td>
                                <td>' . (($sendData['vendor_data'][0]['gst_number']) ? (strtoupper($sendData['vendor_data'][0]['gst_number'])) : ' ') . '</td>
                                <td>Buyer Name</td>
                                <td>' . $sendData['buyer_name'] . '</td>
                            </tr>
                            </tbody>
                        </table>';
        $html = $html . '<div style="position: relative">
                        <table  border="1" cellpadding="0" cellspacing="0" style="width:100%;">
	<thead>
		<tr>
            <th style="padding: 5px 5px 5px 25px; text-align: left; width: 150px; font-size: 10px;" scope="col">Name</th>
			<th style="padding: 5px 5px 5px 10px; font-size: 10px;" scope="col">Price Per Unit (₹)</th>
			<th style="padding: 5px 5px 5px 10px; font-size: 10px;" scope="col">Quantity</th>
			<th style="padding: 5px 5px 5px 10px; font-size: 10px;" scope="col">Total Amount excluding GST (₹)</th>
			<th style="padding: 5px 5px 5px 10px; font-size: 10px;" scope="col">GST (%)</th>
			<th style="padding: 5px 5px 5px 10px; font-size: 10px;" scope="col">GST Price (₹)</th>
			<th style="padding: 5px 5px 5px 10px; font-size: 10px;" scope="col">Total Amount including GST (₹)</th>
		</tr>
	</thead>';
        $html = $html . '<tfoot>
    <tr>
			<th scope="col"></th>
			<th scope="col"></th>
			<th scope="col"></th>
			<th scope="col"></th>
			<th scope="col"></th>
			<th style="padding: 5px 5px 5px 10px; font-size: 10px;" scope="col">Total</th>
			<th style="text-align: left; padding: 5px 5px 5px 10px; font-size: 10px;" scope="col">' . $sendData['total_amount'] . '</th>
		</tr>
  </tfoot> ';

        $html = $html . '<tbody>';

        foreach ($sendData['purchase_data'] as $purchase) {
            $html = $html . '<tr><td style="font-size: 10px; padding: 5px 5px 5px 25px; ">';
            $html = $html . $purchase['item_name'];
            $html = $html . "</td>";
            $html = $html . '<td style="font-size: 10px; padding: 5px 5px 5px 10px; ">';
            $html = $html . $purchase['price'];
            $html = $html . "</td>";
            $html = $html . '<td style="font-size: 10px; padding: 5px 5px 5px 10px; ">';
            $html = $html . $purchase['quantity'] .' '. $purchase['unit'];
            $html = $html . "</td>";
            $html = $html . '<td style="font-size: 10px; padding: 5px 5px 5px 10px; ">';
            $html = $html . $purchase['total'];
            $html = $html . "</td>";
            $html = $html . '<td style="font-size: 10px; padding: 5px 5px 5px 10px; ">';
            $html = $html . $purchase['gst'];
            $html = $html . "</td>";
            $html = $html . '<td style="font-size: 10px; padding: 5px 5px 5px 10px; ">';
            $html = $html . $purchase['gst_price'];
            $html = $html . "</td>";
            $html = $html . '<td style="text-align: left; font-size: 10px; padding: 5px 5px 5px 10px; ">';
            $html = $html . $purchase['total_amount'];
            $html = $html . "</td></tr>";
        }

        $html = $html . '</tbody></table></div>';

        $html = $html . '<div style=\'margin-top: 30px; padding: 10px; border-top: 1px solid lightgrey\'>
                        </div>
                   <div>
                    	<div>
                            <span style="margin: 5px; font-size: 10px; padding:0; font-weight: bold">Terms and Conditions</span>
                        </div>';

        $html = $html . '<div style="font-size: 10px;">' . $sendData['terms'] . '</div>';

        $html = $html . '
                        <div style="padding-bottom: 10px; margin-bottom: 15px; font-size: 10px;">
                        	Thanking You..!!
                        </div>
                        <div style="margin-top: 15px; font-size: 10px;">
                          Authorized Signatory  
                        </div>
                        <div style=\'margin-top: 5px; padding: 10px; border-top: 4px solid gray\'>
                        </div>
                        <div style="padding-bottom: 15px; margin-bottom: 15px; font-size: 10px;">' .
            'PO Acceptance By ' . '<b>' . $sendData['vendor_data'][0]['company_name'] . '</b>' .
            '</div>
                        <div style=\'margin-top: 10px;width: 150px;border-top: 1px solid lightgray\'>
                        </div>
                        <div style="margin-top: 5px; font-size: 10px;">
                          Sign & Stamp
                        </div>
                    </div>

                    </div>
                    </div> 
                    <div style="position: fixed;bottom: 0;left: 0;right: 0; width: 100%; height: 50px;"></div>
                    </div></body></html>';
        $mpdf = new \Mpdf\Mpdf();
        $mpdf->WriteHTML($html);
        $mpdf->Output($basePath . $fileName . '.pdf');
        return $fileName;
    }

    public static function category_item_pdf($data)
    {
        $sendData = null;
        $response = null;
        $TodayDate = null;
        $now = new DateTime();
        $TodayDate = $now->getTimestamp();
        $fileName = 'Category_Item_' . $TodayDate;
        $sendData['categoryItemData'] = $data['category_item_data'];
        $basePath = public_path('category_items/');
        $html = null;
        $html = '<html>
<head>
<style>
td, th {
padding: 5px 15px 5px 25px; 
text-align: left; 
font-size: 10px;
word-break: break-all;
}

</style>
</head><body>
        <div style="position: relative">
                        <table  border="1" cellpadding="0" cellspacing="0" style="width:100%;">
	<thead>
		<tr>
			<th style="padding: 5px 5px 5px 25px; text-align: left; width: 25%;  font-size: 20px;" scope="col">Item Id</th>
			<th style="width: 50%; padding: 5px 5px 5px 25px; font-size: 20px;" scope="col">Item Name</th>
			<th style="padding: 5px 5px 5px 25px; font-size: 20px; width: 30%;" scope="col">On Hand Quantity</th>
		    <th style="width: 50%; padding: 5px 5px 5px 25px; font-size: 20px;width: 30%;" scope="col">Unit</th>
		</tr>
	</thead>';

        $html = $html . '<tbody>';

        foreach ($sendData['categoryItemData'] as $item) {
            $html = $html . '<tr><td style="font-size: 20px; padding: 5px 5px 5px 25px; ">';
            $html = $html . $item['id'];
            $html = $html . "</td>";
            $html = $html . '<td style="font-size: 20px; padding: 5px 5px 5px 25px; ">';
            $html = $html . $item['name'];
            $html = $html . "</td>";
            $html = $html . '<td style="font-size: 20px; padding: 5px 5px 5px 25px; ">';
            $html = $html . ($item['quantity_available'] ? $item['quantity_available'] : 0);
            $html = $html . "</td>";
            $html = $html . '<td style="font-size: 20px; padding: 5px 5px 5px 25px; ">';
            $html = $html . $item['unit'];
            $html = $html . "</td></tr>";
        }

        $html = $html . '</tbody></table></div>

        </div>
                    </div></body></html>';
        $mpdf = new \Mpdf\Mpdf();
        $mpdf->WriteHTML($html);
        $mpdf->Output($basePath . $fileName . '.pdf');
        return $fileName;
    }

    public static function printPoTemplate($data)
    {
        $sendData = null;
        $response = null;
        $nameResponse = null;
        $tudipHeader = null;
        $TodayDate = null;
        $now = new DateTime();
        $TimeStamp = $now->getTimestamp();
        $TodayDate = date('m/d/Y');
        $fileName = 'pdf' . $TimeStamp;
        $sendData['purchase_data'] = $data['purchase_data'];
        $sendData['total_amount'] = round($data['total_amount'], 2);
        $sendData['purchase_id'] = $data['purchase_id'];
        $sendData['vendor_data'] = $data['vendor_data'];
        $sendData['terms'] = $data['terms'];
        $sendData['header'] = $data['header'];
        $buyerId = $sendData['purchase_data'][0]['buyer'];
        $sendData['created_date'] = $data['created_date'];
        if ($buyerId) {
            $userObj = new BaseUserModel();
            $nameResponse = $userObj::where('id',$buyerId)->select('users.name')->first();
            $sendData['buyer_name'] = $nameResponse->name;
        }
        $basePath = public_path('purchase_orders/');
        $html = null;
        $html = '<html>
<head>
<style>
td, th {
padding: 5px 15px 5px 25px; 
text-align: left; 
font-size: 10px;
word-break: break-all;
}

</style>
</head><body><div style="background-color: white">
        <div style="padding: 10px 50px  0 50px ">';
        if ((int)$sendData['purchase_data'][0]['company_unit_id'] == 4) {
            $tudipHeader = '<div>
                            <h1 style="text-align: center; margin-top: 0; color: #3b5998; font-weight: bold">Pesh Infotech</h1>
                        </div>
                        <div>
                        	<p><img alt="" src="data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAAO0AAAAECAYAAABiBrjFAAAACXBIWXMAAA7IAAAN8wFwqNANAAAAMElEQVR4nGORdsz/zzAKRsEoGDKAZaAdMApGwSggDYxm2lEwCoYYGM20o2AUDDEAACYTAdvLTgm6AAAAAElFTkSuQmCCAA==" style="height:6px; width:50%" /><img alt="" src="data:image/jpeg;base64,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" style="height:6px; width:50%" /></p>
                        </div>';
        } else {
            $tudipHeader = '<a class="al-logo clearfix"><img style="width: 120px; height: 52.5px;"
                                                        src="data:image/png;base64,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">
                                                        </a>
                        <div>
                            <h3 style="margin-top: 0; color: #3b5998; font-weight: bold">Integrity Innovation Serenity</h3>
                        </div>
                        <div>
                        	<p><img alt="" src="data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAAO0AAAAECAYAAABiBrjFAAAACXBIWXMAAA7IAAAN8wFwqNANAAAAMElEQVR4nGORdsz/zzAKRsEoGDKAZaAdMApGwSggDYxm2lEwCoYYGM20o2AUDDEAACYTAdvLTgm6AAAAAElFTkSuQmCCAA==" style="height:6px; width:50%" /><img alt="" src="data:image/jpeg;base64,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" style="height:6px; width:50%" /></p>
                        </div>';
        }

        if($sendData['purchase_data'][0]['company_uin_number']) {
            $tudipHeader = $tudipHeader . '<div style="font-size: 10px">'. $sendData['purchase_data'][0]['company_uin_number'] .'</div>';
        }
        if ($sendData['header']) {
            $html = $html . $tudipHeader;
        }

        $html = $html . '<table border="1" cellpadding="0" cellspacing="0" style="margin-bottom: 10px;margin-top: 30px; border-collapse: collapse;width: 100%" *ngFor="let vendor of vendorData" >
                            <thead>
                            <tr>
                                <th style="width: 50%; padding: 5px 5px 5px 25px" colspan="2"><b>Vendor Information</b></th>
                                <th style="width: 50%; padding: 5px 5px 5px 25px" colspan="2"><b>Buyer Information</b></th>
                            </tr>
                            </thead>
                            <tbody>
                            <tr>
                                <td>Vendor Name</td>
                                <td>' . $sendData['vendor_data'][0]['company_name'] . '</td>
                                <td>PO Number</td>
                                <td>' . $sendData['purchase_data'][0]['unit_suffix'].$sendData['purchase_data'][0]['unit_po_id'] . '</td>
                            </tr>
                            <tr>
                                <td>Contact Person Name</td>
                                <td>' . $sendData['vendor_data'][0]['name'] . '</td>
                                <td>Date</td>
                                <td>' . $sendData['created_date'] . '</td>
                            </tr>
                            <tr>
                                <td>Contact No.</td>
                                <td>' . $sendData['vendor_data'][0]['contact_number'] . '</td>
                                <td>Company Name</td>
                                <td>'.$sendData['purchase_data'][0]['company_unit_name'].'</td>
                            </tr>
                            <tr>
                                <td>Email</td>
                                <td>' . $sendData['vendor_data'][0]['email'] . '</td>
                                 <td>Company PAN Number</td>
                                <td>'.strtoupper($sendData['purchase_data'][0]['company_unit_pan_number']).'</td>
                            </tr>
                            <tr>
                                <td>Address</td>
                                <td>' . (($sendData['vendor_data'][0]['address_line_one'] . $sendData['vendor_data'][0]['address_line_two']) ? $sendData['vendor_data'][0]['address_line_one'] . ' ' . $sendData['vendor_data'][0]['address_line_two'] : ' ') . ' ' . $sendData['vendor_data'][0]['city'] . ' ' . $sendData['vendor_data'][0]['state'] . ' ' . (($sendData['vendor_data'][0]['pin_code']) ? ($sendData['vendor_data'][0]['pin_code']) : '') . '</td>
                                <td>Company GST Number</td>
                                <td>'.strtoupper($sendData['purchase_data'][0]['company_unit_gst_number']).'</td>
                            </tr>
                            <tr style="border-bottom: 1px solid lightgray">
                                <td>GST Number</td>
                                <td>' . (($sendData['vendor_data'][0]['gst_number']) ? (strtoupper($sendData['vendor_data'][0]['gst_number'])) : ' ') . '</td>
                                <td>Buyer Name</td>
                                <td>' . $sendData['buyer_name'] . '</td>
                            </tr>
                            </tbody>
                        </table>';
        $html = $html . '<div style="position: relative">
                        <table  border="1" cellpadding="0" cellspacing="0" style="width:100%;">
	<thead>
		<tr>
			<th style="padding: 5px 5px 5px 25px; text-align: left; width: 150px; font-size: 10px;" scope="col">Name</th>
			<th style="padding: 5px 5px 5px 10px; font-size: 10px;" scope="col">Price Per Unit (₹)</th>
			<th style="padding: 5px 5px 5px 10px; font-size: 10px;" scope="col">Quantity</th>
			<th style="padding: 5px 5px 5px 10px; font-size: 10px;" scope="col">Total Amount excluding GST (₹)</th>
			<th style="padding: 5px 5px 5px 10px; font-size: 10px;" scope="col">GST (%)</th>
			<th style="padding: 5px 5px 5px 10px; font-size: 10px;" scope="col">GST Price (₹)</th>
			<th style="padding: 5px 5px 5px 10px; font-size: 10px;" scope="col">Total Amount including GST (₹)</th>
		</tr>
	</thead>';
        $html = $html . '<tfoot>
    <tr>
			<th scope="col"></th>
			<th scope="col"></th>
			<th scope="col"></th>
			<th scope="col"></th>
			<th scope="col"></th>
			<th style="text-align: right; padding: 5px 5px 5px 10px; font-size: 10px;" scope="col">Total</th>
			<th style="text-align: right; padding: 5px 5px 5px 10px; font-size: 10px;" scope="col">' . $sendData['total_amount'] . '</th>
		</tr>
  </tfoot> ';

        $html = $html . '<tbody>';

        foreach ($sendData['purchase_data'] as $purchase) {
            $html = $html . '<tr><td style="font-size: 10px; padding: 5px 5px 5px 25px; ">';
            $html = $html . $purchase['item_name'];
            $html = $html . "</td>";
            $html = $html . '<td style="text-align: right; font-size: 10px; padding: 5px 5px 5px 10px; ">';
            $html = $html . $purchase['price'];
            $html = $html . "</td>";
            $html = $html . '<td style="text-align: right; font-size: 10px; padding: 5px 5px 5px 10px; ">';
            $html = $html . $purchase['quantity'] .' '. $purchase['unit'] ;
            $html = $html . "</td>";
            $html = $html . '<td style="text-align: right; font-size: 10px; padding: 5px 5px 5px 10px; ">';
            $html = $html . $purchase['total'];
            $html = $html . "</td>";
            $html = $html . '<td style="text-align: right; font-size: 10px; padding: 5px 5px 5px 10px; ">';
            $html = $html . $purchase['gst'];
            $html = $html . "</td>";
            $html = $html . '<td style="text-align: right; font-size: 10px; padding: 5px 5px 5px 10px; ">';
            $html = $html . $purchase['gst_price'];
            $html = $html . "</td>";
            $html = $html . '<td style="text-align: right; font-size: 10px; padding: 5px 5px 5px 10px; ">';
            $html = $html . $purchase['total_amount'];
            $html = $html . "</td></tr>";
        }

        $html = $html . '</tbody></table></div>';

        $html = $html . '<div style=\'margin-top: 30px; padding: 10px; border-top: 1px solid lightgrey\'>
                        </div>
                   <div>
                    	<div>
                            <span style="margin: 5px; font-size: 10px; padding:0; font-weight: bold">Terms and Conditions</span>
                        </div>';

        $html = $html . '<div style="font-size: 10px;">' . $sendData['terms'] . '</div>';

        $html = $html . '
                        <div style="padding-bottom: 10px; margin-bottom: 15px; font-size: 10px;">
                        	Thanking You..!!
                        </div>
                        <div style="margin-top: 15px; font-size: 10px;">
                          Authorized Signatory  
                        </div>
                        <div style=\'margin-top: 5px; padding: 10px; border-top: 4px solid gray\'>
                        </div>
                        <div style="padding-bottom: 15px; margin-bottom: 15px; font-size: 10px;">' .
            'PO Acceptance By ' . '<b>' . $sendData['vendor_data'][0]['company_name'] . '</b>' .
            '</div>
                        <div style=\'margin-top: 10px;width: 150px;border-top: 1px solid lightgray\'>
                        </div>
                        <div style="margin-top: 5px; font-size: 10px;">
                          Sign & Stamp
                        </div>
                    </div>

                    </div>
                    </div> 
                    <div style="position: fixed;bottom: 0;left: 0;right: 0; width: 100%; height: 50px;"></div>
                    </div></body></html>';

        $html = $html . '<tbody>';

        foreach ($sendData['purchase_data'] as $purchase) {
            $html = $html . '<tr><td style="font-size: 10px; padding: 5px 5px 5px 25px; ">';
            $html = $html . $purchase['item_name'];
            $html = $html . "</td>";
            $html = $html . '<td style="font-size: 10px; padding: 5px 5px 5px 10px; ">';
            $html = $html . $purchase['price'];
            $html = $html . "</td>";
            $html = $html . '<td style="font-size: 10px; padding: 5px 5px 5px 10px; ">';
            $html = $html . $purchase['quantity'];
            $html = $html . "</td>";
            $html = $html . '<td style="font-size: 10px; padding: 5px 5px 5px 10px; ">';
            $html = $html . $purchase['total'];
            $html = $html . "</td>";
            $html = $html . '<td style="font-size: 10px; padding: 5px 5px 5px 10px; ">';
            $html = $html . $purchase['gst'];
            $html = $html . "</td>";
            $html = $html . '<td style="font-size: 10px; padding: 5px 5px 5px 10px; ">';
            $html = $html . $purchase['gst_price'];
            $html = $html . "</td>";
            $html = $html . '<td style="text-align: left; font-size: 10px; padding: 5px 5px 5px 10px; ">';
            $html = $html . $purchase['total_amount'];
            $html = $html . "</td></tr>";
        }

        $html = $html . '</tbody></table></div>';

        $html = $html . '<div style=\'margin-top: 30px; padding: 10px; border-top: 1px solid lightgrey\'>
                        </div>
                   <div>
                    	<div>
                            <span style="margin: 5px; font-size: 10px; padding:0; font-weight: bold">Terms and Conditions</span>
                        </div>';

        $html = $html . '<div style="font-size: 10px;">' . $sendData['terms'] . '</div>';

        $html = $html . '
                        
                        <div style="padding-bottom: 10px; margin-bottom: 15px; font-size: 10px;">
                        	Thanking You..!!
                        </div>
                        <div style="margin-top: 15px; font-size: 10px;">
                          Authorized Signatory  
                        </div>
                        <div style=\'margin-top: 5px; padding: 10px; border-top: 4px solid gray\'>
                        </div>
                        <div style="padding-bottom: 15px; margin-bottom: 15px; font-size: 10px;">'.
            'PO Acceptance By '.'<b>'. $sendData['vendor_data'][0]['company_name'] .'</b>'.
            '</div>
                        <div style=\'margin-top: 10px;width: 150px;border-top: 1px solid lightgray\'>
                        </div>
                        <div style="margin-top: 5px; font-size: 10px;">
                          Sign & Stamp
                        </div>
                    </div>

                    </div>
                    </div> 
                    </div></body>';
        $mpdf = new \Mpdf\Mpdf();
        if (empty($sendData['header'])) {
                    $mpdf->AddPage('','','','','','','',35,20,10,10);
        }
//        $mpdf->AddPage('','','','','','','',35,20,10,10);
        $mpdf->WriteHTML($html);
        $mpdf->Output($basePath . $fileName. '.pdf');
        return $fileName;
    }

     // send mail using Sparkpost
     public static function sendEmail( $subject = null, $body = null, $to_email = null,$cc_email = null,$hash, $fileName, $fileArray)
     {
         $sendAttatchmentsArray = [];
         $encoded_file = null;
         $senderModelObj = new SenderModel();

         if ($fileName) {
             $filename = $fileName. '.pdf';
             $encoded_file = AppUtility::fileToPdf($filename);
             array_push($sendAttatchmentsArray, $encoded_file);
             $file = null;
         }

         if (!empty($fileArray)){
             foreach ($fileArray as $file ) {
                 array_push($sendAttatchmentsArray, $file);
             }
         }

         $senderDetails['sender_name'] = 'Tudip Technologies';
         $senderDetails['sender_email'] = 'admin@tudip.com';
         $httpClient = new GuzzleAdapter(new Client());
         $sparky = new SparkPost($httpClient, ['key' => '75f3c0b79b63514454bc72c3fcdee31369d2180e']);
         $sparky->setOptions(['async' => false]);
         $cc_final_array = array();
         $to_email_final = array();
         foreach ($cc_email as $data) {
             array_push($cc_final_array, array(
                 'address' => array(
                     'name' => '',
                     'email' => $data['email']
                 )
             ));
         }

         foreach ($to_email as $data) {
             array_push($to_email_final, array(
                 'address' => array(
                     'name' => '',
                     'email' => $data['email']
                 )
             ));
         }
         $results = $sparky->transmissions->post([
             'content' => [
                 'from' => [
                     'name' => $senderDetails['sender_name'],
                     'email' => $senderDetails['sender_email'],
                 ],
                 'attachments' => $sendAttatchmentsArray,
                 'subject' => $subject,
                 'html' => $body,
//                 'reply_to'  => '<admin+'.$hash.'@tudip.com>'
             ],
             'recipients' => $to_email_final,
             'cc' => $cc_final_array,
         ]);
         return $results = $results ? true : false;
     }




    public static function isNotSetOrEmpty($str)
    {
        $return = false;
        if($str == null)
        {
            $return = true;
        }
        return $return;
    }

    /**
     * @param $firstName
     * @param $length
     * @return int
     */
    public static function compareStringLength($firstName, $length)
    {
        $returnVal = 0;
        if(self::checkStringLength($firstName) < $length)
        {
            $returnVal = -1;
        }
        elseif(self::checkStringLength($firstName) > $length)
        {
            $returnVal = 1;
        }
        return $returnVal;
    }

    /**
     * @param $str
     * @return int
     */
    public static function checkStringLength($str)
    {
        $length = strlen($str);
        return $length;
    }

    /**
     * @param $email
     * @return bool
     */
    public static function check_email_address($email) {
        //$status = true;
        if (!filter_var($email, FILTER_VALIDATE_EMAIL) === false) {
            $status = true;
        } else {
            $status = false;
        }

//        $space_pos = strpos($email,' ');
//        $at_pos = strpos($email,'@');
//        $stop_pos = strpos($email,'.', $at_pos);
//        $more_stop = strpos($email, '.', ($stop_pos + 1));
//
//        if(($at_pos === false) || ($stop_pos === false) || $more_stop || $space_pos) {
//            $status = false;
//        }
//        else {
//            if($stop_pos < $at_pos) {
//                $status = false;
//            }
//            else {
//                if (($stop_pos - $at_pos) == 1) {
//                    $status = false;
//                }
//            }
//        }
        return $status;
    }

    /**
     * @param $errorCode
     * @return int
     */
    public static function getHTTPStatusCodeForErrorCode($errorCode)
    {
        $statusCode = ApiConstant::HTTP_RESPONSE_CODE_SUCCESS;
        if (isset(ApiConstant::$httpErrorCodeMap[$statusCode]))
        {
            $statusCode = ApiConstant::$httpErrorCodeMap[$errorCode];
        }
        return $statusCode;
    }

    /**
     * @param $errorCode
     * @return mixed
     */
    public static function getMessageForErrorCode($errorCode)
    {
        $returnData = $errorCode;
        if (isset(ApiConstant::$english[$errorCode]))
        {
            $returnData = ApiConstant::$english[$errorCode];
        }
        return $returnData;
    }

    public static function createSalt($email)
    {
        $salt = md5($email);
        return $salt;

    }

    public static function getPasswordHash($salt, $password)
    {
        $hash = md5($salt.$password);
        return $hash;
    }

    public static function isValidPreviousDate($date)
    {
        $returnVal = false;
        $date = date_create($date);
        $preDate = date_format($date, ApiConstant::DATE_FORMAT);
        $currentDate = date(ApiConstant::DATE_FORMAT);
        if($preDate < $currentDate)
        {
            $returnVal = true;
        }
        return $returnVal;
    }

    public static function isValidDateFormat($date)
    {
        $returnVal = false;
        if (preg_match(ApiConstant::DATE_FORMAT_GRAMMAR, $date))
        {
            $returnVal = true;
        }
        return $returnVal;
    }

    public static function strPosWithNeedleArrray($haystack, $needle) {
        if(!is_array($needle)) $needle = array($needle);
        foreach($needle as $what) {
            if(($pos = strpos($haystack, $what))!==false) return $pos;
        }
        return false;
    }

    public static function forbiddenDomains(){
        return array("tudip.nl", "tudip.com");
    }

    public static function getInbetweenStrings($start, $end, $str){
        $matches = array();
        $regex = "/$start([a-zA-Z0-9_.@-]*)$end/";
        preg_match_all($regex, $str, $matches);
        return $matches[1];
    }

    public static function extract_emails_from($string){
        preg_match_all("/[\._a-zA-Z0-9-]+@[\._a-zA-Z0-9-]+/i", $string, $matches);
        return $matches[0];
    }
    /**
     * @return string
     */
    public static function createUserAuthToken()
    {
        $startTime = microtime();
        $userAuthToken = md5($startTime);
        return $userAuthToken;
    }

    public static function trimContent($str)
    {
        return trim($str);
    }

    public static function getDateFromDateObject($date)
    {
        if(is_object($date)){
            $date = (array)$date;
            $date = $date['date'];
            $date = explode('.', $date);
            $date = $date[0];
        }
        return $date;
    }

    public static function getResetToken()
    {
        return strtolower(str_random(8,'1234567890abcdefghijklmnopqrstuvwxyz'));
    }

    public static function dateFormat($date)
    {
        $date = date_create($date);
        $formattedDate = date_format($date, ApiConstant::DATE_FORMAT);
        return $formattedDate;
    }

    public static function mergeArray($primaryArray, $secondaryArray)
    {
        foreach($secondaryArray as $key => $data)
        {
            $primaryArray[$key] = $data;
        }
        return $primaryArray;
    }

    public static function prepareUserTableData($inputs)
    {
        $returnArray = array();
        $columns = array('first_name', 'last_name', 'birth_date', 'gender');
        foreach($inputs as $key => $input)
        {
            if(in_array($key, $columns))
            {
                $returnArray[$key] =  $input;
            }
        }
        if(isset($inputs['birth_date']))
        {
            $inputs['birth_date'] = AppUtility::reverseDateUsFormat($inputs['birth_date']);
            $returnArray["age"] = date_diff(date_create($inputs['birth_date']), date_create('today'))->y;
            $returnArray["birth_date"] = AppUtility::reverseDateUsFormat($returnArray['birth_date']);
        }

        return $returnArray;
    }

    public static function prepareAddressTableData($inputs)
    {
        $returnArray = array();
        $columns = array('contact', 'street', 'city', 'district', 'state', 'country', 'landmark', 'zip');
        foreach($inputs as $key => $input)
        {
            if(in_array($key, $columns))
            {
                $returnArray[$key] =  $input;
            }
        }
        return $returnArray;
    }

    public static function prepareProfileTableData($inputs)
    {
        $returnArray = array();
        $columns = array('fitness_interest', 'bmi', 'body_fat', 'do_smoke', 'exercise_per_week');
        foreach($inputs as $key => $input)
        {
            if(in_array($key, $columns))
            {
                $returnArray[$key] =  $input;
            }
        }
        return $returnArray;
    }

    public static function isValidBase64($imageBase64)
    {
        $returnVal = false;
        if (base64_encode(base64_decode($imageBase64, true)) === $imageBase64)
        {
            $returnVal = true;
        }
        return $returnVal;
    }

    public static function reverseDateUsFormat($date)
    {
        if($date)
        {
            $array = explode('-', $date);
            $newFormat = $array[1].'-'.$array[0].'-'.$array[2];
            $dateObj = date_create($newFormat);
            $formattedDate = date_format($dateObj, ApiConstant::DATE_FORMAT);
            return $formattedDate;
        }
    }

    public static function dateUsFormat($date)
    {
        if($date)
        {
            $array = explode(' ', $date);
            $dateOnly = explode('-', $array[0]);
            $newFormat = $dateOnly[1].'-'.$dateOnly[2].'-'.$dateOnly[0].' '.$array[1];
            return $newFormat;
        }
    }

    public static function calculateTimePassed($date)
    {
        $currentTime = new \DateTime();
        $pastDate = date_create($date);

        $postedBefore = date_diff($pastDate, $currentTime);
        $dateDiff = array('year' => $postedBefore->y,
            'month' => $postedBefore->m,
            'day' => $postedBefore->d,
            'hour' => $postedBefore->h,
            'minute' => $postedBefore->i,
            'second' => $postedBefore->s,
            'total_days' => $postedBefore->days,
        );
        return $dateDiff;
    }

    public static function dump($data)
    {
        echo'<pre>';
        print_r($data);
        echo'</pre>';
        die;
    }

    public static function validBase64Params($imageBase64)
    {
        $error = false;
        if(AppUtility::isNotSetOrEmpty($imageBase64))
        {
            $error = ApiConstant::EMPTY_BASE64;
        }
        if(!AppUtility::isValidBase64($imageBase64)){
            $error = ApiConstant::INVALID_BASE64;
        }
        return $error;
    }

    public static function formatPhoneNumber($phoneNumber) {
        $phoneNumber = preg_replace('/[^0-9]/','',$phoneNumber);

        if(strlen($phoneNumber) > 10) {
            $countryCode = substr($phoneNumber, 0, strlen($phoneNumber)-10);
            $areaCode = substr($phoneNumber, -10, 3);
            $nextThree = substr($phoneNumber, -7, 3);
            $lastFour = substr($phoneNumber, -4, 4);

            $phoneNumber = '+'.$countryCode.' ('.$areaCode.') '.$nextThree.'-'.$lastFour;
        }
        else if(strlen($phoneNumber) == 10) {
            $areaCode = substr($phoneNumber, 0, 3);
            $nextThree = substr($phoneNumber, 3, 3);
            $lastFour = substr($phoneNumber, 6, 4);

            $phoneNumber = '('.$areaCode.') '.$nextThree.'-'.$lastFour;
        }
        else if(strlen($phoneNumber) == 7) {
            $nextThree = substr($phoneNumber, 0, 3);
            $lastFour = substr($phoneNumber, 3, 4);

            $phoneNumber = $nextThree.'-'.$lastFour;
        }

        return $phoneNumber;
    }
    public static function getCoordinates($address){
        $address = str_replace(" ", "+", $address); // replace all the white space with "+" sign to match with google search pattern
        $url = "http://maps.google.com/maps/api/geocode/json?sensor=false&address=$address";
        try{$response = file_get_contents($url);
            if(!empty($response)){
                $json = json_decode($response,TRUE); //generate array object from the response from the web
//        print_r($json['results'][0]['geometry']['location']);
                return ($json['results'][0]['geometry']['location']);
            }
        }
        catch(\Exception $e){
            return ApiConstant::UNABLE_TO_RETRIEVE_ADDRESS;
        }
    }

    public static function byzipcode($zip){
        $url = 'http://maps.googleapis.com/maps/api/geocode/json?sensor=false&address='.$zip;
        try{
            $response = file_get_contents($url);
            if(!empty($response)){

                $completeAddress['zipcode'] = $zip;
                $json = json_decode($response,TRUE); //generate array object from the response from the web
                if($json['status']=='OK'){
                    foreach($json as $data){
                        if($data[0]['address_components']){

                            $address = $data[0]['address_components'];
                            foreach($address as $break){
                                if($break['types'][0] == "administrative_area_level_1" ){
                                    $completeAddress['state'] = $break['long_name'];
                                }
                                if($break['types'][0] == "locality"){
                                    $completeAddress['city'] = $break['long_name'];
                                }else {
                                    if ($break['types'][0] == "administrative_area_level_2") {
                                        $completeAddress['city'] = $break['long_name'];
                                    }
                                }
                                if($break['types'][0] == "country" ){
                                    $completeAddress['country']  = $break['long_name'];
                                }
                            }
                            return $completeAddress;
                        }
                    }
                }else{
                    return null;
                }


            }
        }
        catch(\Exception $e){
            return ApiConstant::UNABLE_TO_RETRIEVE_ADDRESS;
        }
    }

    public static function unique_multidim_array($array, $key) {
        $temp_array = array();
        $i = 0;
        $key_array = array();

        foreach($array as $val) {
            if (!in_array($val[$key], $key_array)) {
                $key_array[$i] = $val[$key];
                $temp_array[$i] = $val;
            }
            $i++;
        }
        return $temp_array;
    }

    public static function formatSizeUnits($bytes)
    {
        if ($bytes >= 1073741824)
        {
            $bytes = number_format($bytes / 1073741824, 2) . ' GB';
        }
        elseif ($bytes >= 1048576)
        {
            $bytes = number_format($bytes / 1048576, 2) . ' MB';
        }
        elseif ($bytes >= 1024)
        {
            $bytes = number_format($bytes / 1024, 2) . ' kB';
        }
        elseif ($bytes > 1)
        {
            $bytes = $bytes . ' bytes';
        }
        elseif ($bytes == 1)
        {
            $bytes = $bytes . ' byte';
        }
        else
        {
            $bytes = '0 bytes';
        }

        return $bytes;
    }
}
