<?php

namespace App\Console;

use Illuminate\Console\Scheduling\Schedule;
use Illuminate\Foundation\Console\Kernel as ConsoleKernel;

class Kernel extends ConsoleKernel
{
    /**
     * The Artisan commands provided by your application.
     *
     * @var array
     */
    protected $commands = [
        //
//        'App\Console\Commands\SendEmails',
        'App\Console\Commands\ScheduleJobs',
        'App\Console\Commands\schuleJobsWeekBasis',
        'App\Console\Commands\CreateExpenseForParticularMonth',
    ];

    /**
     * Define the application's command schedule.
     *
     * @param  \Illuminate\Console\Scheduling\Schedule  $schedule
     * @return void
     */
    protected function schedule(Schedule $schedule)
    {
        $schedule->command('ScheduleJobs:createExpenses')
            ->monthlyOn(1,'08:00')
            ->timezone('Asia/Kolkata');

        $schedule->command('schuleJobsWeekBasis:createExpenses')
            ->mondays()
            ->timezone('Asia/Kolkata')
            ->at('08:00');
    }

    /**
     * Register the Closure based commands for the application.
     *
     * @return void
     */
    protected function commands()
    {
        require base_path('routes/console.php');
    }
}
