<?php

namespace App\Console\Commands;

use App\BaseModels\BaseExpenseDetailsModel;
use App\BaseModels\BasePaymentFrequencyModel;
use App\Helpers\ApiConstant;
use App\Models\ExpenseModel;
use App\Models\PaymentDetailsModel;
use App\Models\PurchaseOrderModel;
use Illuminate\Console\Command;
use Illuminate\Support\Facades\DB;

class schuleJobsWeekBasis extends Command
{
    /**
     * The name and signature of the console command.
     *
     * @var string
     */
    protected $signature = 'schuleJobsWeekBasis:createExpenses';

    /**
     * The console command description.
     *
     * @var string
     */
    protected $description = 'This command will create expenses as per the frequency defined';

    /**
     * Create a new command instance.
     *
     * @return void
     */
    public function __construct()
    {
        parent::__construct();
    }

    /**
     * Execute the console command.
     *
     * @return mixed
     */
    public function handle()
    {
//        mkdir('/home/lt-73/hit123455', 777);
        try {
            DB::beginTransaction();
            $response = null;
            $purchaseOrderObj = new PurchaseOrderModel();
            $todayDate = date("d/m/Y");
            $current_monday = date('d/m/Y',time()+( 1 - date('w'))*24*3600);
            $current_sunday = date('d/m/Y',time()+( 7 - date('w'))*24*3600);
            $expense['from_date'] = $current_monday;
            $expense['to_date'] = $current_sunday;
            $frequencyArray = [1]; //weekly, Bi-weekly
            foreach ($frequencyArray as $frequency) {
                $monthlyPurchaseOrdersArray = $purchaseOrderObj->viewRecurringPoByFrequency($frequency);
                foreach ($monthlyPurchaseOrdersArray as $po) {
                    $expenseObj = new ExpenseModel();
                    $purchaseOrderObj = new PurchaseOrderModel();
                    $poArray = null;
                    $expenseResponse = null;
                    $data = null;
                    $data['payment_mode'] = '';
                    $data['from_date'] = $current_monday;
                    $data['to_date'] = $current_sunday;
                    $data['bill_date'] = $todayDate;
                    $data['invoice_number'] = '';
                    $data['transaction_number'] = '';
                    $data['cron_generated'] = 1;
                    $data['remark'] = '';
                    $data['deductions'] = 0;
                    $data['is_paid'] = null;
                    $data['vendor_id'] = $po->vendor_id;
                    $data['purchase_id'] = $po->purchase_id;
                    $data['net_amount'] = $po->total_amount;
                    $data['payment_frequency'] = $frequency;
                    $data['paid_by'] = $po->buyer;
                    $expenseResponse = $expenseObj->saveExpenseDetails($data);
                    $poArray = $purchaseOrderObj->viewPurchaseOrderDetailsByPOId($po->purchase_id);
                    foreach ($poArray as $poDetails) {
                        $response = $expenseObj->saveItemExpenseDetails($poDetails, $expenseResponse->id);
                        if(!$response)
                        {
                            break;
                        }
                    }
                }
            }
            if($response) {
                DB::commit();
            }
        } catch (\Exception $e) {
            echo $message = $e->getMessage();
            DB::rollback();
            $error = ApiConstant::EXCEPTION_OCCURED;
        }

    }
}
