<?php

namespace App\Console\Commands;

use App\BaseModels\BaseExpenseDetailsModel;
use App\BaseModels\BasePaymentFrequencyModel;
use App\Helpers\ApiConstant;
use App\Models\ExpenseModel;
use App\Models\PaymentDetailsModel;
use App\Models\PurchaseOrderModel;
use DateTime;
use Illuminate\Console\Command;
use Illuminate\Support\Facades\DB;

class ScheduleJobs extends Command
{
    /**
     * The name and signature of the console command.
     *
     * @var string
     */
    protected $signature = 'ScheduleJobs:createExpenses';

    /**
     * The console command description.
     *
     * @var string
     */
    protected $description = 'This command will create expenses as per the frequency defined';

    /**
     * Create a new command instance.
     *
     * @return void
     */
    public function __construct()
    {
        parent::__construct();
    }

    /**
     * Execute the console command.
     *
     * @return mixed
     */
    public function handle()
    {
//        mkdir('/home/lt-73/hit12344', 777);
        try {
            DB::beginTransaction();
            $response = null;
            $purchaseOrderObj = new PurchaseOrderModel();
            $todayDate = date("d/m/Y");
            $first_day_this_month = date('01/m/Y', strtotime("-1 month")); // hard-coded '01' for first day
            $last_day_this_month  = date('t/m/Y', strtotime("-1 month"));
            $expense['from_date'] = $first_day_this_month;
            $expense['to_date'] = $last_day_this_month;
            $frequencyArray = [3,4,5]; //monthly, Quarterly, Yearly

            foreach ($frequencyArray as $frequency) {
                switch ($frequency) {
                    case 3: {
                        $purchaseOrderObj = new PurchaseOrderModel();
                        $monthlyPurchaseOrdersArray = $purchaseOrderObj->viewRecurringPoByFrequency($frequency);
                        foreach ($monthlyPurchaseOrdersArray as $po) {
                            $expenseObj = new ExpenseModel();
                            $poArray = null;
                            $data = null;
                            $data['payment_mode'] = '';
                            $data['from_date'] = $first_day_this_month;
                            $data['to_date'] = $last_day_this_month;
                            $data['bill_date'] = $todayDate;
                            $data['invoice_number'] = '';
                            $data['transaction_number'] = '';
                            $data['cron_generated'] = 1;
                            $data['remark'] = '';
                            $data['deductions'] = 0;
                            $data['is_paid'] = null;
                            $data['vendor_id'] = $po->vendor_id;
                            $data['purchase_id'] = $po->purchase_id;
                            $data['net_amount'] = $po->total_amount;
                            $data['payment_frequency'] = $frequency;
                            $data['paid_by'] = $po->buyer;
                            $response = $expenseObj->saveExpenseDetails($data);
                            $poArray = $purchaseOrderObj->viewPurchaseOrderDetailsByPOId($po->purchase_id);
                            foreach ($poArray as $poDetails) {
                                $response = $expenseObj->saveItemExpenseDetails($poDetails, $response->id);
                                if($response)
                                {
                                    DB::commit();
                                }
                            }
                        }
                        break;
                    }
//                    case 4: {
//                        $purchaseOrderObj = new PurchaseOrderModel();
//                        $monthlyPurchaseOrdersArray = $purchaseOrderObj->viewRecurringPoByFrequency($frequency);
//
//                        foreach ($monthlyPurchaseOrdersArray as $po) {
//
//                            $expenseObj = new ExpenseModel();
//                            $response = $expenseObj->viewLatestRecurringExpensesByPOId($po->purchase_id);
//                            $bill_date = implode('-', explode('/', $response['bill_date']));
//                            $todayDateDash = new DateTime();
//                            $bill_date = new DateTime($bill_date);
//                            $diff = $todayDateDash->diff($bill_date);
//                            if ($diff->m%3 == 0) {
//                                $poArray = null;
//                                $data = null;
//                                $data['payment_mode'] = '';
//                                $data['from_date'] = $first_day_this_month;
//                                $data['to_date'] = $last_day_this_month;
//                                $data['bill_date'] = $todayDate;
//                                $data['invoice_number'] = '';
//                                $data['transaction_number'] = '';
//                                $data['remark'] = '';
//                                $data['deductions'] = 0;
//                                $data['is_paid'] = null;
//                                $data['vendor_id'] = $po->vendor_id;
//                                $data['purchase_id'] = $po->purchase_id;
//                                $data['net_amount'] = $po->total_amount;
//                                $data['payment_frequency'] = $frequency;
//                                $data['paid_by'] = $po->buyer;
//                                $response = $expenseObj->saveExpenseDetails($data);
//                                $poArray = $purchaseOrderObj->viewPurchaseOrderDetailsByPOId($po->purchase_id);
//                                foreach ($poArray as $poDetails) {
//                                    $response = $expenseObj->saveItemExpenseDetails($poDetails, $response->id);
//                                    if($response)
//                                    {
//                                        DB::commit();
//                                    }
//                                }
//                            }
//                        }
//                        break;
//                    }
                }

            }


//            foreach ($payment_frequency as $frequency) {
//                $purchaseOrderArray[$frequency->name] = $purchaseOrderObj->viewRecurringPoByFrequency($frequency->id);
//                $expense['from_date'] = $first_day_this_month;
//                $expense['to_date'] = $last_day_this_month;
//                switch($frequency->id) {
//                    case 1:
//                        $date = date("Y-m-d", strtotime("-1 week"));
//                        $response = $expenseObj->getExpensesBydate($frequency->id, $date);
//                        break;
//                    case 2:
//                        $date = date("Y-m-d", strtotime("-2 week"));
//                        $response = $expenseObj->getExpensesBydate($frequency->id, $date);
//                        break;
//                    case 3:
//                        $date = date("Y-m-d", strtotime("-1 month"));
//                        $response = $expenseObj->getExpensesBydate($frequency->id, $date);
//                        break;
//                    case 4:
//                        $date = date("Y-m-d", strtotime("-3 month"));
//                        $response = $expenseObj->getExpensesBydate($frequency->id, $date);
//                        break;
//                    case 5:
//                        $date = date("Y-m-d", strtotime("-1 year"));
//                        $response = $expenseObj->getExpensesBydate($frequency->id, $date);
//                        break;
//                }
//
//            }


//            dd($purchaseOrderArray);
//            foreach ($purchaseOrderArray['Weekly'] as $po) {
//                dd($po);
//            }die;

//                switch($frequency->id) {
//                    case 1:
//                        $date = date("Y-m-d", strtotime("-1 week"));
//                        $response = $expenseObj->getExpensesBydate($frequency->id, $date);
//                        break;
//                    case 2:
//                        $date = date("Y-m-d", strtotime("-2 week"));
//                        $response = $expenseObj->getExpensesBydate($frequency->id, $date);
//                        break;
//                    case 3:
//                        $date = date("Y-m-d", strtotime("-1 month"));
//                        $response = $expenseObj->getExpensesBydate($frequency->id, $date);
//                        break;
//                    case 4:
//                        $date = date("Y-m-d", strtotime("-3 month"));
//                        $response = $expenseObj->getExpensesBydate($frequency->id, $date);
//                        break;
//                    case 5:
//                        $date = date("Y-m-d", strtotime("-1 year"));
//                        $response = $expenseObj->getExpensesBydate($frequency->id, $date);
//                        break;
//                }
//                foreach ($response as $expense) {
//                    $expenseObj = new ExpenseModel();
//                    $expesneDetailsObj = new BaseExpenseDetailsModel();
//                    $expense['item_data'] = array();
//                    $expense['item_data'] = $expesneDetailsObj::where('expense_details.expense_id', $expense->id)
//                        ->leftJoin('units', 'expense_details.unit', 'units.id')
//                        ->leftJoin('items', 'expense_details.item_id', 'items.id')
//                        ->select('items.name as item_name', 'expense_details.*', 'expense_details.unit as unit_id', 'units.unit')
//                        ->get();
//                    $expense['bill_date'] = $todayDate;
//                    $expense['from_date'] = $first_day_this_month;
//                    $expense['to_date'] = $last_day_this_month;
//                    $response = $expenseObj->saveExpenseDetails($expense);
//                    $expense['expense_id'] = $response->id;
//                    if (!empty($response)) {
//                        foreach ($expense['item_data'] as $item) {
//                           $item['id_item'] = $item['id'];
//                            $response = $expenseObj->saveItemExpenseDetails($item, $expense['expense_id']);
//                            if ($response) {
//                                DB::commit();
//                            }
//                        }
//                    }
//                }
//            }
        } catch (\Exception $e) {
            echo $message = $e->getMessage();
            DB::rollback();
            $error = ApiConstant::EXCEPTION_OCCURED;
        }

    }
}
