<?php

namespace App\Console\Commands;

use App\BaseModels\BaseExpenseDetailsModel;
use App\BaseModels\BasePaymentFrequencyModel;
use App\Helpers\ApiConstant;
use App\Models\ExpenseModel;
use App\Models\PaymentDetailsModel;
use App\Models\PurchaseOrderModel;
use Illuminate\Console\Command;
use Illuminate\Support\Facades\DB;

class CreateExpenseForParticularMonth extends Command
{
    /**
     * The name and signature of the console command.
     *
     * @var string
     */
    protected $signature = 'CreateExpenseForParticularMonth:createExpenses';

    /**
     * The console command description.
     *
     * @var string
     */
    protected $description = 'This command will create expenses as per the frequency defined';

    /**
     * Create a new command instance.
     *
     * @return void
     */
    public function __construct()
    {
        parent::__construct();
    }

    /**
     * Execute the console command.
     *
     * @return mixed
     */
    public function handle()
    {
//        mkdir('/home/lt-73/hit123455', 777);
        try {
            DB::beginTransaction();
            $response = null;
            $data = null;
            $purchaseOrderObj = new PurchaseOrderModel();
            $datesData['from_date'] = $firstDay = '01/09/2018';
            $datesData['to_date'] = $lastDay = '30/09/2018';
            $firstDayNextMonth = date('m/d/Y',strtotime($firstDay . "+1 days"));
            $datesData['first_date_month'] = date('d-m-Y', strtotime(str_replace("/","-", $firstDay)));
            $datesData['last_date_month'] = date('d-m-Y', strtotime(str_replace("/","-", $lastDay)));
            $frequencyArray = [1, 3]; //weekly, monthly
            foreach ($frequencyArray as $frequency) {
                $monthlyPurchaseOrdersArray = $purchaseOrderObj->viewPurchaseOrdersByDates($datesData, $frequency);
                switch ($frequency) {
                    case 1 : {
                        foreach ($monthlyPurchaseOrdersArray[0] as $po) {
                            $createDate = str_replace("/","-",$po['created_date']);
                            $current_monday = date('d/m/Y', strtotime('monday this week', strtotime($createDate)));
                            $last_monday = date('d/m/Y', strtotime('monday previous week', strtotime($createDate)));
                            $last_sunday = date('d/m/Y', strtotime('sunday previous week', strtotime($createDate)));
                            $expenseObj = new ExpenseModel();
                            $purchaseOrderObj = new PurchaseOrderModel();
                            $poArray = null;
                            $data = null;
                            $data['payment_mode'] = '';
                            $data['from_date'] = $last_monday;
                            $data['to_date'] = $last_sunday;
                            $data['bill_date'] = $current_monday;
                            $data['invoice_number'] = '';
                            $data['transaction_number'] = '';
                            $data['remark'] = '';
                            $data['cron_generated'] = 1;
                            $data['deductions'] = 0;
                            $data['is_paid'] = null;
                            $data['vendor_id'] = $po->vendor_id;
                            $data['purchase_id'] = $po->id;
                            $data['net_amount'] = $po->total_amount;
                            $data['payment_frequency'] = $frequency;
                            $data['paid_by'] = $po->buyer;
                            $response = $expenseObj->saveExpenseDetails($data);
                            $poArray = $purchaseOrderObj->viewPurchaseOrderDetailsByPOId($po->id);
                            foreach ($poArray as $poDetails) {
                                $response = $expenseObj->saveItemExpenseDetails($poDetails, $response->id);
                                if($response)
                                {
                                    DB::commit();
                                }
                            }
                        }
                        break;
                    }

                    case 3 : {
                        foreach ($monthlyPurchaseOrdersArray[0] as $po) {
                            $expenseObj = new ExpenseModel();
                            $purchaseOrderObj = new PurchaseOrderModel();
                            $poArray = null;
                            $data = null;
                            $data['from_date'] = $firstDay;
                            $data['to_date'] = $lastDay;
                            $data['payment_mode'] = '';
                            $data['bill_date'] = $firstDayNextMonth;
                            $data['invoice_number'] = '';
                            $data['transaction_number'] = '';
                            $data['cron_generated'] = 1;
                            $data['remark'] = '';
                            $data['deductions'] = 0;
                            $data['is_paid'] = null;
                            $data['vendor_id'] = $po->vendor_id;
                            $data['purchase_id'] = $po->id;
                            $data['net_amount'] = $po->total_amount;
                            $data['payment_frequency'] = $frequency;
                            $data['paid_by'] = $po->buyer;
                            $response = $expenseObj->saveExpenseDetails($data);
                            $poArray = $purchaseOrderObj->viewPurchaseOrderDetailsByPOId($po->id);
                            foreach ($poArray as $poDetails) {
                                $response = $expenseObj->saveItemExpenseDetails($poDetails, $response->id);
                                if($response)
                                {
                                    DB::commit();
                                }
                            }
                        }

                     break;
                    }
                }
            }
        } catch (\Exception $e) {
            echo $message = $e->getMessage();
            DB::rollback();
            $error = ApiConstant::EXCEPTION_OCCURED;
        }

    }
}
