webpackJsonp([52,56],{

/***/ 129:
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_0__angular_core__ = __webpack_require__(2);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_1__angular_common__ = __webpack_require__(10);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_2__angular_forms__ = __webpack_require__(24);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_3__angular_router__ = __webpack_require__(20);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_4__utilityServices_pipes_capitalize_pipe__ = __webpack_require__(434);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_5__utilityServices_pipes_noComma_pipe__ = __webpack_require__(435);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_6__components__ = __webpack_require__(422);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_7__directives__ = __webpack_require__(427);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_8__services__ = __webpack_require__(65);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_9__validators__ = __webpack_require__(392);
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "a", function() { return NgaModule; });
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};










var NGA_COMPONENTS = [
    __WEBPACK_IMPORTED_MODULE_6__components__["a" /* BaBackTop */],
    __WEBPACK_IMPORTED_MODULE_6__components__["b" /* BaContentTop */],
    __WEBPACK_IMPORTED_MODULE_6__components__["c" /* BaMenuItem */],
    __WEBPACK_IMPORTED_MODULE_6__components__["d" /* BaMenu */],
    __WEBPACK_IMPORTED_MODULE_6__components__["e" /* BaPageTop */],
    __WEBPACK_IMPORTED_MODULE_6__components__["f" /* BaSidebar */]
];
var NGA_DIRECTIVES = [
    __WEBPACK_IMPORTED_MODULE_7__directives__["a" /* BaScrollPosition */],
    __WEBPACK_IMPORTED_MODULE_7__directives__["b" /* BaSlimScroll */],
];
var NGA_SERVICES = [
    __WEBPACK_IMPORTED_MODULE_8__services__["c" /* BaThemePreloader */],
    __WEBPACK_IMPORTED_MODULE_8__services__["a" /* BaThemeSpinner */],
    __WEBPACK_IMPORTED_MODULE_8__services__["b" /* BaMenuService */]
];
var NGA_VALIDATORS = [
    __WEBPACK_IMPORTED_MODULE_9__validators__["b" /* EmailValidator */],
    __WEBPACK_IMPORTED_MODULE_9__validators__["a" /* EqualPasswordsValidator */]
];
var NgaModule = NgaModule_1 = (function () {
    function NgaModule() {
    }
    NgaModule.forRoot = function () {
        return {
            ngModule: NgaModule_1,
            providers: NGA_VALIDATORS.concat(NGA_SERVICES),
        };
    };
    return NgaModule;
}());
NgaModule = NgaModule_1 = __decorate([
    __webpack_require__.i(__WEBPACK_IMPORTED_MODULE_0__angular_core__["NgModule"])({
        declarations: NGA_DIRECTIVES.concat(NGA_COMPONENTS, [
            __WEBPACK_IMPORTED_MODULE_4__utilityServices_pipes_capitalize_pipe__["a" /* CapitalizePipe */],
            __WEBPACK_IMPORTED_MODULE_5__utilityServices_pipes_noComma_pipe__["a" /* NoCommaDecimalPipe */]
        ]),
        imports: [
            __WEBPACK_IMPORTED_MODULE_1__angular_common__["CommonModule"],
            __WEBPACK_IMPORTED_MODULE_3__angular_router__["RouterModule"],
            __WEBPACK_IMPORTED_MODULE_2__angular_forms__["FormsModule"],
            __WEBPACK_IMPORTED_MODULE_2__angular_forms__["ReactiveFormsModule"]
        ],
        exports: NGA_DIRECTIVES.concat(NGA_COMPONENTS, [
            __WEBPACK_IMPORTED_MODULE_4__utilityServices_pipes_capitalize_pipe__["a" /* CapitalizePipe */],
            __WEBPACK_IMPORTED_MODULE_5__utilityServices_pipes_noComma_pipe__["a" /* NoCommaDecimalPipe */]
        ])
    })
], NgaModule);

var NgaModule_1;
//# sourceMappingURL=nga.module.js.map

/***/ }),

/***/ 130:
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_0__angular_core__ = __webpack_require__(2);
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "a", function() { return BaThemeSpinner; });
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
var __metadata = (this && this.__metadata) || function (k, v) {
    if (typeof Reflect === "object" && typeof Reflect.metadata === "function") return Reflect.metadata(k, v);
};

var BaThemeSpinner = (function () {
    function BaThemeSpinner() {
        //Initial View Loading Spinner
        this._selector = 'preloader';
        //Spiner for show any long openrations
        this._contentselector = 'preloaderContent';
        this._element = document.getElementById(this._selector);
        this._contentElement = document.getElementById(this._contentselector);
    }
    BaThemeSpinner.prototype.show = function () {
        this._element.style['display'] = 'block';
    };
    BaThemeSpinner.prototype.hide = function (delay) {
        var _this = this;
        if (delay === void 0) { delay = 0; }
        setTimeout(function () {
            _this._element.style['display'] = 'none';
        }, delay);
    };
    BaThemeSpinner.prototype.showProgress = function (delay) {
        var _this = this;
        if (delay === void 0) { delay = 0; }
        setTimeout(function () {
            _this._contentElement.style['display'] = 'block';
        }, delay);
    };
    BaThemeSpinner.prototype.hideProgress = function (delay) {
        var _this = this;
        if (delay === void 0) { delay = 0; }
        setTimeout(function () {
            _this._contentElement.style['display'] = 'none';
        }, delay);
    };
    return BaThemeSpinner;
}());
BaThemeSpinner = __decorate([
    __webpack_require__.i(__WEBPACK_IMPORTED_MODULE_0__angular_core__["Injectable"])(),
    __metadata("design:paramtypes", [])
], BaThemeSpinner);

//# sourceMappingURL=baThemeSpinner.service.js.map

/***/ }),

/***/ 131:
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_0__angular_core__ = __webpack_require__(2);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_1__angular_http__ = __webpack_require__(128);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_2_rxjs_Observable__ = __webpack_require__(0);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_2_rxjs_Observable___default = __webpack_require__.n(__WEBPACK_IMPORTED_MODULE_2_rxjs_Observable__);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_3__app_constant__ = __webpack_require__(391);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_4__app_authentication__ = __webpack_require__(36);
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "a", function() { return HttpClientHelper; });
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
var __metadata = (this && this.__metadata) || function (k, v) {
    if (typeof Reflect === "object" && typeof Reflect.metadata === "function") return Reflect.metadata(k, v);
};





var HttpClientHelper = (function () {
    function HttpClientHelper(http, authService) {
        this.http = http;
        this.authService = authService;
        this.baseUrl = __WEBPACK_IMPORTED_MODULE_3__app_constant__["c" /* HTTP_CONFIG */].baseUrl;
        this.publicUrl = __WEBPACK_IMPORTED_MODULE_3__app_constant__["c" /* HTTP_CONFIG */].publicUrl;
        this.http = http;
    }
    /**
     * function to create Authorization header.
     */
    HttpClientHelper.prototype.createAuthorizationHeader = function () {
        var headers = new __WEBPACK_IMPORTED_MODULE_1__angular_http__["d" /* Headers */]();
        headers.append('Content-Type', 'application/json');
        headers.append('Authorization', this.authService.tokenKey + ' ' + this.authService.getToken());
        headers.append('Access-Control-Allow-Origin', '*');
        return headers;
    };
    /**
     * Performs a request with `get` http method.
     * @param url
     */
    HttpClientHelper.prototype.get = function (url) {
        url = this.baseUrl + url;
        var headers = this.createAuthorizationHeader();
        return this.http.get(url, { headers: headers })
            .map(this.extractResponse)
            .catch(this.handleError);
    };
    HttpClientHelper.prototype.postPreLogin = function (url, data) {
        var body = JSON.stringify(data);
        var headers = this.createAuthorizationHeader();
        url = this.baseUrl + url;
        return this.http.post(url, body, { headers: headers })
            .map(this.extractResponse)
            .catch(this.handleError);
    };
    /**
     * Performs a request with `post` http method.
     * @param url
     * @param data
     */
    HttpClientHelper.prototype.post = function (url, data) {
        var body = JSON.stringify(data);
        var headers = this.createAuthorizationHeader();
        url = this.baseUrl + url;
        return this.http.post(url, body, { headers: headers })
            .map(this.extractResponse)
            .catch(this.handleError);
    };
    /**
     * Performs a request with `put` http method.
     * @param url
     * @param data
     */
    HttpClientHelper.prototype.put = function (url, data) {
        var body = JSON.stringify(data);
        var headers = this.createAuthorizationHeader();
        url = this.baseUrl + url;
        return this.http.put(url, body, { headers: headers })
            .map(this.extractResponse)
            .catch(this.handleError);
    };
    /**
     * Performs a request with `delete` http method.
     * @param url
     */
    HttpClientHelper.prototype.delete = function (url) {
        var options;
        var headers = this.createAuthorizationHeader();
        options = new __WEBPACK_IMPORTED_MODULE_1__angular_http__["c" /* RequestOptions */]({ headers: headers });
        return this.http.delete(this.baseUrl + url, options)
            .map(this.extractResponse)
            .catch(this.handleError);
    };
    /**
     * Converts response into json.
     */
    HttpClientHelper.prototype.extractResponse = function (res) {
        var body = res.json();
        return body;
    };
    /**
     *  Handles error comming in response.
     */
    HttpClientHelper.prototype.handleError = function (error) {
        var result = error.json();
        if (!result || !result.error_message) {
            result.error_message = 'Something went wrong.';
        }
        else {
            if (result.error_code === '102' || result.error_code === '103') {
                this.authService.removeLoggedIn();
            }
        }
        return __WEBPACK_IMPORTED_MODULE_2_rxjs_Observable__["Observable"].throw(result || 'Please check internet connection');
    };
    return HttpClientHelper;
}());
HttpClientHelper = __decorate([
    __webpack_require__.i(__WEBPACK_IMPORTED_MODULE_0__angular_core__["Injectable"])(),
    __metadata("design:paramtypes", [typeof (_a = typeof __WEBPACK_IMPORTED_MODULE_1__angular_http__["e" /* Http */] !== "undefined" && __WEBPACK_IMPORTED_MODULE_1__angular_http__["e" /* Http */]) === "function" && _a || Object, typeof (_b = typeof __WEBPACK_IMPORTED_MODULE_4__app_authentication__["a" /* AuthenticationHelper */] !== "undefined" && __WEBPACK_IMPORTED_MODULE_4__app_authentication__["a" /* AuthenticationHelper */]) === "function" && _b || Object])
], HttpClientHelper);

var _a, _b;
//# sourceMappingURL=app.httpClient.js.map

/***/ }),

/***/ 177:
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_0__angular_core__ = __webpack_require__(2);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_1__angular_router__ = __webpack_require__(20);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_2__app_authentication__ = __webpack_require__(36);
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "a", function() { return AdminGuard; });
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
var __metadata = (this && this.__metadata) || function (k, v) {
    if (typeof Reflect === "object" && typeof Reflect.metadata === "function") return Reflect.metadata(k, v);
};



var AdminGuard = (function () {
    function AdminGuard(authService, route) {
        this.authService = authService;
        this.route = route;
    }
    AdminGuard.prototype.canActivate = function () {
        if (!this.authService.isSuperAdmin()) {
            this.route.navigate(['dashboard']);
            return false;
        }
        else {
            return true;
        }
    };
    return AdminGuard;
}());
AdminGuard = __decorate([
    __webpack_require__.i(__WEBPACK_IMPORTED_MODULE_0__angular_core__["Injectable"])(),
    __metadata("design:paramtypes", [typeof (_a = typeof __WEBPACK_IMPORTED_MODULE_2__app_authentication__["a" /* AuthenticationHelper */] !== "undefined" && __WEBPACK_IMPORTED_MODULE_2__app_authentication__["a" /* AuthenticationHelper */]) === "function" && _a || Object, typeof (_b = typeof __WEBPACK_IMPORTED_MODULE_1__angular_router__["Router"] !== "undefined" && __WEBPACK_IMPORTED_MODULE_1__angular_router__["Router"]) === "function" && _b || Object])
], AdminGuard);

var _a, _b;
//# sourceMappingURL=app.adminGuard.js.map

/***/ }),

/***/ 178:
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_0__angular_core__ = __webpack_require__(2);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_1__angular_router__ = __webpack_require__(20);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_2__app_authentication__ = __webpack_require__(36);
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "a", function() { return LoginGuard; });
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
var __metadata = (this && this.__metadata) || function (k, v) {
    if (typeof Reflect === "object" && typeof Reflect.metadata === "function") return Reflect.metadata(k, v);
};



var LoginGuard = (function () {
    function LoginGuard(authService, route) {
        this.authService = authService;
        this.route = route;
    }
    LoginGuard.prototype.canActivate = function () {
        if (!this.authService.isLoggedIn()) {
            this.route.navigate(['createPurchaseOrder']);
            return false;
        }
        else {
            return true;
        }
    };
    return LoginGuard;
}());
LoginGuard = __decorate([
    __webpack_require__.i(__WEBPACK_IMPORTED_MODULE_0__angular_core__["Injectable"])(),
    __metadata("design:paramtypes", [typeof (_a = typeof __WEBPACK_IMPORTED_MODULE_2__app_authentication__["a" /* AuthenticationHelper */] !== "undefined" && __WEBPACK_IMPORTED_MODULE_2__app_authentication__["a" /* AuthenticationHelper */]) === "function" && _a || Object, typeof (_b = typeof __WEBPACK_IMPORTED_MODULE_1__angular_router__["Router"] !== "undefined" && __WEBPACK_IMPORTED_MODULE_1__angular_router__["Router"]) === "function" && _b || Object])
], LoginGuard);

var _a, _b;
//# sourceMappingURL=app.guard.js.map

/***/ }),

/***/ 179:
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_0__angular_core__ = __webpack_require__(2);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_1__theme__ = __webpack_require__(181);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_2__pages_menu__ = __webpack_require__(180);
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "a", function() { return Pages; });
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
var __metadata = (this && this.__metadata) || function (k, v) {
    if (typeof Reflect === "object" && typeof Reflect.metadata === "function") return Reflect.metadata(k, v);
};




var Pages = (function () {
    function Pages(_menuService) {
        this._menuService = _menuService;
        // + sign converts string to number
        this.userRoleId = +localStorage.getItem('user_role_id');
    }
    Pages.prototype.ngOnInit = function () {
        switch (this.userRoleId) {
            case 1: {
                // Super Admin
                this._menuService.updateMenuByRoutes(__WEBPACK_IMPORTED_MODULE_2__pages_menu__["a" /* SU_MENU */]);
                break;
            }
            case 2: {
                // Admin
                this._menuService.updateMenuByRoutes(__WEBPACK_IMPORTED_MODULE_2__pages_menu__["b" /* ADMIN_MENU */]);
                break;
            }
        }
        this.currentYear = new Date().getFullYear();
    };
    return Pages;
}());
Pages = __decorate([
    __webpack_require__.i(__WEBPACK_IMPORTED_MODULE_0__angular_core__["Component"])({
        selector: 'pages',
        template: "\n    <ba-sidebar></ba-sidebar>\n    <ba-page-top></ba-page-top>\n    <div class=\"al-main\">\n      <div class=\"al-content\">\n        <ba-content-top></ba-content-top>\n        </div>\n        <div>\n        <router-outlet></router-outlet>\n      </div>\n    </div>\n    <footer class=\"al-footer clearfix\">\n      <div class=\"al-footer-main clearfix\">\n        <div class=\"al-copy\">&copy; <a href=\"http://tudip.com/\" translate> Tudip Technologies </a>{{currentYear}}</div>\n      </div>\n    </footer>\n    <ba-back-top position=\"200\"></ba-back-top>\n    "
    }),
    __metadata("design:paramtypes", [typeof (_a = typeof __WEBPACK_IMPORTED_MODULE_1__theme__["a" /* BaMenuService */] !== "undefined" && __WEBPACK_IMPORTED_MODULE_1__theme__["a" /* BaMenuService */]) === "function" && _a || Object])
], Pages);

var _a;
//# sourceMappingURL=pages.component.js.map

/***/ }),

/***/ 180:
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "a", function() { return SU_MENU; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "b", function() { return ADMIN_MENU; });
var SU_MENU = [
    {
        path: 'createPurchaseOrder',
        data: {
            menu: {
                title: 'Purchase Orders',
                icon: 'fa fa-money',
                selected: false,
                expanded: false,
                order: 0,
            },
        },
    },
    {
        path: 'viewVendors',
        data: {
            menu: {
                title: ' Vendors',
                icon: 'fa fa-user-circle ',
                selected: false,
                expanded: false,
                order: 0,
            },
        },
    },
    {
        path: 'viewItems',
        data: {
            menu: {
                title: ' Items',
                icon: 'fa fa-list',
                selected: false,
                expanded: false,
                order: 0,
            },
        },
    },
    {
        path: 'viewCategoryItems',
        data: {
            menu: {
                title: ' Category-Items',
                icon: 'fa fa-puzzle-piece',
                selected: false,
                expanded: false,
                order: 0,
            },
        },
    },
    {
        path: 'viewCategoryVendors',
        data: {
            menu: {
                title: ' Category-Vendors',
                icon: 'fa fa-handshake-o',
                selected: false,
                expanded: false,
                order: 0,
            },
        },
    },
    {
        path: 'viewReports',
        data: {
            menu: {
                title: ' Reports',
                icon: 'fa fa-bar-chart',
                selected: false,
                expanded: false,
                order: 0,
            },
        },
    },
    {
        path: 'viewExpenses',
        data: {
            menu: {
                title: 'Expenses',
                icon: 'icon ion-calculator',
                selected: false,
                expanded: false,
                order: 0,
            },
        },
    },
    {
        path: 'viewUsers',
        data: {
            menu: {
                title: ' Users',
                icon: 'icon ion-person-stalker',
                selected: false,
                expanded: false,
                order: 0,
            },
        },
    },
    {
        path: '',
        data: {
            menu: {
                title: 'Configuration',
                icon: 'fa fa-cog ',
                selected: false,
                expanded: false,
                order: 0,
            },
        },
        children: [
            {
                path: 'almirah',
                data: {
                    menu: {
                        title: ' Almirah',
                        icon: 'fa fa-columns',
                        selected: false,
                        expanded: false,
                        order: 0,
                    },
                },
            },
            {
                path: 'viewCategories',
                data: {
                    menu: {
                        title: ' Categories ',
                        icon: 'fa fa-tags',
                        selected: false,
                        expanded: false,
                        order: 0,
                    },
                },
            },
            {
                path: 'viewTermsAndConditions',
                data: {
                    menu: {
                        title: ' T&C',
                        icon: 'fa fa-file-text-o',
                        selected: false,
                        expanded: false,
                        order: 0,
                    },
                },
            },
            {
                path: 'viewTemplates',
                data: {
                    menu: {
                        title: 'Templates',
                        icon: 'fa fa-file-o',
                        selected: false,
                        expanded: false,
                        order: 0,
                    },
                },
            },
            {
                path: 'viewUnits',
                data: {
                    menu: {
                        title: 'Units',
                        icon: 'fa fa-building',
                        selected: false,
                        expanded: false,
                        order: 0,
                    },
                },
            },
        ],
    },
];
var ADMIN_MENU = [
    {
        path: 'createPurchaseOrder',
        data: {
            menu: {
                title: 'Purchase Orders',
                icon: 'fa fa-money',
                selected: false,
                expanded: false,
                order: 0,
            },
        },
    },
    {
        path: 'viewVendors',
        data: {
            menu: {
                title: ' Vendors',
                icon: 'fa fa-user-circle ',
                selected: false,
                expanded: false,
                order: 0,
            },
        },
    },
    {
        path: 'viewItems',
        data: {
            menu: {
                title: ' Items',
                icon: 'fa fa-list',
                selected: false,
                expanded: false,
                order: 0,
            },
        },
    },
    {
        path: 'viewCategoryItems',
        data: {
            menu: {
                title: ' Category-Items',
                icon: 'fa fa-puzzle-piece',
                selected: false,
                expanded: false,
                order: 0,
            },
        },
    },
    {
        path: 'viewCategoryVendors',
        data: {
            menu: {
                title: ' Category-Vendors',
                icon: 'fa fa-handshake-o',
                selected: false,
                expanded: false,
                order: 0,
            },
        },
    },
    {
        path: 'viewExpenses',
        data: {
            menu: {
                title: 'Expenses',
                icon: 'icon ion-calculator',
                selected: false,
                expanded: false,
                order: 0,
            },
        },
    },
];
//# sourceMappingURL=pages.menu.js.map

/***/ }),

/***/ 181:
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_0__services__ = __webpack_require__(65);
/* harmony reexport (binding) */ __webpack_require__.d(__webpack_exports__, "a", function() { return __WEBPACK_IMPORTED_MODULE_0__services__["b"]; });
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_1__theme_constants__ = __webpack_require__(433);
/* harmony namespace reexport (by used) */ __webpack_require__.d(__webpack_exports__, "b", function() { return __WEBPACK_IMPORTED_MODULE_1__theme_constants__["a"]; });


//# sourceMappingURL=index.js.map

/***/ }),

/***/ 36:
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_0__angular_core__ = __webpack_require__(2);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_1__utilityServices_app_utility__ = __webpack_require__(64);
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "a", function() { return AuthenticationHelper; });
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
var __metadata = (this && this.__metadata) || function (k, v) {
    if (typeof Reflect === "object" && typeof Reflect.metadata === "function") return Reflect.metadata(k, v);
};


var AuthenticationHelper = (function () {
    function AuthenticationHelper(userUtility) {
        this.userUtility = userUtility;
        this.userKey = 'user';
        this.tokenKey = 'auth_token';
        this.userRole = 'user_role_id';
        this.changeContentTopText = new __WEBPACK_IMPORTED_MODULE_0__angular_core__["EventEmitter"](true);
        this.userValueChanged = new __WEBPACK_IMPORTED_MODULE_0__angular_core__["EventEmitter"](true);
    }
    AuthenticationHelper.prototype.setToken = function (token) {
        localStorage.setItem('token', token);
    };
    AuthenticationHelper.prototype.setApiKey = function (api_key) {
        localStorage.setItem('api-key', api_key);
    };
    AuthenticationHelper.prototype.setUserLocal = function (value) {
        var rolesArray = value.success.data.user.roles.map(function (item) {
            return item.role.name;
        });
        if (value.success.data.user) {
            if (rolesArray.indexOf('admin') !== -1) {
                localStorage.setItem('userName', 'ADMIN');
                localStorage.setItem('user', JSON.stringify(value.success.data.user));
                localStorage.setItem('roles', rolesArray);
                localStorage.setItem('profileImageURL', value.success.data.user.profileImageURL);
            }
            else {
                localStorage.setItem('user', JSON.stringify(value.success.data.user));
                localStorage.setItem('userName', value.success.data.user.firstName);
                localStorage.setItem('roles', rolesArray);
                localStorage.setItem('email', value.success.data.user.email);
                localStorage.setItem('profileImageURL', value.success.data.user.profileImageURL);
            }
        }
    };
    AuthenticationHelper.prototype.getToken = function () {
        return localStorage.getItem('auth_token');
    };
    AuthenticationHelper.prototype.removeLoggedIn = function () {
        localStorage.removeItem(this.tokenKey);
        localStorage.removeItem(this.userRole);
        localStorage.removeItem('userName');
        localStorage.removeItem('userId');
    };
    AuthenticationHelper.prototype.isLoggedIn = function () {
        var token = localStorage.getItem(this.tokenKey);
        if (token && token.length > 0) {
            return true;
        }
        return false;
    };
    AuthenticationHelper.prototype.setLoggedIn = function (res) {
        var token = res.data.auth_token;
        if (token == undefined) {
        }
        else {
            console.log(res, 'res');
            localStorage.setItem(this.tokenKey, token);
            localStorage.setItem(this.userRole, res.data.user_role_id);
            localStorage.setItem('userName', res.data.user_name.name);
            this.userUtility.userName = res.data.user_name.name;
            localStorage.setItem('userId', res.data.id_user);
        }
    };
    // isLoggedIn() {
    //     let token = this.getToken();
    //     if (token && token.length > 0) {
    //         return true;
    //     }
    //     return false;
    // }
    AuthenticationHelper.prototype.isAdmin = function () {
        var userRole = localStorage.getItem(this.userRole);
        var response;
        return response = (userRole == 2);
    };
    AuthenticationHelper.prototype.isSuperAdmin = function () {
        var userRole = localStorage.getItem(this.userRole);
        var response;
        return response = (userRole == 1);
    };
    AuthenticationHelper.prototype.getUserData = function () {
        return localStorage.getItem(this.userKey);
    };
    AuthenticationHelper.prototype.setIsLoggedIn = function (isLoggedIn) {
        localStorage.setItem('IsLoggedIn', isLoggedIn);
    };
    AuthenticationHelper.prototype.setChangedContentTopText = function (value) {
        this.changeContentTopText.emit(value);
    };
    AuthenticationHelper.prototype.getChangedContentTopText = function () {
        return this.changeContentTopText;
    };
    AuthenticationHelper.prototype.userValueChangedEvent = function (value) {
        this.user = value;
        this.userValueChanged.emit(value);
    };
    AuthenticationHelper.prototype.getUserValueChangeEmitter = function () {
        return this.userValueChanged;
    };
    AuthenticationHelper.prototype.setUser = function (inputUser) {
        this.user = inputUser;
    };
    AuthenticationHelper.prototype.getUser = function () {
        return this.user;
    };
    return AuthenticationHelper;
}());
__decorate([
    __webpack_require__.i(__WEBPACK_IMPORTED_MODULE_0__angular_core__["Output"])(),
    __metadata("design:type", typeof (_a = typeof __WEBPACK_IMPORTED_MODULE_0__angular_core__["EventEmitter"] !== "undefined" && __WEBPACK_IMPORTED_MODULE_0__angular_core__["EventEmitter"]) === "function" && _a || Object)
], AuthenticationHelper.prototype, "changeContentTopText", void 0);
__decorate([
    __webpack_require__.i(__WEBPACK_IMPORTED_MODULE_0__angular_core__["Output"])(),
    __metadata("design:type", typeof (_b = typeof __WEBPACK_IMPORTED_MODULE_0__angular_core__["EventEmitter"] !== "undefined" && __WEBPACK_IMPORTED_MODULE_0__angular_core__["EventEmitter"]) === "function" && _b || Object)
], AuthenticationHelper.prototype, "userValueChanged", void 0);
AuthenticationHelper = __decorate([
    __webpack_require__.i(__WEBPACK_IMPORTED_MODULE_0__angular_core__["Injectable"])(),
    __metadata("design:paramtypes", [typeof (_c = typeof __WEBPACK_IMPORTED_MODULE_1__utilityServices_app_utility__["a" /* Utility */] !== "undefined" && __WEBPACK_IMPORTED_MODULE_1__utilityServices_app_utility__["a" /* Utility */]) === "function" && _c || Object])
], AuthenticationHelper);

var _a, _b, _c;
//# sourceMappingURL=app.authentication.js.map

/***/ }),

/***/ 363:
/***/ (function(module, exports, __webpack_require__) {

var map = {
	"./InActiveUser/inActiveUser.module": [
		817,
		12
	],
	"./Profile/profile.module": [
		818,
		26
	],
	"./addAlmirah/addAlmirah.module": [
		819,
		40
	],
	"./addCompanyUnit/addCompanyUnit.module": [
		820,
		35
	],
	"./addExpenseModel/addExpenseModel.module": [
		821,
		30
	],
	"./addItem/addItem.module": [
		822,
		39
	],
	"./addOffering/addOffering.module": [
		823,
		10
	],
	"./addT&C/addT&C.module": [
		824,
		37
	],
	"./addTemplate/addTemplate.module": [
		825,
		34
	],
	"./addUser/addUser.module": [
		826,
		42
	],
	"./addVendor/addVendor.module": [
		827,
		7
	],
	"./almirah/almirah.module": [
		828,
		22
	],
	"./browseOfferings/browseOfferings.module": [
		829,
		28
	],
	"./createPurchaseOrder/createPurchaseOrder.module": [
		830,
		6
	],
	"./editAlmirah/editAlmirah.module": [
		831,
		38
	],
	"./editCompanyUnit/editCompanyUnit.module": [
		832,
		33
	],
	"./editExpenseModel/editExpenseModel.module": [
		833,
		29
	],
	"./editItem/editItem.module": [
		834,
		1
	],
	"./editOffering/editOffering.module": [
		835,
		9
	],
	"./editPurchaseOrder/editPurchaseOrder.module": [
		836,
		0
	],
	"./editT&C/editT&C.module": [
		837,
		36
	],
	"./editTemplate/editTemplate.module": [
		838,
		32
	],
	"./editUser/editUser.module": [
		839,
		41
	],
	"./editVendor/editVendor.module": [
		840,
		5
	],
	"./email/email.module": [
		841,
		50
	],
	"./investor/investor.module": [
		844,
		25
	],
	"./investorProfile/investorProfile.module": [
		845,
		8
	],
	"./item/item.module": [
		846,
		21
	],
	"./manageOfferings/offerings.module": [
		848,
		27
	],
	"./offering/offering.module": [
		849,
		44
	],
	"./paymentDetails/paymentDetails.module": [
		850,
		3
	],
	"./purchaseOrder/purchaseOrder.module": [
		851,
		11
	],
	"./receivedItems/receivedItems.module": [
		852,
		2
	],
	"./sendMail/sendMail.module": [
		854,
		31
	],
	"./settings/settings.module": [
		856,
		24
	],
	"./vendor/vendor.module": [
		858,
		20
	],
	"./viewCategoryItems/viewCategoryItems.module": [
		859,
		19
	],
	"./viewCategoryVendors/viewCategoryVendors.module": [
		860,
		18
	],
	"./viewExpenseModel/viewExpenseModel.module": [
		861,
		4
	],
	"./viewReports/viewReports.module": [
		862,
		17
	],
	"./viewTags/viewTags.module": [
		863,
		16
	],
	"./viewTemplates/viewTemplates.module": [
		864,
		15
	],
	"./viewTermsAndConditions/viewTermsAndConditions.module": [
		865,
		23
	],
	"./viewUnits/viewUnits.module": [
		866,
		14
	],
	"./viewUsers/viewUsers.module": [
		867,
		13
	],
	"app/pages/emailVerificationConfirmation/emailVerificationConfirmation.module": [
		842,
		49
	],
	"app/pages/forgotPassword/forgotPassword.module": [
		843,
		48
	],
	"app/pages/login/login.module": [
		847,
		45
	],
	"app/pages/resetPassword/resetPassword.module": [
		853,
		47
	],
	"app/pages/setPassword/setPassword.module": [
		855,
		46
	],
	"app/pages/signUp/signUp.module": [
		857,
		43
	]
};
function webpackAsyncContext(req) {
	var ids = map[req];	if(!ids)
		return Promise.reject(new Error("Cannot find module '" + req + "'."));
	return __webpack_require__.e(ids[1]).then(function() {
		return __webpack_require__(ids[0]);
	});
};
webpackAsyncContext.keys = function webpackAsyncContextKeys() {
	return Object.keys(map);
};
module.exports = webpackAsyncContext;
webpackAsyncContext.id = 363;


/***/ }),

/***/ 364:
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
Object.defineProperty(__webpack_exports__, "__esModule", { value: true });
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_0__angular_platform_browser_dynamic__ = __webpack_require__(398);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_1__app_app_module__ = __webpack_require__(405);


__webpack_require__.i(__WEBPACK_IMPORTED_MODULE_0__angular_platform_browser_dynamic__["a" /* platformBrowserDynamic */])().bootstrapModule(__WEBPACK_IMPORTED_MODULE_1__app_app_module__["a" /* AppModule */]);
//# sourceMappingURL=main.js.map

/***/ }),

/***/ 389:
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "a", function() { return EqualPasswordsValidator; });
var EqualPasswordsValidator = (function () {
    function EqualPasswordsValidator() {
    }
    EqualPasswordsValidator.validate = function (firstField, secondField) {
        return function (c) {
            return (c.controls && c.controls[firstField].value == c.controls[secondField].value) ? null : {
                passwordsEqual: {
                    valid: false
                }
            };
        };
    };
    return EqualPasswordsValidator;
}());

//# sourceMappingURL=equalPasswords.validator.js.map

/***/ }),

/***/ 390:
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "a", function() { return EmailValidator; });
var EmailValidator = (function () {
    function EmailValidator() {
    }
    EmailValidator.validate = function (c) {
        var EMAIL_REGEXP = /^(([^<>()\[\]\\.,;:\s@"]+(\.[^<>()\[\]\\.,;:\s@"]+)*)|(".+"))@((\[[0-9]{1,3}\.[0-9]{1,3}\.[0-9]{1,3}\.[0-9]{1,3}])|(([a-zA-Z\-0-9]+\.)+[a-zA-Z]{2,}))$/;
        return EMAIL_REGEXP.test(c.value) ? null : {
            validateEmail: {
                valid: false
            }
        };
    };
    return EmailValidator;
}());

//# sourceMappingURL=email.validator.js.map

/***/ }),

/***/ 391:
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "a", function() { return AppConstant; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "b", function() { return Constants; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "c", function() { return HTTP_CONFIG; });
var AppConstant = (function () {
    function AppConstant() {
        //constant variables
        this.LogoImage = 'https://recruitment.tudip.com/assets/img/logomain.png';
    }
    return AppConstant;
}());

var Constants = (function () {
    function Constants() {
        this.FBERROR = 'Facebook has denied authentication, please try again';
        this.FBALERT = 'Cancelled by user, please try again';
    }
    return Constants;
}());

var HTTP_CONFIG = {
    // base url local
    publicUrl: 'https://po-api.tudip.com',
    baseUrl: 'https://po-api.tudip.com/api/auth',
    // publicUrl: 'http://127.0.0.1:8000',
    // baseUrl: 'http://127.0.0.1:8000/api/auth',
    //  baseUrl: 'http://vastu-api.tudip.com/api/auth',
    // base url server
    // baseUrl: 'http://45.79.103.182:3026/',
    apiKey: 'd71a0600eb536f75c2d6de65f18628b5',
};
//# sourceMappingURL=app.constant.js.map

/***/ }),

/***/ 392:
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_0__email_validator__ = __webpack_require__(390);
/* harmony namespace reexport (by used) */ __webpack_require__.d(__webpack_exports__, "b", function() { return __WEBPACK_IMPORTED_MODULE_0__email_validator__["a"]; });
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_1__equalPasswords_validator__ = __webpack_require__(389);
/* harmony namespace reexport (by used) */ __webpack_require__.d(__webpack_exports__, "a", function() { return __WEBPACK_IMPORTED_MODULE_1__equalPasswords_validator__["a"]; });


//# sourceMappingURL=index.js.map

/***/ }),

/***/ 393:
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_0__angular_core__ = __webpack_require__(2);
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "a", function() { return UtilityHelper; });
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
var __metadata = (this && this.__metadata) || function (k, v) {
    if (typeof Reflect === "object" && typeof Reflect.metadata === "function") return Reflect.metadata(k, v);
};

var UtilityHelper = (function () {
    function UtilityHelper() {
    }
    UtilityHelper.prototype.getFormattedDate = function (dates) {
        var date = new Date(dates);
        var displayDate = (date.getUTCMonth() + 1) + '/'
            + date.getDate() + '/' + date.getFullYear();
        return displayDate;
    };
    UtilityHelper.prototype.toTitleCase = function (str) {
        return str.replace(/\w\S*/g, function (txt) {
            return txt.charAt(0).toUpperCase() + txt.substr(1).toLowerCase();
        });
    };
    /**
     * To convert base 64 to blob
     * @param base64Data
     * @param contentType
     * @returns {Blob}
     */
    UtilityHelper.prototype.base64toBlob = function (base64Data, contentType) {
        contentType = contentType || '';
        var sliceSize = 1024;
        var byteCharacters = atob(base64Data);
        var bytesLength = byteCharacters.length;
        var slicesCount = Math.ceil(bytesLength / sliceSize);
        var byteArrays = new Array(slicesCount);
        for (var sliceIndex = 0; sliceIndex < slicesCount; ++sliceIndex) {
            var begin = sliceIndex * sliceSize;
            var end = Math.min(begin + sliceSize, bytesLength);
            var bytes = new Array(end - begin);
            for (var offset = begin, i = 0; offset < end; ++i, ++offset) {
                bytes[i] = byteCharacters[offset].charCodeAt(0);
            }
            byteArrays[sliceIndex] = new Uint8Array(bytes);
        }
        return new Blob(byteArrays, { type: 'xls' });
    };
    UtilityHelper.prototype.trimContent = function (form, value, control) {
        if (value) {
            form.controls[control].setValue(value.trim());
        }
        return value.trim();
    };
    UtilityHelper.prototype.formatDate = function (inputDate) {
        if (inputDate) {
            var date = new Date(inputDate);
            var formatted = {
                year: date.getFullYear(),
                month: date.getMonth() + 1,
                day: date.getDate()
            };
            return formatted;
        }
        else {
            return '';
        }
    };
    ;
    return UtilityHelper;
}());
UtilityHelper = __decorate([
    __webpack_require__.i(__WEBPACK_IMPORTED_MODULE_0__angular_core__["Injectable"])(),
    __metadata("design:paramtypes", [])
], UtilityHelper);

//# sourceMappingURL=utility.js.map

/***/ }),

/***/ 404:
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_0__angular_core__ = __webpack_require__(2);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_1__global_state__ = __webpack_require__(43);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_2_ng2_toastr_ng2_toastr__ = __webpack_require__(63);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_2_ng2_toastr_ng2_toastr___default = __webpack_require__.n(__WEBPACK_IMPORTED_MODULE_2_ng2_toastr_ng2_toastr__);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_3__theme_services__ = __webpack_require__(65);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_4_rxjs_Observable__ = __webpack_require__(0);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_4_rxjs_Observable___default = __webpack_require__.n(__WEBPACK_IMPORTED_MODULE_4_rxjs_Observable__);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_5_app_appServices_application__ = __webpack_require__(86);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_6__utilityServices_app_utility__ = __webpack_require__(64);
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "a", function() { return App; });
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
var __metadata = (this && this.__metadata) || function (k, v) {
    if (typeof Reflect === "object" && typeof Reflect.metadata === "function") return Reflect.metadata(k, v);
};







var App = (function () {
    function App(_state, _spinner, viewContainerRef, userUtility, appService, toastr, vRef) {
        var _this = this;
        this._state = _state;
        this._spinner = _spinner;
        this.viewContainerRef = viewContainerRef;
        this.userUtility = userUtility;
        this.appService = appService;
        this.toastr = toastr;
        this.isMenuCollapsed = false;
        this.isConnected = __WEBPACK_IMPORTED_MODULE_4_rxjs_Observable__["Observable"].merge(__WEBPACK_IMPORTED_MODULE_4_rxjs_Observable__["Observable"].of(navigator.onLine), __WEBPACK_IMPORTED_MODULE_4_rxjs_Observable__["Observable"].fromEvent(window, 'online').map(function () { return true; }), __WEBPACK_IMPORTED_MODULE_4_rxjs_Observable__["Observable"].fromEvent(window, 'offline').map(function () { return false; }));
        this.toastr.setRootViewContainerRef(vRef);
        this.getUserInfo();
        this._loadImages();
        this._state.subscribe('menu.isCollapsed', function (isCollapsed) {
            _this.isMenuCollapsed = isCollapsed;
        });
    }
    App.prototype.ngAfterViewInit = function () {
        var _this = this;
        // hide spinner once all loaders are completed
        __WEBPACK_IMPORTED_MODULE_3__theme_services__["c" /* BaThemePreloader */].load().then(function (values) {
            _this._spinner.hide();
        });
    };
    App.prototype.getUserInfo = function () {
        var _this = this;
        this.appService.getUserDetail().subscribe(function (data) { return _this.loginSuccess(data); }, function (error) { return _this.loginFail(error); });
    };
    App.prototype.loginSuccess = function (res) {
        // localStorage.setItem(this.userRole, res.data.user_role_id);
        localStorage.setItem('userName', res.data[0].name);
        this.userUtility.userName = res.data[0].name;
        localStorage.setItem('userId', res.data[0].id);
    };
    App.prototype.loginFail = function (err) {
        if (err.error && err.error.message) {
            this.toastr.error(err.error.message);
        }
        else {
            this.toastr.error('Server error');
        }
        this._spinner.hide();
    };
    App.prototype._loadImages = function () {
        // register some loaders
    };
    return App;
}());
App = __decorate([
    __webpack_require__.i(__WEBPACK_IMPORTED_MODULE_0__angular_core__["Component"])({
        selector: 'app',
        styles: [__webpack_require__(498)],
        template: "\n        <div class=\"connected\" *ngIf=\"!(isConnected | async)\">\n            <i class=\"fa fa-ban\" style=\"font-size:24px\"></i>\n            Check your internet connectiion\n        </div>\n    <main [ngClass]=\"{'menu-collapsed': isMenuCollapsed}\">\n      <div class=\"additional-bg\"></div>\n      <router-outlet></router-outlet>\n    </main>\n  "
    }),
    __metadata("design:paramtypes", [typeof (_a = typeof __WEBPACK_IMPORTED_MODULE_1__global_state__["a" /* GlobalState */] !== "undefined" && __WEBPACK_IMPORTED_MODULE_1__global_state__["a" /* GlobalState */]) === "function" && _a || Object, typeof (_b = typeof __WEBPACK_IMPORTED_MODULE_3__theme_services__["a" /* BaThemeSpinner */] !== "undefined" && __WEBPACK_IMPORTED_MODULE_3__theme_services__["a" /* BaThemeSpinner */]) === "function" && _b || Object, typeof (_c = typeof __WEBPACK_IMPORTED_MODULE_0__angular_core__["ViewContainerRef"] !== "undefined" && __WEBPACK_IMPORTED_MODULE_0__angular_core__["ViewContainerRef"]) === "function" && _c || Object, typeof (_d = typeof __WEBPACK_IMPORTED_MODULE_6__utilityServices_app_utility__["a" /* Utility */] !== "undefined" && __WEBPACK_IMPORTED_MODULE_6__utilityServices_app_utility__["a" /* Utility */]) === "function" && _d || Object, typeof (_e = typeof __WEBPACK_IMPORTED_MODULE_5_app_appServices_application__["a" /* ApplicationAdminServices */] !== "undefined" && __WEBPACK_IMPORTED_MODULE_5_app_appServices_application__["a" /* ApplicationAdminServices */]) === "function" && _e || Object, typeof (_f = typeof __WEBPACK_IMPORTED_MODULE_2_ng2_toastr_ng2_toastr__["ToastsManager"] !== "undefined" && __WEBPACK_IMPORTED_MODULE_2_ng2_toastr_ng2_toastr__["ToastsManager"]) === "function" && _f || Object, typeof (_g = typeof __WEBPACK_IMPORTED_MODULE_0__angular_core__["ViewContainerRef"] !== "undefined" && __WEBPACK_IMPORTED_MODULE_0__angular_core__["ViewContainerRef"]) === "function" && _g || Object])
], App);

var _a, _b, _c, _d, _e, _f, _g;
//# sourceMappingURL=app.component.js.map

/***/ }),

/***/ 405:
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_0__angular_core__ = __webpack_require__(2);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_1__angular_platform_browser__ = __webpack_require__(37);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_2__angular_platform_browser_animations__ = __webpack_require__(399);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_3__angular_forms__ = __webpack_require__(24);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_4__angular_http__ = __webpack_require__(128);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_5__angular_router__ = __webpack_require__(20);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_6__ng_bootstrap_ng_bootstrap__ = __webpack_require__(402);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_7_ng2_toastr_ng2_toastr__ = __webpack_require__(63);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_7_ng2_toastr_ng2_toastr___default = __webpack_require__.n(__WEBPACK_IMPORTED_MODULE_7_ng2_toastr_ng2_toastr__);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_8__app_routing__ = __webpack_require__(406);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_9_ng2_charts__ = __webpack_require__(394);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_9_ng2_charts___default = __webpack_require__.n(__WEBPACK_IMPORTED_MODULE_9_ng2_charts__);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_10__app_component__ = __webpack_require__(404);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_11__app_service__ = __webpack_require__(407);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_12__global_state__ = __webpack_require__(43);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_13__theme_nga_module__ = __webpack_require__(129);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_14__pages_pages_module__ = __webpack_require__(408);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_15__app_authentication__ = __webpack_require__(36);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_16__app_httpClient__ = __webpack_require__(131);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_17__appServices_application__ = __webpack_require__(86);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_18__filter_app_guard__ = __webpack_require__(178);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_19__filter_app_adminGuard__ = __webpack_require__(177);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_20__pages_shared_utility__ = __webpack_require__(393);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_21__angular_common__ = __webpack_require__(10);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_22__utilityServices_app_utility__ = __webpack_require__(64);
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "a", function() { return AppModule; });
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
var __metadata = (this && this.__metadata) || function (k, v) {
    if (typeof Reflect === "object" && typeof Reflect.metadata === "function") return Reflect.metadata(k, v);
};










// App is our top level component













// import { ViewTemplatesComponent } from './viewTemplates/viewTemplates.component';
// Application wide providers
var APP_PROVIDERS = [
    __WEBPACK_IMPORTED_MODULE_11__app_service__["a" /* AppState */],
    __WEBPACK_IMPORTED_MODULE_12__global_state__["a" /* GlobalState */],
    __WEBPACK_IMPORTED_MODULE_19__filter_app_adminGuard__["a" /* AdminGuard */],
    __WEBPACK_IMPORTED_MODULE_18__filter_app_guard__["a" /* LoginGuard */]
];
/**
 * `AppModule` is the main entry point into Angular2's bootstraping process
 */
var AppModule = (function () {
    function AppModule(appState) {
        this.appState = appState;
    }
    return AppModule;
}());
AppModule = __decorate([
    __webpack_require__.i(__WEBPACK_IMPORTED_MODULE_0__angular_core__["NgModule"])({
        bootstrap: [__WEBPACK_IMPORTED_MODULE_10__app_component__["a" /* App */]],
        declarations: [__WEBPACK_IMPORTED_MODULE_10__app_component__["a" /* App */]],
        imports: [
            __WEBPACK_IMPORTED_MODULE_1__angular_platform_browser__["BrowserModule"],
            __WEBPACK_IMPORTED_MODULE_4__angular_http__["a" /* HttpModule */],
            __WEBPACK_IMPORTED_MODULE_5__angular_router__["RouterModule"],
            __WEBPACK_IMPORTED_MODULE_3__angular_forms__["FormsModule"],
            __WEBPACK_IMPORTED_MODULE_9_ng2_charts__["ChartsModule"],
            __WEBPACK_IMPORTED_MODULE_3__angular_forms__["ReactiveFormsModule"],
            __WEBPACK_IMPORTED_MODULE_13__theme_nga_module__["a" /* NgaModule */].forRoot(),
            __WEBPACK_IMPORTED_MODULE_6__ng_bootstrap_ng_bootstrap__["a" /* NgbModule */].forRoot(),
            __WEBPACK_IMPORTED_MODULE_14__pages_pages_module__["a" /* PagesModule */],
            __WEBPACK_IMPORTED_MODULE_8__app_routing__["a" /* routing */],
            __WEBPACK_IMPORTED_MODULE_7_ng2_toastr_ng2_toastr__["ToastModule"].forRoot(),
            __WEBPACK_IMPORTED_MODULE_2__angular_platform_browser_animations__["a" /* BrowserAnimationsModule */]
        ],
        providers: [
            APP_PROVIDERS,
            __WEBPACK_IMPORTED_MODULE_15__app_authentication__["a" /* AuthenticationHelper */],
            __WEBPACK_IMPORTED_MODULE_16__app_httpClient__["a" /* HttpClientHelper */],
            __WEBPACK_IMPORTED_MODULE_17__appServices_application__["a" /* ApplicationAdminServices */],
            __WEBPACK_IMPORTED_MODULE_20__pages_shared_utility__["a" /* UtilityHelper */],
            __WEBPACK_IMPORTED_MODULE_21__angular_common__["DatePipe"],
            __WEBPACK_IMPORTED_MODULE_22__utilityServices_app_utility__["a" /* Utility */]
        ]
    }),
    __metadata("design:paramtypes", [typeof (_a = typeof __WEBPACK_IMPORTED_MODULE_11__app_service__["a" /* AppState */] !== "undefined" && __WEBPACK_IMPORTED_MODULE_11__app_service__["a" /* AppState */]) === "function" && _a || Object])
], AppModule);

var _a;
//# sourceMappingURL=app.module.js.map

/***/ }),

/***/ 406:
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_0__angular_router__ = __webpack_require__(20);
/* unused harmony export routes */
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "a", function() { return routing; });

var routes = [
    { path: '', redirectTo: 'login', pathMatch: 'full' },
    { path: '**', redirectTo: 'login' }
];
var routing = __WEBPACK_IMPORTED_MODULE_0__angular_router__["RouterModule"].forRoot(routes, { useHash: false });
//# sourceMappingURL=app.routing.js.map

/***/ }),

/***/ 407:
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_0__angular_core__ = __webpack_require__(2);
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "a", function() { return AppState; });
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
var __metadata = (this && this.__metadata) || function (k, v) {
    if (typeof Reflect === "object" && typeof Reflect.metadata === "function") return Reflect.metadata(k, v);
};

var AppState = (function () {
    function AppState() {
        this._state = {};
    }
    Object.defineProperty(AppState.prototype, "state", {
        // already return a clone of the current state
        get: function () {
            return this._state = this._clone(this._state);
        },
        // never allow mutation
        set: function (value) {
            throw new Error('do not mutate the `.state` directly');
        },
        enumerable: true,
        configurable: true
    });
    AppState.prototype.get = function (prop) {
        // use our state getter for the clone
        var state = this.state;
        return state.hasOwnProperty(prop) ? state[prop] : state;
    };
    AppState.prototype.set = function (prop, value) {
        // internally mutate our state
        return this._state[prop] = value;
    };
    AppState.prototype._clone = function (object) {
        // simple object clone
        return JSON.parse(JSON.stringify(object));
    };
    return AppState;
}());
AppState = __decorate([
    __webpack_require__.i(__WEBPACK_IMPORTED_MODULE_0__angular_core__["Injectable"])(),
    __metadata("design:paramtypes", [])
], AppState);

//# sourceMappingURL=app.service.js.map

/***/ }),

/***/ 408:
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_0__angular_core__ = __webpack_require__(2);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_1__angular_common__ = __webpack_require__(10);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_2__theme_nga_module__ = __webpack_require__(129);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_3__pages_routing__ = __webpack_require__(409);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_4__pages_component__ = __webpack_require__(179);
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "a", function() { return PagesModule; });
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};





var PagesModule = (function () {
    function PagesModule() {
    }
    return PagesModule;
}());
PagesModule = __decorate([
    __webpack_require__.i(__WEBPACK_IMPORTED_MODULE_0__angular_core__["NgModule"])({
        imports: [__WEBPACK_IMPORTED_MODULE_1__angular_common__["CommonModule"], __WEBPACK_IMPORTED_MODULE_2__theme_nga_module__["a" /* NgaModule */], __WEBPACK_IMPORTED_MODULE_3__pages_routing__["a" /* routing */]],
        declarations: [__WEBPACK_IMPORTED_MODULE_4__pages_component__["a" /* Pages */]]
    })
], PagesModule);

//# sourceMappingURL=pages.module.js.map

/***/ }),

/***/ 409:
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_0__angular_router__ = __webpack_require__(20);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_1__pages_component__ = __webpack_require__(179);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_2__filter_app_guard__ = __webpack_require__(178);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_3__filter_app_adminGuard__ = __webpack_require__(177);
/* unused harmony export routes */
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "a", function() { return routing; });




var routes = [
    {
        path: 'login',
        loadChildren: 'app/pages/login/login.module#LoginModule',
    },
    {
        path: '',
        loadChildren: 'app/pages/login/login.module#LoginModule'
    },
    {
        path: 'forgot-password',
        loadChildren: 'app/pages/forgotPassword/forgotPassword.module#ForgotPasswordModule'
    },
    {
        path: 'signup',
        loadChildren: 'app/pages/signUp/signUp.module#SignUpModule'
    },
    {
        path: 'reset-password',
        loadChildren: 'app/pages/resetPassword/resetPassword.module#ResetPasswordModule'
    },
    {
        path: 'set-password',
        loadChildren: 'app/pages/setPassword/setPassword.module#SetPasswordModule'
    },
    {
        path: 'email-verification',
        loadChildren: 'app/pages/emailVerificationConfirmation/emailVerificationConfirmation.module#EmailVerificationModule'
    },
    {
        path: '',
        component: __WEBPACK_IMPORTED_MODULE_1__pages_component__["a" /* Pages */],
        children: [
            {
                path: '',
                redirectTo: 'createPurchaseOrder',
                pathMatch: 'full'
            },
            {
                path: 'createPurchaseOrder',
                loadChildren: './createPurchaseOrder/createPurchaseOrder.module#createPurchaseOrderModule',
                canActivate: [__WEBPACK_IMPORTED_MODULE_2__filter_app_guard__["a" /* LoginGuard */]]
            },
            {
                path: 'addVendor',
                loadChildren: './addVendor/addVendor.module#addVendorModule',
                canActivate: [__WEBPACK_IMPORTED_MODULE_2__filter_app_guard__["a" /* LoginGuard */]]
            },
            {
                path: 'editVendor',
                loadChildren: './editVendor/editVendor.module#editVendorModule',
                canActivate: [__WEBPACK_IMPORTED_MODULE_2__filter_app_guard__["a" /* LoginGuard */]]
            },
            {
                path: 'viewVendors',
                loadChildren: './vendor/vendor.module#VendorModule',
                canActivate: [__WEBPACK_IMPORTED_MODULE_2__filter_app_guard__["a" /* LoginGuard */]]
            },
            {
                path: 'viewUsers',
                loadChildren: './viewUsers/viewUsers.module#viewUsersModule',
                canActivate: [__WEBPACK_IMPORTED_MODULE_2__filter_app_guard__["a" /* LoginGuard */], __WEBPACK_IMPORTED_MODULE_3__filter_app_adminGuard__["a" /* AdminGuard */]]
            },
            {
                path: 'viewExpenses',
                loadChildren: './viewExpenseModel/viewExpenseModel.module#viewExpenseModelModule',
                canActivate: [__WEBPACK_IMPORTED_MODULE_2__filter_app_guard__["a" /* LoginGuard */]]
            },
            {
                path: 'viewTermsAndConditions',
                loadChildren: './viewTermsAndConditions/viewTermsAndConditions.module#viewTermsAndConditionsModule',
                canActivate: [__WEBPACK_IMPORTED_MODULE_2__filter_app_guard__["a" /* LoginGuard */], __WEBPACK_IMPORTED_MODULE_3__filter_app_adminGuard__["a" /* AdminGuard */]]
            },
            {
                path: 'viewItems',
                loadChildren: './item/item.module#itemModule',
                canActivate: [__WEBPACK_IMPORTED_MODULE_2__filter_app_guard__["a" /* LoginGuard */]]
            },
            {
                path: 'viewCategoryItems',
                loadChildren: './viewCategoryItems/viewCategoryItems.module#viewCategoryItemsModule',
                canActivate: [__WEBPACK_IMPORTED_MODULE_2__filter_app_guard__["a" /* LoginGuard */]]
            },
            {
                path: 'viewReports',
                loadChildren: './viewReports/viewReports.module#viewReportsModule',
                canActivate: [__WEBPACK_IMPORTED_MODULE_2__filter_app_guard__["a" /* LoginGuard */]]
            },
            {
                path: 'viewCategoryVendors',
                loadChildren: './viewCategoryVendors/viewCategoryVendors.module#viewCategoryVendorsModule',
                canActivate: [__WEBPACK_IMPORTED_MODULE_2__filter_app_guard__["a" /* LoginGuard */]]
            },
            {
                path: 'paymentDetails',
                loadChildren: './paymentDetails/paymentDetails.module#paymentDetailsModule',
                canActivate: [__WEBPACK_IMPORTED_MODULE_2__filter_app_guard__["a" /* LoginGuard */]]
            },
            {
                path: 'receivedItems',
                loadChildren: './receivedItems/receivedItems.module#receivedItemsDetailsModule',
                canActivate: [__WEBPACK_IMPORTED_MODULE_2__filter_app_guard__["a" /* LoginGuard */]]
            },
            {
                path: 'addItem',
                loadChildren: './addItem/addItem.module#addItemModule',
                canActivate: [__WEBPACK_IMPORTED_MODULE_2__filter_app_guard__["a" /* LoginGuard */]]
            },
            {
                path: 'addTermsAndCondition',
                loadChildren: './addT&C/addT&C.module#addTermsAndConditionModule',
                canActivate: [__WEBPACK_IMPORTED_MODULE_2__filter_app_guard__["a" /* LoginGuard */], __WEBPACK_IMPORTED_MODULE_3__filter_app_adminGuard__["a" /* AdminGuard */]]
            },
            {
                path: 'editTermsAndCondition',
                loadChildren: './editT&C/editT&C.module#editTermsAndConditionModule',
                canActivate: [__WEBPACK_IMPORTED_MODULE_2__filter_app_guard__["a" /* LoginGuard */], __WEBPACK_IMPORTED_MODULE_3__filter_app_adminGuard__["a" /* AdminGuard */]]
            },
            {
                path: 'editItem',
                loadChildren: './editItem/editItem.module#editItemModule',
                canActivate: [__WEBPACK_IMPORTED_MODULE_2__filter_app_guard__["a" /* LoginGuard */]]
            },
            {
                path: 'purchaseOrder',
                loadChildren: './purchaseOrder/purchaseOrder.module#purchaseOrderModule',
                canActivate: [__WEBPACK_IMPORTED_MODULE_2__filter_app_guard__["a" /* LoginGuard */]]
            },
            {
                path: 'createPurchaseOrder',
                loadChildren: './createPurchaseOrder/createPurchaseOrder.module#createPurchaseOrderModule',
                canActivate: [__WEBPACK_IMPORTED_MODULE_2__filter_app_guard__["a" /* LoginGuard */]]
            },
            {
                path: 'editPurchaseOrder',
                loadChildren: './editPurchaseOrder/editPurchaseOrder.module#editPurchaseOrderModule',
                canActivate: [__WEBPACK_IMPORTED_MODULE_2__filter_app_guard__["a" /* LoginGuard */]]
            },
            {
                path: 'settings',
                loadChildren: './settings/settings.module#SettingsModule',
                canActivate: [__WEBPACK_IMPORTED_MODULE_2__filter_app_guard__["a" /* LoginGuard */]]
            },
            {
                path: 'viewCategories',
                loadChildren: './viewTags/viewTags.module#ViewTagsModule',
                canActivate: [__WEBPACK_IMPORTED_MODULE_2__filter_app_guard__["a" /* LoginGuard */], __WEBPACK_IMPORTED_MODULE_3__filter_app_adminGuard__["a" /* AdminGuard */]]
            },
            {
                path: 'almirah',
                loadChildren: './almirah/almirah.module#almirahModule',
                canActivate: [__WEBPACK_IMPORTED_MODULE_2__filter_app_guard__["a" /* LoginGuard */], __WEBPACK_IMPORTED_MODULE_3__filter_app_adminGuard__["a" /* AdminGuard */]]
            },
            {
                path: 'viewTemplates',
                loadChildren: './viewTemplates/viewTemplates.module#viewTemplatesModule',
                canActivate: [__WEBPACK_IMPORTED_MODULE_2__filter_app_guard__["a" /* LoginGuard */], __WEBPACK_IMPORTED_MODULE_3__filter_app_adminGuard__["a" /* AdminGuard */]]
            },
            {
                path: 'viewUnits',
                loadChildren: './viewUnits/viewUnits.module#viewUnitsModule',
                canActivate: [__WEBPACK_IMPORTED_MODULE_2__filter_app_guard__["a" /* LoginGuard */], __WEBPACK_IMPORTED_MODULE_3__filter_app_adminGuard__["a" /* AdminGuard */]]
            },
            {
                path: 'addAlmirah',
                loadChildren: './addAlmirah/addAlmirah.module#addAlmirahModule',
                canActivate: [__WEBPACK_IMPORTED_MODULE_2__filter_app_guard__["a" /* LoginGuard */], __WEBPACK_IMPORTED_MODULE_3__filter_app_adminGuard__["a" /* AdminGuard */]]
            },
            {
                path: 'addExpense',
                loadChildren: './addExpenseModel/addExpenseModel.module#addExpenseModelModule',
                canActivate: [__WEBPACK_IMPORTED_MODULE_2__filter_app_guard__["a" /* LoginGuard */]]
            },
            {
                path: 'editExpense',
                loadChildren: './editExpenseModel/editExpenseModel.module#editExpenseModelModule',
                canActivate: [__WEBPACK_IMPORTED_MODULE_2__filter_app_guard__["a" /* LoginGuard */]]
            },
            {
                path: 'addTemplate',
                loadChildren: './addTemplate/addTemplate.module#addTemplateModule',
                canActivate: [__WEBPACK_IMPORTED_MODULE_2__filter_app_guard__["a" /* LoginGuard */], __WEBPACK_IMPORTED_MODULE_3__filter_app_adminGuard__["a" /* AdminGuard */]]
            },
            {
                path: 'addCompanyUnit',
                loadChildren: './addCompanyUnit/addCompanyUnit.module#addCompanyUnitModule',
                canActivate: [__WEBPACK_IMPORTED_MODULE_2__filter_app_guard__["a" /* LoginGuard */], __WEBPACK_IMPORTED_MODULE_3__filter_app_adminGuard__["a" /* AdminGuard */]]
            },
            {
                path: 'editCompanyUnit',
                loadChildren: './editCompanyUnit/editCompanyUnit.module#editCompanyUnitModule',
                canActivate: [__WEBPACK_IMPORTED_MODULE_2__filter_app_guard__["a" /* LoginGuard */], __WEBPACK_IMPORTED_MODULE_3__filter_app_adminGuard__["a" /* AdminGuard */]]
            },
            {
                path: 'editTemplate',
                loadChildren: './editTemplate/editTemplate.module#editTemplateModule',
                canActivate: [__WEBPACK_IMPORTED_MODULE_2__filter_app_guard__["a" /* LoginGuard */], __WEBPACK_IMPORTED_MODULE_3__filter_app_adminGuard__["a" /* AdminGuard */]]
            },
            {
                path: 'sendMail',
                loadChildren: './sendMail/sendMail.module#sendMailModule',
                canActivate: [__WEBPACK_IMPORTED_MODULE_2__filter_app_guard__["a" /* LoginGuard */]]
            },
            {
                path: 'editAlmirah',
                loadChildren: './editAlmirah/editAlmirah.module#editAlmirahModule',
                canActivate: [__WEBPACK_IMPORTED_MODULE_2__filter_app_guard__["a" /* LoginGuard */], __WEBPACK_IMPORTED_MODULE_3__filter_app_adminGuard__["a" /* AdminGuard */]]
            },
            {
                path: 'changePassword',
                loadChildren: './Profile/profile.module#ProfileModule',
                canActivate: [__WEBPACK_IMPORTED_MODULE_2__filter_app_guard__["a" /* LoginGuard */]]
            },
            {
                path: 'inactive-user',
                loadChildren: './InActiveUser/inActiveUser.module#inActiveUserModule',
                canActivate: [__WEBPACK_IMPORTED_MODULE_2__filter_app_guard__["a" /* LoginGuard */], __WEBPACK_IMPORTED_MODULE_3__filter_app_adminGuard__["a" /* AdminGuard */]]
            },
            {
                path: 'email',
                loadChildren: './email/email.module#EmailModule',
                canActivate: [__WEBPACK_IMPORTED_MODULE_2__filter_app_guard__["a" /* LoginGuard */], __WEBPACK_IMPORTED_MODULE_3__filter_app_adminGuard__["a" /* AdminGuard */]]
            },
            {
                path: 'addUser',
                loadChildren: './addUser/addUser.module#AddUserModule',
                canActivate: [__WEBPACK_IMPORTED_MODULE_2__filter_app_guard__["a" /* LoginGuard */], __WEBPACK_IMPORTED_MODULE_3__filter_app_adminGuard__["a" /* AdminGuard */]]
            },
            {
                path: 'editUser',
                loadChildren: './editUser/editUser.module#editUserModule',
                canActivate: [__WEBPACK_IMPORTED_MODULE_2__filter_app_guard__["a" /* LoginGuard */], __WEBPACK_IMPORTED_MODULE_3__filter_app_adminGuard__["a" /* AdminGuard */]]
            },
            {
                path: 'investor',
                loadChildren: './investor/investor.module#InvestorModule',
                canActivate: [__WEBPACK_IMPORTED_MODULE_2__filter_app_guard__["a" /* LoginGuard */], __WEBPACK_IMPORTED_MODULE_3__filter_app_adminGuard__["a" /* AdminGuard */]]
            },
            {
                path: 'investor-profile',
                loadChildren: './investorProfile/investorProfile.module#InvestorProfileModule',
                canActivate: [__WEBPACK_IMPORTED_MODULE_2__filter_app_guard__["a" /* LoginGuard */]]
            },
            {
                path: 'manage-offering',
                loadChildren: './manageOfferings/offerings.module#OfferingsModule',
                canActivate: [__WEBPACK_IMPORTED_MODULE_2__filter_app_guard__["a" /* LoginGuard */]]
            },
            {
                path: 'add-offering',
                loadChildren: './addOffering/addOffering.module#AddOfferingModule',
                canActivate: [__WEBPACK_IMPORTED_MODULE_2__filter_app_guard__["a" /* LoginGuard */]]
            },
            {
                path: 'browse-offering',
                loadChildren: './browseOfferings/browseOfferings.module#BrowseOfferingsModule',
                canActivate: [__WEBPACK_IMPORTED_MODULE_2__filter_app_guard__["a" /* LoginGuard */]]
            },
            {
                path: 'edit-offering',
                loadChildren: './editOffering/editOffering.module#EditOfferingModule',
                canActivate: [__WEBPACK_IMPORTED_MODULE_2__filter_app_guard__["a" /* LoginGuard */]]
            },
            {
                path: 'offering',
                loadChildren: './offering/offering.module#OfferingModule',
                canActivate: [__WEBPACK_IMPORTED_MODULE_2__filter_app_guard__["a" /* LoginGuard */]]
            },
        ]
    }
];
var routing = __WEBPACK_IMPORTED_MODULE_0__angular_router__["RouterModule"].forChild(routes);
//# sourceMappingURL=pages.routing.js.map

/***/ }),

/***/ 410:
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_0__angular_core__ = __webpack_require__(2);
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "a", function() { return BaBackTop; });
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
var __metadata = (this && this.__metadata) || function (k, v) {
    if (typeof Reflect === "object" && typeof Reflect.metadata === "function") return Reflect.metadata(k, v);
};

var BaBackTop = (function () {
    function BaBackTop() {
        this.position = 400;
        this.showSpeed = 500;
        this.moveSpeed = 1000;
    }
    BaBackTop.prototype.ngAfterViewInit = function () {
        this._onWindowScroll();
    };
    BaBackTop.prototype._onClick = function () {
        jQuery('html, body').animate({ scrollTop: 0 }, { duration: this.moveSpeed });
        return false;
    };
    BaBackTop.prototype._onWindowScroll = function () {
        var el = this._selector.nativeElement;
        window.scrollY > this.position ? jQuery(el).fadeIn(this.showSpeed) : jQuery(el).fadeOut(this.showSpeed);
    };
    return BaBackTop;
}());
__decorate([
    __webpack_require__.i(__WEBPACK_IMPORTED_MODULE_0__angular_core__["Input"])(),
    __metadata("design:type", Number)
], BaBackTop.prototype, "position", void 0);
__decorate([
    __webpack_require__.i(__WEBPACK_IMPORTED_MODULE_0__angular_core__["Input"])(),
    __metadata("design:type", Number)
], BaBackTop.prototype, "showSpeed", void 0);
__decorate([
    __webpack_require__.i(__WEBPACK_IMPORTED_MODULE_0__angular_core__["Input"])(),
    __metadata("design:type", Number)
], BaBackTop.prototype, "moveSpeed", void 0);
__decorate([
    __webpack_require__.i(__WEBPACK_IMPORTED_MODULE_0__angular_core__["ViewChild"])('baBackTop'),
    __metadata("design:type", typeof (_a = typeof __WEBPACK_IMPORTED_MODULE_0__angular_core__["ElementRef"] !== "undefined" && __WEBPACK_IMPORTED_MODULE_0__angular_core__["ElementRef"]) === "function" && _a || Object)
], BaBackTop.prototype, "_selector", void 0);
__decorate([
    __webpack_require__.i(__WEBPACK_IMPORTED_MODULE_0__angular_core__["HostListener"])('click'),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", []),
    __metadata("design:returntype", Boolean)
], BaBackTop.prototype, "_onClick", null);
__decorate([
    __webpack_require__.i(__WEBPACK_IMPORTED_MODULE_0__angular_core__["HostListener"])('window:scroll'),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", []),
    __metadata("design:returntype", void 0)
], BaBackTop.prototype, "_onWindowScroll", null);
BaBackTop = __decorate([
    __webpack_require__.i(__WEBPACK_IMPORTED_MODULE_0__angular_core__["Component"])({
        selector: 'ba-back-top',
        styles: [__webpack_require__(499)],
        template: "\n    <i #baBackTop class=\"fa fa-angle-up back-top ba-back-top\" title=\"Back to Top\"></i>\n  "
    })
], BaBackTop);

var _a;
//# sourceMappingURL=baBackTop.component.js.map

/***/ }),

/***/ 411:
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_0__baBackTop_component__ = __webpack_require__(410);
/* harmony namespace reexport (by used) */ __webpack_require__.d(__webpack_exports__, "a", function() { return __WEBPACK_IMPORTED_MODULE_0__baBackTop_component__["a"]; });

//# sourceMappingURL=index.js.map

/***/ }),

/***/ 412:
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_0__angular_core__ = __webpack_require__(2);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_1__global_state__ = __webpack_require__(43);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_2__angular_router__ = __webpack_require__(20);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_3__app_authentication__ = __webpack_require__(36);
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "a", function() { return BaContentTop; });
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
var __metadata = (this && this.__metadata) || function (k, v) {
    if (typeof Reflect === "object" && typeof Reflect.metadata === "function") return Reflect.metadata(k, v);
};




var BaContentTop = (function () {
    function BaContentTop(_state, router, authentication) {
        var _this = this;
        this._state = _state;
        this.router = router;
        this.authentication = authentication;
        this.activePageTitle = '';
        this._state.subscribe('menu.activeLink', function (activeLink) {
            _this.activePageTitle = activeLink.title;
        });
    }
    /* ngAfterViewInit(){
       setInterval(item=>{
         if(this.router.url == '/dashboard'){
           this.activePageTitle = 'Dashboard';
         }
       }, 1);
   */
    // }
    BaContentTop.prototype.ngAfterViewInit = function () {
        var _this = this;
        this.authentication.getChangedContentTopText().subscribe(function (item) {
            if (item) {
                _this.activePageTitle = item;
            }
        });
    };
    return BaContentTop;
}());
BaContentTop = __decorate([
    __webpack_require__.i(__WEBPACK_IMPORTED_MODULE_0__angular_core__["Component"])({
        selector: 'ba-content-top',
        styles: [__webpack_require__(500)],
        template: __webpack_require__(554),
    }),
    __metadata("design:paramtypes", [typeof (_a = typeof __WEBPACK_IMPORTED_MODULE_1__global_state__["a" /* GlobalState */] !== "undefined" && __WEBPACK_IMPORTED_MODULE_1__global_state__["a" /* GlobalState */]) === "function" && _a || Object, typeof (_b = typeof __WEBPACK_IMPORTED_MODULE_2__angular_router__["Router"] !== "undefined" && __WEBPACK_IMPORTED_MODULE_2__angular_router__["Router"]) === "function" && _b || Object, typeof (_c = typeof __WEBPACK_IMPORTED_MODULE_3__app_authentication__["a" /* AuthenticationHelper */] !== "undefined" && __WEBPACK_IMPORTED_MODULE_3__app_authentication__["a" /* AuthenticationHelper */]) === "function" && _c || Object])
], BaContentTop);

var _a, _b, _c;
//# sourceMappingURL=baContentTop.component.js.map

/***/ }),

/***/ 413:
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_0__baContentTop_component__ = __webpack_require__(412);
/* harmony namespace reexport (by used) */ __webpack_require__.d(__webpack_exports__, "a", function() { return __WEBPACK_IMPORTED_MODULE_0__baContentTop_component__["a"]; });

//# sourceMappingURL=index.js.map

/***/ }),

/***/ 414:
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_0__angular_core__ = __webpack_require__(2);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_1__angular_router__ = __webpack_require__(20);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_2__services__ = __webpack_require__(65);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_3__global_state__ = __webpack_require__(43);
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "a", function() { return BaMenu; });
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
var __metadata = (this && this.__metadata) || function (k, v) {
    if (typeof Reflect === "object" && typeof Reflect.metadata === "function") return Reflect.metadata(k, v);
};




var BaMenu = (function () {
    function BaMenu(_router, _service, _state) {
        this._router = _router;
        this._service = _service;
        this._state = _state;
        this.sidebarCollapsed = false;
        this.expandMenu = new __WEBPACK_IMPORTED_MODULE_0__angular_core__["EventEmitter"]();
        this.outOfArea = -200;
    }
    BaMenu.prototype.updateMenu = function (newMenuItems) {
        this.menuItems = newMenuItems;
        this.selectMenuAndNotify();
    };
    BaMenu.prototype.selectMenuAndNotify = function () {
        if (this.menuItems) {
            this.menuItems = this._service.selectMenuItem(this.menuItems);
            this._state.notifyDataChanged('menu.activeLink', this._service.getCurrentItem());
        }
    };
    BaMenu.prototype.ngOnInit = function () {
        var _this = this;
        this._onRouteChange = this._router.events.subscribe(function (event) {
            if (event instanceof __WEBPACK_IMPORTED_MODULE_1__angular_router__["NavigationEnd"]) {
                if (_this.menuItems) {
                    _this.selectMenuAndNotify();
                }
                else {
                    // on page load we have to wait as event is fired before menu elements are prepared
                    setTimeout(function () { return _this.selectMenuAndNotify(); });
                }
            }
        });
        this._menuItemsSub = this._service.menuItems.subscribe(this.updateMenu.bind(this));
    };
    BaMenu.prototype.ngOnDestroy = function () {
        this._onRouteChange.unsubscribe();
        this._menuItemsSub.unsubscribe();
    };
    BaMenu.prototype.hoverItem = function ($event) {
        this.showHoverElem = true;
        this.hoverElemHeight = $event.currentTarget.clientHeight;
        // TODO: get rid of magic 66 constant
        this.hoverElemTop = $event.currentTarget.getBoundingClientRect().top - 66;
    };
    BaMenu.prototype.toggleSubMenu = function ($event) {
        var submenu = jQuery($event.currentTarget).next();
        if (this.sidebarCollapsed) {
            this.expandMenu.emit(null);
            if (!$event.item.expanded) {
                $event.item.expanded = true;
            }
        }
        else {
            $event.item.expanded = !$event.item.expanded;
            submenu.slideToggle();
        }
        return false;
    };
    return BaMenu;
}());
__decorate([
    __webpack_require__.i(__WEBPACK_IMPORTED_MODULE_0__angular_core__["Input"])(),
    __metadata("design:type", Boolean)
], BaMenu.prototype, "sidebarCollapsed", void 0);
__decorate([
    __webpack_require__.i(__WEBPACK_IMPORTED_MODULE_0__angular_core__["Input"])(),
    __metadata("design:type", Number)
], BaMenu.prototype, "menuHeight", void 0);
__decorate([
    __webpack_require__.i(__WEBPACK_IMPORTED_MODULE_0__angular_core__["Output"])(),
    __metadata("design:type", Object)
], BaMenu.prototype, "expandMenu", void 0);
BaMenu = __decorate([
    __webpack_require__.i(__WEBPACK_IMPORTED_MODULE_0__angular_core__["Component"])({
        selector: 'ba-menu',
        template: __webpack_require__(555),
        styles: [__webpack_require__(501)]
    }),
    __metadata("design:paramtypes", [typeof (_a = typeof __WEBPACK_IMPORTED_MODULE_1__angular_router__["Router"] !== "undefined" && __WEBPACK_IMPORTED_MODULE_1__angular_router__["Router"]) === "function" && _a || Object, typeof (_b = typeof __WEBPACK_IMPORTED_MODULE_2__services__["b" /* BaMenuService */] !== "undefined" && __WEBPACK_IMPORTED_MODULE_2__services__["b" /* BaMenuService */]) === "function" && _b || Object, typeof (_c = typeof __WEBPACK_IMPORTED_MODULE_3__global_state__["a" /* GlobalState */] !== "undefined" && __WEBPACK_IMPORTED_MODULE_3__global_state__["a" /* GlobalState */]) === "function" && _c || Object])
], BaMenu);

var _a, _b, _c;
//# sourceMappingURL=baMenu.component.js.map

/***/ }),

/***/ 415:
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_0__angular_core__ = __webpack_require__(2);
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "a", function() { return BaMenuItem; });
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
var __metadata = (this && this.__metadata) || function (k, v) {
    if (typeof Reflect === "object" && typeof Reflect.metadata === "function") return Reflect.metadata(k, v);
};

var BaMenuItem = (function () {
    function BaMenuItem() {
        this.child = false;
        this.itemHover = new __WEBPACK_IMPORTED_MODULE_0__angular_core__["EventEmitter"]();
        this.toggleSubMenu = new __WEBPACK_IMPORTED_MODULE_0__angular_core__["EventEmitter"]();
    }
    BaMenuItem.prototype.onHoverItem = function ($event) {
        this.itemHover.emit($event);
    };
    BaMenuItem.prototype.onToggleSubMenu = function ($event, item) {
        $event.item = item;
        this.toggleSubMenu.emit($event);
        return false;
    };
    return BaMenuItem;
}());
__decorate([
    __webpack_require__.i(__WEBPACK_IMPORTED_MODULE_0__angular_core__["Input"])(),
    __metadata("design:type", Object)
], BaMenuItem.prototype, "menuItem", void 0);
__decorate([
    __webpack_require__.i(__WEBPACK_IMPORTED_MODULE_0__angular_core__["Input"])(),
    __metadata("design:type", Boolean)
], BaMenuItem.prototype, "child", void 0);
__decorate([
    __webpack_require__.i(__WEBPACK_IMPORTED_MODULE_0__angular_core__["Output"])(),
    __metadata("design:type", Object)
], BaMenuItem.prototype, "itemHover", void 0);
__decorate([
    __webpack_require__.i(__WEBPACK_IMPORTED_MODULE_0__angular_core__["Output"])(),
    __metadata("design:type", Object)
], BaMenuItem.prototype, "toggleSubMenu", void 0);
BaMenuItem = __decorate([
    __webpack_require__.i(__WEBPACK_IMPORTED_MODULE_0__angular_core__["Component"])({
        selector: 'ba-menu-item',
        template: __webpack_require__(556),
        styles: [__webpack_require__(502)]
    })
], BaMenuItem);

//# sourceMappingURL=baMenuItem.component.js.map

/***/ }),

/***/ 416:
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_0__baMenuItem_component__ = __webpack_require__(415);
/* harmony namespace reexport (by used) */ __webpack_require__.d(__webpack_exports__, "a", function() { return __WEBPACK_IMPORTED_MODULE_0__baMenuItem_component__["a"]; });

//# sourceMappingURL=index.js.map

/***/ }),

/***/ 417:
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_0__baMenu_component__ = __webpack_require__(414);
/* harmony namespace reexport (by used) */ __webpack_require__.d(__webpack_exports__, "a", function() { return __WEBPACK_IMPORTED_MODULE_0__baMenu_component__["a"]; });

//# sourceMappingURL=index.js.map

/***/ }),

/***/ 418:
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_0__angular_core__ = __webpack_require__(2);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_1__global_state__ = __webpack_require__(43);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_2__angular_router__ = __webpack_require__(20);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_3__app_authentication__ = __webpack_require__(36);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_4__angular_common__ = __webpack_require__(10);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_5__appServices_application__ = __webpack_require__(86);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_6__services_baThemeSpinner_baThemeSpinner_service__ = __webpack_require__(130);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_7_ng2_toastr__ = __webpack_require__(63);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_7_ng2_toastr___default = __webpack_require__.n(__WEBPACK_IMPORTED_MODULE_7_ng2_toastr__);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_8__utilityServices_app_utility__ = __webpack_require__(64);
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "a", function() { return BaPageTop; });
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
var __metadata = (this && this.__metadata) || function (k, v) {
    if (typeof Reflect === "object" && typeof Reflect.metadata === "function") return Reflect.metadata(k, v);
};









var BaPageTop = (function () {
    function BaPageTop(adminServices, userUtility, toastr, spinner, _state, router, authentication, location, vRef) {
        var _this = this;
        this.adminServices = adminServices;
        this.userUtility = userUtility;
        this.toastr = toastr;
        this.spinner = spinner;
        this._state = _state;
        this.router = router;
        this.authentication = authentication;
        this.location = location;
        this.isScrolled = false;
        this.isMenuCollapsed = false;
        this.rolesArray = [];
        this._state.subscribe('menu.isCollapsed', function (isCollapsed) {
            _this.isMenuCollapsed = isCollapsed;
        });
        FB.init({
            appId: '206515609891723',
            cookie: true,
            xfbml: true,
            version: 'v2.8',
        });
        this.userName = localStorage.getItem('userName');
        this.userUtility.userName = localStorage.getItem('userName');
        this.userProfileImage = localStorage.getItem('profileImageURL');
        this.rolesArray = localStorage.getItem('roles');
        // if (this.rolesArray.indexOf('admin') !== -1){
        //     this.isAdmin = false;
        // }else{
        this.isAdmin = true;
        // }
    }
    BaPageTop.prototype.ngOnInit = function () {
        var _this = this;
        this.authentication.getUserValueChangeEmitter().subscribe(function (item) { return _this.setUserInfo(); });
    };
    BaPageTop.prototype.toggleMenu = function () {
        this.isMenuCollapsed = !this.isMenuCollapsed;
        this._state.notifyDataChanged('menu.isCollapsed', this.isMenuCollapsed);
        return false;
    };
    BaPageTop.prototype.scrolledChanged = function (isScrolled) {
        this.isScrolled = isScrolled;
    };
    // logout
    // public loggedOff() {
    //     FB.getLoginStatus((response) => {
    //         if (response && response.status === 'connected') {
    //             FB.logout();
    //         }
    //     }, true);
    //     this.router.navigate(['login']);
    //     localStorage.clear();
    //     this.toastr.success('Logged Out successfully');
    // }
    BaPageTop.prototype.loggedOff = function () {
        var _this = this;
        FB.getLoginStatus(function (response) {
            if (response && response.status === 'connected') {
                FB.logout();
            }
        }, true);
        this.authentication.removeLoggedIn();
        var data = this.authentication.getToken();
        this.adminServices.userLogout(data).subscribe(function (data) { return _this.logOutSuccess(data); }, function (error) { return _this.logOutFail(error); });
    };
    BaPageTop.prototype.logOutSuccess = function (result) {
        var data = {};
        this.authentication.setUser(data);
        this.toastr.success('Logged Out successfully');
        this.router.navigate(['login']);
    };
    BaPageTop.prototype.logOutFail = function (error) {
        this.toastr.success('Logged Out Failed');
        // toastr.error(error.error_message);
    };
    // navigate to profile.
    BaPageTop.prototype.navigateToProfile = function () {
        this.router.navigate(['changePassword']);
    };
    // navigate to dashboard.
    BaPageTop.prototype.navigateToDashboard = function () {
        this.router.navigate(['dashboard']);
    };
    BaPageTop.prototype.userValueChanged = function (value) {
        this.setUserInfo();
    };
    // to set updated user details
    BaPageTop.prototype.setUserInfo = function () {
        var input = this.authentication.getUser();
        this.userProfileImage = input.profileImageURL;
        this.userName = input.firstName;
    };
    return BaPageTop;
}());
BaPageTop = __decorate([
    __webpack_require__.i(__WEBPACK_IMPORTED_MODULE_0__angular_core__["Component"])({
        selector: 'ba-page-top',
        template: __webpack_require__(557),
        styles: [__webpack_require__(503)],
    }),
    __metadata("design:paramtypes", [typeof (_a = typeof __WEBPACK_IMPORTED_MODULE_5__appServices_application__["a" /* ApplicationAdminServices */] !== "undefined" && __WEBPACK_IMPORTED_MODULE_5__appServices_application__["a" /* ApplicationAdminServices */]) === "function" && _a || Object, typeof (_b = typeof __WEBPACK_IMPORTED_MODULE_8__utilityServices_app_utility__["a" /* Utility */] !== "undefined" && __WEBPACK_IMPORTED_MODULE_8__utilityServices_app_utility__["a" /* Utility */]) === "function" && _b || Object, typeof (_c = typeof __WEBPACK_IMPORTED_MODULE_7_ng2_toastr__["ToastsManager"] !== "undefined" && __WEBPACK_IMPORTED_MODULE_7_ng2_toastr__["ToastsManager"]) === "function" && _c || Object, typeof (_d = typeof __WEBPACK_IMPORTED_MODULE_6__services_baThemeSpinner_baThemeSpinner_service__["a" /* BaThemeSpinner */] !== "undefined" && __WEBPACK_IMPORTED_MODULE_6__services_baThemeSpinner_baThemeSpinner_service__["a" /* BaThemeSpinner */]) === "function" && _d || Object, typeof (_e = typeof __WEBPACK_IMPORTED_MODULE_1__global_state__["a" /* GlobalState */] !== "undefined" && __WEBPACK_IMPORTED_MODULE_1__global_state__["a" /* GlobalState */]) === "function" && _e || Object, typeof (_f = typeof __WEBPACK_IMPORTED_MODULE_2__angular_router__["Router"] !== "undefined" && __WEBPACK_IMPORTED_MODULE_2__angular_router__["Router"]) === "function" && _f || Object, typeof (_g = typeof __WEBPACK_IMPORTED_MODULE_3__app_authentication__["a" /* AuthenticationHelper */] !== "undefined" && __WEBPACK_IMPORTED_MODULE_3__app_authentication__["a" /* AuthenticationHelper */]) === "function" && _g || Object, typeof (_h = typeof __WEBPACK_IMPORTED_MODULE_4__angular_common__["Location"] !== "undefined" && __WEBPACK_IMPORTED_MODULE_4__angular_common__["Location"]) === "function" && _h || Object, typeof (_j = typeof __WEBPACK_IMPORTED_MODULE_0__angular_core__["ViewContainerRef"] !== "undefined" && __WEBPACK_IMPORTED_MODULE_0__angular_core__["ViewContainerRef"]) === "function" && _j || Object])
], BaPageTop);

var _a, _b, _c, _d, _e, _f, _g, _h, _j;
//# sourceMappingURL=baPageTop.component.js.map

/***/ }),

/***/ 419:
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_0__baPageTop_component__ = __webpack_require__(418);
/* harmony namespace reexport (by used) */ __webpack_require__.d(__webpack_exports__, "a", function() { return __WEBPACK_IMPORTED_MODULE_0__baPageTop_component__["a"]; });

//# sourceMappingURL=index.js.map

/***/ }),

/***/ 420:
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_0__angular_core__ = __webpack_require__(2);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_1__app_authentication__ = __webpack_require__(36);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_2__global_state__ = __webpack_require__(43);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_3__theme__ = __webpack_require__(181);
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "a", function() { return BaSidebar; });
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
var __metadata = (this && this.__metadata) || function (k, v) {
    if (typeof Reflect === "object" && typeof Reflect.metadata === "function") return Reflect.metadata(k, v);
};




var BaSidebar = (function () {
    function BaSidebar(_elementRef, authentication, _state) {
        var _this = this;
        this._elementRef = _elementRef;
        this.authentication = authentication;
        this._state = _state;
        this.isMenuCollapsed = false;
        this.isMenuShouldCollapsed = false;
        this._state.subscribe('menu.isCollapsed', function (isCollapsed) {
            _this.isMenuCollapsed = isCollapsed;
        });
        this.userName = localStorage.getItem('userName');
        this.userProfileImage = localStorage.getItem('profileImageURL');
    }
    BaSidebar.prototype.ngOnInit = function () {
        var _this = this;
        if (this._shouldMenuCollapse()) {
            this.menuCollapse();
        }
        this.authentication.getUserValueChangeEmitter().subscribe(function (item) { return _this.setUserInfo(); });
    };
    BaSidebar.prototype.ngAfterViewInit = function () {
        var _this = this;
        setTimeout(function () { return _this.updateSidebarHeight(); });
    };
    BaSidebar.prototype.onWindowResize = function () {
        var isMenuShouldCollapsed = this._shouldMenuCollapse();
        if (this.isMenuShouldCollapsed !== isMenuShouldCollapsed) {
            this.menuCollapseStateChange(isMenuShouldCollapsed);
        }
        this.isMenuShouldCollapsed = isMenuShouldCollapsed;
        this.updateSidebarHeight();
    };
    BaSidebar.prototype.menuExpand = function () {
        this.menuCollapseStateChange(false);
    };
    BaSidebar.prototype.menuCollapse = function () {
        this.menuCollapseStateChange(true);
    };
    BaSidebar.prototype.menuCollapseStateChange = function (isCollapsed) {
        this.isMenuCollapsed = isCollapsed;
        this._state.notifyDataChanged('menu.isCollapsed', this.isMenuCollapsed);
    };
    BaSidebar.prototype.updateSidebarHeight = function () {
        // TODO: get rid of magic 84 constant
        this.menuHeight = this._elementRef.nativeElement.childNodes[0].clientHeight - 84;
    };
    BaSidebar.prototype._shouldMenuCollapse = function () {
        return window.innerWidth <= __WEBPACK_IMPORTED_MODULE_3__theme__["b" /* layoutSizes */].resWidthCollapseSidebar;
    };
    // to set updated user details
    BaSidebar.prototype.setUserInfo = function () {
        var input = this.authentication.getUser();
        this.userProfileImage = input.profileImageURL;
        this.userName = input.firstName;
    };
    return BaSidebar;
}());
__decorate([
    __webpack_require__.i(__WEBPACK_IMPORTED_MODULE_0__angular_core__["HostListener"])('window:resize'),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", []),
    __metadata("design:returntype", void 0)
], BaSidebar.prototype, "onWindowResize", null);
BaSidebar = __decorate([
    __webpack_require__.i(__WEBPACK_IMPORTED_MODULE_0__angular_core__["Component"])({
        selector: 'ba-sidebar',
        template: __webpack_require__(558),
        styles: [__webpack_require__(504)]
    }),
    __metadata("design:paramtypes", [typeof (_a = typeof __WEBPACK_IMPORTED_MODULE_0__angular_core__["ElementRef"] !== "undefined" && __WEBPACK_IMPORTED_MODULE_0__angular_core__["ElementRef"]) === "function" && _a || Object, typeof (_b = typeof __WEBPACK_IMPORTED_MODULE_1__app_authentication__["a" /* AuthenticationHelper */] !== "undefined" && __WEBPACK_IMPORTED_MODULE_1__app_authentication__["a" /* AuthenticationHelper */]) === "function" && _b || Object, typeof (_c = typeof __WEBPACK_IMPORTED_MODULE_2__global_state__["a" /* GlobalState */] !== "undefined" && __WEBPACK_IMPORTED_MODULE_2__global_state__["a" /* GlobalState */]) === "function" && _c || Object])
], BaSidebar);

var _a, _b, _c;
//# sourceMappingURL=baSidebar.component.js.map

/***/ }),

/***/ 421:
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_0__baSidebar_component__ = __webpack_require__(420);
/* harmony namespace reexport (by used) */ __webpack_require__.d(__webpack_exports__, "a", function() { return __WEBPACK_IMPORTED_MODULE_0__baSidebar_component__["a"]; });

//# sourceMappingURL=index.js.map

/***/ }),

/***/ 422:
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_0__baPageTop__ = __webpack_require__(419);
/* harmony namespace reexport (by used) */ __webpack_require__.d(__webpack_exports__, "e", function() { return __WEBPACK_IMPORTED_MODULE_0__baPageTop__["a"]; });
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_1__baSidebar__ = __webpack_require__(421);
/* harmony namespace reexport (by used) */ __webpack_require__.d(__webpack_exports__, "f", function() { return __WEBPACK_IMPORTED_MODULE_1__baSidebar__["a"]; });
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_2__baMenu_components_baMenuItem__ = __webpack_require__(416);
/* harmony namespace reexport (by used) */ __webpack_require__.d(__webpack_exports__, "c", function() { return __WEBPACK_IMPORTED_MODULE_2__baMenu_components_baMenuItem__["a"]; });
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_3__baMenu__ = __webpack_require__(417);
/* harmony namespace reexport (by used) */ __webpack_require__.d(__webpack_exports__, "d", function() { return __WEBPACK_IMPORTED_MODULE_3__baMenu__["a"]; });
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_4__baContentTop__ = __webpack_require__(413);
/* harmony namespace reexport (by used) */ __webpack_require__.d(__webpack_exports__, "b", function() { return __WEBPACK_IMPORTED_MODULE_4__baContentTop__["a"]; });
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_5__baBackTop__ = __webpack_require__(411);
/* harmony namespace reexport (by used) */ __webpack_require__.d(__webpack_exports__, "a", function() { return __WEBPACK_IMPORTED_MODULE_5__baBackTop__["a"]; });






//# sourceMappingURL=index.js.map

/***/ }),

/***/ 423:
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_0__angular_core__ = __webpack_require__(2);
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "a", function() { return BaScrollPosition; });
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
var __metadata = (this && this.__metadata) || function (k, v) {
    if (typeof Reflect === "object" && typeof Reflect.metadata === "function") return Reflect.metadata(k, v);
};

var BaScrollPosition = (function () {
    function BaScrollPosition() {
        this.scrollChange = new __WEBPACK_IMPORTED_MODULE_0__angular_core__["EventEmitter"]();
    }
    BaScrollPosition.prototype.ngOnInit = function () {
        this.onWindowScroll();
    };
    BaScrollPosition.prototype.onWindowScroll = function () {
        var isScrolled = window.scrollY > this.maxHeight;
        if (isScrolled !== this._isScrolled) {
            this._isScrolled = isScrolled;
            this.scrollChange.emit(isScrolled);
        }
    };
    return BaScrollPosition;
}());
__decorate([
    __webpack_require__.i(__WEBPACK_IMPORTED_MODULE_0__angular_core__["Input"])(),
    __metadata("design:type", Number)
], BaScrollPosition.prototype, "maxHeight", void 0);
__decorate([
    __webpack_require__.i(__WEBPACK_IMPORTED_MODULE_0__angular_core__["Output"])(),
    __metadata("design:type", typeof (_a = typeof __WEBPACK_IMPORTED_MODULE_0__angular_core__["EventEmitter"] !== "undefined" && __WEBPACK_IMPORTED_MODULE_0__angular_core__["EventEmitter"]) === "function" && _a || Object)
], BaScrollPosition.prototype, "scrollChange", void 0);
__decorate([
    __webpack_require__.i(__WEBPACK_IMPORTED_MODULE_0__angular_core__["HostListener"])('window:scroll'),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", []),
    __metadata("design:returntype", void 0)
], BaScrollPosition.prototype, "onWindowScroll", null);
BaScrollPosition = __decorate([
    __webpack_require__.i(__WEBPACK_IMPORTED_MODULE_0__angular_core__["Directive"])({
        selector: '[baScrollPosition]'
    })
], BaScrollPosition);

var _a;
//# sourceMappingURL=baScrollPosition.directive.js.map

/***/ }),

/***/ 424:
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_0__baScrollPosition_directive__ = __webpack_require__(423);
/* harmony namespace reexport (by used) */ __webpack_require__.d(__webpack_exports__, "a", function() { return __WEBPACK_IMPORTED_MODULE_0__baScrollPosition_directive__["a"]; });

//# sourceMappingURL=index.js.map

/***/ }),

/***/ 425:
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_0__angular_core__ = __webpack_require__(2);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_1_jquery_slimscroll__ = __webpack_require__(508);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_1_jquery_slimscroll___default = __webpack_require__.n(__WEBPACK_IMPORTED_MODULE_1_jquery_slimscroll__);
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "a", function() { return BaSlimScroll; });
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
var __metadata = (this && this.__metadata) || function (k, v) {
    if (typeof Reflect === "object" && typeof Reflect.metadata === "function") return Reflect.metadata(k, v);
};


var BaSlimScroll = (function () {
    function BaSlimScroll(_elementRef) {
        this._elementRef = _elementRef;
    }
    BaSlimScroll.prototype.ngOnChanges = function (changes) {
        this._scroll();
    };
    BaSlimScroll.prototype._scroll = function () {
        this._destroy();
        this._init();
    };
    BaSlimScroll.prototype._init = function () {
        jQuery(this._elementRef.nativeElement).slimScroll(this.baSlimScrollOptions);
    };
    BaSlimScroll.prototype._destroy = function () {
        jQuery(this._elementRef.nativeElement).slimScroll({ destroy: true });
    };
    return BaSlimScroll;
}());
__decorate([
    __webpack_require__.i(__WEBPACK_IMPORTED_MODULE_0__angular_core__["Input"])(),
    __metadata("design:type", Object)
], BaSlimScroll.prototype, "baSlimScrollOptions", void 0);
BaSlimScroll = __decorate([
    __webpack_require__.i(__WEBPACK_IMPORTED_MODULE_0__angular_core__["Directive"])({
        selector: '[baSlimScroll]'
    }),
    __metadata("design:paramtypes", [typeof (_a = typeof __WEBPACK_IMPORTED_MODULE_0__angular_core__["ElementRef"] !== "undefined" && __WEBPACK_IMPORTED_MODULE_0__angular_core__["ElementRef"]) === "function" && _a || Object])
], BaSlimScroll);

var _a;
//# sourceMappingURL=baSlimScroll.directive.js.map

/***/ }),

/***/ 426:
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_0__baSlimScroll_directive__ = __webpack_require__(425);
/* harmony namespace reexport (by used) */ __webpack_require__.d(__webpack_exports__, "a", function() { return __WEBPACK_IMPORTED_MODULE_0__baSlimScroll_directive__["a"]; });

//# sourceMappingURL=index.js.map

/***/ }),

/***/ 427:
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_0__baScrollPosition__ = __webpack_require__(424);
/* harmony namespace reexport (by used) */ __webpack_require__.d(__webpack_exports__, "a", function() { return __WEBPACK_IMPORTED_MODULE_0__baScrollPosition__["a"]; });
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_1__baSlimScroll__ = __webpack_require__(426);
/* harmony namespace reexport (by used) */ __webpack_require__.d(__webpack_exports__, "b", function() { return __WEBPACK_IMPORTED_MODULE_1__baSlimScroll__["a"]; });


//# sourceMappingURL=index.js.map

/***/ }),

/***/ 428:
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_0__angular_core__ = __webpack_require__(2);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_1__angular_router__ = __webpack_require__(20);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_2_lodash__ = __webpack_require__(380);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_2_lodash___default = __webpack_require__.n(__WEBPACK_IMPORTED_MODULE_2_lodash__);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_3_rxjs_BehaviorSubject__ = __webpack_require__(76);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_3_rxjs_BehaviorSubject___default = __webpack_require__.n(__WEBPACK_IMPORTED_MODULE_3_rxjs_BehaviorSubject__);
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "a", function() { return BaMenuService; });
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
var __metadata = (this && this.__metadata) || function (k, v) {
    if (typeof Reflect === "object" && typeof Reflect.metadata === "function") return Reflect.metadata(k, v);
};




var BaMenuService = (function () {
    function BaMenuService(_router) {
        this._router = _router;
        this.menuItems = new __WEBPACK_IMPORTED_MODULE_3_rxjs_BehaviorSubject__["BehaviorSubject"]([]);
        this._currentMenuItem = {};
    }
    /**
     * Updates the routes in the menu
     *
     * @param {Routes} routes Type compatible with app.menu.ts
     */
    BaMenuService.prototype.updateMenuByRoutes = function (routes) {
        var convertedRoutes = this.convertRoutesToMenus(__WEBPACK_IMPORTED_MODULE_2_lodash__["cloneDeep"](routes));
        this.menuItems.next(convertedRoutes);
    };
    BaMenuService.prototype.convertRoutesToMenus = function (routes) {
        var items = this._convertArrayToItems(routes);
        return this._skipEmpty(items);
    };
    BaMenuService.prototype.getCurrentItem = function () {
        return this._currentMenuItem;
    };
    BaMenuService.prototype.selectMenuItem = function (menuItems) {
        var _this = this;
        var items = [];
        menuItems.forEach(function (item) {
            _this._selectItem(item);
            if (item.selected) {
                _this._currentMenuItem = item;
            }
            if (item.children && item.children.length > 0) {
                item.children = _this.selectMenuItem(item.children);
            }
            items.push(item);
        });
        return items;
    };
    BaMenuService.prototype._skipEmpty = function (items) {
        var menu = [];
        items.forEach(function (item) {
            var menuItem;
            if (item.skip) {
                if (item.children && item.children.length > 0) {
                    menuItem = item.children;
                }
            }
            else {
                menuItem = item;
            }
            if (menuItem) {
                menu.push(menuItem);
            }
        });
        return [].concat.apply([], menu);
    };
    BaMenuService.prototype._convertArrayToItems = function (routes, parent) {
        var _this = this;
        var items = [];
        routes.forEach(function (route) {
            items.push(_this._convertObjectToItem(route, parent));
        });
        return items;
    };
    BaMenuService.prototype._convertObjectToItem = function (object, parent) {
        var item = {};
        if (object.data && object.data.menu) {
            // this is a menu object
            item = object.data.menu;
            item.route = object;
            delete item.route.data.menu;
        }
        else {
            item.route = object;
            item.skip = true;
        }
        // we have to collect all paths to correctly build the url then
        if (Array.isArray(item.route.path)) {
            item.route.paths = item.route.path;
        }
        else {
            item.route.paths = parent && parent.route && parent.route.paths ? parent.route.paths.slice(0) : ['/'];
            if (!!item.route.path)
                item.route.paths.push(item.route.path);
        }
        if (object.children && object.children.length > 0) {
            item.children = this._convertArrayToItems(object.children, item);
        }
        var prepared = this._prepareItem(item);
        // if current item is selected or expanded - then parent is expanded too
        if ((prepared.selected || prepared.expanded) && parent) {
            parent.expanded = true;
        }
        return prepared;
    };
    BaMenuService.prototype._prepareItem = function (object) {
        if (!object.skip) {
            object.target = object.target || '';
            object.pathMatch = object.pathMatch || 'full';
            return this._selectItem(object);
        }
        return object;
    };
    BaMenuService.prototype._selectItem = function (object) {
        object.selected = this._router.isActive(this._router.createUrlTree(object.route.paths), object.pathMatch === 'full');
        return object;
    };
    return BaMenuService;
}());
BaMenuService = __decorate([
    __webpack_require__.i(__WEBPACK_IMPORTED_MODULE_0__angular_core__["Injectable"])(),
    __metadata("design:paramtypes", [typeof (_a = typeof __WEBPACK_IMPORTED_MODULE_1__angular_router__["Router"] !== "undefined" && __WEBPACK_IMPORTED_MODULE_1__angular_router__["Router"]) === "function" && _a || Object])
], BaMenuService);

var _a;
//# sourceMappingURL=baMenu.service.js.map

/***/ }),

/***/ 429:
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_0__baMenu_service__ = __webpack_require__(428);
/* harmony namespace reexport (by used) */ __webpack_require__.d(__webpack_exports__, "a", function() { return __WEBPACK_IMPORTED_MODULE_0__baMenu_service__["a"]; });

//# sourceMappingURL=index.js.map

/***/ }),

/***/ 43:
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_0__angular_core__ = __webpack_require__(2);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_1_rxjs_Subject__ = __webpack_require__(9);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_1_rxjs_Subject___default = __webpack_require__.n(__WEBPACK_IMPORTED_MODULE_1_rxjs_Subject__);
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "a", function() { return GlobalState; });
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
var __metadata = (this && this.__metadata) || function (k, v) {
    if (typeof Reflect === "object" && typeof Reflect.metadata === "function") return Reflect.metadata(k, v);
};


var GlobalState = (function () {
    function GlobalState() {
        var _this = this;
        this._data = new __WEBPACK_IMPORTED_MODULE_1_rxjs_Subject__["Subject"]();
        this._dataStream$ = this._data.asObservable();
        this._subscriptions = new Map();
        this._dataStream$.subscribe(function (data) { return _this._onEvent(data); });
    }
    GlobalState.prototype.notifyDataChanged = function (event, value) {
        var current = this._data[event];
        if (current !== value) {
            this._data[event] = value;
            this._data.next({
                event: event,
                data: this._data[event]
            });
        }
    };
    GlobalState.prototype.subscribe = function (event, callback) {
        var subscribers = this._subscriptions.get(event) || [];
        subscribers.push(callback);
        this._subscriptions.set(event, subscribers);
    };
    GlobalState.prototype._onEvent = function (data) {
        var onEveentSubscribers = this._subscriptions.get(data['event']) || [];
        onEveentSubscribers.forEach(function (callback) {
            callback.call(null, data['data']);
        });
    };
    return GlobalState;
}());
GlobalState = __decorate([
    __webpack_require__.i(__WEBPACK_IMPORTED_MODULE_0__angular_core__["Injectable"])(),
    __metadata("design:paramtypes", [])
], GlobalState);

//# sourceMappingURL=global.state.js.map

/***/ }),

/***/ 430:
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_0__angular_core__ = __webpack_require__(2);
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "a", function() { return BaThemePreloader; });
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};

var BaThemePreloader = BaThemePreloader_1 = (function () {
    function BaThemePreloader() {
    }
    BaThemePreloader.registerLoader = function (method) {
        BaThemePreloader_1._loaders.push(method);
    };
    BaThemePreloader.clear = function () {
        BaThemePreloader_1._loaders = [];
    };
    BaThemePreloader.load = function () {
        return new Promise(function (resolve, reject) {
            BaThemePreloader_1._executeAll(resolve);
        });
    };
    BaThemePreloader._executeAll = function (done) {
        setTimeout(function () {
            Promise.all(BaThemePreloader_1._loaders).then(function (values) {
                done.call(null, values);
            }).catch(function (error) {
                console.error(error);
            });
        });
    };
    return BaThemePreloader;
}());
BaThemePreloader._loaders = [];
BaThemePreloader = BaThemePreloader_1 = __decorate([
    __webpack_require__.i(__WEBPACK_IMPORTED_MODULE_0__angular_core__["Injectable"])()
], BaThemePreloader);

var BaThemePreloader_1;
//# sourceMappingURL=baThemePreloader.service.js.map

/***/ }),

/***/ 431:
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_0__baThemePreloader_service__ = __webpack_require__(430);
/* harmony namespace reexport (by used) */ __webpack_require__.d(__webpack_exports__, "a", function() { return __WEBPACK_IMPORTED_MODULE_0__baThemePreloader_service__["a"]; });

//# sourceMappingURL=index.js.map

/***/ }),

/***/ 432:
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_0__baThemeSpinner_service__ = __webpack_require__(130);
/* harmony namespace reexport (by used) */ __webpack_require__.d(__webpack_exports__, "a", function() { return __WEBPACK_IMPORTED_MODULE_0__baThemeSpinner_service__["a"]; });

//# sourceMappingURL=index.js.map

/***/ }),

/***/ 433:
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "a", function() { return layoutSizes; });
/* unused harmony export isMobile */
var layoutSizes = {
    resWidthCollapseSidebar: 1200,
    resWidthHideSidebar: 500
};
var isMobile = function () { return (/android|webos|iphone|ipad|ipod|blackberry|windows phone/).test(navigator.userAgent.toLowerCase()); };
//# sourceMappingURL=theme.constants.js.map

/***/ }),

/***/ 434:
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_0__angular_core__ = __webpack_require__(2);
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "a", function() { return CapitalizePipe; });
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};

/*
 * Capitalize the first letter of the string
 * Takes a string as a value.
 * Usage:
 * value | capitalize
 */
var CapitalizePipe = (function () {
    function CapitalizePipe() {
    }
    CapitalizePipe.prototype.transform = function (input) {
        return input && input.length ? (input.charAt(0).toUpperCase() + input.slice(1).toLowerCase()) : input;
    };
    return CapitalizePipe;
}());
CapitalizePipe = __decorate([
    __webpack_require__.i(__WEBPACK_IMPORTED_MODULE_0__angular_core__["Pipe"])({ name: 'capitalize' })
], CapitalizePipe);

//# sourceMappingURL=capitalize.pipe.js.map

/***/ }),

/***/ 435:
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_0__angular_core__ = __webpack_require__(2);
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "a", function() { return NoCommaDecimalPipe; });
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};

var NoCommaDecimalPipe = (function () {
    function NoCommaDecimalPipe() {
    }
    NoCommaDecimalPipe.prototype.transform = function (val) {
        if (val !== undefined && val !== null) {
            return parseFloat(val).toFixed(2);
        }
        else {
            return '';
        }
    };
    return NoCommaDecimalPipe;
}());
NoCommaDecimalPipe = __decorate([
    __webpack_require__.i(__WEBPACK_IMPORTED_MODULE_0__angular_core__["Pipe"])({
        name: 'noCommaDecimal'
    })
], NoCommaDecimalPipe);

//# sourceMappingURL=noComma.pipe.js.map

/***/ }),

/***/ 498:
/***/ (function(module, exports, __webpack_require__) {

exports = module.exports = __webpack_require__(17)(false);
// imports


// module
exports.push([module.i, ":host /deep/ .al-sidebar {\n  width: 180px;\n  top: 66px;\n  left: 0;\n  z-index: 1001;\n  display: block;\n  min-height: 100%;\n  background-color: #374767;\n  height: 100%;\n  position: fixed;\n  box-shadow: 3px 2px 3px 0px #D3D3D3; }\n\n:host /deep/ .al-sidebar-list {\n  margin: 0;\n  overflow: hidden;\n  padding: 18px 0 0 0;\n  list-style: none; }\n\n:host /deep/ .al-sidebar-sublist .subitem-submenu-list {\n  padding-left: 15px; }\n\n:host /deep/ .subitem-submenu-link .fa {\n  top: 7px; }\n\n:host /deep/ .al-sidebar-list-item {\n  display: block;\n  position: relative;\n  float: none;\n  padding: 0; }\n  :host /deep/ .al-sidebar-list-item.selected:not(.with-sub-menu) {\n    background-color: #59a453;\n    border-bottom: 1px solid rgba(250, 250, 250, 0.4);\n    border-top: 1px solid rgba(250, 250, 250, 0.4);\n    font-size: 14px;\n    font-weight: 300; }\n    :host /deep/ .al-sidebar-list-item.selected:not(.with-sub-menu) a.al-sidebar-list-link {\n      color: #ffffff; }\n      :host /deep/ .al-sidebar-list-item.selected:not(.with-sub-menu) a.al-sidebar-list-link b {\n        color: #ffffff; }\n\n:host /deep/ .al-sidebar-list-item :hover {\n  background-color: rgba(34, 45, 50, 0.37); }\n\n:host /deep/ .ba-sidebar-item-expanded > ul.al-sidebar-sublist {\n  display: block !important; }\n\n:host /deep/ .al-sidebar-list-item.ba-sidebar-item-expanded > .al-sidebar-list-link b, :host /deep/ .ba-sidebar-sublist-item.ba-sidebar-item-expanded > .al-sidebar-list-link b {\n  -webkit-transform: rotate(180deg);\n          transform: rotate(180deg); }\n\n:host /deep/ .al-sidebar-list-item.ba-sidebar-item-expanded > .al-sidebar-sublist, :host /deep/ .ba-sidebar-sublist-item.ba-sidebar-item-expanded > .al-sidebar-sublist {\n  display: block; }\n\n:host /deep/ a.al-sidebar-list-link {\n  display: block;\n  height: 42px;\n  padding-left: 18px;\n  text-shadow: none;\n  font-size: 13px;\n  text-decoration: none;\n  color: #ffffff;\n  line-height: 42px;\n  white-space: nowrap;\n  overflow: hidden;\n  cursor: pointer; }\n  :host /deep/ a.al-sidebar-list-link i {\n    margin-right: 18px;\n    width: 16px;\n    display: inline-block; }\n  :host /deep/ a.al-sidebar-list-link b {\n    display: block;\n    opacity: 1;\n    width: 14px;\n    height: 14px;\n    line-height: 14px;\n    text-shadow: none;\n    font-size: 18px;\n    position: absolute;\n    right: 10px;\n    top: 12px;\n    padding: 0;\n    text-align: center;\n    color: #ffffff;\n    transition: -webkit-transform 0.2s linear;\n    transition: transform 0.2s linear;\n    transition: transform 0.2s linear, -webkit-transform 0.2s linear; }\n\n:host /deep/ .slimScrollBar, :host /deep/ .slimScrollRail {\n  border-radius: 0;\n  width: 4px !important;\n  left: 176px; }\n\n:host /deep/ .al-sidebar-sublist {\n  padding: 0;\n  list-style: none;\n  position: relative;\n  display: none; }\n  :host /deep/ .al-sidebar-sublist.expanded {\n    display: block; }\n  :host /deep/ .al-sidebar-sublist > ba-menu-item > li {\n    display: block;\n    float: none;\n    padding: 0;\n    border-bottom: none;\n    position: relative; }\n    :host /deep/ .al-sidebar-sublist > ba-menu-item > li a {\n      display: block;\n      text-shadow: none;\n      font-size: 13px;\n      text-decoration: none;\n      color: #ffffff;\n      padding-left: 52px;\n      height: auto;\n      line-height: 29px; }\n    :host /deep/ .al-sidebar-sublist > ba-menu-item > li.selected:not(.with-sub-menu) > a {\n      font-size: 14px;\n      font-weight: 300;\n      background-color: #59a453;\n      border-top: 1px solid rgba(250, 250, 250, 0.4);\n      border-bottom: 1px solid rgba(250, 250, 250, 0.4); }\n\n:host /deep/ .sidebar-hover-elem {\n  width: 4px;\n  background: #374767;\n  position: absolute;\n  top: -150px;\n  left: 176px;\n  transition: all 0.5s ease;\n  transition-property: top, height;\n  height: 42px;\n  display: none; }\n\n:host /deep/ .sidebar-select-elem {\n  display: block;\n  top: 94px; }\n\n:host /deep/ .menu-collapsed .slimScrollBar, :host /deep/ .menu-collapsed .slimScrollRail {\n  display: none !important; }\n\n:host /deep/ .menu-collapsed .userImageSidebar {\n  display: none; }\n\n:host /deep/ .menu-collapsed .userProfileName {\n  display: none; }\n\n:host /deep/ .userImageSidebar {\n  margin-left: 18px;\n  border-radius: 70px;\n  width: 70px;\n  height: 70px;\n  margin-top: 20px;\n  display: inline-block; }\n\n:host /deep/ .userImageDiv {\n  display: inline-block; }\n\n:host /deep/ .userProfileName {\n  display: inline-block;\n  margin-left: 12px;\n  color: white; }\n\n:host /deep/ .connected {\n  background-color: red;\n  color: white;\n  padding: 20px;\n  z-index: 999999;\n  position: fixed;\n  float: left;\n  width: 100%;\n  text-align: center; }\n\n:host /deep/ rl-tag-input-item {\n  color: white;\n  background-color: #195C94 !important; }\n\n:host /deep/ span.ng2-tag-input-remove {\n  background: none !important; }\n\n@media (min-width: 1200px) {\n  :host /deep/ .menu-collapsed .al-main {\n    margin-left: 50px; }\n  :host /deep/ .menu-collapsed .al-footer {\n    padding-left: 83px; }\n  :host /deep/ .menu-collapsed .al-content {\n    width: calc(100% - 50px); } }\n\n@media (max-width: 1200px) and (min-width: 500px) {\n  :host /deep/ .al-main {\n    margin-left: 50px; }\n  :host /deep/ .al-footer {\n    padding-left: 83px; }\n  :host /deep/ .al-content {\n    width: calc(100% - 50px); } }\n\n@media (min-width: 501px) {\n  :host /deep/ .menu-collapsed .al-sidebar {\n    width: 52px; }\n    :host /deep/ .menu-collapsed .al-sidebar .fa-angle-down, :host /deep/ .menu-collapsed .al-sidebar .fa-angle-up {\n      opacity: 0; }\n    :host /deep/ .menu-collapsed .al-sidebar .al-sidebar-sublist {\n      position: absolute;\n      top: -1px;\n      left: 52px;\n      background: rgba(0, 0, 0, 0.8);\n      width: 0;\n      display: block;\n      overflow: hidden;\n      transition: width 0.5s ease; }\n      :host /deep/ .menu-collapsed .al-sidebar .al-sidebar-sublist.slide-right {\n        width: 135px; }\n      :host /deep/ .menu-collapsed .al-sidebar .al-sidebar-sublist::before {\n        display: none; }\n      :host /deep/ .menu-collapsed .al-sidebar .al-sidebar-sublist li::before {\n        display: none; }\n      :host /deep/ .menu-collapsed .al-sidebar .al-sidebar-sublist li a {\n        padding-left: 18px;\n        padding-right: 18px;\n        min-width: 130px;\n        white-space: nowrap; }\n    :host /deep/ .menu-collapsed .al-sidebar .sidebar-hover-elem, :host /deep/ .menu-collapsed .al-sidebar .sidebar-select-elem {\n      left: 48px; } }\n\n@media (max-width: 1200px) {\n  :host /deep/ .al-sidebar {\n    width: 180px;\n    background: rgba(0, 0, 0, 0.75);\n    transition: width 0.5s ease; }\n    :host /deep/ .al-sidebar .fa-angle-down, :host /deep/ .al-sidebar .fa-angle-up {\n      opacity: 1; }\n    :host /deep/ .al-sidebar .al-sidebar-sublist {\n      padding: 0;\n      list-style: none;\n      position: relative;\n      display: none;\n      top: auto;\n      left: auto;\n      background: none;\n      width: auto;\n      overflow: visible;\n      transition: none; }\n      :host /deep/ .al-sidebar .al-sidebar-sublist.expanded {\n        display: block; }\n      :host /deep/ .al-sidebar .al-sidebar-sublist > ba-menu-item > li {\n        display: block;\n        float: none;\n        padding: 0;\n        border-bottom: none;\n        position: relative; }\n        :host /deep/ .al-sidebar .al-sidebar-sublist > ba-menu-item > li a {\n          display: block;\n          text-shadow: none;\n          font-size: 13px;\n          text-decoration: none;\n          color: #ffffff;\n          padding-left: 52px;\n          height: auto;\n          line-height: 29px; }\n        :host /deep/ .al-sidebar .al-sidebar-sublist > ba-menu-item > li.selected:not(.with-sub-menu) > a {\n          font-size: 14px;\n          font-weight: 300;\n          background-color: #59a453;\n          border-top: 1px solid rgba(250, 250, 250, 0.4);\n          border-bottom: 1px solid rgba(250, 250, 250, 0.4); }\n    :host /deep/ .al-sidebar .sidebar-hover-elem, :host /deep/ .al-sidebar .sidebar-select-elem {\n      left: 176px;\n      transition: left 0.5s ease; } }\n\n@media (max-width: 500px) {\n  :host /deep/ .menu-collapsed .al-sidebar {\n    width: 0; }\n  :host /deep/ .menu-collapsed .sidebar-hover-elem, :host /deep/ .menu-collapsed .sidebar-select-elem {\n    display: none; }\n  :host /deep/ .menu-collapsed .al-content {\n    width: calc(100%); }\n  :host /deep/ .al-main {\n    margin-left: 0; }\n  :host /deep/ .al-footer {\n    padding-left: 0; } }\n\n@media (max-width: 500px) {\n  :host /deep/ .al-content {\n    width: calc(100%); } }\n", ""]);

// exports


/*** EXPORTS FROM exports-loader ***/
module.exports = module.exports.toString();

/***/ }),

/***/ 499:
/***/ (function(module, exports, __webpack_require__) {

exports = module.exports = __webpack_require__(17)(false);
// imports


// module
exports.push([module.i, ".ba-back-top {\n  position: fixed;\n  width: 52px;\n  height: 52px;\n  cursor: pointer;\n  z-index: 9999;\n  display: none;\n  text-decoration: none;\n  right: 40px;\n  bottom: 40px !important;\n  font-size: 45px;\n  text-align: center;\n  opacity: 0.4;\n  color: white;\n  background-color: rgba(0, 0, 0, 0.75);\n  border-radius: 50%;\n  line-height: 46px; }\n  .ba-back-top:hover {\n    opacity: 0.8; }\n", ""]);

// exports


/*** EXPORTS FROM exports-loader ***/
module.exports = module.exports.toString();

/***/ }),

/***/ 500:
/***/ (function(module, exports, __webpack_require__) {

exports = module.exports = __webpack_require__(17)(false);
// imports


// module
exports.push([module.i, ".content-top {\n  padding: 18px 13px 13px;\n  background-color: #ffffff; }\n\n.al-content {\n  background-color: #fff;\n  box-shadow: 0 1px 3px rgba(0, 0, 0, 0.12), 0 1px 2px rgba(0, 0, 0, 0.24);\n  z-index: 0;\n  padding: 8px 32px 8px 40px; }\n\nh1.al-title {\n  font-weight: 700;\n  color: #374767;\n  float: left;\n  width: auto;\n  margin: 0;\n  padding: 0;\n  font-size: 24px;\n  text-transform: uppercase;\n  opacity: 0.9; }\n\n.al-breadcrumb {\n  background: none;\n  color: #374767;\n  padding: 0;\n  margin: 0;\n  float: right;\n  padding-top: 5px; }\n  .al-breadcrumb li {\n    font-size: 18px;\n    font-weight: 400; }\n    .al-breadcrumb li a {\n      color: #374767; }\n    .al-breadcrumb li.breadcrumb-item.active {\n      color: #374767; }\n\n.al-look {\n  float: right;\n  margin-right: 10px;\n  padding-top: 10px; }\n  .al-look > a {\n    font-size: 19px; }\n", ""]);

// exports


/*** EXPORTS FROM exports-loader ***/
module.exports = module.exports.toString();

/***/ }),

/***/ 501:
/***/ (function(module, exports, __webpack_require__) {

exports = module.exports = __webpack_require__(17)(false);
// imports


// module
exports.push([module.i, "", ""]);

// exports


/*** EXPORTS FROM exports-loader ***/
module.exports = module.exports.toString();

/***/ }),

/***/ 502:
/***/ (function(module, exports, __webpack_require__) {

exports = module.exports = __webpack_require__(17)(false);
// imports


// module
exports.push([module.i, "", ""]);

// exports


/*** EXPORTS FROM exports-loader ***/
module.exports = module.exports.toString();

/***/ }),

/***/ 503:
/***/ (function(module, exports, __webpack_require__) {

exports = module.exports = __webpack_require__(17)(false);
// imports


// module
exports.push([module.i, "/* msg center */\n@-webkit-keyframes pulsate {\n  30% {\n    -webkit-transform: scale(0.1, 0.1);\n    opacity: 0.0; }\n  35% {\n    opacity: 1.0; }\n  40% {\n    -webkit-transform: scale(1.2, 1.2);\n    opacity: 0.0; } }\n\n.al-msg-center {\n  float: right;\n  padding: 0;\n  list-style: none;\n  margin: 13px 47px 0 0; }\n  .al-msg-center li {\n    list-style: none;\n    float: left;\n    margin-left: 30px; }\n    .al-msg-center li:first-child {\n      margin-left: 0; }\n    .al-msg-center li > a {\n      color: #ffffff;\n      text-decoration: none;\n      font-size: 13px;\n      position: relative; }\n      .al-msg-center li > a span {\n        display: inline-block;\n        min-width: 10px;\n        padding: 2px 4px 2px 4px;\n        color: #ffffff;\n        vertical-align: baseline;\n        white-space: nowrap;\n        text-align: center;\n        border-radius: 13px;\n        text-shadow: none;\n        line-height: 11px;\n        background-color: #f95372;\n        position: absolute;\n        top: -5px;\n        right: -14px;\n        font-size: 11px; }\n      .al-msg-center li > a .notification-ring {\n        border: 1px solid #f95372;\n        border-radius: 100px;\n        height: 40px;\n        width: 40px;\n        position: absolute;\n        top: -18px;\n        right: -27px;\n        -webkit-animation: pulsate 8s ease-out;\n                animation: pulsate 8s ease-out;\n        -webkit-animation-iteration-count: infinite;\n                animation-iteration-count: infinite;\n        opacity: 0.0; }\n      .al-msg-center li > a:hover {\n        color: #f95372; }\n        .al-msg-center li > a:hover.msg {\n          color: #374767; }\n      .al-msg-center li > a.msg span {\n        background-color: #374767; }\n      .al-msg-center li > a.msg .notification-ring {\n        border-color: #374767; }\n    .al-msg-center li.open > a {\n      color: #f95372; }\n      .al-msg-center li.open > a.msg {\n        color: #374767; }\n\n@media (max-width: 435px) {\n  .al-msg-center {\n    margin-right: 20px; }\n    .al-msg-center li {\n      margin-left: 20px; }\n      .al-msg-center li:first-child {\n        margin-left: 0; } }\n\n.msg-block-header {\n  display: inline-block;\n  padding: 0;\n  font-size: 13px;\n  margin: 0 0 0 6px; }\n\n.top-dropdown-menu {\n  width: 316px;\n  left: auto;\n  right: -47px;\n  top: 26px; }\n  .top-dropdown-menu ::-webkit-scrollbar {\n    width: 0.4em;\n    height: 0.4em; }\n  .top-dropdown-menu ::-webkit-scrollbar-thumb {\n    background: rgba(0, 0, 0, 0.5);\n    cursor: pointer; }\n  .top-dropdown-menu ::-webkit-scrollbar-track {\n    background: #fff; }\n  .top-dropdown-menu body {\n    scrollbar-face-color: rgba(0, 0, 0, 0.5);\n    scrollbar-track-color: #fff; }\n  .top-dropdown-menu .header {\n    padding: 10px 12px;\n    border-bottom: 1px solid #ffffff;\n    font-size: 12px; }\n    .top-dropdown-menu .header strong {\n      float: left;\n      color: #7d7d7d; }\n    .top-dropdown-menu .header > a {\n      float: right;\n      margin-left: 12px;\n      text-decoration: none; }\n      .top-dropdown-menu .header > a:hover {\n        color: #7d7d7d; }\n  .top-dropdown-menu .msg-list {\n    max-height: 296px;\n    overflow: scroll;\n    overflow-x: hidden; }\n    .top-dropdown-menu .msg-list > a {\n      border-top: 1px solid #ffffff;\n      padding: 10px 12px;\n      display: block;\n      text-decoration: none;\n      color: #7d7d7d;\n      font-size: 12px; }\n      .top-dropdown-menu .msg-list > a:first-child {\n        border-top: none; }\n      .top-dropdown-menu .msg-list > a .img-area {\n        float: left;\n        width: 36px; }\n        .top-dropdown-menu .msg-list > a .img-area img {\n          width: 36px;\n          height: 36px; }\n          .top-dropdown-menu .msg-list > a .img-area img.photo-msg-item {\n            border-radius: 18px; }\n        .top-dropdown-menu .msg-list > a .img-area > div {\n          width: 36px;\n          height: 36px;\n          border-radius: 4px;\n          font-size: 24px;\n          text-align: center; }\n          .top-dropdown-menu .msg-list > a .img-area > div.comments {\n            color: #e7ba08; }\n          .top-dropdown-menu .msg-list > a .img-area > div.orders {\n            color: #e7ba08; }\n          .top-dropdown-menu .msg-list > a .img-area > div i {\n            width: 36px;\n            line-height: 36px; }\n      .top-dropdown-menu .msg-list > a .msg-area {\n        float: right;\n        width: 230px; }\n        .top-dropdown-menu .msg-list > a .msg-area div {\n          max-height: 34px;\n          overflow: hidden;\n          text-overflow: ellipsis; }\n        .top-dropdown-menu .msg-list > a .msg-area span {\n          font-style: italic;\n          text-align: right;\n          display: block;\n          font-size: 11px; }\n      .top-dropdown-menu .msg-list > a:hover {\n        background: #E2F0FF; }\n  .top-dropdown-menu > a {\n    border-top: 1px solid #ffffff;\n    display: block;\n    text-align: center;\n    padding: 10px;\n    font-size: 12px;\n    text-decoration: none; }\n    .top-dropdown-menu > a:hover {\n      color: #7d7d7d; }\n  .top-dropdown-menu.profile-dropdown {\n    width: 200px;\n    top: 35px;\n    right: -20px; }\n    .top-dropdown-menu.profile-dropdown a {\n      text-align: left;\n      border: none;\n      text-decoration: none;\n      color: #7d7d7d;\n      padding: 4px 16px 4px 20px; }\n      .top-dropdown-menu.profile-dropdown a i {\n        margin-right: 10px; }\n    .top-dropdown-menu.profile-dropdown i.dropdown-arr {\n      right: 25px; }\n  .top-dropdown-menu i.dropdown-arr {\n    position: absolute;\n    top: -22px;\n    right: 42px;\n    display: block;\n    width: 0;\n    height: 0;\n    border: 11px solid transparent;\n    border-bottom-color: rgba(0, 0, 0, 0.15); }\n    .top-dropdown-menu i.dropdown-arr:after {\n      top: -9px;\n      left: 0px;\n      margin-left: -10px;\n      content: \" \";\n      position: absolute;\n      display: block;\n      width: 0;\n      height: 0;\n      border: 10px solid transparent;\n      border-bottom-color: #ffffff; }\n\n@media (max-width: 415px) {\n  .top-dropdown-menu {\n    right: -81px; }\n    .top-dropdown-menu i.dropdown-arr {\n      right: 75px; } }\n\n:host /deep/ .page-top {\n  background-color: #f1f3f6;\n  position: fixed;\n  z-index: 904;\n  box-shadow: 2px 0 3px rgba(0, 0, 0, 0.5);\n  height: 66px;\n  width: 100%;\n  min-width: 320px;\n  padding: 0 32px 0 40px; }\n  :host /deep/ .page-top .dropdown-toggle::after {\n    display: none; }\n\n:host /deep/ .signout {\n  cursor: pointer; }\n\n:host /deep/ .blur .page-top.scrolled {\n  background-color: rgba(0, 0, 0, 0.85); }\n\n:host /deep/ a.al-logo {\n  color: #ffffff;\n  display: block;\n  font-size: 24px;\n  font-family: \"Conv_Avenir\";\n  white-space: nowrap;\n  float: left;\n  outline: none !important;\n  line-height: 60px;\n  cursor: pointer; }\n  :host /deep/ a.al-logo span {\n    color: #374767; }\n  :host /deep/ a.al-logo img {\n    height: 35px; }\n\n:host /deep/ a.al-logo:hover {\n  color: #374767; }\n\n:host /deep/ .user-profile {\n  float: right;\n  min-width: 230px;\n  margin-top: 15px;\n  color: #374767; }\n\n:host /deep/ .profile-user-name {\n  -webkit-box-align: center;\n      -ms-flex-align: center;\n          align-items: center;\n  float: right;\n  margin-top: 10px;\n  padding-left: 5px; }\n\n:host /deep/ .user-picture-circle {\n  display: inline-block;\n  width: 35px;\n  height: 35px;\n  border-radius: 50%;\n  background-repeat: no-repeat;\n  background-position: center; }\n\n:host /deep/ .al-user-profile {\n  float: right;\n  margin-right: 12px;\n  transition: all .15s ease-in-out;\n  padding: 0;\n  /* width: 36px;\n    height: 36px;*/\n  border: 0;\n  opacity: 1;\n  position: relative; }\n  :host /deep/ .al-user-profile ul.profile-dropdown:after {\n    bottom: 100%;\n    right: 0;\n    border: solid transparent;\n    content: \" \";\n    height: 0;\n    width: 0;\n    position: absolute;\n    pointer-events: none;\n    border-color: rgba(255, 255, 255, 0);\n    border-bottom-color: #fff;\n    border-width: 10px;\n    margin-right: 28px; }\n  :host /deep/ .al-user-profile a {\n    display: block; }\n  :host /deep/ .al-user-profile img {\n    width: 35px;\n    height: 35px;\n    border-radius: 50%;\n    cursor: pointer; }\n\n:host /deep/ a.refresh-data {\n  color: #ffffff;\n  font-size: 13px;\n  text-decoration: none;\n  font-weight: 400;\n  float: right;\n  margin-top: 13px;\n  margin-right: 26px; }\n  :host /deep/ a.refresh-data:hover {\n    color: #e7ba08 !important; }\n\n:host /deep/ a.collapse-menu-link {\n  font-size: 31px;\n  cursor: pointer;\n  display: block;\n  text-decoration: none;\n  line-height: 42px;\n  color: #374767;\n  padding: 0;\n  float: left;\n  margin: 11px 0 0 25px; }\n  :host /deep/ a.collapse-menu-link:hover {\n    text-decoration: none;\n    color: #374767; }\n\n:host /deep/ .al-skin-dropdown {\n  float: right;\n  margin-top: 14px;\n  margin-right: 26px; }\n  :host /deep/ .al-skin-dropdown .tpl-skin-panel {\n    max-height: 300px;\n    overflow-y: scroll;\n    overflow-x: hidden; }\n\n:host /deep/ .icon-palette {\n  display: inline-block;\n  width: 14px;\n  height: 13px;\n  background: url(\"/img/theme/palette.png\");\n  background-size: cover; }\n\n:host /deep/ .search {\n  text-shadow: none;\n  font-size: 13px;\n  line-height: 25px;\n  transition: all 0.5s ease;\n  white-space: nowrap;\n  overflow: hidden;\n  width: 162px;\n  float: left;\n  margin: 20px 0 0 30px; }\n  :host /deep/ .search label {\n    cursor: pointer; }\n  :host /deep/ .search i {\n    width: 16px;\n    display: inline-block;\n    cursor: pointer;\n    padding-left: 1px;\n    font-size: 16px;\n    margin-right: 13px; }\n  :host /deep/ .search input {\n    color: #ffffff;\n    background: none;\n    border: none;\n    outline: none;\n    width: 120px;\n    padding: 0;\n    margin: 0 0 0 -3px;\n    height: 27px; }\n\n@media screen and (max-width: 660px) {\n  :host /deep/ .search {\n    display: none; } }\n\n@media screen and (max-width: 500px) {\n  :host /deep/ .page-top {\n    padding: 0 20px; } }\n\n@media (max-width: 435px) {\n  :host /deep/ .user-profile {\n    min-width: 125px; }\n  :host /deep/ a.refresh-data {\n    margin-right: 10px; }\n  :host /deep/ a.collapse-menu-link {\n    margin-left: 9px; }\n  :host /deep/ .al-skin-dropdown {\n    display: none; } }\n\n:host /deep/ .profile-toggle-link {\n  cursor: pointer; }\n", ""]);

// exports


/*** EXPORTS FROM exports-loader ***/
module.exports = module.exports.toString();

/***/ }),

/***/ 504:
/***/ (function(module, exports, __webpack_require__) {

exports = module.exports = __webpack_require__(17)(false);
// imports


// module
exports.push([module.i, ":host /deep/ .al-sidebar {\n  width: 180px;\n  top: 66px;\n  left: 0;\n  z-index: 1001;\n  display: block;\n  min-height: 100%;\n  background-color: #374767;\n  height: 100%;\n  position: fixed;\n  box-shadow: 3px 2px 3px 0px #D3D3D3; }\n\n:host /deep/ .al-sidebar-list {\n  margin: 0;\n  overflow: hidden;\n  padding: 18px 0 0 0;\n  list-style: none; }\n\n:host /deep/ .al-sidebar-sublist .subitem-submenu-list {\n  padding-left: 15px; }\n\n:host /deep/ .subitem-submenu-link .fa {\n  top: 7px; }\n\n:host /deep/ .al-sidebar-list-item {\n  display: block;\n  position: relative;\n  float: none;\n  padding: 0; }\n  :host /deep/ .al-sidebar-list-item.selected:not(.with-sub-menu) {\n    background-color: #59a453;\n    border-bottom: 1px solid rgba(250, 250, 250, 0.4);\n    border-top: 1px solid rgba(250, 250, 250, 0.4);\n    font-size: 14px;\n    font-weight: 300; }\n    :host /deep/ .al-sidebar-list-item.selected:not(.with-sub-menu) a.al-sidebar-list-link {\n      color: #ffffff; }\n      :host /deep/ .al-sidebar-list-item.selected:not(.with-sub-menu) a.al-sidebar-list-link b {\n        color: #ffffff; }\n\n:host /deep/ .al-sidebar-list-item :hover {\n  background-color: rgba(34, 45, 50, 0.37); }\n\n:host /deep/ .ba-sidebar-item-expanded > ul.al-sidebar-sublist {\n  display: block !important; }\n\n:host /deep/ .al-sidebar-list-item.ba-sidebar-item-expanded > .al-sidebar-list-link b, :host /deep/ .ba-sidebar-sublist-item.ba-sidebar-item-expanded > .al-sidebar-list-link b {\n  -webkit-transform: rotate(180deg);\n          transform: rotate(180deg); }\n\n:host /deep/ .al-sidebar-list-item.ba-sidebar-item-expanded > .al-sidebar-sublist, :host /deep/ .ba-sidebar-sublist-item.ba-sidebar-item-expanded > .al-sidebar-sublist {\n  display: block; }\n\n:host /deep/ a.al-sidebar-list-link {\n  display: block;\n  height: 42px;\n  padding-left: 18px;\n  text-shadow: none;\n  font-size: 13px;\n  text-decoration: none;\n  color: #ffffff;\n  line-height: 42px;\n  white-space: nowrap;\n  overflow: hidden;\n  cursor: pointer; }\n  :host /deep/ a.al-sidebar-list-link i {\n    margin-right: 18px;\n    width: 16px;\n    display: inline-block; }\n  :host /deep/ a.al-sidebar-list-link b {\n    display: block;\n    opacity: 1;\n    width: 14px;\n    height: 14px;\n    line-height: 14px;\n    text-shadow: none;\n    font-size: 18px;\n    position: absolute;\n    right: 10px;\n    top: 12px;\n    padding: 0;\n    text-align: center;\n    color: #ffffff;\n    transition: -webkit-transform 0.2s linear;\n    transition: transform 0.2s linear;\n    transition: transform 0.2s linear, -webkit-transform 0.2s linear; }\n\n:host /deep/ .slimScrollBar, :host /deep/ .slimScrollRail {\n  border-radius: 0;\n  width: 4px !important;\n  left: 176px; }\n\n:host /deep/ .al-sidebar-sublist {\n  padding: 0;\n  list-style: none;\n  position: relative;\n  display: none; }\n  :host /deep/ .al-sidebar-sublist.expanded {\n    display: block; }\n  :host /deep/ .al-sidebar-sublist > ba-menu-item > li {\n    display: block;\n    float: none;\n    padding: 0;\n    border-bottom: none;\n    position: relative; }\n    :host /deep/ .al-sidebar-sublist > ba-menu-item > li a {\n      display: block;\n      text-shadow: none;\n      font-size: 13px;\n      text-decoration: none;\n      color: #ffffff;\n      padding-left: 52px;\n      height: auto;\n      line-height: 29px; }\n    :host /deep/ .al-sidebar-sublist > ba-menu-item > li.selected:not(.with-sub-menu) > a {\n      font-size: 14px;\n      font-weight: 300;\n      background-color: #59a453;\n      border-top: 1px solid rgba(250, 250, 250, 0.4);\n      border-bottom: 1px solid rgba(250, 250, 250, 0.4); }\n\n:host /deep/ .sidebar-hover-elem {\n  width: 4px;\n  background: #374767;\n  position: absolute;\n  top: -150px;\n  left: 176px;\n  transition: all 0.5s ease;\n  transition-property: top, height;\n  height: 42px;\n  display: none; }\n\n:host /deep/ .sidebar-select-elem {\n  display: block;\n  top: 94px; }\n\n:host /deep/ .menu-collapsed .slimScrollBar, :host /deep/ .menu-collapsed .slimScrollRail {\n  display: none !important; }\n\n:host /deep/ .menu-collapsed .userImageSidebar {\n  display: none; }\n\n:host /deep/ .menu-collapsed .userProfileName {\n  display: none; }\n\n:host /deep/ .userImageSidebar {\n  margin-left: 18px;\n  border-radius: 70px;\n  width: 70px;\n  height: 70px;\n  margin-top: 20px;\n  display: inline-block; }\n\n:host /deep/ .userImageDiv {\n  display: inline-block; }\n\n:host /deep/ .userProfileName {\n  display: inline-block;\n  margin-left: 12px;\n  color: white; }\n", ""]);

// exports


/*** EXPORTS FROM exports-loader ***/
module.exports = module.exports.toString();

/***/ }),

/***/ 509:
/***/ (function(module, exports, __webpack_require__) {

var map = {
	"./af": 195,
	"./af.js": 195,
	"./ar": 202,
	"./ar-dz": 196,
	"./ar-dz.js": 196,
	"./ar-kw": 197,
	"./ar-kw.js": 197,
	"./ar-ly": 198,
	"./ar-ly.js": 198,
	"./ar-ma": 199,
	"./ar-ma.js": 199,
	"./ar-sa": 200,
	"./ar-sa.js": 200,
	"./ar-tn": 201,
	"./ar-tn.js": 201,
	"./ar.js": 202,
	"./az": 203,
	"./az.js": 203,
	"./be": 204,
	"./be.js": 204,
	"./bg": 205,
	"./bg.js": 205,
	"./bn": 206,
	"./bn.js": 206,
	"./bo": 207,
	"./bo.js": 207,
	"./br": 208,
	"./br.js": 208,
	"./bs": 209,
	"./bs.js": 209,
	"./ca": 210,
	"./ca.js": 210,
	"./cs": 211,
	"./cs.js": 211,
	"./cv": 212,
	"./cv.js": 212,
	"./cy": 213,
	"./cy.js": 213,
	"./da": 214,
	"./da.js": 214,
	"./de": 217,
	"./de-at": 215,
	"./de-at.js": 215,
	"./de-ch": 216,
	"./de-ch.js": 216,
	"./de.js": 217,
	"./dv": 218,
	"./dv.js": 218,
	"./el": 219,
	"./el.js": 219,
	"./en-au": 220,
	"./en-au.js": 220,
	"./en-ca": 221,
	"./en-ca.js": 221,
	"./en-gb": 222,
	"./en-gb.js": 222,
	"./en-ie": 223,
	"./en-ie.js": 223,
	"./en-nz": 224,
	"./en-nz.js": 224,
	"./eo": 225,
	"./eo.js": 225,
	"./es": 227,
	"./es-do": 226,
	"./es-do.js": 226,
	"./es.js": 227,
	"./et": 228,
	"./et.js": 228,
	"./eu": 229,
	"./eu.js": 229,
	"./fa": 230,
	"./fa.js": 230,
	"./fi": 231,
	"./fi.js": 231,
	"./fo": 232,
	"./fo.js": 232,
	"./fr": 235,
	"./fr-ca": 233,
	"./fr-ca.js": 233,
	"./fr-ch": 234,
	"./fr-ch.js": 234,
	"./fr.js": 235,
	"./fy": 236,
	"./fy.js": 236,
	"./gd": 237,
	"./gd.js": 237,
	"./gl": 238,
	"./gl.js": 238,
	"./gom-latn": 239,
	"./gom-latn.js": 239,
	"./he": 240,
	"./he.js": 240,
	"./hi": 241,
	"./hi.js": 241,
	"./hr": 242,
	"./hr.js": 242,
	"./hu": 243,
	"./hu.js": 243,
	"./hy-am": 244,
	"./hy-am.js": 244,
	"./id": 245,
	"./id.js": 245,
	"./is": 246,
	"./is.js": 246,
	"./it": 247,
	"./it.js": 247,
	"./ja": 248,
	"./ja.js": 248,
	"./jv": 249,
	"./jv.js": 249,
	"./ka": 250,
	"./ka.js": 250,
	"./kk": 251,
	"./kk.js": 251,
	"./km": 252,
	"./km.js": 252,
	"./kn": 253,
	"./kn.js": 253,
	"./ko": 254,
	"./ko.js": 254,
	"./ky": 255,
	"./ky.js": 255,
	"./lb": 256,
	"./lb.js": 256,
	"./lo": 257,
	"./lo.js": 257,
	"./lt": 258,
	"./lt.js": 258,
	"./lv": 259,
	"./lv.js": 259,
	"./me": 260,
	"./me.js": 260,
	"./mi": 261,
	"./mi.js": 261,
	"./mk": 262,
	"./mk.js": 262,
	"./ml": 263,
	"./ml.js": 263,
	"./mr": 264,
	"./mr.js": 264,
	"./ms": 266,
	"./ms-my": 265,
	"./ms-my.js": 265,
	"./ms.js": 266,
	"./my": 267,
	"./my.js": 267,
	"./nb": 268,
	"./nb.js": 268,
	"./ne": 269,
	"./ne.js": 269,
	"./nl": 271,
	"./nl-be": 270,
	"./nl-be.js": 270,
	"./nl.js": 271,
	"./nn": 272,
	"./nn.js": 272,
	"./pa-in": 273,
	"./pa-in.js": 273,
	"./pl": 274,
	"./pl.js": 274,
	"./pt": 276,
	"./pt-br": 275,
	"./pt-br.js": 275,
	"./pt.js": 276,
	"./ro": 277,
	"./ro.js": 277,
	"./ru": 278,
	"./ru.js": 278,
	"./sd": 279,
	"./sd.js": 279,
	"./se": 280,
	"./se.js": 280,
	"./si": 281,
	"./si.js": 281,
	"./sk": 282,
	"./sk.js": 282,
	"./sl": 283,
	"./sl.js": 283,
	"./sq": 284,
	"./sq.js": 284,
	"./sr": 286,
	"./sr-cyrl": 285,
	"./sr-cyrl.js": 285,
	"./sr.js": 286,
	"./ss": 287,
	"./ss.js": 287,
	"./sv": 288,
	"./sv.js": 288,
	"./sw": 289,
	"./sw.js": 289,
	"./ta": 290,
	"./ta.js": 290,
	"./te": 291,
	"./te.js": 291,
	"./tet": 292,
	"./tet.js": 292,
	"./th": 293,
	"./th.js": 293,
	"./tl-ph": 294,
	"./tl-ph.js": 294,
	"./tlh": 295,
	"./tlh.js": 295,
	"./tr": 296,
	"./tr.js": 296,
	"./tzl": 297,
	"./tzl.js": 297,
	"./tzm": 299,
	"./tzm-latn": 298,
	"./tzm-latn.js": 298,
	"./tzm.js": 299,
	"./uk": 300,
	"./uk.js": 300,
	"./ur": 301,
	"./ur.js": 301,
	"./uz": 303,
	"./uz-latn": 302,
	"./uz-latn.js": 302,
	"./uz.js": 303,
	"./vi": 304,
	"./vi.js": 304,
	"./x-pseudo": 305,
	"./x-pseudo.js": 305,
	"./yo": 306,
	"./yo.js": 306,
	"./zh-cn": 307,
	"./zh-cn.js": 307,
	"./zh-hk": 308,
	"./zh-hk.js": 308,
	"./zh-tw": 309,
	"./zh-tw.js": 309
};
function webpackContext(req) {
	return __webpack_require__(webpackContextResolve(req));
};
function webpackContextResolve(req) {
	var id = map[req];
	if(!(id + 1)) // check for number
		throw new Error("Cannot find module '" + req + "'.");
	return id;
};
webpackContext.keys = function webpackContextKeys() {
	return Object.keys(map);
};
webpackContext.resolve = webpackContextResolve;
module.exports = webpackContext;
webpackContext.id = 509;


/***/ }),

/***/ 554:
/***/ (function(module, exports) {

module.exports = "<div class=\"content-top clearfix\">\n  <h1 class=\"al-title\" translate>{{ activePageTitle }}</h1>\n\n  <!--<ul class=\"breadcrumb al-breadcrumb\">\n    <li class=\"breadcrumb-item\">\n      <a routerLink=\"/pages/dashboard\" translate>{{'general.home'}}</a>\n    </li>\n    <li class=\"breadcrumb-item active\" translate>{{ activePageTitle }}</li>\n  </ul>-->\n</div>\n"

/***/ }),

/***/ 555:
/***/ (function(module, exports) {

module.exports = "<ul id=\"al-sidebar-list\" class=\"al-sidebar-list\" baSlimScroll [baSlimScrollOptions]=\"{height: menuHeight}\"\n    (mouseleave)=\"hoverElemTop=outOfArea\">\n  <ba-menu-item\n    [menuItem]=\"item\"\n    (itemHover)=\"hoverItem($event)\"\n    (toggleSubMenu)=\"toggleSubMenu($event)\"\n    *ngFor=\"let item of menuItems\"></ba-menu-item>\n</ul>\n<div class=\"sidebar-hover-elem\" [ngStyle]=\"{top: hoverElemTop + 'px', height: hoverElemHeight + 'px'}\"\n     [ngClass]=\"{'show-hover-elem': showHoverElem }\">\n</div>\n"

/***/ }),

/***/ 556:
/***/ (function(module, exports) {

module.exports = "<li *ngIf=\"!menuItem.hidden\" [title]=\"menuItem.title\" [ngClass]=\"{'al-sidebar-list-item': !child, 'ba-sidebar-sublist-item': child, 'selected': menuItem.selected && !menuItem.expanded, 'with-sub-menu': menuItem.children, 'ba-sidebar-item-expanded': menuItem.expanded}\">\n\n  <a *ngIf=\"!menuItem.children && !menuItem.url\" (mouseenter)=\"onHoverItem($event, item)\" [routerLink]=\"menuItem.route.paths\" class=\"al-sidebar-list-link\">\n    <i *ngIf=\"menuItem.icon\" class=\"{{ menuItem.icon }}\"></i><span translate>{{ menuItem.title }}</span>\n  </a>\n\n  <a *ngIf=\"!menuItem.children && menuItem.url\" (mouseenter)=\"onHoverItem($event, item)\" [href]=\"menuItem.url\" [target]=\"menuItem.target\" class=\"al-sidebar-list-link\">\n    <i *ngIf=\"menuItem.icon\" class=\"{{ menuItem.icon }}\"></i><span translate>{{ menuItem.title }}</span>\n  </a>\n\n  <a *ngIf=\"menuItem.children\" (mouseenter)=\"onHoverItem($event, item)\" href (click)=\"onToggleSubMenu($event, menuItem)\" class=\"al-sidebar-list-link\">\n    <i *ngIf=\"menuItem.icon\" class=\"{{ menuItem.icon }}\"></i><span translate>{{ menuItem.title }}</span>\n    <b class=\"fa fa-angle-down\" [ngClass]=\"{'fa-angle-up': menuItem.expanded}\"></b>\n  </a>\n\n  <ul *ngIf=\"menuItem.children\" class=\"al-sidebar-sublist\" [ngClass]=\"{'slide-right': menuItem.slideRight}\">\n    <ba-menu-item [menuItem]=\"subItem\"\n                  [child]=\"true\"\n                  (itemHover)=\"onHoverItem($event)\"\n                  (toggleSubMenu)=\"onToggleSubMenu($event, subItem)\"\n                  *ngFor=\"let subItem of menuItem.children\"></ba-menu-item>\n  </ul>\n\n</li>\n"

/***/ }),

/***/ 557:
/***/ (function(module, exports) {

module.exports = "<div class=\"page-top clearfix\" baScrollPosition maxHeight=\"50\" (scrollChange)=\"scrolledChanged($event)\"\n     [ngClass]=\"{scrolled: isScrolled}\">\n    <a (click)=\"navigateToDashboard()\" class=\"al-logo clearfix\"><img src=\"https://tudip.com/wp-content/uploads/2017/07/tudip_80x35.png\"></a>\n    <!-- <a routerLink=\"/pages/dashboard\" class=\"al-logo clearfix\"><span>ng2-</span>admin</a>-->\n    <a href (click)=\"toggleMenu()\" class=\"collapse-menu-link ion-navicon\"></a>\n\n    <!--  <div class=\"search\">\n        <i class=\"ion-ios-search-strong\" ng-click=\"startSearch()\"></i>\n        <input id=\"searchInput\" type=\"text\" placeholder=\"Search for...\">\n      </div>-->\n\n    <div class=\"user-profile clearfix\">\n        <div class=\"dropdown al-user-profile\">\n            <a class=\"profile-toggle-link dropdown-toggle\" id=\"user-profile-dd\" data-toggle=\"dropdown\"\n               aria-expanded=\"false\">\n                <div class=\"user-picture-circle\">\n                <!--<img src=\"{{userProfileImage}}\">-->\n                </div>\n                <div style=\"overflow: hidden; white-space: nowrap; text-overflow: ellipsis; max-width: 200px;\" class=\"profile-user-name\"><span>Hi, {{this.userUtility.userName | capitalize}} <i class=\"fa fa-angle-down\"></i></span></div>\n            </a>\n            <ul class=\"dropdown-menu top-dropdown-menu profile-dropdown\" aria-labelledby=\"user-profile-dd\">\n                <li class=\"dropdown-item\"><a class=\"signout\" (click)=\"navigateToProfile()\"><i class=\"fa fa-cog\"></i>Change Password</a></li>\n                <!--<li *ngIf='isAdmin' class=\"dropdown-item\"><a class=\"signout\" (click)=\"navigateToProfile()\"><i class=\"fa fa-user\"></i>Investor Profile</a></li>-->\n                <li class=\"dropdown-item\"><a class=\"signout\" (click)=\"loggedOff()\"><i class=\"fa fa-power-off\"></i>Sign\n                    out</a></li>\n            </ul>\n        </div>\n    </div>\n</div>\n"

/***/ }),

/***/ 558:
/***/ (function(module, exports) {

module.exports = "<aside class=\"al-sidebar\" sidebarResize>\n  <div>\n    <!--<div class=\"userImageDiv\">-->\n      <!--<img class=\"userImageSidebar\" src=\"{{userProfileImage}}\">-->\n    <!--</div>-->\n    <div class=\"userProfileName\">\n\n    </div>\n\n  </div>\n  <ba-menu [menuHeight]=\"menuHeight\"\n           [sidebarCollapsed]=\"isMenuCollapsed\"\n           (expandMenu)=\"menuExpand()\"></ba-menu>\n</aside>\n"

/***/ }),

/***/ 64:
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_0__angular_core__ = __webpack_require__(2);
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "a", function() { return Utility; });
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
var __metadata = (this && this.__metadata) || function (k, v) {
    if (typeof Reflect === "object" && typeof Reflect.metadata === "function") return Reflect.metadata(k, v);
};

var Utility = (function () {
    function Utility() {
        this.states = [];
        this.unitArray = [
            'Kg/s',
            'Litre/s',
            'Dozen/s',
            'Half dozen/s',
            'Piece/s',
            'Per person/s',
            'Per month/s',
            'Per plate/s'
        ];
        this.perPageArray = [
            25,
            50,
            100
        ];
        this.vendorPoGridRecord = {
            pageNumber: 1,
            perPage: 25,
            searchString: '',
        };
        this.paymentRecord = {
            pageNumber: 1,
            perPage: 25,
            searchString: '',
        };
        this.receivedRecord = {
            pageNumber: 1,
            perPage: 25,
            searchString: '',
        };
        this.itemQuantityRecord = {
            pageNumber: 1,
            perPage: 25,
            searchString: '',
        };
        this.itemUsedRecord = {
            pageNumber: 1,
            perPage: 25,
            searchString: '',
        };
        this.itemVendorRecord = {
            pageNumber: 1,
            perPage: 25,
            searchString: '',
        };
        this.vendorItemRecordAdd = {
            pageNumber: 1,
            perPage: 25,
            searchString: '',
        };
        this.vendorItemRecordEdit = {
            pageNumber: 1,
            perPage: 25,
            searchString: '',
        };
        this.vendorPageRecord = {
            pageNumber: 1,
            perPage: 25,
            searchString: '',
        };
        this.itemPageRecord = {
            pageNumber: 1,
            perPage: 25,
            searchString: '',
        };
        this.expensePageRecord = {
            pageNumber: 1,
            perPage: 25,
            searchString: '',
        };
        this.almirahPageRecord = {
            pageNumber: 1,
            perPage: 25,
            searchString: '',
        };
        this.tagsPageRecord = {
            pageNumber: 1,
            perPage: 25,
            searchString: '',
        };
        this.userPageRecord = {
            pageNumber: 1,
            perPage: 25,
            searchString: '',
        };
        this.termsPageRecord = {
            pageNumber: 1,
            perPage: 25,
            searchString: '',
        };
        this.templatesPageRecord = {
            pageNumber: 1,
            perPage: 25,
            searchString: '',
        };
        this.poPageRecord = {
            pageNumber: 1,
            perPage: 25,
            vendorId: '',
            unitId: '',
            statusId: '',
        };
        this.catItemPageRecord = {
            pageNumber: 1,
            perPage: 25,
            tagId: 0,
        };
        this.catVendorPageRecord = {
            pageNumber: 1,
            perPage: 25,
            tagId: 0,
        };
        this.mailData = {
            'purchase_data': '',
            'total_amount': '',
            'vendor_data': '',
            'email': '',
            'status': '',
        };
        this.unitArray.sort();
        this.poSubject = 'Test Email';
        this.poTemplate = '<b> Hello, </b> <p> Greetings,</p> <p>This is Test Mail</p>';
        this.states = [
            'Andaman and Nicobar Islands',
            'Andra Pradesh',
            'Arunachal Pradesh',
            'Assam',
            'Bihar',
            'Chandigarh',
            'Chhattisgarh',
            'Dadar and Nagar Haveli',
            'Daman and Diu',
            'Delhi',
            'Goa',
            'Gujarat',
            'Haryana',
            'Himachal Pradesh',
            'Jammu and Kashmir',
            'Jharkhand',
            'Karnataka',
            'Kerala',
            'Lakshadeep',
            'Madya Pradesh',
            'Maharashtra',
            'Manipur',
            'Meghalaya',
            'Mizoram',
            'Nagaland',
            'Orissa',
            'Pondicherry',
            'Punjab',
            'Rajasthan',
            'Sikkim',
            'Tamil Nadu',
            'Telangana',
            'Tripura',
            'Uttaranchal',
            'Uttar Pradesh',
            'West Bengal',
        ];
        this.successMessages = {
            'ADD_VENDOR_SUCCESS': 'Vendor added successfully',
            'EDIT_VENDOR_FINANCE_SUCCESS': 'Financial information updated successfully',
            'EDIT_VENDOR_CONTACT_SUCCESS': 'Contact information updated successfully',
            'DELETE_VENDOR_SUCCESS': 'Vendor deleted successfully',
            'ADD_TAG_SUCCESS': 'Category added successfully',
            'EDIT_TAG_SUCCESS': 'Category edited successfully',
            'ADD_TERMS_SUCCESS': 'Terms and conditions added successfully',
            'DELETE_TAG_SUCCESS': 'Category deleted successfully',
            'ADD_ITEM_SUCCESS': 'Item added successfully',
            'EDIT_ITEM_SUCCESS': 'Item updated successfully',
            'DELETE_ITEM_SUCCESS': 'Item deleted successfully',
            'ADD_VENDOR_ITEM_SUCCESS': "Vendor's item added successfully",
            'EDIT_VENDOR_ITEM_SUCCESS': "Vendor's item updated successfully",
            'DELETE_VENDOR_ITEM_SUCCESS': "Vendor's item deleted successfully",
            'DELETE_ITEM_QUANTITY_SUCCESS': "Item quantity deleted successfully",
            'DELETE_ITEM_USED_SUCCESS': "Item used deleted successfully",
            'DELETE_PURCHASE_ORDER_SUCCESS': "Purchase order deleted successfully",
            'SEND_PURCHASE_ORDER_SUCCESS': "Purchase order sent to vendor Successfully",
            'SEND_MAIL_SUCCESS': "Mail sent to vendor successfully",
            'ADD_PURCHASE_ORDER_SUCCESS': "Purchase order added Successfully",
            'EDIT_PURCHASE_ORDER_SUCCESS': "Purchase order edited successfully",
            'ITEM_QUANTITY_ADD_SUCCESS': 'Items quantity added successfully',
            'USED_QUANTITY_ADD_SUCESS': 'Used quantity added successfully',
            'ALMIRAH_ADD_SUCESS': 'Almirah added successfully',
            'EXPENSE_ADD_SUCESS': 'Expense details added successfully',
            'OFFERING_ADD_SUCESS': 'Offering created successfully.',
            'TEMPLATE_ADD_SUCESS': 'Template added successfully',
            'UNIT_ADD_SUCESS': 'Unit added successfully',
            'UNIT_EDIT_SUCESS': 'Unit edited successfully',
            'USER_ADD_SUCESS': 'User created successfully',
            'ALMIRAH_DELTE_SUCESS': 'Almirah deleted successfully',
            'ALMIRAH_EDIT_SUCESS': 'Almirah edited successfully',
            'EXPENSE_EDIT_SUCESS': 'Expense details edited successfully',
            'CAT_DELETE_SUCESS': 'Category deleted successfully',
            'TERMS_EDITED_SUCCESS': 'Terms and conditions edited successfully',
            'TEMPLATE_EDIT_SUCCESS': 'Template edited successfully',
            'PAYMENT_EDIT_SUCCESS': 'Payment details edited successfully',
            'PAYMENT_ADD_SUCCESS': 'Payment details added successfully',
            'PAYMENT_DELETE_SUCCESS': 'Payment details deleted successfully',
            'RECEIVED_ADD_SUCCESS': 'Received items added successfully',
            'RECEIVED_ITEMS_SUCCESS': 'We have received items',
            'RECEIVED_ITEMS_DELETE_SUCCESS': 'Received item details deleted successfully',
            'EXPENSE_DELETE_SUCCESS': 'Expense deleted successfully',
            'TEMPLATE_DELETE_SUCCESS': 'Template deleted successfully',
            'TERMS_DELETE_SUCCESS': 'Terms and conditions deleted successfully',
            'USER_DELETE_SUCCESS': 'User deleted successfully',
            'LOGIN_SUCCESSFULL': 'Login successful',
            'PO_COPY_SUCESS': 'Purchase order copied successfully',
        };
        this.errorMessages = {
            'EXCEPTION': 'Something went wrong',
            'ADD_VENDOR_FAIL': 'Vendor added failed',
            'EDIT_VENDOR_FAIL': 'Vendor updated failed',
            'DELETE_VENDOR_FAIL': 'Vendor deleted failed',
            'ADD_TAG_FAIL': 'Category added failed',
            'EDIT_TAG_FAIL': 'Category updated failed',
            'DELETE_TAG_FAIL': 'Category deleted failed',
            'TAG_EXIST': 'Category already exist',
            'TAG_INVALID_ENTRY': 'Please enter category first',
            'ADD_ITEM_FAIL': 'Item added failed',
            'EDIT_ITEM_FAIL': 'Item updated failed',
            'DELETE_ITEM_FAIL': 'Item deleted failed',
            'ITEM_ALREADY_EXIST': 'Item already exist',
            'ADD_VENDOR_ITEM_FAIL': "Vendor's item added failed",
            'EDIT_VENDOR_ITEM_FAIL': "Vendor's item updated failed",
            'DELETE_VENDOR_ITEM_FAIL': "Vendor's item deleted failed",
            'NO_VENDOR_ITEMS': "Vendor's item should not be empty",
            'DELETE_PURCHASE_ORDER_FAIL': 'Purchase order deleted failed',
            'SEND_PURCHASE_ORDER_FAIL': 'Purchase order sending to vendor failed',
            'ADD_PURCHASE_ORDER_FAIL': 'Purchase order added failed',
            'FILL_PURCHASE_ORDER_DETAILS': 'Please fill item details in purchase order first',
            'GET_TAGS_FAILED': 'Failed to get categories',
            'LOCTION_NOT_FOUND': 'Failed to get item locations',
            'FAILED_TO_LOAD_ALL_PO': 'Failed to get all purchase orders',
            'LOGIN_DEACTIVATED': 'User account is de-activated',
            'EMAIL_PASSWORD_INCORRECT': 'Email or password is incorrect',
            'ADD_TERMS': 'Please add terms and conditions to this vendor',
            'ADD_VENDOR_ITEMS': 'Please add vendor-items to this vendor',
            'FAILED_OPEN_PO': 'Failed to open purchase order',
            'FAILED_OPEN_REPORT': 'Failed to open Monthly Expense Report',
            'RESTRICT_ITEM_DELETE': 'Item can not be deleted as used in purchase order',
            'RESTRICT_ITEM_FOR_VENDOR': 'Item can not be deleted as used in item vendors',
            'PO_NOT_SUBMITTED': 'Purchase Order is not submitted',
            'ON_HAND_QUANT_CHECK': 'Please enter quantity less than on hand quantity',
            'ITEM_QUANTITY_ALREADY_EXIST': "Item's Vendor is already exist",
            'TAG_NOT_CHANGED': 'Can not change category as It is used',
            'TERMS_NOT_SELECTED': 'Terms and conditions are not selected',
            'PO_ALREADY_SENT': 'Purchase order has already sent to vendor',
            'ALMIRAH_ALREADY_EXIST': 'Almirah already exist',
            'DUPLICATE_VENDOR_ITEM': 'Vendor\'s item is already exist',
            'DUPLICATE_EMAIL': 'Email address already exist',
            'INVALID_EMAIL': 'Please enter valid email address',
            'DUPLICATE_CONTACT': 'Contact already Exist',
            'EDIT_FAIL': 'User edited failed',
            'UPDATE_FAIL': 'User updated successfully',
            'DATA_FAIL': 'Failed to get data',
            'ALMIRAH_ADD_FAIL': 'Failed to add almirah',
            'DATE_VALIDATION': 'From date should be less than to date',
            'DATE_VALIDATION_BILL': 'Bill period from date should be less than bill period To date',
            'EXPESNE_ADD_FAIL': 'Failed to add expense details',
            'DUPLICATE_TEMPLATE': 'Template already exist',
            'DUPLICATE_UNIT': 'Unit already exist',
            'TEMPLATE_FAIL': 'Template added failed',
            'UNIT_FAIL': 'Unit added failed',
            'USER_ADD_FAIL': 'User created failed',
            'ALMIRAH_DELETE_FAIL': 'Almirah deleted failed',
            'ALMIRAH_DETAILS_FAIL': 'Failed to get almirah details',
            'UNITS_DETAILS_FAIL': 'Failed to get units details',
            'ALMIRAH_EDIT_FAIL': 'Failed to edit almirah',
            'EXPENSE_EDIT_FAIL': 'Failed to edit expense details',
            'EXPENSE_ADD_FAIL': 'Failed to add expense details',
            'NAN_CHECK': 'Please enter valid amounts in item grid',
            'ONE_ITEM_PO': 'Atleast one item is required in purchase order',
            'PO_EDIT_FAIL': 'Purchase order edited failed',
            'ITEM_GET_FAIL': 'Failed to get item details',
            'QUANTITY_PURCHASE_RECEIVED': 'Quantity purchased should be greater than quantity received',
            'QUANTITY_PURCHASE_RECEIVED_LESS': 'Quantity received should be less than quantity purchased',
            'DUPLICATE_FILE_AVOID': 'Duplicate files are not allowed',
            'VENDOR_DELETE_FAIL_PO': 'Vendor can not be deleted as used in purchase order',
            'VENDOR_DELETE_FAIL_VEN_ITEMS': 'Vendor can not be deleted as used in vendor items',
            'EXPENSE_DELETE_FAIL': 'Expense deleted failed',
            'CAT_DELETE_PROHIBIT_FOR_VENDOR': 'Category can not be deleted as used in vendors',
            'CAT_DELETE_PROHIBIT_FOR_ITEM': 'Category can not be deleted as used in items',
            'TEMPLATE_DELETE_FAIL': 'Template deleted failed',
            'UNIT_DELETE_FAIL': 'Unit deleted failed',
            'USER_DELETE_PROHIBIT': 'This user can not be deleted',
            'USER_DELETE_FAIL': 'User deleted failed',
            'RESTRICT_ALMIRAH_DELETE': 'Can not delete almirah as it is used',
            'DATE_FORMAT_WRONG': 'Please select date with proper format',
            'DEDUCTION_CHECK': 'Deduction amount should be less than payment amount',
            'PAYMENT_AMOUNT_CHECK': 'Payment amount should be less than remaining amount',
        };
        this.configurationCkEditor = {
            // fullPage: true,
            toolbar: [
                { name: 'document', items: ['Source', '-', 'Preview', 'Print', '-', 'Templates'] },
                { name: 'links', items: ['Anchor', 'Link', 'Unlink'] },
                { name: 'insert', items: ['SpecialChar', 'Iframe', 'HorizontalRule', 'Smiley', '-', 'Image'] },
                { name: 'tools', items: ['About', 'Maximize', 'ShowBlocks'] }, '/',
                { name: 'basicstyles', items: ['Bold', 'Italic', 'Underline', 'Strike', 'Subscript', 'Superscript'] },
                {
                    name: 'paragraph',
                    items: ['BulletedList', 'NumberedList', '-', 'JustifyCenter', 'Outdent', 'Indent', 'JustifyLeft', 'JustifyRight', 'JustifyBlock']
                }, '/',
                { name: 'colors', items: ['TextColor', 'BGColor'] },
                { name: 'editing', items: ['Find', 'Replace', '-', 'SelectAll', '-', 'Scayt'] },
                { name: 'clipboard', items: ['Cut', 'Copy', 'Undo', 'Redo'] },
                { name: 'styles', items: ['Styles', 'Format', 'Font', 'FontSize'] }
            ]
        };
    }
    Utility.prototype.makeFirstLetterCapital = function (data) {
        return data.replace(/^\w/, function (txt) {
            return txt.charAt(0).toUpperCase() + txt.substr(1).toLowerCase();
        });
    };
    Utility.prototype.makeItCapital = function (data) {
        return data.replace(/\w\S*/g, function (txt) {
            return txt.charAt(0).toUpperCase() + txt.substr(1).toLowerCase();
        });
    };
    Utility.prototype.validateDate = function (testdate) {
        var dateRegex = /^\d{1,2}\/\d{1,2}\/\d{4}$/;
        return dateRegex.test(testdate);
    };
    Utility.prototype.getFirstDayOfCurrentMonth = function () {
        var date = new Date();
        var preDate = new Date().toISOString().slice(0, 10).split('-');
        var dateString = preDate[2] + '/' + preDate[1] + '/' + preDate[0];
        var firstDateString = new Date(date.getFullYear(), date.getMonth() + 1, 1);
        var firstDate = firstDateString.toString().split(' ')[2] + '/' + preDate[1] + '/' + preDate[0];
        return firstDate;
    };
    Utility.prototype.getLastDayOfCurrentMonth = function () {
        var date = new Date();
        var preDate = new Date().toISOString().slice(0, 10).split('-');
        var dateString = preDate[2] + '/' + preDate[1] + '/' + preDate[0];
        var lastDateString = new Date(date.getFullYear(), date.getMonth() + 1, 0);
        var lastDate = lastDateString.toString().split(' ')[2] + '/' + preDate[1] + '/' + preDate[0];
        return lastDate;
    };
    return Utility;
}());
Utility = __decorate([
    __webpack_require__.i(__WEBPACK_IMPORTED_MODULE_0__angular_core__["Injectable"])(),
    __metadata("design:paramtypes", [])
], Utility);

//# sourceMappingURL=app.utility.js.map

/***/ }),

/***/ 65:
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_0__baMenu__ = __webpack_require__(429);
/* harmony namespace reexport (by used) */ __webpack_require__.d(__webpack_exports__, "b", function() { return __WEBPACK_IMPORTED_MODULE_0__baMenu__["a"]; });
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_1__baThemePreloader__ = __webpack_require__(431);
/* harmony namespace reexport (by used) */ __webpack_require__.d(__webpack_exports__, "c", function() { return __WEBPACK_IMPORTED_MODULE_1__baThemePreloader__["a"]; });
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_2__baThemeSpinner__ = __webpack_require__(432);
/* harmony namespace reexport (by used) */ __webpack_require__.d(__webpack_exports__, "a", function() { return __WEBPACK_IMPORTED_MODULE_2__baThemeSpinner__["a"]; });



//# sourceMappingURL=index.js.map

/***/ }),

/***/ 814:
/***/ (function(module, exports, __webpack_require__) {

module.exports = __webpack_require__(364);


/***/ }),

/***/ 86:
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_0__angular_core__ = __webpack_require__(2);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_1_rxjs_Observable__ = __webpack_require__(0);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_1_rxjs_Observable___default = __webpack_require__.n(__WEBPACK_IMPORTED_MODULE_1_rxjs_Observable__);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_2__app_httpClient__ = __webpack_require__(131);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_3_ng2_toastr_ng2_toastr__ = __webpack_require__(63);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_3_ng2_toastr_ng2_toastr___default = __webpack_require__.n(__WEBPACK_IMPORTED_MODULE_3_ng2_toastr_ng2_toastr__);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_4_rxjs_Rx__ = __webpack_require__(386);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_4_rxjs_Rx___default = __webpack_require__.n(__WEBPACK_IMPORTED_MODULE_4_rxjs_Rx__);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_5__angular_router__ = __webpack_require__(20);
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "a", function() { return ApplicationAdminServices; });
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
var __metadata = (this && this.__metadata) || function (k, v) {
    if (typeof Reflect === "object" && typeof Reflect.metadata === "function") return Reflect.metadata(k, v);
};






var ApplicationAdminServices = (function () {
    function ApplicationAdminServices(httpClient, router, toastr) {
        this.router = router;
        this.toastr = toastr;
        this.loginWithfacebookUrl = 'users/loginwithfacebook';
        /**
         * Newly written APIs
         * @type {string}
         */
        this.retry = 2;
        this.loginUrl = '/login';
        this.logoutUrl = '/logout';
        this.addVendorUrl = '/addVendor';
        this.addTermsUrl = '/addTermsConditions';
        this.editTermsUrl = '/editTermsConditions';
        this.addVendorItemsUrl = '/addVendorItems';
        this.addPurchaseOrderUrl = '/addPurchaseOrder';
        this.editPurchaseOrderUrl = '/editPurchaseOrder';
        this.sendPurchaseOrderBackendUrl = '/sendPurchaseOrderBackend';
        this.addItemUrl = '/addItem';
        this.addExpenseDetailsUrl = '/addExpenseDetails';
        this.editExpenseDetailsUrl = '/editExpenseDetails';
        this.editVendorUrl = '/editVendor';
        this.copyPurchaseOrderUrl = '/copyPurchaseOrder';
        this.editItemUrl = '/editItem';
        this.deleteVendorUrl = '/deleteVendor';
        this.deletePaymentUrl = '/deletePaymentDetail';
        this.getPurchaseByItemUrl = '/viewPurchaseDetailsByItemId';
        this.deleteTermsAndTagDetailsUrl = '/deleteTermsConditions';
        this.deleteItemUrl = '/deleteItem';
        this.deleteItemLocationUrl = '/deleteItemLocation';
        this.deleteTemplateUrl = '/deleteTemplate';
        this.deleteUnitUrl = '/deleteUnit';
        this.addPaymentUrl = '/addPaymentDetails';
        this.addItemQuantityUrl = '/addItemQuantity';
        this.addItemQuantityUsedUrl = '/addUsedItemQuantity';
        this.editPaymentUrl = '/editPaymentDetails';
        this.deleteVendorItemUrl = '/deleteVendorItem';
        this.deleteItemQuantityUrl = '/deleteItemQuantity';
        this.deleteItemUsedUrl = '/deleteItemUsed';
        this.getPurchaseOrderByItemUrl = '/getPurchaseOrdersByItemById';
        this.getVendorsByItemUrl = '/getVendorsByItemId';
        this.deletePurchaseOrderUrl = '/deletePurchaseOrder';
        this.deleteTagsUrl = '/deleteVendorTags';
        this.deleteExpenseDetailsUrl = '/deleteExpenses';
        this.deleteUserUrl = '/deleteUser';
        this.addTagUrl = '/addVendorTags';
        this.editTagUrl = '/editTags';
        this.getUnitsUrl = '/getUnits';
        this.getUserDetailUrl = '/getUserDetail';
        this.getTagByIdUrl = '/getTagById';
        this.viewVendorbyIdUrl = '/getVendorbyId';
        this.viewPurchasebyIdUrl = '/viewPurchaseOrderById';
        this.viewPurchaseDatebyIdUrl = '/viewPurchaseOrderDateById';
        this.monthlyReportUrl = '/viewMonthlyRecurringReport';
        this.viewTermByTagIdUrl = '/viewTermsDataByTagId';
        this.sendPurchaseOrderUrl = '/sendPurchaseOrderToVendor';
        this.downloadPurchaseOrderUrl = '/downloadPurchaseOrder';
        this.viewItembyIdUrl = '/getItembyId';
        this.getVendorTagsByIdUrl = '/viewVendorTags';
        this.getPOByVendorIdUrl = '/viewAllPurchaseOrdersByVendor';
        this.getRecPOByVendorUrl = '/viewRecurringPurchaseOrdersByVendorId';
        this.buyItmesUrl = '/buyItemsFromVendor';
        this.getVendorItemsByIdUrl = '/getVendorItems';
        this.getUserByIdUrl = '/getUserById';
        this.getItemTagsByIdUrl = '/viewItemTags';
        this.getAllTagsUrl = '/viewAllTags';
        this.getTagsForVendorItemsUrl = '/viewTagsForVendorItems';
        this.getTagsUrl = '/viewTags';
        this.getItemLocationByIdUrl = '/getItemLocationById';
        this.getTemplateByIdUrl = '/viewTemplateById';
        this.getCompanyUnitByIdUrl = '/viewCompanyUnitById';
        this.getTermsForDraftedPOUrl = '/getTermsForDraftedPO';
        this.getCompanyUnitByPurchaseIdUrl = '/viewCompanyUnitByPurchaseId';
        this.addItemLocationUrl = '/addItemLocation';
        this.addTemplateDataUrl = '/addTemplate';
        this.addCompanyUnitUrl = '/addCompanyUnit';
        this.editCompanyUnitUrl = '/editCompanyUnit';
        this.editTemplateDataUrl = '/editTemplate';
        this.editItemLocationUrl = '/editItemLocation';
        this.getAllLocationsUrl = '/viewAllItemLocations';
        this.getExpensesByIdUrl = '/viewExpensesById';
        this.getAllTemplatesUrl = '/viewAllTemplates';
        this.getAllCompanyUnitsUrl = '/viewAllCompanyUnits';
        this.getTemsUrl = '/viewTermsConditionsById';
        this.getTermsDataUrl = '/viewTermsAndTagDetails';
        this.changePasswordUrl = '/changePassword';
        this.addNewUserUrl = '/addUser';
        this.editNewUserUrl = '/editUser';
        /**
         * Old APIs
         * @type {string}
         */
        this.signUpUrl = 'users/signup';
        this.editUserProfileUrl = 'users/edit';
        this.createInvestorProfileUrl = 'investors/createInvestor';
        this.generateCodeUrl = 'users/generateCode';
        this.forgotPasswordUrl = 'users/forgotPassword';
        this.setPasswordUrl = 'users/setPassword';
        this.getAllUsersUrl = 'users/fetchUsers';
        this.getAllInvestorsUrl = 'investors/fetchInvestors';
        this.getUserProfileUrl = 'users/profile';
        this.viewVendorNamesUrl = '/viewVendorNames';
        this.viewVendorNamesForItemUrl = '/viewVendorNamesByItemId';
        this.getItemNamesUrl = '/viewItemNamesByVendor';
        this.getPaymentFrequencyUrl = '/viewPaymentFrequency';
        this.getVendorWithNoDraftedPoUrl = '/viewVendorsWithNoDraftedPo';
        this.getAdminsUrl = '/getAdmins';
        this.emailVerificationUrl = 'users/emailVerification';
        this.updateActiveStatusUrl = 'users/toActiveInActiveUser';
        this.getUsersExportDataUrl = 'users/exportUsers';
        this.getInvestorsExportDataUrl = 'investors/exportInvestors';
        this.createOfferingUrl = 'deals/addDeal';
        this.editOfferingUrl = 'deals/edit';
        this.getAllOfferingsUrl = 'deals/fetchDeals';
        this.getSpecificOfferingUrl = 'deals/deal/';
        this.httpClient = httpClient;
    }
    // Login With Facebook
    ApplicationAdminServices.prototype.loginWithFacebook = function (data) {
        return this.httpClient.post(this.loginWithfacebookUrl, data)
            .map(this.extractResponse)
            .retry(this.retry)
            .catch(this.handleError.bind(this));
    };
    // New APIs -
    /**
     * To get call user login
     * @param data
     * @returns {Observable<any>}
     */
    ApplicationAdminServices.prototype.userLogin = function (data) {
        return this.httpClient.post(this.loginUrl, data)
            .map(this.extractResponse)
            .retry(this.retry)
            .catch(this.handleError.bind(this));
    };
    ApplicationAdminServices.prototype.getUnits = function () {
        return this.httpClient.get(this.getUnitsUrl)
            .map(this.extractResponse)
            .retry(this.retry)
            .catch(this.handleError.bind(this));
    };
    ApplicationAdminServices.prototype.getUserDetail = function () {
        return this.httpClient.get(this.getUserDetailUrl)
            .map(this.extractResponse)
            .retry(this.retry)
            .catch(this.handleError.bind(this));
    };
    /**
     * To post call for user logout
     * @param data
     * @returns {Observable<any>}
     */
    ApplicationAdminServices.prototype.userLogout = function (data) {
        return this.httpClient.post(this.logoutUrl, data)
            .map(this.extractResponse)
            .retry(this.retry)
            .catch(this.handleError);
    };
    /**
     * To get call for view Vendor details by Id.
     * @param data
     * @returns {Observable<any>}
     */
    ApplicationAdminServices.prototype.viewVendorbyId = function (data) {
        return this.httpClient.post(this.viewVendorbyIdUrl, data)
            .map(this.extractResponse)
            .retry(this.retry)
            .catch(this.handleError.bind(this));
    };
    ApplicationAdminServices.prototype.viewPurchasebyId = function (data) {
        return this.httpClient.post(this.viewPurchasebyIdUrl, data)
            .map(this.extractResponse)
            .retry(this.retry)
            .catch(this.handleError.bind(this));
    };
    ApplicationAdminServices.prototype.getMonthlyReports = function (data) {
        return this.httpClient.post(this.monthlyReportUrl, data)
            .map(this.extractResponse)
            .retry(this.retry)
            .catch(this.handleError.bind(this));
    };
    ApplicationAdminServices.prototype.viewPurchaseDate = function (data) {
        return this.httpClient.post(this.viewPurchaseDatebyIdUrl, data)
            .map(this.extractResponse)
            .retry(this.retry)
            .catch(this.handleError.bind(this));
    };
    ApplicationAdminServices.prototype.viewTermsDataByTagId = function (data) {
        return this.httpClient.post(this.viewTermByTagIdUrl, data)
            .map(this.extractResponse)
            .retry(this.retry)
            .catch(this.handleError.bind(this));
    };
    ApplicationAdminServices.prototype.sendPurchaseOrderToVendor = function (data) {
        return this.httpClient.post(this.sendPurchaseOrderUrl, data)
            .map(this.extractResponse)
            .retry(this.retry)
            .catch(this.handleError.bind(this));
    };
    ApplicationAdminServices.prototype.downloadPurchaseOrder = function (data) {
        return this.httpClient.post(this.downloadPurchaseOrderUrl, data)
            .map(this.extractResponse)
            .retry(this.retry)
            .catch(this.handleError.bind(this));
    };
    /**
     * To get call for view Vendor details by Id.
     * @param data
     * @returns {Observable<any>}
     */
    ApplicationAdminServices.prototype.viewItembyId = function (data) {
        return this.httpClient.post(this.viewItembyIdUrl, data)
            .map(this.extractResponse)
            .retry(this.retry)
            .catch(this.handleError.bind(this));
    };
    ApplicationAdminServices.prototype.getCandidateTagById = function (data) {
        return this.httpClient.post(this.getVendorTagsByIdUrl, data)
            .map(this.extractResponse)
            .retry(this.retry)
            .catch(this.handleError.bind(this));
    };
    ApplicationAdminServices.prototype.viewAllPurchaseOrdersByVendorId = function (data) {
        return this.httpClient.post(this.getPOByVendorIdUrl, data)
            .map(this.extractResponse)
            .retry(this.retry)
            .catch(this.handleError.bind(this));
    };
    ApplicationAdminServices.prototype.viewRecurringPOByVendor = function (data) {
        return this.httpClient.post(this.getRecPOByVendorUrl, data)
            .map(this.extractResponse)
            .retry(this.retry)
            .catch(this.handleError.bind(this));
    };
    ApplicationAdminServices.prototype.buyItems = function (data) {
        return this.httpClient.post(this.buyItmesUrl, data)
            .map(this.extractResponse)
            .retry(this.retry)
            .catch(this.handleError.bind(this));
    };
    ApplicationAdminServices.prototype.getVendorItemsById = function (data) {
        return this.httpClient.post(this.getVendorItemsByIdUrl, data)
            .map(this.extractResponse)
            .retry(this.retry)
            .catch(this.handleError.bind(this));
    };
    ApplicationAdminServices.prototype.getUserById = function (data) {
        return this.httpClient.post(this.getUserByIdUrl, data)
            .map(this.extractResponse)
            .retry(this.retry)
            .catch(this.handleError.bind(this));
    };
    /**
     * To get call for get Item Tags details by Id.
     * @param data
     * @returns {Observable<any>}
     */
    ApplicationAdminServices.prototype.getItemTagById = function (data) {
        return this.httpClient.post(this.getItemTagsByIdUrl, data)
            .map(this.extractResponse)
            .retry(this.retry)
            .catch(this.handleError.bind(this));
    };
    /**
     * To post call for edit Vendor details by Id.
     * @param data
     * @returns {Observable<any>}
     */
    ApplicationAdminServices.prototype.editVendorById = function (data) {
        return this.httpClient.post(this.editVendorUrl, data)
            .map(this.extractResponse)
            .retry(this.retry)
            .catch(this.handleError.bind(this));
    };
    ApplicationAdminServices.prototype.copyPurchaseOrder = function (data) {
        return this.httpClient.post(this.copyPurchaseOrderUrl, data)
            .map(this.extractResponse)
            .retry(this.retry)
            .catch(this.handleError.bind(this));
    };
    /**
     * To post call for edit Vendor details by Id.
     * @param data
     * @returns {Observable<any>}
     */
    ApplicationAdminServices.prototype.editItemById = function (data) {
        return this.httpClient.post(this.editItemUrl, data)
            .map(this.extractResponse)
            .retry(this.retry)
            .catch(this.handleError.bind(this));
    };
    /**
     * To post call for add new Vendor details.
     * @param data
     * @returns {Observable<any>}
     */
    ApplicationAdminServices.prototype.addNewVendor = function (data) {
        return this.httpClient.post(this.addVendorUrl, data)
            .map(this.extractResponse)
            .retry(this.retry)
            .catch(this.handleError.bind(this));
    };
    ApplicationAdminServices.prototype.addTermsCondition = function (data) {
        return this.httpClient.post(this.addTermsUrl, data)
            .map(this.extractResponse)
            .retry(this.retry)
            .catch(this.handleError.bind(this));
    };
    ApplicationAdminServices.prototype.editTermsCondition = function (data) {
        return this.httpClient.post(this.editTermsUrl, data)
            .map(this.extractResponse)
            .retry(this.retry)
            .catch(this.handleError.bind(this));
    };
    ApplicationAdminServices.prototype.addNewVendorItems = function (data) {
        return this.httpClient.post(this.addVendorItemsUrl, data)
            .map(this.extractResponse)
            .retry(this.retry)
            .catch(this.handleError.bind(this));
    };
    ApplicationAdminServices.prototype.addPurchaseOrder = function (data) {
        return this.httpClient.post(this.addPurchaseOrderUrl, data)
            .map(this.extractResponse)
            .retry(this.retry)
            .catch(this.handleError.bind(this));
    };
    ApplicationAdminServices.prototype.editPurchaseOrder = function (data) {
        return this.httpClient.post(this.editPurchaseOrderUrl, data)
            .map(this.extractResponse)
            .retry(this.retry)
            .catch(this.handleError.bind(this));
    };
    ApplicationAdminServices.prototype.sendPurchaseOrderBackend = function (data) {
        return this.httpClient.post(this.sendPurchaseOrderBackendUrl, data)
            .map(this.extractResponse)
            .retry(this.retry)
            .catch(this.handleError.bind(this));
    };
    /**
     * To post call for add new Item details.
     * @param data
     * @returns {Observable<any>}
     */
    ApplicationAdminServices.prototype.addNewItem = function (data) {
        return this.httpClient.post(this.addItemUrl, data)
            .map(this.extractResponse)
            .retry(this.retry)
            .catch(this.handleError.bind(this));
    };
    ApplicationAdminServices.prototype.onAddExpenseDetails = function (data) {
        return this.httpClient.post(this.addExpenseDetailsUrl, data)
            .map(this.extractResponse)
            .retry(this.retry)
            .catch(this.handleError.bind(this));
    };
    ApplicationAdminServices.prototype.onEditExpenseDetails = function (data) {
        return this.httpClient.post(this.editExpenseDetailsUrl, data)
            .map(this.extractResponse)
            .retry(this.retry)
            .catch(this.handleError.bind(this));
    };
    /**
     * To post call for delete Vendor details by Id.
     * @param data
     * @returns {Observable<any>}
     */
    ApplicationAdminServices.prototype.deleteVendor = function (data) {
        return this.httpClient.post(this.deleteVendorUrl, data)
            .map(this.extractResponse)
            .retry(this.retry)
            .catch(this.handleError.bind(this));
    };
    ApplicationAdminServices.prototype.showPurchaseDetailByItemId = function (data) {
        return this.httpClient.post(this.getPurchaseByItemUrl, data)
            .map(this.extractResponse)
            .retry(this.retry)
            .catch(this.handleError.bind(this));
    };
    ApplicationAdminServices.prototype.deletePaymentDetail = function (data) {
        return this.httpClient.post(this.deletePaymentUrl, data)
            .map(this.extractResponse)
            .retry(this.retry)
            .catch(this.handleError.bind(this));
    };
    ApplicationAdminServices.prototype.deleteTerms = function (data) {
        return this.httpClient.post(this.deleteTermsAndTagDetailsUrl, data)
            .map(this.extractResponse)
            .retry(this.retry)
            .catch(this.handleError.bind(this));
    };
    /**
     * To post call for delete Vendor details by Id.
     * @param data
     * @returns {Observable<any>}
     */
    ApplicationAdminServices.prototype.deleteItem = function (data) {
        return this.httpClient.post(this.deleteItemUrl, data)
            .map(this.extractResponse)
            .retry(this.retry)
            .catch(this.handleError.bind(this));
    };
    ApplicationAdminServices.prototype.deleteItemLocation = function (data) {
        return this.httpClient.post(this.deleteItemLocationUrl, data)
            .map(this.extractResponse)
            .retry(this.retry)
            .catch(this.handleError.bind(this));
    };
    ApplicationAdminServices.prototype.deleteTemplate = function (data) {
        return this.httpClient.post(this.deleteTemplateUrl, data)
            .map(this.extractResponse)
            .retry(this.retry)
            .catch(this.handleError.bind(this));
    };
    ApplicationAdminServices.prototype.deleteUnit = function (data) {
        return this.httpClient.post(this.deleteUnitUrl, data)
            .map(this.extractResponse)
            .retry(this.retry)
            .catch(this.handleError.bind(this));
    };
    ApplicationAdminServices.prototype.onAddPaymentDetails = function (data) {
        return this.httpClient.post(this.addPaymentUrl, data)
            .map(this.extractResponse)
            .retry(this.retry)
            .catch(this.handleError.bind(this));
    };
    ApplicationAdminServices.prototype.onAddItemQuantityDetails = function (data) {
        return this.httpClient.post(this.addItemQuantityUrl, data)
            .map(this.extractResponse)
            .retry(this.retry)
            .catch(this.handleError.bind(this));
    };
    ApplicationAdminServices.prototype.onAddItemQuantityUsedDetails = function (data) {
        return this.httpClient.post(this.addItemQuantityUsedUrl, data)
            .map(this.extractResponse)
            .retry(this.retry)
            .catch(this.handleError.bind(this));
    };
    ApplicationAdminServices.prototype.onEditPaymentDetails = function (data) {
        return this.httpClient.post(this.editPaymentUrl, data)
            .map(this.extractResponse)
            .retry(this.retry)
            .catch(this.handleError.bind(this));
    };
    ApplicationAdminServices.prototype.deleteVendorItem = function (data) {
        return this.httpClient.post(this.deleteVendorItemUrl, data)
            .map(this.extractResponse)
            .retry(this.retry)
            .catch(this.handleError.bind(this));
    };
    ApplicationAdminServices.prototype.deleteItemQuantity = function (data) {
        return this.httpClient.post(this.deleteItemQuantityUrl, data)
            .map(this.extractResponse)
            .retry(this.retry)
            .catch(this.handleError.bind(this));
    };
    ApplicationAdminServices.prototype.deleteItemUsed = function (data) {
        return this.httpClient.post(this.deleteItemUsedUrl, data)
            .map(this.extractResponse)
            .retry(this.retry)
            .catch(this.handleError.bind(this));
    };
    ApplicationAdminServices.prototype.getPurchaseOrdersByItem = function (data) {
        return this.httpClient.post(this.getPurchaseOrderByItemUrl, data)
            .map(this.extractResponse)
            .retry(this.retry)
            .catch(this.handleError.bind(this));
    };
    ApplicationAdminServices.prototype.getVendorsByItem = function (data) {
        return this.httpClient.post(this.getVendorsByItemUrl, data)
            .map(this.extractResponse)
            .retry(this.retry)
            .catch(this.handleError.bind(this));
    };
    ApplicationAdminServices.prototype.deletePurchaseOrder = function (data) {
        return this.httpClient.post(this.deletePurchaseOrderUrl, data)
            .map(this.extractResponse)
            .retry(this.retry)
            .catch(this.handleError.bind(this));
    };
    /**
     * To post call for delete Tags by Id.
     * @param data
     * @returns {Observable<any>}
     */
    ApplicationAdminServices.prototype.deleteTags = function (data) {
        return this.httpClient.post(this.deleteTagsUrl, data)
            .map(this.extractResponse)
            .retry(this.retry)
            .catch(this.handleError.bind(this));
    };
    ApplicationAdminServices.prototype.deleteExpenseDetails = function (data) {
        return this.httpClient.post(this.deleteExpenseDetailsUrl, data)
            .map(this.extractResponse)
            .retry(this.retry)
            .catch(this.handleError.bind(this));
    };
    ApplicationAdminServices.prototype.deleteUserDetails = function (data) {
        return this.httpClient.post(this.deleteUserUrl, data)
            .map(this.extractResponse)
            .retry(this.retry)
            .catch(this.handleError.bind(this));
    };
    /**
     *
     * @param data
     * @returns {Observable<any>}
     */
    ApplicationAdminServices.prototype.addTag = function (data) {
        return this.httpClient.post(this.addTagUrl, data)
            .map(this.extractResponse)
            .retry(this.retry)
            .catch(this.handleError.bind(this));
    };
    ApplicationAdminServices.prototype.editTag = function (data) {
        return this.httpClient.post(this.editTagUrl, data)
            .map(this.extractResponse)
            .retry(this.retry)
            .catch(this.handleError.bind(this));
    };
    ApplicationAdminServices.prototype.getTagById = function (data) {
        return this.httpClient.post(this.getTagByIdUrl, data)
            .map(this.extractResponse)
            .retry(this.retry)
            .catch(this.handleError.bind(this));
    };
    /** To post call for show Tags by Id.
     * show all predefined tags
     * @returns {Observable<any>}
     */
    ApplicationAdminServices.prototype.getAllTags = function () {
        return this.httpClient.get(this.getAllTagsUrl)
            .map(this.extractResponse)
            .retry(this.retry)
            .catch(this.handleError.bind(this));
    };
    ApplicationAdminServices.prototype.getTagsForVendorItems = function () {
        return this.httpClient.get(this.getTagsForVendorItemsUrl)
            .map(this.extractResponse)
            .retry(this.retry)
            .catch(this.handleError.bind(this));
    };
    ApplicationAdminServices.prototype.getItemLocationById = function (data) {
        return this.httpClient.post(this.getItemLocationByIdUrl, data)
            .map(this.extractResponse)
            .retry(this.retry)
            .catch(this.handleError.bind(this));
    };
    ApplicationAdminServices.prototype.addItemLocation = function (data) {
        return this.httpClient.post(this.addItemLocationUrl, data)
            .map(this.extractResponse)
            .retry(this.retry)
            .catch(this.handleError.bind(this));
    };
    ApplicationAdminServices.prototype.editItemLocation = function (data) {
        return this.httpClient.post(this.editItemLocationUrl, data)
            .map(this.extractResponse)
            .retry(this.retry)
            .catch(this.handleError.bind(this));
    };
    ApplicationAdminServices.prototype.getAllLocations = function () {
        return this.httpClient.get(this.getAllLocationsUrl)
            .map(this.extractResponse)
            .retry(this.retry)
            .catch(this.handleError.bind(this));
    };
    ApplicationAdminServices.prototype.getExpensesById = function (data) {
        return this.httpClient.post(this.getExpensesByIdUrl, data)
            .map(this.extractResponse)
            .retry(this.retry)
            .catch(this.handleError.bind(this));
    };
    ApplicationAdminServices.prototype.getAllTemplates = function () {
        return this.httpClient.get(this.getAllTemplatesUrl)
            .map(this.extractResponse)
            .retry(this.retry)
            .catch(this.handleError.bind(this));
    };
    ApplicationAdminServices.prototype.getAllCompanyUnits = function () {
        return this.httpClient.get(this.getAllCompanyUnitsUrl)
            .map(this.extractResponse)
            .retry(this.retry)
            .catch(this.handleError.bind(this));
    };
    ApplicationAdminServices.prototype.getTermsById = function (data) {
        return this.httpClient.post(this.getTemsUrl, data)
            .map(this.extractResponse)
            .retry(this.retry)
            .catch(this.handleError.bind(this));
    };
    /**
     * To get call for show Vendors by Id.
     * @returns {Observable<any>}
     */
    ApplicationAdminServices.prototype.getTermsData = function (data) {
        return this.httpClient.post(this.getTermsDataUrl, data)
            .map(this.extractResponse)
            .retry(this.retry)
            .catch(this.handleError.bind(this));
    };
    ApplicationAdminServices.prototype.addTemplateData = function (data) {
        return this.httpClient.post(this.addTemplateDataUrl, data)
            .map(this.extractResponse)
            .retry(this.retry)
            .catch(this.handleError.bind(this));
    };
    ApplicationAdminServices.prototype.addCompanyUnit = function (data) {
        return this.httpClient.post(this.addCompanyUnitUrl, data)
            .map(this.extractResponse)
            .retry(this.retry)
            .catch(this.handleError.bind(this));
    };
    ApplicationAdminServices.prototype.editCompanyUnit = function (data) {
        return this.httpClient.post(this.editCompanyUnitUrl, data)
            .map(this.extractResponse)
            .retry(this.retry)
            .catch(this.handleError.bind(this));
    };
    ApplicationAdminServices.prototype.editTemplateData = function (data) {
        return this.httpClient.post(this.editTemplateDataUrl, data)
            .map(this.extractResponse)
            .retry(this.retry)
            .catch(this.handleError.bind(this));
    };
    ApplicationAdminServices.prototype.getTemplateById = function (data) {
        return this.httpClient.post(this.getTemplateByIdUrl, data)
            .map(this.extractResponse)
            .retry(this.retry)
            .catch(this.handleError.bind(this));
    };
    ApplicationAdminServices.prototype.getCompanyUnitById = function (data) {
        return this.httpClient.post(this.getCompanyUnitByIdUrl, data)
            .map(this.extractResponse)
            .retry(this.retry)
            .catch(this.handleError.bind(this));
    };
    ApplicationAdminServices.prototype.getTermsForDraftedPO = function (data) {
        return this.httpClient.post(this.getTermsForDraftedPOUrl, data)
            .map(this.extractResponse)
            .retry(this.retry)
            .catch(this.handleError.bind(this));
    };
    ApplicationAdminServices.prototype.getVendorNames = function () {
        return this.httpClient.get(this.viewVendorNamesUrl)
            .map(this.extractResponse)
            .retry(this.retry)
            .catch(this.handleError.bind(this));
    };
    ApplicationAdminServices.prototype.getVendorsForItem = function (data) {
        return this.httpClient.post(this.viewVendorNamesForItemUrl, data)
            .map(this.extractResponse)
            .retry(this.retry)
            .catch(this.handleError.bind(this));
    };
    /**
     * To get call for show all items.
     * @returns {Observable<any>}
     * */
    ApplicationAdminServices.prototype.getItemNames = function (data) {
        return this.httpClient.post(this.getItemNamesUrl, data)
            .map(this.extractResponse)
            .retry(this.retry)
            .catch(this.handleError.bind(this));
    };
    ApplicationAdminServices.prototype.getPaymentFrequency = function () {
        return this.httpClient.get(this.getPaymentFrequencyUrl)
            .map(this.extractResponse)
            .retry(this.retry)
            .catch(this.handleError.bind(this));
    };
    ApplicationAdminServices.prototype.getVendorWithNoDraftedPo = function () {
        return this.httpClient.get(this.getVendorWithNoDraftedPoUrl)
            .map(this.extractResponse)
            .retry(this.retry)
            .catch(this.handleError.bind(this));
    };
    ApplicationAdminServices.prototype.onViewAdmins = function () {
        return this.httpClient.get(this.getAdminsUrl)
            .map(this.extractResponse)
            .retry(this.retry)
            .catch(this.handleError.bind(this));
    };
    //To get call user signUp
    ApplicationAdminServices.prototype.addNewUser = function (data) {
        return this.httpClient.post(this.addNewUserUrl, data)
            .map(this.extractResponse)
            .retry(this.retry)
            .catch(this.handleError.bind(this));
    };
    ApplicationAdminServices.prototype.editNewUser = function (data) {
        return this.httpClient.post(this.editNewUserUrl, data)
            .map(this.extractResponse)
            .retry(this.retry)
            .catch(this.handleError.bind(this));
    };
    // Old APIs -
    //To get call user signUp
    ApplicationAdminServices.prototype.userSignUp = function (data) {
        return this.httpClient.post(this.signUpUrl, data)
            .map(this.extractResponse)
            .retry(this.retry)
            .catch(this.handleError.bind(this));
    };
    //To get call edit user profile
    ApplicationAdminServices.prototype.editUserProfile = function (data) {
        return this.httpClient.put(this.editUserProfileUrl, data)
            .map(this.extractResponse)
            .retry(this.retry)
            .catch(this.handleError.bind(this));
    };
    //To post call create investor profile
    ApplicationAdminServices.prototype.createInvestorProfile = function (data) {
        return this.httpClient.post(this.createInvestorProfileUrl, data)
            .map(this.extractResponse)
            .retry(this.retry)
            .catch(this.handleError.bind(this));
    };
    //To get call user generateCode
    ApplicationAdminServices.prototype.generateCode = function (data) {
        return this.httpClient.post(this.generateCodeUrl, data)
            .map(this.extractResponse)
            .retry(this.retry)
            .catch(this.handleError.bind(this));
    };
    // To get Users Export Data
    ApplicationAdminServices.prototype.getUsersExportData = function (searchValue) {
        return this.httpClient.get(this.getUsersExportDataUrl + searchValue)
            .map(this.extractResponse)
            .retry(this.retry)
            .catch(this.handleError.bind(this));
    };
    // To get Investors Export Data
    ApplicationAdminServices.prototype.getInvestorsExportData = function (searchValue) {
        return this.httpClient.get(this.getInvestorsExportDataUrl + searchValue)
            .map(this.extractResponse)
            .retry(this.retry)
            .catch(this.handleError.bind(this));
    };
    //To get call user forgotPassword
    ApplicationAdminServices.prototype.forgotPassword = function (data) {
        return this.httpClient.post(this.forgotPasswordUrl, data)
            .map(this.extractResponse)
            .retry(this.retry)
            .catch(this.handleError.bind(this));
    };
    //To get call user setPassword
    ApplicationAdminServices.prototype.setPassword = function (data) {
        return this.httpClient.post(this.setPasswordUrl, data)
            .map(this.extractResponse)
            .retry(this.retry)
            .catch(this.handleError.bind(this));
    };
    //To call get all user
    ApplicationAdminServices.prototype.getUsers = function (searchValue) {
        return this.httpClient.get(this.getAllUsersUrl + searchValue)
            .map(this.extractResponse)
            .retry(this.retry)
            .catch(this.handleError.bind(this));
    };
    //To call get all investors
    ApplicationAdminServices.prototype.getInvestors = function (searchValue) {
        return this.httpClient.get(this.getAllInvestorsUrl + searchValue)
            .map(this.extractResponse)
            .retry(this.retry)
            .catch(this.handleError.bind(this));
    };
    //To call get user profile details
    ApplicationAdminServices.prototype.getUserProfile = function () {
        return this.httpClient.get(this.getUserProfileUrl)
            .map(this.extractResponse)
            .retry(this.retry)
            .catch(this.handleError.bind(this));
    };
    // To call get vendors details
    //To get call user forgotPassword
    ApplicationAdminServices.prototype.emailVerification = function (data) {
        return this.httpClient.put(this.emailVerificationUrl, data)
            .map(this.extractResponse)
            .retry(this.retry)
            .catch(this.handleError.bind(this));
    };
    //To get call
    ApplicationAdminServices.prototype.editUserActiveStatus = function (data) {
        return this.httpClient.put(this.updateActiveStatusUrl, data)
            .map(this.extractResponse)
            .retry(this.retry)
            .catch(this.handleError.bind(this));
    };
    //To call change password
    ApplicationAdminServices.prototype.changePassword = function (data) {
        return this.httpClient.post(this.changePasswordUrl, data)
            .map(this.extractResponse)
            .retry(this.retry)
            .catch(this.handleError.bind(this));
    };
    // To call create offerings API.
    ApplicationAdminServices.prototype.createOffering = function (data) {
        return this.httpClient.post(this.createOfferingUrl, data)
            .map(this.extractResponse)
            .retry(this.retry)
            .catch(this.handleError.bind(this));
    };
    // To call edit offerings API.
    ApplicationAdminServices.prototype.editOffering = function (data) {
        return this.httpClient.put(this.editOfferingUrl, data)
            .map(this.extractResponse)
            .retry(this.retry)
            .catch(this.handleError.bind(this));
    };
    // To call get all offerings
    ApplicationAdminServices.prototype.getOfferings = function (searchValue) {
        return this.httpClient.get(this.getAllOfferingsUrl + searchValue)
            .map(this.extractResponse)
            .retry(this.retry)
            .catch(this.handleError.bind(this));
    };
    // To call get specific offering details
    ApplicationAdminServices.prototype.getSpecificOffering = function (offeringId) {
        return this.httpClient.get(this.getSpecificOfferingUrl + offeringId)
            .map(this.extractResponse)
            .retry(this.retry)
            .catch(this.handleError.bind(this));
    };
    ApplicationAdminServices.prototype.extractResponse = function (res) {
        return res;
    };
    ApplicationAdminServices.prototype.handleError = function (error) {
        var _this = this;
        var errorCode = error.error.code;
        // if invalid token or token expired
        if (errorCode == '-114' || errorCode == -114 || errorCode == '-102' || errorCode == -102 || errorCode == '-132'
            || errorCode == -132) {
            // if the user is inactivated by the admin
            if (errorCode == '-132' || errorCode == -132) {
                localStorage.clear();
                this.toastr.error(error.error.message);
                setTimeout(function () {
                    _this.router.navigate(['login']);
                }, 3000);
            }
            else {
                localStorage.clear();
                this.router.navigate(['login']);
            }
        }
        else {
            return __WEBPACK_IMPORTED_MODULE_1_rxjs_Observable__["Observable"].throw(error);
        }
    };
    return ApplicationAdminServices;
}());
ApplicationAdminServices = __decorate([
    __webpack_require__.i(__WEBPACK_IMPORTED_MODULE_0__angular_core__["Injectable"])(),
    __metadata("design:paramtypes", [typeof (_a = typeof __WEBPACK_IMPORTED_MODULE_2__app_httpClient__["a" /* HttpClientHelper */] !== "undefined" && __WEBPACK_IMPORTED_MODULE_2__app_httpClient__["a" /* HttpClientHelper */]) === "function" && _a || Object, typeof (_b = typeof __WEBPACK_IMPORTED_MODULE_5__angular_router__["Router"] !== "undefined" && __WEBPACK_IMPORTED_MODULE_5__angular_router__["Router"]) === "function" && _b || Object, typeof (_c = typeof __WEBPACK_IMPORTED_MODULE_3_ng2_toastr_ng2_toastr__["ToastsManager"] !== "undefined" && __WEBPACK_IMPORTED_MODULE_3_ng2_toastr_ng2_toastr__["ToastsManager"]) === "function" && _c || Object])
], ApplicationAdminServices);

var _a, _b, _c;
//# sourceMappingURL=application.js.map

/***/ })

},[814]);
//# sourceMappingURL=main.bundle.js.map