webpackJsonp([45,56],{

/***/ 1021:
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_0__angular_core__ = __webpack_require__(2);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_1__angular_forms__ = __webpack_require__(24);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_2__angular_router__ = __webpack_require__(20);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_3_ng2_toastr_ng2_toastr__ = __webpack_require__(63);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_3_ng2_toastr_ng2_toastr___default = __webpack_require__.n(__WEBPACK_IMPORTED_MODULE_3_ng2_toastr_ng2_toastr__);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_4__appServices_application__ = __webpack_require__(86);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_5__theme_validators__ = __webpack_require__(392);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_6__app_authentication__ = __webpack_require__(36);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_7__theme_services__ = __webpack_require__(65);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_8__app_constant__ = __webpack_require__(391);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_9__utilityServices_app_utility__ = __webpack_require__(64);
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "a", function() { return Login; });
var __extends = (this && this.__extends) || (function () {
    var extendStatics = Object.setPrototypeOf ||
        ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
        function (d, b) { for (var p in b) if (b.hasOwnProperty(p)) d[p] = b[p]; };
    return function (d, b) {
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
var __metadata = (this && this.__metadata) || function (k, v) {
    if (typeof Reflect === "object" && typeof Reflect.metadata === "function") return Reflect.metadata(k, v);
};










var Login = (function (_super) {
    __extends(Login, _super);
    function Login(fb, userUtility, router, toastr, appService, _spinner, authentication, vRef) {
        var _this = _super.call(this) || this;
        _this.userUtility = userUtility;
        _this.router = router;
        _this.toastr = toastr;
        _this.appService = appService;
        _this._spinner = _spinner;
        _this.authentication = authentication;
        _this.myStyle = {};
        _this.myParams = {};
        _this.width = 100;
        _this.height = 100;
        _this.submitted = false;
        _this.isLoggedIn = false;
        if (_this.authentication.isLoggedIn()) {
            _this.router.navigate(['createPurchaseOrder']);
        }
        else {
            _this.router.navigate(['login']);
        }
        _this.form = fb.group({
            'email': ['', __WEBPACK_IMPORTED_MODULE_1__angular_forms__["Validators"].compose([__WEBPACK_IMPORTED_MODULE_1__angular_forms__["Validators"].required, __WEBPACK_IMPORTED_MODULE_5__theme_validators__["b" /* EmailValidator */].validate])],
            'password': ['', __WEBPACK_IMPORTED_MODULE_1__angular_forms__["Validators"].compose([__WEBPACK_IMPORTED_MODULE_1__angular_forms__["Validators"].required, __WEBPACK_IMPORTED_MODULE_1__angular_forms__["Validators"].minLength(8)])],
        });
        // if (this.authentication.isLoggedIn()) {
        //     this.router.navigate(['user']);
        // }
        FB.init({
            appId: '206515609891723',
            cookie: true,
            xfbml: true,
            version: 'v2.8',
        });
        return _this;
    }
    Login.prototype.ngAfterViewInit = function () {
        this.emailField.first.nativeElement.focus();
    };
    Login.prototype.ngOnInit = function () {
        this.myStyle = {
            'position': 'fixed',
            'width': '100%',
            'height': '100%',
            'z-index': 0,
            'top': 0,
            'left': 0,
            'right': 0,
            'bottom': 0,
        };
        this.myParams = {
            particles: {
                number: {
                    value: 60,
                },
                color: {
                    value: '#195C94',
                },
                shape: {
                    type: 'polygon',
                },
                size: {
                    value: 8,
                },
                line_linked: {
                    color: '#999',
                },
            },
        };
    };
    /**
     * get userName and password from login page and call service
     * @param loginData
     */
    Login.prototype.onSubmit = function (loginData) {
        var _this = this;
        this.submitted = true;
        this._spinner.show();
        this.submitted = true;
        var data = {
            'email': loginData.email,
            'password': loginData.password,
        };
        this.appService.userLogin(data).subscribe(function (data) { return _this.loginSuccess(data); }, function (error) { return _this.loginFail(error); });
    };
    /**
     * if err
     * @param err
     */
    Login.prototype.loginFail = function (err) {
        if (err.error && err.error.message) {
            this.toastr.error(err.error.message);
        }
        else {
            this.toastr.error('Server error');
        }
        this._spinner.hide();
        this.submitted = false;
    };
    /**
     * if login success
     * @param result
     */
    Login.prototype.loginSuccess = function (res) {
        if (res.status < 0) {
            if (res.data.code == '-318') {
                this.toastr.error(this.userUtility.errorMessages['LOGIN_DEACTIVATED']);
            }
            else {
                this.toastr.error(this.userUtility.errorMessages['EMAIL_PASSWORD_INCORRECT']);
            }
            this.submitted = false;
        }
        else {
            this.authentication.setLoggedIn(res);
            this.router.navigate(['createPurchaseOrder']);
            this.toastr.success(this.userUtility.successMessages['LOGIN_SUCCESSFULL']);
        }
        this._spinner.hide();
    };
    /**
     *  To navigate to sign up page.
     */
    Login.prototype.navigateToSignUp = function () {
        this.router.navigate(['/signup']);
    };
    /**
     *  To navigate to forgot password page.
     */
    Login.prototype.navigateToForwardPassword = function () {
        this.router.navigate(['/forgot-password']);
    };
    Login.prototype.onFacebookLoginClick = function () {
        var _this = this;
        this._spinner.show();
        FB.login(function (response) {
            _this.statusChangeCallback(response);
        }, { scope: 'email', return_scopes: true });
    };
    // Function for send facebook data to server
    Login.prototype.statusChangeCallback = function (resp) {
        if (resp.status === 'connected') {
            var self_1 = this;
            FB.api('/me?fields=id,name,email,first_name,last_name,gender,' +
                'picture.width(150).height(150),age_range,friends', function (result) {
                var signUpData = {
                    'first_name': result.first_name.trim(),
                    'last_name': result.last_name.trim(),
                    'email': result.email,
                    'device_token': '6a0974954e45d826239fc3c150734619745ca33e',
                    'ud_id': '12345678',
                    'device_os': 'ios',
                    'profileImageURL': result.picture.data.url,
                };
                self_1._spinner.hide();
                self_1.appService.loginWithFacebook(signUpData).subscribe(function (next) {
                    self_1.loginSuccess(next);
                    // console.log(next,'dws');
                    // // if (next) {
                    // //     self._spinner.hide();
                    // //     self.toastr.success('SignUp Successful. An email has been' +
                    // //         ' sent to your email id. Please verify before sign in.');
                    // //     self.router.navigate(['/login']);
                    // // }
                }, function (Error) {
                    self_1._spinner.hide();
                    if (Error.error && Error.error.message) {
                        self_1.toastr.error(Error.error.message);
                    }
                    else {
                        self_1.toastr.error('Server error');
                    }
                });
            });
        }
        else if (resp.status === 'not_authorized') {
            FB.resetFB();
            this.toastr.error(this.constants.FBERROR);
        }
        else {
            FB.resetFB();
            this.toastr.error(this.constants.FBALERT);
        }
    };
    return Login;
}(__WEBPACK_IMPORTED_MODULE_8__app_constant__["a" /* AppConstant */]));
__decorate([
    __webpack_require__.i(__WEBPACK_IMPORTED_MODULE_0__angular_core__["Input"])(),
    __metadata("design:type", typeof (_a = typeof __WEBPACK_IMPORTED_MODULE_8__app_constant__["b" /* Constants */] !== "undefined" && __WEBPACK_IMPORTED_MODULE_8__app_constant__["b" /* Constants */]) === "function" && _a || Object)
], Login.prototype, "constants", void 0);
__decorate([
    __webpack_require__.i(__WEBPACK_IMPORTED_MODULE_0__angular_core__["ViewChildren"])('emailField'),
    __metadata("design:type", Object)
], Login.prototype, "emailField", void 0);
Login = __decorate([
    __webpack_require__.i(__WEBPACK_IMPORTED_MODULE_0__angular_core__["Component"])({
        selector: 'login',
        template: __webpack_require__(1179),
        styles: [__webpack_require__(1129)],
    }),
    __metadata("design:paramtypes", [typeof (_b = typeof __WEBPACK_IMPORTED_MODULE_1__angular_forms__["FormBuilder"] !== "undefined" && __WEBPACK_IMPORTED_MODULE_1__angular_forms__["FormBuilder"]) === "function" && _b || Object, typeof (_c = typeof __WEBPACK_IMPORTED_MODULE_9__utilityServices_app_utility__["a" /* Utility */] !== "undefined" && __WEBPACK_IMPORTED_MODULE_9__utilityServices_app_utility__["a" /* Utility */]) === "function" && _c || Object, typeof (_d = typeof __WEBPACK_IMPORTED_MODULE_2__angular_router__["Router"] !== "undefined" && __WEBPACK_IMPORTED_MODULE_2__angular_router__["Router"]) === "function" && _d || Object, typeof (_e = typeof __WEBPACK_IMPORTED_MODULE_3_ng2_toastr_ng2_toastr__["ToastsManager"] !== "undefined" && __WEBPACK_IMPORTED_MODULE_3_ng2_toastr_ng2_toastr__["ToastsManager"]) === "function" && _e || Object, typeof (_f = typeof __WEBPACK_IMPORTED_MODULE_4__appServices_application__["a" /* ApplicationAdminServices */] !== "undefined" && __WEBPACK_IMPORTED_MODULE_4__appServices_application__["a" /* ApplicationAdminServices */]) === "function" && _f || Object, typeof (_g = typeof __WEBPACK_IMPORTED_MODULE_7__theme_services__["a" /* BaThemeSpinner */] !== "undefined" && __WEBPACK_IMPORTED_MODULE_7__theme_services__["a" /* BaThemeSpinner */]) === "function" && _g || Object, typeof (_h = typeof __WEBPACK_IMPORTED_MODULE_6__app_authentication__["a" /* AuthenticationHelper */] !== "undefined" && __WEBPACK_IMPORTED_MODULE_6__app_authentication__["a" /* AuthenticationHelper */]) === "function" && _h || Object, typeof (_j = typeof __WEBPACK_IMPORTED_MODULE_0__angular_core__["ViewContainerRef"] !== "undefined" && __WEBPACK_IMPORTED_MODULE_0__angular_core__["ViewContainerRef"]) === "function" && _j || Object])
], Login);

var _a, _b, _c, _d, _e, _f, _g, _h, _j;
//# sourceMappingURL=login.component.js.map

/***/ }),

/***/ 1078:
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_0__angular_router__ = __webpack_require__(20);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_1__login_component__ = __webpack_require__(1021);
/* unused harmony export routes */
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "a", function() { return routing; });


var routes = [
    {
        path: '',
        component: __WEBPACK_IMPORTED_MODULE_1__login_component__["a" /* Login */]
    }
];
var routing = __WEBPACK_IMPORTED_MODULE_0__angular_router__["RouterModule"].forChild(routes);
//# sourceMappingURL=login.routing.js.map

/***/ }),

/***/ 1099:
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_0__angular_core__ = __webpack_require__(2);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_1__angular_common__ = __webpack_require__(10);
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "a", function() { return ParticlesModule; });
/* unused harmony export ParticlesComponent */
/* unused harmony export ParticlesDirective */



var ParticlesComponent = (function () {
    function ParticlesComponent() {
        this.width = 100;
        this.height = 100;
        this.style = {};
    }
    return ParticlesComponent;
}());
ParticlesComponent.decorators = [
    { type: __WEBPACK_IMPORTED_MODULE_0__angular_core__["Component"], args: [{
                selector: 'particles',
                template: "\n        <div [ngStyle]=\"style\" class=\"particles-container\">\n            <canvas d-particles [params]=\"params\" [style.width.%]=\"width\" [style.height.%]=\"height\"></canvas>\n        </div>\n    "
            },] },
];
/**
 * @nocollapse
 */
ParticlesComponent.ctorParameters = function () { return []; };
ParticlesComponent.propDecorators = {
    'width': [{ type: __WEBPACK_IMPORTED_MODULE_0__angular_core__["Input"] },],
    'height': [{ type: __WEBPACK_IMPORTED_MODULE_0__angular_core__["Input"] },],
    'params': [{ type: __WEBPACK_IMPORTED_MODULE_0__angular_core__["Input"] },],
    'style': [{ type: __WEBPACK_IMPORTED_MODULE_0__angular_core__["Input"] },],
};

var hexToRgb = function (hex) {
    var /** @type {?} */ shorthandRegex = /^#?([a-f\d])([a-f\d])([a-f\d])$/i;
    hex = hex.replace(shorthandRegex, function (m, r, g, b) {
        return r + r + g + g + b + b;
    });
    var /** @type {?} */ result = /^#?([a-f\d]{2})([a-f\d]{2})([a-f\d]{2})$/i.exec(hex);
    return result ? {
        r: parseInt(result[1], 16),
        g: parseInt(result[2], 16),
        b: parseInt(result[3], 16)
    } : null;
};
var clamp = function (number, min, max) {
    return Math.min(Math.max(number, min), max);
};
var isInArray = function (value, array) {
    return array.indexOf(value) > -1;
};
var deepExtend = function (destination, source) {
    for (var /** @type {?} */ property in source) {
        if (source[property] &&
            source[property].constructor &&
            source[property].constructor === Object) {
            destination[property] = destination[property] || {};
            deepExtend(destination[property], source[property]);
        }
        else {
            destination[property] = source[property];
        }
    }
    return destination;
};
var getColor = function (colorObject) {
    var /** @type {?} */ color = {};
    if (typeof (colorObject) == 'object') {
        if (colorObject instanceof Array) {
            var /** @type {?} */ selectedColor = colorObject[Math.floor(Math.random() * colorObject.length)];
            color.rgb = hexToRgb(selectedColor);
        }
        else {
            var r = colorObject.r, g = colorObject.g, b = colorObject.b;
            if (r !== undefined && g !== undefined && b !== undefined) {
                color.rgb = { r: r, g: g, b: b };
            }
            else {
                var h = colorObject.h, s = colorObject.s, l = colorObject.l;
                if (h !== undefined && g !== undefined && b !== undefined) {
                    color.hsl = { h: h, s: s, l: l };
                }
            }
        }
    }
    else if (colorObject == 'random') {
        color.rgb = {
            r: (Math.floor(Math.random() * 255) + 1),
            g: (Math.floor(Math.random() * 255) + 1),
            b: (Math.floor(Math.random() * 255) + 1)
        };
    }
    else if (typeof (colorObject) == 'string') {
        color.rgb = hexToRgb(colorObject);
    }
    return color;
};
var getDefaultParams = function () {
    return {
        particles: {
            number: {
                value: 100,
                density: {
                    enable: true,
                    value_area: 800
                }
            },
            color: {
                value: '#FFF'
            },
            shape: {
                type: 'circle',
                stroke: {
                    width: 0,
                    color: '#000000'
                },
                polygon: {
                    nb_sides: 5
                },
                image: {
                    src: '',
                    width: 100,
                    height: 100
                }
            },
            opacity: {
                value: 0.5,
                random: false,
                anim: {
                    enable: true,
                    speed: 1,
                    opacity_min: 0.1,
                    sync: false
                }
            },
            size: {
                value: 3,
                random: true,
                anim: {
                    enable: false,
                    speed: 40,
                    size_min: 0,
                    sync: false
                }
            },
            line_linked: {
                enable: true,
                distance: 150,
                color: '#FFF',
                opacity: 0.6,
                width: 1,
                shadow: {
                    enable: false,
                    blur: 5,
                    color: 'lime'
                }
            },
            move: {
                enable: true,
                speed: 3,
                direction: 'none',
                random: false,
                straight: false,
                out_mode: 'out',
                bounce: true,
                attract: {
                    enable: false,
                    rotateX: 3000,
                    rotateY: 3000
                }
            },
            array: []
        },
        interactivity: {
            detect_on: 'canvas',
            events: {
                onhover: {
                    enable: true,
                    mode: 'grab'
                },
                onclick: {
                    enable: true,
                    mode: 'push'
                },
                resize: true
            },
            modes: {
                grab: {
                    distance: 200,
                    line_linked: {
                        opacity: 1
                    }
                },
                bubble: {
                    distance: 200,
                    size: 80,
                    duration: 0.4
                },
                repulse: {
                    distance: 200,
                    duration: 0.4
                },
                push: {
                    particles_nb: 4
                },
                remove: {
                    particles_nb: 2
                }
            },
            mouse: {}
        },
        retina_detect: true
    };
};
/**
 * @param {?} params
 * @param {?} tmp
 * @return {?}
 */
function loadImg(params, tmp) {
    var particles = this.params.particles;
    tmp.img_error = undefined;
    if (particles.shape.type == 'image' && particles.shape.image.src != '') {
        if (tmp.img_type == 'svg') {
            var /** @type {?} */ xhr_1 = new XMLHttpRequest();
            xhr_1.open('GET', particles.shape.image.src);
            xhr_1.onreadystatechange = function (data) {
                if (xhr_1.readyState == 4) {
                    if (xhr_1.status == 200) {
                        tmp.source_svg = data.currentTarget.response;
                        if (tmp.source_svg == undefined) {
                            var /** @type {?} */ check = void 0;
                            tmp.checkAnimFrame = requestAnimationFrame(check);
                        }
                    }
                    else {
                        tmp.img_error = true;
                        throw "Error : image not found";
                    }
                }
            };
            xhr_1.send();
        }
        else {
            var /** @type {?} */ img_1 = new Image();
            img_1.addEventListener('load', function () {
                tmp.img_obj = img_1;
                cancelAnimationFrame(tmp.checkAnimFrame);
            });
            img_1.src = particles.shape.image.src;
        }
    }
    else {
        tmp.img_error = true;
        throw "Error : no image.src";
    }
}
/**
 * @param {?} particle
 * @param {?} tmp
 * @return {?}
 */
function createSvgImg(particle, tmp) {
    var /** @type {?} */ svgXml = tmp.source_svg;
    var /** @type {?} */ rgbHex = /#([0-9A-F]{3,6})/gi;
    var /** @type {?} */ coloredSvgXml = svgXml.replace(rgbHex, function (m, r, g, b) {
        var /** @type {?} */ color_value;
        if (particle.color.rgb) {
            var _a = particle.color.rgb, r_1 = _a.r, g_1 = _a.g, b_1 = _a.b;
            color_value = "rgba( " + r_1 + ", " + g_1 + ", " + b_1 + ", " + particle.opacity + " )";
        }
        else {
            var _b = particle.color.hsl, h = _b.h, s = _b.s, l = _b.l;
            color_value = "rgba( " + h + ", " + s + ", " + l + ", " + particle.opacity + " )";
        }
        return color_value;
    });
    var /** @type {?} */ svg = new Blob([coloredSvgXml], {
        type: 'image/svg+xml;charset=utf-8'
    });
    var /** @type {?} */ DOMURL = window.URL || window;
    var /** @type {?} */ url = DOMURL.createObjectURL(svg);
    var /** @type {?} */ img = new Image();
    img.addEventListener('load', function () {
        particle.img.obj = img;
        particle.img.loaded = true;
        DOMURL.revokeObjectURL(url);
        tmp.count_svg++;
    });
    img.src = url;
}

var CanvasManager$$1 = (function () {
    /**
     * @param {?} _canvasParams
     * @param {?} _params
     * @param {?} _tmpParams
     */
    function CanvasManager$$1(_canvasParams, _params, _tmpParams) {
        this._canvasParams = _canvasParams;
        this._params = _params;
        this._tmpParams = _tmpParams;
        this._onWindowResize = this._onWindowResize.bind(this);
        this._retinaInit();
        this._canvasSize();
        this.particlesManager = new ParticlesManager$$1(this._canvasParams, this._params, this._tmpParams);
        this.particlesManager.particlesCreate();
        this._densityAutoParticles();
        var particles = this._params.particles;
        particles.line_linked.color_rgb_line = hexToRgb(particles.line_linked.color);
    }
    /**
     * @return {?}
     */
    CanvasManager$$1.prototype.draw = function () {
        var particles = this._params.particles;
        if (particles.shape.type == 'image') {
            if (this._tmpParams.img_type == 'svg') {
                if (this._tmpParams.count_svg >= particles.number.value) {
                    this.particlesManager.particlesDraw();
                    if (!particles.move.enable) {
                        cancelAnimationFrame(this._tmpParams.drawAnimFrame);
                    }
                    else {
                        this._tmpParams.drawAnimFrame = requestAnimationFrame(this.draw.bind(this));
                    }
                }
                else {
                    if (!this._tmpParams.img_error) {
                        this._tmpParams.drawAnimFrame = requestAnimationFrame(this.draw.bind(this));
                    }
                }
            }
            else {
                if (this._tmpParams.img_obj != undefined) {
                    this.particlesManager.particlesDraw();
                    if (!particles.move.enable) {
                        cancelAnimationFrame(this._tmpParams.drawAnimFrame);
                    }
                    else {
                        this._tmpParams.drawAnimFrame = requestAnimationFrame(this.draw.bind(this));
                    }
                }
                else {
                    if (!this._tmpParams.img_error) {
                        this._tmpParams.drawAnimFrame = requestAnimationFrame(this.draw.bind(this));
                    }
                }
            }
        }
        else {
            this.particlesManager.particlesDraw();
            if (!particles.move.enable) {
                cancelAnimationFrame(this._tmpParams.drawAnimFrame);
            }
            else {
                this._tmpParams.drawAnimFrame = requestAnimationFrame(this.draw.bind(this));
            }
        }
    };
    /**
     * @return {?}
     */
    CanvasManager$$1.prototype._densityAutoParticles = function () {
        var particles = this._params.particles;
        if (particles.number.density.enable) {
            var /** @type {?} */ area = this._canvasParams.el.width * this._canvasParams.el.height / 1000;
            if (this._tmpParams.retina) {
                area = area / (this._canvasParams.pxratio * 2);
            }
            var /** @type {?} */ nb_particles = area * particles.number.value / particles.number.density.value_area;
            var /** @type {?} */ missing_particles = particles.array.length - nb_particles;
            if (missing_particles < 0) {
                this.particlesManager.pushParticles(Math.abs(missing_particles));
            }
            else {
                this.particlesManager.removeParticles(missing_particles);
            }
        }
    };
    /**
     * @return {?}
     */
    CanvasManager$$1.prototype._retinaInit = function () {
        if (this._params.retina_detect && window.devicePixelRatio > 1) {
            this._canvasParams.pxratio = window.devicePixelRatio;
            this._tmpParams.retina = true;
            this._canvasParams.width = this._canvasParams.el.offsetWidth * this._canvasParams.pxratio;
            this._canvasParams.height = this._canvasParams.el.offsetHeight * this._canvasParams.pxratio;
            this._params.particles.size.value = this._tmpParams.obj.size_value * this._canvasParams.pxratio;
            this._params.particles.size.anim.speed = this._tmpParams.obj.size_anim_speed * this._canvasParams.pxratio;
            this._params.particles.move.speed = this._tmpParams.obj.move_speed * this._canvasParams.pxratio;
            this._params.particles.line_linked.distance = this._tmpParams.obj.line_linked_distance * this._canvasParams.pxratio;
            this._params.interactivity.modes.grab.distance = this._tmpParams.obj.mode_grab_distance * this._canvasParams.pxratio;
            this._params.interactivity.modes.bubble.distance = this._tmpParams.obj.mode_bubble_distance * this._canvasParams.pxratio;
            this._params.particles.line_linked.width = this._tmpParams.obj.line_linked_width * this._canvasParams.pxratio;
            this._params.interactivity.modes.bubble.size = this._tmpParams.obj.mode_bubble_size * this._canvasParams.pxratio;
            this._params.interactivity.modes.repulse.distance = this._tmpParams.obj.mode_repulse_distance * this._canvasParams.pxratio;
        }
        else {
            this._canvasParams.pxratio = 1;
            this._tmpParams.retina = false;
        }
    };
    /**
     * @return {?}
     */
    CanvasManager$$1.prototype._canvasClear = function () {
        this._canvasParams.ctx.clearRect(0, 0, this._canvasParams.width, this._canvasParams.height);
    };
    /**
     * @return {?}
     */
    CanvasManager$$1.prototype._canvasPaint = function () {
        this._canvasParams.ctx.fillRect(0, 0, this._canvasParams.width, this._canvasParams.height);
    };
    /**
     * @return {?}
     */
    CanvasManager$$1.prototype._canvasSize = function () {
        this._canvasParams.el.width = this._canvasParams.width;
        this._canvasParams.el.height = this._canvasParams.height;
        if (this._params && this._params.interactivity.events.resize) {
            window.addEventListener('resize', this._onWindowResize);
        }
    };
    /**
     * @return {?}
     */
    CanvasManager$$1.prototype._onWindowResize = function () {
        this._canvasParams.width = this._canvasParams.el.offsetWidth;
        this._canvasParams.height = this._canvasParams.el.offsetHeight;
        if (this._tmpParams.retina) {
            this._canvasParams.width *= this._canvasParams.pxratio;
            this._canvasParams.height *= this._canvasParams.pxratio;
        }
        this._canvasParams.el.width = this._canvasParams.width;
        this._canvasParams.el.height = this._canvasParams.height;
        if (!this._params.particles.move.enable) {
            this.particlesManager.particlesEmpty();
            this.particlesManager.particlesCreate();
            this.particlesManager.particlesDraw();
            this._densityAutoParticles();
        }
        this._densityAutoParticles();
    };
    return CanvasManager$$1;
}());

var ParticlesManager$$1 = (function () {
    /**
     * @param {?} _canvasParams
     * @param {?} _params
     * @param {?} _tmpParams
     */
    function ParticlesManager$$1(_canvasParams, _params, _tmpParams) {
        this._canvasParams = _canvasParams;
        this._params = _params;
        this._tmpParams = _tmpParams;
        this._interaction = new ParticleInteraction();
    }
    /**
     * @return {?}
     */
    ParticlesManager$$1.prototype.particlesCreate = function () {
        var _a = this._params.particles, color = _a.color, opacity = _a.opacity;
        for (var /** @type {?} */ i = 0; i < this._params.particles.number.value; i++) {
            this._params.particles.array.push(new Particle$$1(this._canvasParams, this._params, this._tmpParams, color, opacity.value));
        }
    };
    /**
     * @return {?}
     */
    ParticlesManager$$1.prototype._particlesUpdate = function () {
        var _this = this;
        this._params.particles.array.forEach(function (particle, i) {
            if (_this._params.particles.move.enable) {
                var /** @type {?} */ ms = _this._params.particles.move.speed / 2;
                particle.x += particle.vx * ms;
                particle.y += particle.vy * ms;
            }
            if (_this._params.particles.opacity.anim.enable) {
                if (particle.opacity_status == true) {
                    if (particle.opacity >= _this._params.particles.opacity.value)
                        particle.opacity_status = false;
                    particle.opacity += particle.vo;
                }
                else {
                    if (particle.opacity <= _this._params.particles.opacity.anim.opacity_min)
                        particle.opacity_status = true;
                    particle.opacity -= particle.vo;
                }
                if (particle.opacity < 0)
                    particle.opacity = 0;
            }
            if (_this._params.particles.size.anim.enable) {
                if (particle.size_status == true) {
                    if (particle.radius >= _this._params.particles.size.value)
                        particle.size_status = false;
                    particle.radius += particle.vs;
                }
                else {
                    if (particle.radius <= _this._params.particles.size.anim.size_min)
                        particle.size_status = true;
                    particle.radius -= particle.vs;
                }
                if (particle.radius < 0)
                    particle.radius = 0;
            }
            var /** @type {?} */ new_pos;
            if (_this._params.particles.move.out_mode == 'bounce') {
                new_pos = {
                    x_left: particle.radius,
                    x_right: _this._canvasParams.width,
                    y_top: particle.radius,
                    y_bottom: _this._canvasParams.height
                };
            }
            else {
                new_pos = {
                    x_left: -particle.radius,
                    x_right: _this._canvasParams.width + particle.radius,
                    y_top: -particle.radius,
                    y_bottom: _this._canvasParams.height + particle.radius
                };
            }
            if (particle.x - particle.radius > _this._canvasParams.width) {
                particle.x = new_pos.x_left;
                particle.y = Math.random() * _this._canvasParams.height;
            }
            else if (particle.x + particle.radius < 0) {
                particle.x = new_pos.x_right;
                particle.y = Math.random() * _this._canvasParams.height;
            }
            if (particle.y - particle.radius > _this._canvasParams.height) {
                particle.y = new_pos.y_top;
                particle.x = Math.random() * _this._canvasParams.width;
            }
            else if (particle.y + particle.radius < 0) {
                particle.y = new_pos.y_bottom;
                particle.x = Math.random() * _this._canvasParams.width;
            }
            switch (_this._params.particles.move.out_mode) {
                case 'bounce':
                    if (particle.x + particle.radius > _this._canvasParams.width)
                        particle.vx = -particle.vx;
                    else if (particle.x - particle.radius < 0)
                        particle.vx = -particle.vx;
                    if (particle.y + particle.radius > _this._canvasParams.height)
                        particle.vy = -particle.vy;
                    else if (particle.y - particle.radius < 0)
                        particle.vy = -particle.vy;
                    break;
            }
            if (isInArray('grab', _this._params.interactivity.events.onhover.mode)) {
                _this._grabParticle(particle);
            }
            if (isInArray('bubble', _this._params.interactivity.events.onhover.mode) ||
                isInArray('bubble', _this._params.interactivity.events.onclick.mode)) {
                _this._bubbleParticle(particle);
            }
            if (isInArray('repulse', _this._params.interactivity.events.onhover.mode) ||
                isInArray('repulse', _this._params.interactivity.events.onclick.mode)) {
                _this._repulseParticle(particle);
            }
            if (_this._params.particles.line_linked.enable || _this._params.particles.move.attract.enable) {
                for (var /** @type {?} */ j = i + 1; j < _this._params.particles.array.length; j++) {
                    var /** @type {?} */ link = _this._params.particles.array[j];
                    if (_this._params.particles.line_linked.enable)
                        _this._interaction.linkParticles(particle, link, _this._params, _this._canvasParams);
                    if (_this._params.particles.move.attract.enable)
                        _this._interaction.attractParticles(particle, link, _this._params);
                    if (_this._params.particles.move.bounce)
                        _this._interaction.bounceParticles(particle, link);
                }
            }
        });
    };
    /**
     * @return {?}
     */
    ParticlesManager$$1.prototype.particlesDraw = function () {
        this._canvasParams.ctx.clearRect(0, 0, this._canvasParams.width, this._canvasParams.height);
        this._particlesUpdate();
        this._params.particles.array.forEach(function (particle) {
            particle.draw();
        });
    };
    /**
     * @return {?}
     */
    ParticlesManager$$1.prototype.particlesEmpty = function () {
        this._params.particles.array = [];
    };
    /**
     * @param {?} nb
     * @return {?}
     */
    ParticlesManager$$1.prototype.removeParticles = function (nb) {
        this._params.particles.array.splice(0, nb);
        if (!this._params.particles.move.enable) {
            this.particlesDraw();
        }
    };
    /**
     * @param {?} nb
     * @param {?=} pos
     * @return {?}
     */
    ParticlesManager$$1.prototype.pushParticles = function (nb, pos) {
        this._tmpParams.pushing = true;
        for (var /** @type {?} */ i = 0; i < nb; i++) {
            this._params.particles.array.push(new Particle$$1(this._canvasParams, this._params, this._tmpParams, this._params.particles.color, this._params.particles.opacity.value, {
                x: pos ? pos.pos_x : Math.random() * this._canvasParams.width,
                y: pos ? pos.pos_y : Math.random() * this._canvasParams.height
            }));
            if (i == nb - 1) {
                if (!this._params.particles.move.enable) {
                    this.particlesDraw();
                }
                this._tmpParams.pushing = false;
            }
        }
    };
    /**
     * @param {?} particle
     * @return {?}
     */
    ParticlesManager$$1.prototype._bubbleParticle = function (particle) {
        var _this = this;
        if (this._params.interactivity.events.onhover.enable &&
            isInArray('bubble', this._params.interactivity.events.onhover.mode)) {
            var /** @type {?} */ dx_mouse = particle.x - this._params.interactivity.mouse.pos_x;
            var /** @type {?} */ dy_mouse = particle.y - this._params.interactivity.mouse.pos_y;
            var /** @type {?} */ dist_mouse = Math.sqrt(dx_mouse * dx_mouse + dy_mouse * dy_mouse);
            var /** @type {?} */ ratio = 1 - dist_mouse / this._params.interactivity.modes.bubble.distance;
            var /** @type {?} */ init = function () {
                particle.opacity_bubble = particle.opacity;
                particle.radius_bubble = particle.radius;
            };
            if (dist_mouse <= this._params.interactivity.modes.bubble.distance) {
                if (ratio >= 0 && this._params.interactivity.status == 'mousemove') {
                    if (this._params.interactivity.modes.bubble.size != this._params.particles.size.value) {
                        if (this._params.interactivity.modes.bubble.size > this._params.particles.size.value) {
                            var /** @type {?} */ size = particle.radius + (this._params.interactivity.modes.bubble.size * ratio);
                            if (size >= 0) {
                                particle.radius_bubble = size;
                            }
                        }
                        else {
                            var /** @type {?} */ dif = particle.radius - this._params.interactivity.modes.bubble.size;
                            var /** @type {?} */ size = particle.radius - (dif * ratio);
                            if (size > 0) {
                                particle.radius_bubble = size;
                            }
                            else {
                                particle.radius_bubble = 0;
                            }
                        }
                    }
                    if (this._params.interactivity.modes.bubble.opacity != this._params.particles.opacity.value) {
                        if (this._params.interactivity.modes.bubble.opacity > this._params.particles.opacity.value) {
                            var /** @type {?} */ opacity = this._params.interactivity.modes.bubble.opacity * ratio;
                            if (opacity > particle.opacity && opacity <= this._params.interactivity.modes.bubble.opacity) {
                                particle.opacity_bubble = opacity;
                            }
                        }
                        else {
                            var /** @type {?} */ opacity = particle.opacity - (this._params.particles.opacity.value - this._params.interactivity.modes.bubble.opacity) * ratio;
                            if (opacity < particle.opacity && opacity >= this._params.interactivity.modes.bubble.opacity) {
                                particle.opacity_bubble = opacity;
                            }
                        }
                    }
                }
            }
            else {
                init();
            }
            if (this._params.interactivity.status == 'mouseleave') {
                init();
            }
        }
        else if (this._params.interactivity.events.onclick.enable &&
            isInArray('bubble', this._params.interactivity.events.onclick.mode)) {
            if (this._tmpParams.bubble_clicking) {
                var /** @type {?} */ dx_mouse = particle.x - this._params.interactivity.mouse.click_pos_x;
                var /** @type {?} */ dy_mouse = particle.y - this._params.interactivity.mouse.click_pos_y;
                var /** @type {?} */ dist_mouse_1 = Math.sqrt(dx_mouse * dx_mouse + dy_mouse * dy_mouse);
                var /** @type {?} */ time_spent_1 = (new Date().getTime() - this._params.interactivity.mouse.click_time) / 1000;
                if (time_spent_1 > this._params.interactivity.modes.bubble.duration) {
                    this._tmpParams.bubble_duration_end = true;
                }
                if (time_spent_1 > this._params.interactivity.modes.bubble.duration * 2) {
                    this._tmpParams.bubble_clicking = false;
                    this._tmpParams.bubble_duration_end = false;
                }
                var /** @type {?} */ process = function (bubble_param, particles_param, p_obj_bubble, p_obj, id) {
                    if (bubble_param != particles_param) {
                        if (!_this._tmpParams.bubble_duration_end) {
                            if (dist_mouse_1 <= _this._params.interactivity.modes.bubble.distance) {
                                var /** @type {?} */ obj = void 0;
                                if (p_obj_bubble != undefined) {
                                    obj = p_obj_bubble;
                                }
                                else {
                                    obj = p_obj;
                                }
                                if (obj != bubble_param) {
                                    var /** @type {?} */ value = p_obj - (time_spent_1 * (p_obj - bubble_param) / _this._params.interactivity.modes.bubble.duration);
                                    if (id == 'size')
                                        particle.radius_bubble = value;
                                    if (id == 'opacity')
                                        particle.opacity_bubble = value;
                                }
                            }
                            else {
                                if (id == 'size')
                                    particle.radius_bubble = undefined;
                                if (id == 'opacity')
                                    particle.opacity_bubble = undefined;
                            }
                        }
                        else {
                            if (p_obj_bubble != undefined) {
                                var /** @type {?} */ value_tmp = p_obj - (time_spent_1 * (p_obj - bubble_param) / _this._params.interactivity.modes.bubble.duration);
                                var /** @type {?} */ dif = bubble_param - value_tmp;
                                var /** @type {?} */ value = bubble_param + dif;
                                if (id == 'size')
                                    particle.radius_bubble = value;
                                if (id == 'opacity')
                                    particle.opacity_bubble = value;
                            }
                        }
                    }
                };
                if (this._tmpParams.bubble_clicking) {
                    process(this._params.interactivity.modes.bubble.size, this._params.particles.size.value, particle.radius_bubble, particle.radius, 'size');
                    process(this._params.interactivity.modes.bubble.opacity, this._params.particles.opacity.value, particle.opacity_bubble, particle.opacity, 'opacity');
                }
            }
        }
    };
    /**
     * @param {?} particle
     * @return {?}
     */
    ParticlesManager$$1.prototype._repulseParticle = function (particle) {
        var _this = this;
        if (this._params.interactivity.events.onhover.enable &&
            isInArray('repulse', this._params.interactivity.events.onhover.mode) &&
            this._params.interactivity.status == 'mousemove') {
            var /** @type {?} */ dx_mouse = particle.x - this._params.interactivity.mouse.pos_x;
            var /** @type {?} */ dy_mouse = particle.y - this._params.interactivity.mouse.pos_y;
            var /** @type {?} */ dist_mouse = Math.sqrt(dx_mouse * dx_mouse + dy_mouse * dy_mouse);
            var /** @type {?} */ normVec = { x: dx_mouse / dist_mouse, y: dy_mouse / dist_mouse };
            var /** @type {?} */ repulseRadius = this._params.interactivity.modes.repulse.distance;
            var /** @type {?} */ velocity = 100;
            var /** @type {?} */ repulseFactor = clamp((1 / repulseRadius) * (-1 * Math.pow(dist_mouse / repulseRadius, 2) + 1) * repulseRadius * velocity, 0, 50);
            var /** @type {?} */ pos = {
                x: particle.x + normVec.x * repulseFactor,
                y: particle.y + normVec.y * repulseFactor
            };
            if (this._params.particles.move.out_mode == 'bounce') {
                if (pos.x - particle.radius > 0 && pos.x + particle.radius < this._canvasParams.width)
                    particle.x = pos.x;
                if (pos.y - particle.radius > 0 && pos.y + particle.radius < this._canvasParams.height)
                    particle.y = pos.y;
            }
            else {
                particle.x = pos.x;
                particle.y = pos.y;
            }
        }
        else if (this._params.interactivity.events.onclick.enable &&
            isInArray('repulse', this._params.interactivity.events.onclick.mode)) {
            if (!this._tmpParams.repulse_finish) {
                this._tmpParams.repulse_count++;
                if (this._tmpParams.repulse_count == this._params.particles.array.length)
                    this._tmpParams.repulse_finish = true;
            }
            if (this._tmpParams.repulse_clicking) {
                var /** @type {?} */ repulseRadius = Math.pow(this._params.interactivity.modes.repulse.distance / 6, 3);
                var /** @type {?} */ dx_1 = this._params.interactivity.mouse.click_pos_x - particle.x;
                var /** @type {?} */ dy_1 = this._params.interactivity.mouse.click_pos_y - particle.y;
                var /** @type {?} */ d = dx_1 * dx_1 + dy_1 * dy_1;
                var /** @type {?} */ force_1 = -repulseRadius / d * 1;
                var /** @type {?} */ process = function () {
                    var /** @type {?} */ f = Math.atan2(dy_1, dx_1);
                    particle.vx = force_1 * Math.cos(f);
                    particle.vy = force_1 * Math.sin(f);
                    if (_this._params.particles.move.out_mode == 'bounce') {
                        var /** @type {?} */ pos = {
                            x: particle.x + particle.vx,
                            y: particle.y + particle.vy
                        };
                        if (pos.x + particle.radius > _this._canvasParams.width)
                            particle.vx = -particle.vx;
                        else if (pos.x - particle.radius < 0)
                            particle.vx = -particle.vx;
                        if (pos.y + particle.radius > _this._canvasParams.height)
                            particle.vy = -particle.vy;
                        else if (pos.y - particle.radius < 0)
                            particle.vy = -particle.vy;
                    }
                };
                if (d <= repulseRadius) {
                    process();
                }
            }
            else {
                if (this._tmpParams.repulse_clicking == false) {
                    particle.vx = particle.vx_i;
                    particle.vy = particle.vy_i;
                }
            }
        }
    };
    /**
     * @param {?} particle
     * @return {?}
     */
    ParticlesManager$$1.prototype._grabParticle = function (particle) {
        var _a = this._params, interactivity = _a.interactivity, particles = _a.particles;
        if (interactivity.events.onhover.enable &&
            interactivity.status == 'mousemove') {
            var /** @type {?} */ dx_mouse = particle.x - interactivity.mouse.pos_x;
            var /** @type {?} */ dy_mouse = particle.y - interactivity.mouse.pos_y;
            var /** @type {?} */ dist_mouse = Math.sqrt(dx_mouse * dx_mouse + dy_mouse * dy_mouse);
            if (dist_mouse <= interactivity.modes.grab.distance) {
                var grab = interactivity.modes.grab;
                var /** @type {?} */ opacity_line = grab.line_linked.opacity - (dist_mouse / (1 / grab.line_linked.opacity)) / grab.distance;
                if (opacity_line > 0) {
                    var /** @type {?} */ color_line = particles.line_linked.color_rgb_line;
                    var r = color_line.r, g = color_line.g, b = color_line.b;
                    this._canvasParams.ctx.strokeStyle = "rgba( " + r + ", " + g + ", " + b + ", " + opacity_line + " )";
                    this._canvasParams.ctx.lineWidth = particles.line_linked.width;
                    this._canvasParams.ctx.beginPath();
                    this._canvasParams.ctx.moveTo(particle.x, particle.y);
                    this._canvasParams.ctx.lineTo(interactivity.mouse.pos_x, interactivity.mouse.pos_y);
                    this._canvasParams.ctx.stroke();
                    this._canvasParams.ctx.closePath();
                }
            }
        }
    };
    return ParticlesManager$$1;
}());

var Particle$$1 = (function () {
    /**
     * @param {?} _canvasParams
     * @param {?} _params
     * @param {?} _tmpParams
     * @param {?=} color
     * @param {?=} opacity
     * @param {?=} position
     */
    function Particle$$1(_canvasParams, _params, _tmpParams, color, opacity, position) {
        this._canvasParams = _canvasParams;
        this._params = _params;
        this._tmpParams = _tmpParams;
        this._setupSize();
        this._setupPosition(position);
        this._setupColor(color);
        this._setupOpacity();
        this._setupAnimation();
    }
    /**
     * @return {?}
     */
    Particle$$1.prototype._setupSize = function () {
        this.radius = (this._params.particles.size.random ? Math.random() : 1) * this._params.particles.size.value;
        if (this._params.particles.size.anim.enable) {
            this.size_status = false;
            this.vs = this._params.particles.size.anim.speed / 100;
            if (!this._params.particles.size.anim.sync)
                this.vs = this.vs * Math.random();
        }
    };
    /**
     * @param {?=} position
     * @return {?}
     */
    Particle$$1.prototype._setupPosition = function (position) {
        this.x = position ? position.x : Math.random() * this._canvasParams.width;
        this.y = position ? position.y : Math.random() * this._canvasParams.height;
        if (this.x > this._canvasParams.width - this.radius * 2) {
            this.x = this.x - this.radius;
        }
        else if (this.x < this.radius * 2) {
            this.x = this.x + this.radius;
        }
        if (this.y > this._canvasParams.height - this.radius * 2) {
            this.y = this.y - this.radius;
        }
        else if (this.y < this.radius * 2) {
            this.y = this.y + this.radius;
        }
        if (this._params.particles.move.bounce) {
            this._checkOverlap(this, position);
        }
    };
    /**
     * @param {?} p1
     * @param {?=} position
     * @return {?}
     */
    Particle$$1.prototype._checkOverlap = function (p1, position) {
        var _this = this;
        var particles = this._params.particles;
        particles.array.forEach(function (particle) {
            var /** @type {?} */ p2 = particle;
            var /** @type {?} */ dx = p1.x - p2.x;
            var /** @type {?} */ dy = p1.y - p2.y;
            var /** @type {?} */ dist = Math.sqrt(dx * dx + dy * dy);
            if (dist <= p1.radius + p2.radius) {
                p1.x = position ? position.x : Math.random() * _this._canvasParams.width;
                p1.y = position ? position.y : Math.random() * _this._canvasParams.height;
                _this._checkOverlap(p1);
            }
        });
    };
    /**
     * @param {?=} color
     * @return {?}
     */
    Particle$$1.prototype._setupColor = function (color) {
        this.color = getColor(color.value);
    };
    /**
     * @return {?}
     */
    Particle$$1.prototype._setupOpacity = function () {
        this.opacity = (this._params.particles.opacity.random ? Math.random() : 1) * this._params.particles.opacity.value;
        if (this._params.particles.opacity.anim.enable) {
            this.opacity_status = false;
            this.vo = this._params.particles.opacity.anim.speed / 100;
            if (!this._params.particles.opacity.anim.sync) {
                this.vo = this.vo * Math.random();
            }
        }
    };
    /**
     * @return {?}
     */
    Particle$$1.prototype._setupAnimation = function () {
        var /** @type {?} */ velbase = null;
        switch (this._params.particles.move.direction) {
            case 'top':
                velbase = { x: 0, y: -1 };
                break;
            case 'top-right':
                velbase = { x: 0.5, y: -0.5 };
                break;
            case 'right':
                velbase = { x: 1, y: 0 };
                break;
            case 'bottom-right':
                velbase = { x: 0.5, y: 0.5 };
                break;
            case 'bottom':
                velbase = { x: 0, y: 1 };
                break;
            case 'bottom-left':
                velbase = { x: -0.5, y: 1 };
                break;
            case 'left':
                velbase = { x: -1, y: 0 };
                break;
            case 'top-left':
                velbase = { x: -0.5, y: -0.5 };
                break;
            default:
                velbase = { x: 0, y: 0 };
                break;
        }
        if (this._params.particles.move.straight) {
            this.vx = velbase.x;
            this.vy = velbase.y;
            if (this._params.particles.move.random) {
                this.vx = this.vx * (Math.random());
                this.vy = this.vy * (Math.random());
            }
        }
        else {
            this.vx = velbase.x + Math.random() - 0.5;
            this.vy = velbase.y + Math.random() - 0.5;
        }
        this.vx_i = this.vx;
        this.vy_i = this.vy;
        var /** @type {?} */ shape_type = this._params.particles.shape.type;
        if (typeof (shape_type) == 'object') {
            if (shape_type instanceof Array) {
                var /** @type {?} */ shape_selected = shape_type[Math.floor(Math.random() * shape_type.length)];
                this.shape = shape_selected;
            }
        }
        else {
            this.shape = shape_type;
        }
        if (this.shape == 'image') {
            var /** @type {?} */ sh = this._params.particles.shape;
            this.img = {
                src: sh.image.src,
                ratio: sh.image.width / sh.image.height
            };
            if (!this.img.ratio)
                this.img.ratio = 1;
            if (this._tmpParams.img_type == 'svg' && this._tmpParams.source_svg != undefined) {
                createSvgImg(this, this._tmpParams);
                if (this._tmpParams.pushing) {
                    this.img.loaded = false;
                }
            }
        }
    };
    /**
     * @param {?} c
     * @param {?} startX
     * @param {?} startY
     * @param {?} sideLength
     * @param {?} sideCountNumerator
     * @param {?} sideCountDenominator
     * @return {?}
     */
    Particle$$1.prototype._drawShape = function (c, startX, startY, sideLength, sideCountNumerator, sideCountDenominator) {
        var /** @type {?} */ sideCount = sideCountNumerator * sideCountDenominator;
        var /** @type {?} */ decimalSides = sideCountNumerator / sideCountDenominator;
        var /** @type {?} */ interiorAngleDegrees = (180 * (decimalSides - 2)) / decimalSides;
        var /** @type {?} */ interiorAngle = Math.PI - Math.PI * interiorAngleDegrees / 180;
        c.save();
        c.beginPath();
        c.translate(startX, startY);
        c.moveTo(0, 0);
        for (var /** @type {?} */ i = 0; i < sideCount; i++) {
            c.lineTo(sideLength, 0);
            c.translate(sideLength, 0);
            c.rotate(interiorAngle);
        }
        c.fill();
        c.restore();
    };
    /**
     * @return {?}
     */
    Particle$$1.prototype.draw = function () {
        var _this = this;
        var particles = this._params.particles;
        var /** @type {?} */ radius;
        if (this.radius_bubble != undefined) {
            radius = this.radius_bubble;
        }
        else {
            radius = this.radius;
        }
        var /** @type {?} */ opacity;
        if (this.opacity_bubble != undefined) {
            opacity = this.opacity_bubble;
        }
        else {
            opacity = this.opacity;
        }
        var /** @type {?} */ color_value;
        if (this.color.rgb) {
            var _a = this.color.rgb, r = _a.r, g = _a.g, b = _a.b;
            color_value = "rgba( " + r + ", " + g + ", " + b + ", " + opacity + " )";
        }
        else {
            var _b = this.color.hsl, h = _b.h, s = _b.s, l = _b.l;
            color_value = "hsla( " + h + ", " + s + ", " + l + ", " + opacity + " )";
        }
        this._canvasParams.ctx.fillStyle = color_value;
        this._canvasParams.ctx.beginPath();
        switch (this.shape) {
            case 'circle':
                this._canvasParams.ctx.arc(this.x, this.y, radius, 0, Math.PI * 2, false);
                break;
            case 'edge':
                this._canvasParams.ctx.rect(this.x - radius, this.y - radius, radius * 2, radius * 2);
                break;
            case 'triangle':
                this._drawShape(this._canvasParams.ctx, this.x - radius, this.y + radius / 1.66, radius * 2, 3, 2);
                break;
            case 'polygon':
                this._drawShape(this._canvasParams.ctx, this.x - radius / (this._params.particles.shape.polygon.nb_sides / 3.5), this.y - radius / (2.66 / 3.5), radius * 2.66 / (this._params.particles.shape.polygon.nb_sides / 3), this._params.particles.shape.polygon.nb_sides, 1);
                break;
            case 'star':
                this._drawShape(this._canvasParams.ctx, this.x - radius * 2 / (this._params.particles.shape.polygon.nb_sides / 4), this.y - radius / (2 * 2.66 / 3.5), radius * 2 * 2.66 / (this._params.particles.shape.polygon.nb_sides / 3), this._params.particles.shape.polygon.nb_sides, 2);
                break;
            case 'image':
                var /** @type {?} */ draw = function (img_obj) {
                    _this._canvasParams.ctx.drawImage(img_obj, _this.x - radius, _this.y - radius, radius * 2, radius * 2 / _this.img.ratio);
                };
                var /** @type {?} */ img_obj = void 0;
                if (this._tmpParams.img_type == 'svg') {
                    img_obj = this.img.obj;
                }
                else {
                    img_obj = this._tmpParams.img_obj;
                }
                if (img_obj)
                    draw(img_obj);
                break;
        }
        this._canvasParams.ctx.closePath();
        if (this._params.particles.shape.stroke.width > 0) {
            this._canvasParams.ctx.strokeStyle = this._params.particles.shape.stroke.color;
            this._canvasParams.ctx.lineWidth = this._params.particles.shape.stroke.width;
            this._canvasParams.ctx.stroke();
        }
        this._canvasParams.ctx.fill();
    };
    return Particle$$1;
}());

var ParticleInteraction = (function () {
    function ParticleInteraction() {
    }
    /**
     * @param {?} p1
     * @param {?} p2
     * @param {?} params
     * @param {?} canvasParams
     * @return {?}
     */
    ParticleInteraction.prototype.linkParticles = function (p1, p2, params, canvasParams) {
        var /** @type {?} */ dx = p1.x - p2.x;
        var /** @type {?} */ dy = p1.y - p2.y;
        var /** @type {?} */ dist = Math.sqrt(dx * dx + dy * dy);
        var line_linked = params.particles.line_linked;
        if (dist <= params.particles.line_linked.distance) {
            var /** @type {?} */ opacity_line = params.particles.line_linked.opacity - (dist / (1 / params.particles.line_linked.opacity)) / params.particles.line_linked.distance;
            if (opacity_line > 0) {
                var /** @type {?} */ color_line = params.particles.line_linked.color_rgb_line;
                var r = color_line.r, g = color_line.g, b = color_line.b;
                canvasParams.ctx.save();
                canvasParams.ctx.strokeStyle = "rgba( " + r + ", " + g + ", " + b + ", " + opacity_line + " )";
                canvasParams.ctx.lineWidth = params.particles.line_linked.width;
                canvasParams.ctx.beginPath();
                if (line_linked.shadow.enable) {
                    canvasParams.ctx.shadowBlur = line_linked.shadow.blur;
                    canvasParams.ctx.shadowColor = line_linked.shadow.color;
                }
                canvasParams.ctx.moveTo(p1.x, p1.y);
                canvasParams.ctx.lineTo(p2.x, p2.y);
                canvasParams.ctx.stroke();
                canvasParams.ctx.closePath();
                canvasParams.ctx.restore();
            }
        }
    };
    /**
     * @param {?} p1
     * @param {?} p2
     * @param {?} params
     * @return {?}
     */
    ParticleInteraction.prototype.attractParticles = function (p1, p2, params) {
        var /** @type {?} */ dx = p1.x - p2.x;
        var /** @type {?} */ dy = p1.y - p2.y;
        var /** @type {?} */ dist = Math.sqrt(dx * dx + dy * dy);
        if (dist <= params.particles.line_linked.distance) {
            var /** @type {?} */ ax = dx / (params.particles.move.attract.rotateX * 1000);
            var /** @type {?} */ ay = dy / (params.particles.move.attract.rotateY * 1000);
            p1.vx -= ax;
            p1.vy -= ay;
            p2.vx += ax;
            p2.vy += ay;
        }
    };
    /**
     * @param {?} p1
     * @param {?} p2
     * @return {?}
     */
    ParticleInteraction.prototype.bounceParticles = function (p1, p2) {
        var /** @type {?} */ dx = p1.x - p2.x;
        var /** @type {?} */ dy = p1.y - p2.y;
        var /** @type {?} */ dist = Math.sqrt(dx * dx + dy * dy);
        var /** @type {?} */ dist_p = p1.radius + p2.radius;
        if (dist <= dist_p) {
            p1.vx = -p1.vx;
            p1.vy = -p1.vy;
            p2.vx = -p2.vx;
            p2.vy = -p2.vy;
        }
    };
    return ParticleInteraction;
}());

var ParticlesDirective = (function () {
    /**
     * @param {?} el
     */
    function ParticlesDirective(el) {
        this.el = el;
        this._tmpParams = {};
    }
    Object.defineProperty(ParticlesDirective.prototype, "params", {
        /**
         * @param {?} value
         * @return {?}
         */
        set: function (value) {
            var /** @type {?} */ defaultParams = getDefaultParams();
            this._params = deepExtend(defaultParams, value);
        },
        enumerable: true,
        configurable: true
    });
    /**
     * @return {?}
     */
    ParticlesDirective.prototype.ngAfterViewInit = function () {
        this._canvasParams = {
            el: this.el.nativeElement,
            ctx: this.el.nativeElement.getContext('2d'),
            width: this.el.nativeElement.offsetWidth,
            height: this.el.nativeElement.offsetHeight
        };
        this._tmpParams.obj = {
            size_value: this._params.particles.size.value,
            size_anim_speed: this._params.particles.size.anim.speed,
            move_speed: this._params.particles.move.speed,
            line_linked_distance: this._params.particles.line_linked.distance,
            line_linked_width: this._params.particles.line_linked.width,
            mode_grab_distance: this._params.interactivity.modes.grab.distance,
            mode_bubble_distance: this._params.interactivity.modes.bubble.distance,
            mode_bubble_size: this._params.interactivity.modes.bubble.size,
            mode_repulse_distance: this._params.interactivity.modes.repulse.distance
        };
        this._params.interactivity.el = (this._params.interactivity.detect_on == 'window') ? window : this._canvasParams.el;
        if (isInArray('image', this._params.particles.shape.type)) {
            this._tmpParams.img_type = this._params.particles.shape.image.src.substr(this._params.particles.shape.image.src.length - 3);
            loadImg(this._params, this._tmpParams);
        }
        this._canvasManager = new CanvasManager$$1(this._canvasParams, this._params, this._tmpParams);
        this._canvasManager.draw();
    };
    /**
     * Mouse move event
    \@param event
     * @param {?} event
     * @return {?}
     */
    ParticlesDirective.prototype.onMouseMove = function (event) {
        var interactivity = this._params.interactivity;
        if (interactivity.events.onhover.enable ||
            interactivity.events.onclick.enable) {
            var /** @type {?} */ pos = void 0;
            if (interactivity.el == window) {
                pos = {
                    x: event.clientX,
                    y: event.clientY
                };
            }
            else {
                pos = {
                    x: event.offsetX || event.clientX,
                    y: event.offsetY || event.clientY
                };
            }
            interactivity.mouse.pos_x = pos.x;
            interactivity.mouse.pos_y = pos.y;
            if (this._tmpParams.retina) {
                interactivity.mouse.pos_x *= this._canvasParams.pxratio;
                interactivity.mouse.pos_y *= this._canvasParams.pxratio;
            }
            interactivity.status = 'mousemove';
        }
    };
    /**
     * Mouse leave event
     * @return {?}
     */
    ParticlesDirective.prototype.onMouseLeave = function () {
        var interactivity = this._params.interactivity;
        if (interactivity.events.onhover.enable ||
            interactivity.events.onclick.enable) {
            interactivity.mouse.pos_x = null;
            interactivity.mouse.pos_y = null;
            interactivity.status = 'mouseleave';
        }
    };
    /**
     * Click event
     * @return {?}
     */
    ParticlesDirective.prototype.onClick = function () {
        var _this = this;
        var _a = this._params, interactivity = _a.interactivity, particles = _a.particles;
        if (interactivity.events.onclick.enable) {
            interactivity.mouse.click_pos_x = interactivity.mouse.pos_x;
            interactivity.mouse.click_pos_y = interactivity.mouse.pos_y;
            interactivity.mouse.click_time = new Date().getTime();
            switch (interactivity.events.onclick.mode) {
                case 'push':
                    if (particles.move.enable) {
                        this._canvasManager.particlesManager.pushParticles(interactivity.modes.push.particles_nb, interactivity.mouse);
                    }
                    else {
                        if (interactivity.modes.push.particles_nb == 1) {
                            this._canvasManager.particlesManager.pushParticles(interactivity.modes.push.particles_nb, interactivity.mouse);
                        }
                        else if (interactivity.modes.push.particles_nb > 1) {
                            this._canvasManager.particlesManager.pushParticles(interactivity.modes.push.particles_nb);
                        }
                    }
                    break;
                case 'remove':
                    this._canvasManager.particlesManager.removeParticles(interactivity.modes.remove.particles_nb);
                    break;
                case 'bubble':
                    this._tmpParams.bubble_clicking = true;
                    break;
                case 'repulse':
                    this._tmpParams.repulse_clicking = true;
                    this._tmpParams.repulse_count = 0;
                    this._tmpParams.repulse_finish = false;
                    setTimeout(function () {
                        _this._tmpParams.repulse_clicking = false;
                    }, interactivity.modes.repulse.duration * 1000);
                    break;
            }
        }
    };
    return ParticlesDirective;
}());
ParticlesDirective.decorators = [
    { type: __WEBPACK_IMPORTED_MODULE_0__angular_core__["Directive"], args: [{
                selector: '[d-particles]'
            },] },
];
/**
 * @nocollapse
 */
ParticlesDirective.ctorParameters = function () { return [
    { type: __WEBPACK_IMPORTED_MODULE_0__angular_core__["ElementRef"], },
]; };
ParticlesDirective.propDecorators = {
    'params': [{ type: __WEBPACK_IMPORTED_MODULE_0__angular_core__["Input"] },],
    'onMouseMove': [{ type: __WEBPACK_IMPORTED_MODULE_0__angular_core__["HostListener"], args: ['mousemove', ['$event'],] },],
    'onMouseLeave': [{ type: __WEBPACK_IMPORTED_MODULE_0__angular_core__["HostListener"], args: ['mouseleave',] },],
    'onClick': [{ type: __WEBPACK_IMPORTED_MODULE_0__angular_core__["HostListener"], args: ['click',] },],
};

var ParticlesModule = (function () {
    function ParticlesModule() {
    }
    return ParticlesModule;
}());
ParticlesModule.decorators = [
    { type: __WEBPACK_IMPORTED_MODULE_0__angular_core__["NgModule"], args: [{
                imports: [
                    __WEBPACK_IMPORTED_MODULE_1__angular_common__["CommonModule"]
                ],
                declarations: [
                    ParticlesComponent,
                    ParticlesDirective
                ],
                exports: [
                    ParticlesComponent,
                    ParticlesDirective
                ]
            },] },
];
/**
 * @nocollapse
 */
ParticlesModule.ctorParameters = function () { return []; };




/***/ }),

/***/ 1129:
/***/ (function(module, exports, __webpack_require__) {

exports = module.exports = __webpack_require__(17)(false);
// imports


// module
exports.push([module.i, ".auth-main {\n  display: -webkit-box;\n  display: -ms-flexbox;\n  display: flex;\n  -webkit-box-align: center;\n      -ms-flex-align: center;\n          align-items: center;\n  height: 100%;\n  width: 100%;\n  position: absolute; }\n\n.auth-block {\n  width: 540px;\n  margin: 0 auto;\n  border-radius: 5px;\n  background: rgba(0, 0, 0, 0.55);\n  color: #fff;\n  padding: 32px; }\n  .auth-block h1 {\n    font-weight: 300;\n    margin-bottom: 28px;\n    text-align: center; }\n  .auth-block p {\n    font-size: 16px; }\n  .auth-block a {\n    text-decoration: none;\n    outline: none;\n    transition: all 0.2s ease;\n    color: #374767; }\n    .auth-block a:hover {\n      color: #2f3c58; }\n  .auth-block .control-label {\n    padding-top: 11px;\n    color: #ffffff; }\n  .auth-block .form-group {\n    margin-bottom: 12px; }\n\n.auth-input {\n  width: 300px;\n  margin-bottom: 24px; }\n  .auth-input input {\n    display: block;\n    width: 100%;\n    border: none;\n    font-size: 16px;\n    padding: 4px 10px;\n    outline: none; }\n\na.forgot-pass {\n  display: block;\n  text-align: right;\n  margin-bottom: -20px;\n  float: right;\n  z-index: 2;\n  position: relative; }\n\n.auth-link {\n  display: block;\n  font-size: 16px;\n  text-align: center;\n  margin-bottom: 33px; }\n\n.auth-sep {\n  margin-top: 36px;\n  margin-bottom: 24px;\n  line-height: 20px;\n  font-size: 16px;\n  text-align: center;\n  display: block;\n  position: relative; }\n  .auth-sep > span {\n    display: table-cell;\n    width: 30%;\n    white-space: nowrap;\n    padding: 0 24px;\n    color: #ffffff; }\n    .auth-sep > span > span {\n      margin-top: -12px;\n      display: block; }\n  .auth-sep:before, .auth-sep:after {\n    border-top: solid 1px #ffffff;\n    content: \"\";\n    height: 1px;\n    width: 35%;\n    display: table-cell; }\n\n.al-share-auth {\n  text-align: center; }\n  .al-share-auth .al-share {\n    float: none;\n    margin: 0;\n    padding: 0;\n    display: inline-block; }\n    .al-share-auth .al-share li {\n      margin-left: 24px; }\n      .al-share-auth .al-share li:first-child {\n        margin-left: 0; }\n      .al-share-auth .al-share li i {\n        font-size: 24px; }\n\nbody {\n  font-family: 'Conv_Avenir'; }\n\n.auth-main {\n  display: -webkit-box;\n  display: -ms-flexbox;\n  display: flex;\n  -webkit-box-align: center;\n      -ms-flex-align: center;\n          align-items: center;\n  height: 100%;\n  width: 100%;\n  position: absolute; }\n\n.auth-block {\n  width: 540px;\n  margin: 0 auto;\n  border-radius: 5px;\n  background: rgba(0, 0, 0, 0.55);\n  color: #fff;\n  padding: 32px; }\n  .auth-block h1 {\n    font-weight: 300;\n    margin-bottom: 28px;\n    text-align: center; }\n  .auth-block p {\n    font-size: 16px; }\n  .auth-block a {\n    text-decoration: none;\n    outline: none;\n    transition: all 0.2s ease;\n    color: #374767; }\n    .auth-block a:hover {\n      color: #2f3c58; }\n  .auth-block .control-label {\n    padding-top: 11px;\n    color: #ffffff; }\n  .auth-block .form-group {\n    margin-bottom: 12px; }\n\n.auth-input {\n  width: 300px;\n  margin-bottom: 24px; }\n  .auth-input input {\n    display: block;\n    width: 100%;\n    border: none;\n    font-size: 16px;\n    padding: 4px 10px;\n    outline: none; }\n\na.forgot-pass {\n  display: block;\n  text-align: right;\n  margin-bottom: -20px;\n  float: right;\n  z-index: 2;\n  position: relative; }\n\n.auth-link {\n  display: block;\n  font-size: 16px;\n  text-align: center;\n  margin-bottom: 33px; }\n\n.auth-sep {\n  margin-top: 36px;\n  margin-bottom: 24px;\n  line-height: 20px;\n  font-size: 16px;\n  text-align: center;\n  display: block;\n  position: relative; }\n  .auth-sep > span {\n    display: table-cell;\n    width: 30%;\n    white-space: nowrap;\n    padding: 0 24px;\n    color: #ffffff; }\n    .auth-sep > span > span {\n      margin-top: -12px;\n      display: block; }\n  .auth-sep:before, .auth-sep:after {\n    border-top: solid 1px #ffffff;\n    content: \"\";\n    height: 1px;\n    width: 35%;\n    display: table-cell; }\n\n.al-share-auth {\n  text-align: center; }\n  .al-share-auth .al-share {\n    float: none;\n    margin: 0;\n    padding: 0;\n    display: inline-block; }\n    .al-share-auth .al-share li {\n      margin-left: 24px; }\n      .al-share-auth .al-share li:first-child {\n        margin-left: 0; }\n      .al-share-auth .al-share li i {\n        font-size: 24px; }\n\nbody {\n  font-family: 'Conv_Avenir'; }\n\n.paginationControl {\n  width: 100%;\n  float: left; }\n  .paginationControl #listItem .ngx-pagination .current {\n    background: #195C94;\n    color: #fff; }\n  .paginationControl #listItem .ngx-pagination .pagination-previous {\n    border-bottom-left-radius: 3px;\n    border-top-left-radius: 3px; }\n  .paginationControl #listItem .ngx-pagination .pagination-next {\n    border-bottom-right-radius: 3px;\n    border-top-right-radius: 3px; }\n  .paginationControl #listItem .ngx-pagination a {\n    color: #606c71; }\n    .paginationControl #listItem .ngx-pagination a:hover {\n      background: transparent; }\n  .paginationControl #listItem .ngx-pagination .disabled {\n    padding: 0.1875rem 0.625rem;\n    margin-left: 0.9px;\n    color: #cacaca;\n    cursor: not-allowed; }\n  .paginationControl #listItemNew .ngx-pagination .current {\n    background: #195C94;\n    color: #fff; }\n  .paginationControl #listItemNew .ngx-pagination .pagination-previous {\n    border-bottom-left-radius: 3px;\n    border-top-left-radius: 3px; }\n  .paginationControl #listItemNew .ngx-pagination .pagination-next {\n    border-bottom-right-radius: 3px;\n    border-top-right-radius: 3px; }\n  .paginationControl #listItemNew .ngx-pagination a {\n    color: #606c71; }\n    .paginationControl #listItemNew .ngx-pagination a:hover {\n      background: transparent; }\n  .paginationControl #listItemNew .ngx-pagination .disabled {\n    padding: 0.1875rem 0.625rem;\n    margin-left: 0.9px;\n    color: #cacaca;\n    cursor: not-allowed; }\n  .paginationControl #listItem ul li {\n    border: 1px solid #d6d6d6;\n    margin-left: -2px;\n    height: 35px;\n    text-align: center;\n    min-width: 35px;\n    line-height: 27px; }\n    .paginationControl #listItem ul li:hover {\n      background: transparent; }\n  .paginationControl #listItemNew ul li {\n    border: 1px solid #d6d6d6;\n    margin-left: -2px;\n    height: 35px;\n    text-align: center;\n    min-width: 35px;\n    line-height: 27px; }\n    .paginationControl #listItemNew ul li:hover {\n      background: transparent; }\n  .paginationControl .pageControl {\n    cursor: pointer;\n    padding: 0 10px; }\n    .paginationControl .pageControl ul {\n      padding: 10px 0;\n      margin: 0;\n      float: left; }\n\n.rowsPerPagination {\n  display: inline-block;\n  cursor: pointer;\n  padding: 8px;\n  background-color: white;\n  color: #282828;\n  border: 1px solid lightgray; }\n\n.adjust_row_left {\n  margin-right: 5px; }\n\n.adjust_row_right {\n  margin-left: 5px; }\n\n.rowsPerPagination:hover {\n  background-color: lightgray; }\n\n.page_number_select {\n  background-color: #3b5998;\n  color: white; }\n\n.page_number_select:hover {\n  background-color: #3b5998;\n  color: white; }\n\n.per_page_paginate {\n  float: right;\n  margin-bottom: 5px; }\n\n.btn-danger {\n  margin-left: 3px; }\n\n#itemQuantityTable table > tbody > tr > td:nth-child(3) {\n  text-align: right; }\n\n#itemQuantityTable table > tbody > tr > td:nth-child(4) {\n  text-align: right; }\n\n#itemQuantityUsedTable table > tbody > tr > td:nth-child(2) {\n  text-align: right; }\n\n#editItemsTable table > tbody > tr > td:nth-child(2) {\n  text-align: right; }\n\n#vendorPurchaseTable table > tbody > tr > td:nth-child(3) {\n  text-align: right; }\n\n.purchase_table table > tbody > tr > td:nth-child(4) {\n  text-align: right; }\n\n.purchase_table table > tbody > tr > td:nth-child(5) {\n  text-align: right; }\n\n#viewRecurringExpenses table > tbody > tr > td:nth-child(6) {\n  text-align: right; }\n\n#viewRecurringExpenses table > tbody > tr > td:nth-child(7) {\n  text-align: right; }\n\n#viewNormalExpenses table > tbody > tr > td:nth-child(4) {\n  text-align: right; }\n\n#viewNormalExpenses table > tbody > tr > td:nth-child(5) {\n  text-align: right; }\n\n#viewNormalExpenses table > tbody > tr > td:nth-child(6) {\n  text-align: right; }\n\n.btn-primary {\n  margin-right: 3px; }\n\n.btn:hover {\n  -webkit-transform: none;\n          transform: none; }\n\n.help-block {\n  color: red; }\n\n.modal-header {\n  margin: 0 auto; }\n\n.fa-rupee:before, .fa-inr:before {\n  content: \"\\F156\";\n  margin-right: 14px !important; }\n\n.ion-edit:before {\n  content: \"\\F2BF\";\n  color: #000000; }\n\n.text-spacing {\n  margin-bottom: 1%; }\n\n.disableSubmit {\n  opacity: 0.8;\n  cursor: not-allowed; }\n  .disableSubmit:hover {\n    opacity: 0.8;\n    cursor: not-allowed !important; }\n\n.purchase_table .ion-edit:before {\n  content: \"\\F2BF\";\n  margin-right: 10px;\n  color: #000000; }\n\n.ion-trash-b:before {\n  content: \"\\F252\";\n  color: #ff0000; }\n\n.fa-envelope-o:before {\n  margin-right: 10px; }\n\n.fa-copy:before {\n  margin-right: 10px; }\n\n.form-control[disabled] {\n  color: grey;\n  border-color: lightgrey; }\n\n#vendorPurchaseTable table > thead > tr > th:first-child {\n  text-align: center; }\n\n.tagsSmart {\n  background: #F1F3F6;\n  color: #282828;\n  display: inline-block;\n  border: 1px solid lightgray;\n  padding: 0 10px 0 10px;\n  margin: 2px 2px 2px 2px;\n  border-radius: 90px; }\n\ntable th, table td {\n  border: 1px solid #ddd; }\n\ntable .ng2-smart-actions {\n  text-align: center;\n  color: #374767; }\n\ntable .ng2-smart-title a {\n  color: #374767; }\n\ntable .ng2-smart-title a:hover {\n  text-decoration: none; }\n\n.modal-body-data {\n  margin-bottom: 15px; }\n\ntable .ng2-smart-actions {\n  width: 100px !important; }\n\n.inputbox {\n  border-radius: 3px;\n  background-color: white;\n  width: 100%;\n  height: 100%;\n  margin-bottom: 0px;\n  padding-left: 2%;\n  border: 1px solid gainsboro;\n  outline: none;\n  box-shadow: none;\n  color: #555555; }\n\n.inputbox::-webkit-input-placeholder {\n  /* Chrome/Opera/Safari */\n  color: gainsboro; }\n\n.inputbox::-moz-placeholder {\n  /* Firefox 19+ */\n  color: gainsboro; }\n\n.inputbox:-ms-input-placeholder {\n  /* IE 10+ */\n  color: gainsboro; }\n\n.inputbox:-moz-placeholder {\n  /* Firefox 18- */\n  color: gainsboro; }\n\n.inputbox:focus, .inputbox:active {\n  border-color: #A5C9BB;\n  outline: 0;\n  outline: thin dotted \\9;\n  /* -webkit-box-shadow: inset 0 1px 1px rgba(0,0,0,.075), 0 0 8px rgba(82,168,236,.6); */\n  box-shadow: inset 0 1px 1px rgba(0, 220, 0, 0.075), 0 0 8px rgba(0, 225, 0, 0.2); }\n\n.inputbutton {\n  height: 58px;\n  line-height: 2.8;\n  margin: 3% 0 -2% 0; }\n\n.btnStyle {\n  width: 100%;\n  height: 100%;\n  background-color: #195C94;\n  color: white;\n  font-size: medium;\n  font-weight: bold;\n  border: none;\n  border-radius: 3px;\n  cursor: pointer; }\n  .btnStyle:focus {\n    outline: none;\n    box-shadow: 0px 0px 2px 2px #59a453; }\n\n.btnBackStyle {\n  width: 100%;\n  height: 100%;\n  background-color: white;\n  border: 1px solid #195C94;\n  color: #195C94;\n  font-size: medium;\n  font-weight: bold;\n  border-radius: 3px;\n  cursor: pointer; }\n  .btnBackStyle:focus {\n    outline: none;\n    box-shadow: 0px 0px 2px 2px #59a453; }\n\n.passwordErrorMessage {\n  float: left;\n  margin-top: -35px;\n  width: 100%;\n  margin-bottom: 10px; }\n\n.backButtonTop {\n  margin-bottom: 25px;\n  border: 1px solid #3b5998;\n  color: #3b5998;\n  display: inline-block; }\n\nselect option:checked:after {\n  background: #3b5998 -webkit-linear-gradient(bottom, #3b5998 0%, #3b5998 100%);\n  color: white; }\n\n.divAlignLeft {\n  float: left; }\n\n.divAlignRight {\n  float: right; }\n\n.Quotedatepicker .mydp .currmonth:hover {\n  background-color: #195C94 !important;\n  color: white !important; }\n\n.Quotedatepicker .mydp .selectiongroup {\n  cursor: not-allowed; }\n\n.Quotedatepicker .mydp .selector {\n  z-index: 1;\n  boder-radius: 3px; }\n\n.Quotedatepicker .mydp .selection {\n  height: 33px !important;\n  color: #282828;\n  font-size: 13px !important;\n  font-family: \"Conv_Avenir\" !important;\n  position: relative;\n  text-align: left;\n  padding-left: 8px;\n  pointer-events: none;\n  cursor: not-allowed;\n  boder-radius: 3px; }\n\n.Quotedatepicker .mydp .selbtngroup {\n  height: 33px !important; }\n\n.Quotedatepicker .mydp .btnclear {\n  color: #757575; }\n\n.Quotedatepicker .mydp .btnclear:hover {\n  background-color: #195C94 !important; }\n\n.Quotedatepicker .mydp .btnpicker {\n  height: 33px !important; }\n\n.Quotedatepicker .mydp .btnclearenabled:hover {\n  background-color: #195C94;\n  color: #fff; }\n\n.Quotedatepicker .mydp .btnpicker {\n  color: #757575; }\n\n.Quotedatepicker .mydp .btnpicker:hover {\n  background-color: #2f96b4 !important; }\n\n.Quotedatepicker .mydp .btnpickerenabled:hover {\n  background-color: #2f96b4;\n  color: #fff; }\n\n.Quotedatepicker .help-block {\n  color: red; }\n\nrl-tag-input-item {\n  margin-bottom: 3px; }\n\nselect[multiple]:focus option:checked {\n  background: #3b5998 linear-gradient(0deg, #3b5998 0%, #3b5998 100%); }\n\nrl-tag-input input {\n  font-family: 'Conv_Avenir' !important;\n  font-size: 14px !important; }\n\nrl-tag-input input::-webkit-input-placeholder {\n  color: grey; }\n\nrl-tag-input-item {\n  font-family: 'Conv_Avenir' !important;\n  font-size: 14px !important; }\n\n.required:after {\n  content: \"*\";\n  color: red; }\n\n@media screen and (min-width: 200px) and (max-width: 700px) {\n  .loginSegment {\n    width: 100% !important; }\n  .signInText {\n    display: inline-block;\n    width: 27%;\n    padding: 0; } }\n\n@media only screen and (min-device-width: 768px) and (max-device-width: 1024px) {\n  .loginSegment {\n    width: 60% !important; }\n  .signInText {\n    display: inline-block;\n    width: 27%; } }\n\n.loginContainer {\n  text-align: center; }\n  .loginContainer .loginSegment {\n    width: 28%;\n    display: inline-block; }\n    .loginContainer .loginSegment div {\n      text-align: center;\n      font-size: 17px;\n      font-weight: 500;\n      letter-spacing: 0.005em; }\n    .loginContainer .loginSegment .loginTitle {\n      width: 60%;\n      display: inline-block;\n      margin-top: 15%; }\n      .loginContainer .loginSegment .loginTitle img {\n        width: 100%;\n        height: 100%; }\n    .loginContainer .loginSegment .loginBody {\n      border: 1px solid gainsboro;\n      background-color: #fff;\n      border-radius: 3px;\n      margin-top: 10px; }\n      .loginContainer .loginSegment .loginBody .signIn {\n        padding-top: 1.4%;\n        padding-bottom: 3%;\n        display: -webkit-box;\n        display: -ms-flexbox;\n        display: flex; }\n        .loginContainer .loginSegment .loginBody .signIn .signInText {\n          width: 80%;\n          margin: 0 auto;\n          font-size: 17px; }\n      .loginContainer .loginSegment .loginBody .emaildiv {\n        margin-bottom: 16px; }\n      .loginContainer .loginSegment .loginBody .submitButton {\n        margin-top: 7%; }\n      .loginContainer .loginSegment .loginBody .passwordtext {\n        margin-top: 0px; }\n      .loginContainer .loginSegment .loginBody .disableSubmit {\n        opacity: 0.8;\n        cursor: not-allowed; }\n        .loginContainer .loginSegment .loginBody .disableSubmithover {\n          opacity: 0.8;\n          cursor: not-allowed; }\n      .loginContainer .loginSegment .loginBody .input-group {\n        height: 55px; }\n        .loginContainer .loginSegment .loginBody .input-group .input-group-addon {\n          border-bottom-left-radius: 3px;\n          border-top-left-radius: 3px; }\n      .loginContainer .loginSegment .loginBody .right-border {\n        border-bottom-right-radius: 3px;\n        border-top-right-radius: 3px; }\n      .loginContainer .loginSegment .loginBody .signin {\n        padding-bottom: 4.5%;\n        display: -webkit-box;\n        display: -ms-flexbox;\n        display: flex; }\n        .loginContainer .loginSegment .loginBody .signin div {\n          padding-top: 5px; }\n        .loginContainer .loginSegment .loginBody .signin a {\n          color: #59a453; }\n        .loginContainer .loginSegment .loginBody .signin .forgotPassword {\n          cursor: pointer;\n          font-size: 17px;\n          color: #59a453;\n          outline: none; }\n          .loginContainer .loginSegment .loginBody .signin .forgotPassword:hover {\n            text-decoration: underline; }\n      .loginContainer .loginSegment .loginBody .facebook-login {\n        display: inline-block;\n        padding-left: 9%;\n        padding-right: 9%;\n        height: 74px;\n        position: relative; }\n        .loginContainer .loginSegment .loginBody .facebook-login i {\n          position: absolute;\n          border-right: thin solid white;\n          color: white;\n          font-size: 40px;\n          height: 57px;\n          padding-right: 14px;\n          padding-left: 12px;\n          padding-top: 10px; }\n\n.loginBody .has-error .form-control {\n  border: 1px solid #fa758e; }\n\n.loginBody .has-success .form-control {\n  border: 1px solid #59a453; }\n\n.loginBody .signUpErrorMessage {\n  float: left;\n  margin-top: -35px;\n  width: 100%; }\n\n.loginBody .help-block {\n  color: red; }\n\n.loginBody .sub-little-signUp-error {\n  font-size: 12px; }\n", ""]);

// exports


/*** EXPORTS FROM exports-loader ***/
module.exports = module.exports.toString();

/***/ }),

/***/ 1179:
/***/ (function(module, exports) {

module.exports = "<particles [style]=\"myStyle\" [width]=\"width\" [height]=\"height\" [params]=\"myParams\"></particles>\n<div class=\"loginContainer\" >\n    <div class=\"row loginSegment\" style=\"position: absolute;left:37%; top:6%\">\n        <div class=\"col-md-12\">\n            <div class=\"loginTitle\"><img [src]=\"LogoImage\"></div>\n        </div>\n        <div class=\"loginBody\">\n            <div style=\"padding: 5%\">\n                <div class=\"col-md-12 signIn\">\n                    <div class=\"signInText\">Sign In</div>\n                </div>\n                <form [formGroup]=\"form\" (ngSubmit)=\"onSubmit(form.value)\" class=\"form-horizontal\">\n                    <div class=\"form-group row col-md-12 inputbutton emaildiv\"\n                         [ngClass]=\"{'has-error': (!form.get('email').valid && form.get('email').touched), 'has-success': (form.get('email').valid && form.get('email').touched)}\">\n                        <div class=\"input-group\">\n                            <span class=\"input-group-addon\" id=\"basic-addon1\"><i class=\"fa fa-envelope\"\n                                                                                 aria-hidden=\"true\"></i></span>\n                            <input #emailField formControlName=\"email\" type=\"email\" class=\"form-control inputbox right-border\"\n                                   id=\"inputEmail3\" placeholder=\"Email\" autofocus tabindex=\"1\">\n                        </div>\n                        <div class=\"signUpErrorMessage\">\n                            <span *ngIf=\"!form.get('email').valid && form.get('email').touched\"\n                                  class=\"help-block sub-little-signUp-error confpass\">Email is {{!form.get('email').valid && form.get('email').value === ''?'required':'not valid'}}.</span>\n                        </div>\n                    </div>\n                    <div class=\"form-group row col-md-12 inputbutton passwordtext\"\n                         [ngClass]=\"{'has-error': (!form.get('password').valid && form.get('password').touched), 'has-success': (form.get('password').valid && form.get('password').touched)}\">\n                        <div class=\"input-group\">\n                            <span class=\"input-group-addon\" id=\"basic-addon\"><i class=\"fa fa-key\"\n                                                                                aria-hidden=\"true\"></i></span>\n                            <input formControlName=\"password\" type=\"password\" class=\"form-control inputbox right-border\"\n                                   id=\"inputPassword3\" placeholder=\"Password\" maxlength=\"16\" tabindex=\"2\">\n                        </div>\n                        <div class=\"signUpErrorMessage\">\n                            <span *ngIf=\"!form.get('password').valid && form.get('password').touched\"\n                                  class=\"help-block sub-little-signUp-error confpass\">Password is {{!form.get('password').valid && form.get('password').value === ''?'required':'not valid'}}.</span>\n                        </div>\n                    </div>\n                    <div class=\"form-group row col-md-12 inputbutton submitButton\">\n                        <input [ngClass]=\"{'disableSubmit' : (!form.valid || submitted) }\"\n                               [disabled]=\"!form.valid || submitted\" type=\"submit\" class=\"btnStyle\" tabindex=\"3\" value=\"SIGN IN\">\n                    </div>\n                </form>\n            </div>\n            <!--<div class=\"col-md-12 signin\" style=\"display: inline-block;\">-->\n            <!--<div class=\"col-md-12\">-->\n            <!--<span>Don't have an account?</span>-->\n            <!--<a (keyup.enter)=\"navigateToSignUp()\" tabindex=\"4\"><span class=\"forgotPassword\" [routerLink]=\"['/signup']\">Sign Up</span></a>-->\n            <!--</div>-->\n            <!--<div class=\"col-md-12\">-->\n            <!--<a (keyup.enter)=\"navigateToForwardPassword()\" tabindex=\"5\"><span class=\"forgotPassword\" [routerLink]=\"['/forgot-password']\">Don't Remember Password?</span></a>-->\n            <!--</div>-->\n            <!--</div>-->\n            <!--<div class=\"col-md-12 signin\" style=\"display: inline-block;\">-->\n            <!--Or-->\n            <!--</div>-->\n            <!--<div class=\"col-md-12 signin facebook-login\" style=\"display: inline-block;\">-->\n            <!--<i class=\"fa fa-facebook\"></i>-->\n            <!--<button class=\"btnStyle\" (click)=\"onFacebookLoginClick()\">Log In With Facebook</button>-->\n            <!--</div>-->\n        </div>\n        <div style=\"text-align: center;font-size: 13px; margin-top: 10px;\"> © Tudip Technologies 2018. All rights reserved. </div>\n    </div>\n</div>\n"

/***/ }),

/***/ 847:
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
Object.defineProperty(__webpack_exports__, "__esModule", { value: true });
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_0__angular_core__ = __webpack_require__(2);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_1__angular_common__ = __webpack_require__(10);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_2__angular_forms__ = __webpack_require__(24);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_3__theme_nga_module__ = __webpack_require__(129);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_4__login_component__ = __webpack_require__(1021);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_5__login_routing__ = __webpack_require__(1078);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_6_angular_particle__ = __webpack_require__(1099);
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "LoginModule", function() { return LoginModule; });
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};







var LoginModule = (function () {
    function LoginModule() {
    }
    return LoginModule;
}());
LoginModule = __decorate([
    __webpack_require__.i(__WEBPACK_IMPORTED_MODULE_0__angular_core__["NgModule"])({
        imports: [
            __WEBPACK_IMPORTED_MODULE_1__angular_common__["CommonModule"],
            __WEBPACK_IMPORTED_MODULE_2__angular_forms__["ReactiveFormsModule"],
            __WEBPACK_IMPORTED_MODULE_2__angular_forms__["FormsModule"],
            __WEBPACK_IMPORTED_MODULE_3__theme_nga_module__["a" /* NgaModule */],
            __WEBPACK_IMPORTED_MODULE_5__login_routing__["a" /* routing */],
            __WEBPACK_IMPORTED_MODULE_6_angular_particle__["a" /* ParticlesModule */]
        ],
        declarations: [
            __WEBPACK_IMPORTED_MODULE_4__login_component__["a" /* Login */]
        ]
    })
], LoginModule);

//# sourceMappingURL=login.module.js.map

/***/ })

});
//# sourceMappingURL=45.chunk.js.map