webpackJsonp([42,56],{

/***/ 1000:
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_0__angular_core__ = __webpack_require__(2);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_1__angular_forms__ = __webpack_require__(24);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_2__app_authentication__ = __webpack_require__(36);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_3_ng2_toastr_ng2_toastr__ = __webpack_require__(63);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_3_ng2_toastr_ng2_toastr___default = __webpack_require__.n(__WEBPACK_IMPORTED_MODULE_3_ng2_toastr_ng2_toastr__);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_4__appServices_application__ = __webpack_require__(86);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_5__theme_services_baThemeSpinner_baThemeSpinner_service__ = __webpack_require__(130);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_6__angular_router__ = __webpack_require__(20);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_7__theme_validators_equalPasswords_validator__ = __webpack_require__(389);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_8_app_theme_validators_blank_validator__ = __webpack_require__(900);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_9__utilityServices_app_utility__ = __webpack_require__(64);
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "a", function() { return addUser; });
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
var __metadata = (this && this.__metadata) || function (k, v) {
    if (typeof Reflect === "object" && typeof Reflect.metadata === "function") return Reflect.metadata(k, v);
};










var addUser = (function () {
    function addUser(fb, router, userUtility, authentication, appService, toastr, vRef, _spinner) {
        this.fb = fb;
        this.router = router;
        this.userUtility = userUtility;
        this.authentication = authentication;
        this.appService = appService;
        this.toastr = toastr;
        this._spinner = _spinner;
        this.authentication.setChangedContentTopText('Add User');
        this.numberMask = [/[0-9]/, /[0-9]/, /[0-9]/, /[0-9]/, /[0-9]/, /[0-9]/, /[0-9]/, /[0-9]/, /[0-9]/, /[0-9]/, /[0-9]/];
    }
    addUser.prototype.ngOnInit = function () {
        window.scrollTo(0, 0);
        this.userBasicInfo();
    };
    addUser.prototype.ngAfterViewInit = function () {
    };
    // set up form.
    addUser.prototype.userBasicInfo = function () {
        this.form = this.fb.group({
            'firstName': this.fb.control('', __WEBPACK_IMPORTED_MODULE_1__angular_forms__["Validators"].compose([__WEBPACK_IMPORTED_MODULE_8_app_theme_validators_blank_validator__["a" /* BlankSpaceValidator */].validate, __WEBPACK_IMPORTED_MODULE_1__angular_forms__["Validators"].required])),
            'phoneNumber': this.fb.control('', __WEBPACK_IMPORTED_MODULE_1__angular_forms__["Validators"].compose([__WEBPACK_IMPORTED_MODULE_1__angular_forms__["Validators"].pattern('^(?!0+$)[0-9][1-9]{1}[0-9]{8,9}$')])),
            'role': this.fb.control('', __WEBPACK_IMPORTED_MODULE_1__angular_forms__["Validators"].compose([__WEBPACK_IMPORTED_MODULE_1__angular_forms__["Validators"].required])),
            'passwords': this.fb.group({
                'password': ['', __WEBPACK_IMPORTED_MODULE_1__angular_forms__["Validators"].compose([__WEBPACK_IMPORTED_MODULE_1__angular_forms__["Validators"].required, __WEBPACK_IMPORTED_MODULE_1__angular_forms__["Validators"].minLength(8)])],
                'confirm_password': ['', __WEBPACK_IMPORTED_MODULE_1__angular_forms__["Validators"].compose([__WEBPACK_IMPORTED_MODULE_1__angular_forms__["Validators"].required, __WEBPACK_IMPORTED_MODULE_1__angular_forms__["Validators"].minLength(8)])]
            }, { validator: __WEBPACK_IMPORTED_MODULE_7__theme_validators_equalPasswords_validator__["a" /* EqualPasswordsValidator */].validate('password', 'confirm_password') }),
            'status': this.fb.control('', __WEBPACK_IMPORTED_MODULE_1__angular_forms__["Validators"].compose([__WEBPACK_IMPORTED_MODULE_1__angular_forms__["Validators"].required])),
            'email': this.fb.control('', __WEBPACK_IMPORTED_MODULE_1__angular_forms__["Validators"].compose([__WEBPACK_IMPORTED_MODULE_1__angular_forms__["Validators"].required, __WEBPACK_IMPORTED_MODULE_1__angular_forms__["Validators"].pattern('^(([^<>()\\[\\]\\.,;:\\s@\\"]+(\\.[^<>()\\[\\]\\.,;:\\s@\\"]+)*)|(\\".+\\"))@(([^<>()[\\]\\.,-;:\\s@\\"]+\\.)+[^<>()[\\]\\.,;:\\s@\\"]{2,})$')])),
        });
    };
    // submission of add user form.
    addUser.prototype.onSubmit = function (value) {
        var _this = this;
        this._spinner.show();
        var userData = {
            'name': this.makeItCapital(value.firstName.trim()),
            'email': value.email,
            'password': value.passwords.password,
            'contact_number': value.phoneNumber,
            'role': value.role,
            'status': value.status,
        };
        // Api call to edit profile, if success editUserProfile(data) and if error editUserProfileFail(error)
        this.appService.addNewUser(userData).subscribe(function (data) { return _this.addNewUserSuccess(data); }, function (error) { return _this.addNewUserFail(error); });
    };
    addUser.prototype.makeItCapital = function (data) {
        return data.replace(/\w\S*/g, function (txt) {
            return txt.charAt(0).toUpperCase() + txt.substr(1).toLowerCase();
        });
    };
    // if add user success
    addUser.prototype.addNewUserSuccess = function (result) {
        this._spinner.hide();
        if (result.status < 0) {
            if (result.data.code == '-123') {
                this.toastr.error(this.userUtility.errorMessages['DUPLICATE_EMAIL']);
            }
            else if (result.data.code == '-115') {
                this.toastr.error(this.userUtility.errorMessages['INVALID_EMAIL']);
            }
            else if (result.data.code == '-298') {
                this.toastr.error(this.userUtility.errorMessages['DUPLICATE_CONTACT']);
            }
            else {
                this.toastr.error(this.userUtility.errorMessages['USER_ADD_FAIL']);
            }
        }
        else {
            this.toastr.success(this.userUtility.successMessages['USER_ADD_SUCESS']);
            this.router.navigate(['/viewUsers']);
        }
    };
    // if add user fail
    addUser.prototype.addNewUserFail = function (err) {
        this._spinner.hide();
        if (err.error && err.error.message) {
            this.toastr.error(err.error.message);
        }
        else {
            this.toastr.error('Server error');
        }
    };
    return addUser;
}());
__decorate([
    __webpack_require__.i(__WEBPACK_IMPORTED_MODULE_0__angular_core__["ViewChildren"])('firstName'),
    __metadata("design:type", Object)
], addUser.prototype, "firstField", void 0);
addUser = __decorate([
    __webpack_require__.i(__WEBPACK_IMPORTED_MODULE_0__angular_core__["Component"])({
        selector: 'addUser',
        styles: [__webpack_require__(1109)],
        template: __webpack_require__(1158)
    }),
    __metadata("design:paramtypes", [typeof (_a = typeof __WEBPACK_IMPORTED_MODULE_1__angular_forms__["FormBuilder"] !== "undefined" && __WEBPACK_IMPORTED_MODULE_1__angular_forms__["FormBuilder"]) === "function" && _a || Object, typeof (_b = typeof __WEBPACK_IMPORTED_MODULE_6__angular_router__["Router"] !== "undefined" && __WEBPACK_IMPORTED_MODULE_6__angular_router__["Router"]) === "function" && _b || Object, typeof (_c = typeof __WEBPACK_IMPORTED_MODULE_9__utilityServices_app_utility__["a" /* Utility */] !== "undefined" && __WEBPACK_IMPORTED_MODULE_9__utilityServices_app_utility__["a" /* Utility */]) === "function" && _c || Object, typeof (_d = typeof __WEBPACK_IMPORTED_MODULE_2__app_authentication__["a" /* AuthenticationHelper */] !== "undefined" && __WEBPACK_IMPORTED_MODULE_2__app_authentication__["a" /* AuthenticationHelper */]) === "function" && _d || Object, typeof (_e = typeof __WEBPACK_IMPORTED_MODULE_4__appServices_application__["a" /* ApplicationAdminServices */] !== "undefined" && __WEBPACK_IMPORTED_MODULE_4__appServices_application__["a" /* ApplicationAdminServices */]) === "function" && _e || Object, typeof (_f = typeof __WEBPACK_IMPORTED_MODULE_3_ng2_toastr_ng2_toastr__["ToastsManager"] !== "undefined" && __WEBPACK_IMPORTED_MODULE_3_ng2_toastr_ng2_toastr__["ToastsManager"]) === "function" && _f || Object, typeof (_g = typeof __WEBPACK_IMPORTED_MODULE_0__angular_core__["ViewContainerRef"] !== "undefined" && __WEBPACK_IMPORTED_MODULE_0__angular_core__["ViewContainerRef"]) === "function" && _g || Object, typeof (_h = typeof __WEBPACK_IMPORTED_MODULE_5__theme_services_baThemeSpinner_baThemeSpinner_service__["a" /* BaThemeSpinner */] !== "undefined" && __WEBPACK_IMPORTED_MODULE_5__theme_services_baThemeSpinner_baThemeSpinner_service__["a" /* BaThemeSpinner */]) === "function" && _h || Object])
], addUser);

var _a, _b, _c, _d, _e, _f, _g, _h;
//# sourceMappingURL=addUser.component.js.map

/***/ }),

/***/ 1054:
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_0__angular_router__ = __webpack_require__(20);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_1__addUser_component__ = __webpack_require__(1000);
/* unused harmony export routes */
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "a", function() { return routing; });


var routes = [
    {
        path: '',
        component: __WEBPACK_IMPORTED_MODULE_1__addUser_component__["a" /* addUser */],
        children: []
    }
];
var routing = __WEBPACK_IMPORTED_MODULE_0__angular_router__["RouterModule"].forChild(routes);
//# sourceMappingURL=addUser.routing.js.map

/***/ }),

/***/ 1109:
/***/ (function(module, exports, __webpack_require__) {

exports = module.exports = __webpack_require__(17)(false);
// imports


// module
exports.push([module.i, ".auth-main {\n  display: -webkit-box;\n  display: -ms-flexbox;\n  display: flex;\n  -webkit-box-align: center;\n      -ms-flex-align: center;\n          align-items: center;\n  height: 100%;\n  width: 100%;\n  position: absolute; }\n\n.auth-block {\n  width: 540px;\n  margin: 0 auto;\n  border-radius: 5px;\n  background: rgba(0, 0, 0, 0.55);\n  color: #fff;\n  padding: 32px; }\n  .auth-block h1 {\n    font-weight: 300;\n    margin-bottom: 28px;\n    text-align: center; }\n  .auth-block p {\n    font-size: 16px; }\n  .auth-block a {\n    text-decoration: none;\n    outline: none;\n    transition: all 0.2s ease;\n    color: #374767; }\n    .auth-block a:hover {\n      color: #2f3c58; }\n  .auth-block .control-label {\n    padding-top: 11px;\n    color: #ffffff; }\n  .auth-block .form-group {\n    margin-bottom: 12px; }\n\n.auth-input {\n  width: 300px;\n  margin-bottom: 24px; }\n  .auth-input input {\n    display: block;\n    width: 100%;\n    border: none;\n    font-size: 16px;\n    padding: 4px 10px;\n    outline: none; }\n\na.forgot-pass {\n  display: block;\n  text-align: right;\n  margin-bottom: -20px;\n  float: right;\n  z-index: 2;\n  position: relative; }\n\n.auth-link {\n  display: block;\n  font-size: 16px;\n  text-align: center;\n  margin-bottom: 33px; }\n\n.auth-sep {\n  margin-top: 36px;\n  margin-bottom: 24px;\n  line-height: 20px;\n  font-size: 16px;\n  text-align: center;\n  display: block;\n  position: relative; }\n  .auth-sep > span {\n    display: table-cell;\n    width: 30%;\n    white-space: nowrap;\n    padding: 0 24px;\n    color: #ffffff; }\n    .auth-sep > span > span {\n      margin-top: -12px;\n      display: block; }\n  .auth-sep:before, .auth-sep:after {\n    border-top: solid 1px #ffffff;\n    content: \"\";\n    height: 1px;\n    width: 35%;\n    display: table-cell; }\n\n.al-share-auth {\n  text-align: center; }\n  .al-share-auth .al-share {\n    float: none;\n    margin: 0;\n    padding: 0;\n    display: inline-block; }\n    .al-share-auth .al-share li {\n      margin-left: 24px; }\n      .al-share-auth .al-share li:first-child {\n        margin-left: 0; }\n      .al-share-auth .al-share li i {\n        font-size: 24px; }\n\nbody {\n  font-family: 'Conv_Avenir'; }\n\n.paginationControl {\n  width: 100%;\n  float: left; }\n  .paginationControl #listItem .ngx-pagination .current {\n    background: #195C94;\n    color: #fff; }\n  .paginationControl #listItem .ngx-pagination .pagination-previous {\n    border-bottom-left-radius: 3px;\n    border-top-left-radius: 3px; }\n  .paginationControl #listItem .ngx-pagination .pagination-next {\n    border-bottom-right-radius: 3px;\n    border-top-right-radius: 3px; }\n  .paginationControl #listItem .ngx-pagination a {\n    color: #606c71; }\n    .paginationControl #listItem .ngx-pagination a:hover {\n      background: transparent; }\n  .paginationControl #listItem .ngx-pagination .disabled {\n    padding: 0.1875rem 0.625rem;\n    margin-left: 0.9px;\n    color: #cacaca;\n    cursor: not-allowed; }\n  .paginationControl #listItemNew .ngx-pagination .current {\n    background: #195C94;\n    color: #fff; }\n  .paginationControl #listItemNew .ngx-pagination .pagination-previous {\n    border-bottom-left-radius: 3px;\n    border-top-left-radius: 3px; }\n  .paginationControl #listItemNew .ngx-pagination .pagination-next {\n    border-bottom-right-radius: 3px;\n    border-top-right-radius: 3px; }\n  .paginationControl #listItemNew .ngx-pagination a {\n    color: #606c71; }\n    .paginationControl #listItemNew .ngx-pagination a:hover {\n      background: transparent; }\n  .paginationControl #listItemNew .ngx-pagination .disabled {\n    padding: 0.1875rem 0.625rem;\n    margin-left: 0.9px;\n    color: #cacaca;\n    cursor: not-allowed; }\n  .paginationControl #listItem ul li {\n    border: 1px solid #d6d6d6;\n    margin-left: -2px;\n    height: 35px;\n    text-align: center;\n    min-width: 35px;\n    line-height: 27px; }\n    .paginationControl #listItem ul li:hover {\n      background: transparent; }\n  .paginationControl #listItemNew ul li {\n    border: 1px solid #d6d6d6;\n    margin-left: -2px;\n    height: 35px;\n    text-align: center;\n    min-width: 35px;\n    line-height: 27px; }\n    .paginationControl #listItemNew ul li:hover {\n      background: transparent; }\n  .paginationControl .pageControl {\n    cursor: pointer;\n    padding: 0 10px; }\n    .paginationControl .pageControl ul {\n      padding: 10px 0;\n      margin: 0;\n      float: left; }\n\n.rowsPerPagination {\n  display: inline-block;\n  cursor: pointer;\n  padding: 8px;\n  background-color: white;\n  color: #282828;\n  border: 1px solid lightgray; }\n\n.adjust_row_left {\n  margin-right: 5px; }\n\n.adjust_row_right {\n  margin-left: 5px; }\n\n.rowsPerPagination:hover {\n  background-color: lightgray; }\n\n.page_number_select {\n  background-color: #3b5998;\n  color: white; }\n\n.page_number_select:hover {\n  background-color: #3b5998;\n  color: white; }\n\n.per_page_paginate {\n  float: right;\n  margin-bottom: 5px; }\n\n.btn-danger {\n  margin-left: 3px; }\n\n#itemQuantityTable table > tbody > tr > td:nth-child(3) {\n  text-align: right; }\n\n#itemQuantityTable table > tbody > tr > td:nth-child(4) {\n  text-align: right; }\n\n#itemQuantityUsedTable table > tbody > tr > td:nth-child(2) {\n  text-align: right; }\n\n#editItemsTable table > tbody > tr > td:nth-child(2) {\n  text-align: right; }\n\n#vendorPurchaseTable table > tbody > tr > td:nth-child(3) {\n  text-align: right; }\n\n.purchase_table table > tbody > tr > td:nth-child(4) {\n  text-align: right; }\n\n.purchase_table table > tbody > tr > td:nth-child(5) {\n  text-align: right; }\n\n#viewRecurringExpenses table > tbody > tr > td:nth-child(6) {\n  text-align: right; }\n\n#viewRecurringExpenses table > tbody > tr > td:nth-child(7) {\n  text-align: right; }\n\n#viewNormalExpenses table > tbody > tr > td:nth-child(4) {\n  text-align: right; }\n\n#viewNormalExpenses table > tbody > tr > td:nth-child(5) {\n  text-align: right; }\n\n#viewNormalExpenses table > tbody > tr > td:nth-child(6) {\n  text-align: right; }\n\n.btn-primary {\n  margin-right: 3px; }\n\n.btn:hover {\n  -webkit-transform: none;\n          transform: none; }\n\n.help-block {\n  color: red; }\n\n.modal-header {\n  margin: 0 auto; }\n\n.fa-rupee:before, .fa-inr:before {\n  content: \"\\F156\";\n  margin-right: 14px !important; }\n\n.ion-edit:before {\n  content: \"\\F2BF\";\n  color: #000000; }\n\n.text-spacing {\n  margin-bottom: 1%; }\n\n.disableSubmit {\n  opacity: 0.8;\n  cursor: not-allowed; }\n  .disableSubmit:hover {\n    opacity: 0.8;\n    cursor: not-allowed !important; }\n\n.purchase_table .ion-edit:before {\n  content: \"\\F2BF\";\n  margin-right: 10px;\n  color: #000000; }\n\n.ion-trash-b:before {\n  content: \"\\F252\";\n  color: #ff0000; }\n\n.fa-envelope-o:before {\n  margin-right: 10px; }\n\n.fa-copy:before {\n  margin-right: 10px; }\n\n.form-control[disabled] {\n  color: grey;\n  border-color: lightgrey; }\n\n#vendorPurchaseTable table > thead > tr > th:first-child {\n  text-align: center; }\n\n.tagsSmart {\n  background: #F1F3F6;\n  color: #282828;\n  display: inline-block;\n  border: 1px solid lightgray;\n  padding: 0 10px 0 10px;\n  margin: 2px 2px 2px 2px;\n  border-radius: 90px; }\n\ntable th, table td {\n  border: 1px solid #ddd; }\n\ntable .ng2-smart-actions {\n  text-align: center;\n  color: #374767; }\n\ntable .ng2-smart-title a {\n  color: #374767; }\n\ntable .ng2-smart-title a:hover {\n  text-decoration: none; }\n\n.modal-body-data {\n  margin-bottom: 15px; }\n\ntable .ng2-smart-actions {\n  width: 100px !important; }\n\n.inputbox {\n  border-radius: 3px;\n  background-color: white;\n  width: 100%;\n  height: 100%;\n  margin-bottom: 0px;\n  padding-left: 2%;\n  border: 1px solid gainsboro;\n  outline: none;\n  box-shadow: none;\n  color: #555555; }\n\n.inputbox::-webkit-input-placeholder {\n  /* Chrome/Opera/Safari */\n  color: gainsboro; }\n\n.inputbox::-moz-placeholder {\n  /* Firefox 19+ */\n  color: gainsboro; }\n\n.inputbox:-ms-input-placeholder {\n  /* IE 10+ */\n  color: gainsboro; }\n\n.inputbox:-moz-placeholder {\n  /* Firefox 18- */\n  color: gainsboro; }\n\n.inputbox:focus, .inputbox:active {\n  border-color: #A5C9BB;\n  outline: 0;\n  outline: thin dotted \\9;\n  /* -webkit-box-shadow: inset 0 1px 1px rgba(0,0,0,.075), 0 0 8px rgba(82,168,236,.6); */\n  box-shadow: inset 0 1px 1px rgba(0, 220, 0, 0.075), 0 0 8px rgba(0, 225, 0, 0.2); }\n\n.inputbutton {\n  height: 58px;\n  line-height: 2.8;\n  margin: 3% 0 -2% 0; }\n\n.btnStyle {\n  width: 100%;\n  height: 100%;\n  background-color: #195C94;\n  color: white;\n  font-size: medium;\n  font-weight: bold;\n  border: none;\n  border-radius: 3px;\n  cursor: pointer; }\n  .btnStyle:focus {\n    outline: none;\n    box-shadow: 0px 0px 2px 2px #59a453; }\n\n.btnBackStyle {\n  width: 100%;\n  height: 100%;\n  background-color: white;\n  border: 1px solid #195C94;\n  color: #195C94;\n  font-size: medium;\n  font-weight: bold;\n  border-radius: 3px;\n  cursor: pointer; }\n  .btnBackStyle:focus {\n    outline: none;\n    box-shadow: 0px 0px 2px 2px #59a453; }\n\n.passwordErrorMessage {\n  float: left;\n  margin-top: -35px;\n  width: 100%;\n  margin-bottom: 10px; }\n\n.backButtonTop {\n  margin-bottom: 25px;\n  border: 1px solid #3b5998;\n  color: #3b5998;\n  display: inline-block; }\n\nselect option:checked:after {\n  background: #3b5998 -webkit-linear-gradient(bottom, #3b5998 0%, #3b5998 100%);\n  color: white; }\n\n.divAlignLeft {\n  float: left; }\n\n.divAlignRight {\n  float: right; }\n\n.Quotedatepicker .mydp .currmonth:hover {\n  background-color: #195C94 !important;\n  color: white !important; }\n\n.Quotedatepicker .mydp .selectiongroup {\n  cursor: not-allowed; }\n\n.Quotedatepicker .mydp .selector {\n  z-index: 1;\n  boder-radius: 3px; }\n\n.Quotedatepicker .mydp .selection {\n  height: 33px !important;\n  color: #282828;\n  font-size: 13px !important;\n  font-family: \"Conv_Avenir\" !important;\n  position: relative;\n  text-align: left;\n  padding-left: 8px;\n  pointer-events: none;\n  cursor: not-allowed;\n  boder-radius: 3px; }\n\n.Quotedatepicker .mydp .selbtngroup {\n  height: 33px !important; }\n\n.Quotedatepicker .mydp .btnclear {\n  color: #757575; }\n\n.Quotedatepicker .mydp .btnclear:hover {\n  background-color: #195C94 !important; }\n\n.Quotedatepicker .mydp .btnpicker {\n  height: 33px !important; }\n\n.Quotedatepicker .mydp .btnclearenabled:hover {\n  background-color: #195C94;\n  color: #fff; }\n\n.Quotedatepicker .mydp .btnpicker {\n  color: #757575; }\n\n.Quotedatepicker .mydp .btnpicker:hover {\n  background-color: #2f96b4 !important; }\n\n.Quotedatepicker .mydp .btnpickerenabled:hover {\n  background-color: #2f96b4;\n  color: #fff; }\n\n.Quotedatepicker .help-block {\n  color: red; }\n\nrl-tag-input-item {\n  margin-bottom: 3px; }\n\nselect[multiple]:focus option:checked {\n  background: #3b5998 linear-gradient(0deg, #3b5998 0%, #3b5998 100%); }\n\nrl-tag-input input {\n  font-family: 'Conv_Avenir' !important;\n  font-size: 14px !important; }\n\nrl-tag-input input::-webkit-input-placeholder {\n  color: grey; }\n\nrl-tag-input-item {\n  font-family: 'Conv_Avenir' !important;\n  font-size: 14px !important; }\n\n.required:after {\n  content: \"*\";\n  color: red; }\n\n.auth-main {\n  display: -webkit-box;\n  display: -ms-flexbox;\n  display: flex;\n  -webkit-box-align: center;\n      -ms-flex-align: center;\n          align-items: center;\n  height: 100%;\n  width: 100%;\n  position: absolute; }\n\n.auth-block {\n  width: 540px;\n  margin: 0 auto;\n  border-radius: 5px;\n  background: rgba(0, 0, 0, 0.55);\n  color: #fff;\n  padding: 32px; }\n  .auth-block h1 {\n    font-weight: 300;\n    margin-bottom: 28px;\n    text-align: center; }\n  .auth-block p {\n    font-size: 16px; }\n  .auth-block a {\n    text-decoration: none;\n    outline: none;\n    transition: all 0.2s ease;\n    color: #374767; }\n    .auth-block a:hover {\n      color: #2f3c58; }\n  .auth-block .control-label {\n    padding-top: 11px;\n    color: #ffffff; }\n  .auth-block .form-group {\n    margin-bottom: 12px; }\n\n.auth-input {\n  width: 300px;\n  margin-bottom: 24px; }\n  .auth-input input {\n    display: block;\n    width: 100%;\n    border: none;\n    font-size: 16px;\n    padding: 4px 10px;\n    outline: none; }\n\na.forgot-pass {\n  display: block;\n  text-align: right;\n  margin-bottom: -20px;\n  float: right;\n  z-index: 2;\n  position: relative; }\n\n.auth-link {\n  display: block;\n  font-size: 16px;\n  text-align: center;\n  margin-bottom: 33px; }\n\n.auth-sep {\n  margin-top: 36px;\n  margin-bottom: 24px;\n  line-height: 20px;\n  font-size: 16px;\n  text-align: center;\n  display: block;\n  position: relative; }\n  .auth-sep > span {\n    display: table-cell;\n    width: 30%;\n    white-space: nowrap;\n    padding: 0 24px;\n    color: #ffffff; }\n    .auth-sep > span > span {\n      margin-top: -12px;\n      display: block; }\n  .auth-sep:before, .auth-sep:after {\n    border-top: solid 1px #ffffff;\n    content: \"\";\n    height: 1px;\n    width: 35%;\n    display: table-cell; }\n\n.al-share-auth {\n  text-align: center; }\n  .al-share-auth .al-share {\n    float: none;\n    margin: 0;\n    padding: 0;\n    display: inline-block; }\n    .al-share-auth .al-share li {\n      margin-left: 24px; }\n      .al-share-auth .al-share li:first-child {\n        margin-left: 0; }\n      .al-share-auth .al-share li i {\n        font-size: 24px; }\n\nbody {\n  font-family: 'Conv_Avenir'; }\n\n.addUserContainer {\n  margin: 115px 2.5% 50px 2.5%;\n  padding: 15px;\n  background: white;\n  min-width: 95%;\n  border-radius: 3px;\n  box-shadow: 0px 0px 2px 2px rgba(0, 0, 0, 0.1); }\n  .addUserContainer .profileImage {\n    font-size: 15px;\n    color: #777777; }\n  .addUserContainer .inputbutton {\n    text-align: center;\n    margin: 1.9% 0 2% 0; }\n  .addUserContainer .form-control {\n    border-radius: 3px; }\n  .addUserContainer .form-control[disabled] {\n    color: grey;\n    border-color: lightgrey; }\n  .addUserContainer .disableSubmit {\n    opacity: 0.8;\n    cursor: not-allowed; }\n    .addUserContainer .disableSubmit:hover {\n      opacity: 0.8;\n      cursor: not-allowed; }\n  .addUserContainer .profileContent {\n    margin-top: 2%;\n    margin-left: 2.5%;\n    margin-right: 0%; }\n  .addUserContainer .btnStyle {\n    float: right;\n    width: 150px;\n    height: 85%; }\n    @media screen and (max-width: 767px) {\n      .addUserContainer .btnStyle {\n        width: 80%; } }\n  .addUserContainer .small {\n    font-size: 100%; }\n  .addUserContainer .profileDiv {\n    padding-bottom: 25px; }\n  .addUserContainer .disableSubmit {\n    opacity: 0.8;\n    cursor: not-allowed; }\n    .addUserContainer .disableSubmit:hover {\n      opacity: 0.8;\n      cursor: not-allowed; }\n  .addUserContainer .help-block {\n    color: red; }\n  .addUserContainer .sub-little-text {\n    font-size: 12px; }\n\n@media only screen and (min-device-width: 310px) and (max-device-width: 320px) {\n  .profileForm {\n    padding-right: 0 !important; } }\n\n.has-error .form-control {\n  border-left: 5px solid #f7043a; }\n\n.adjustBottom {\n  margin-bottom: 15px; }\n\n.has-error .form-control:focus {\n  box-shadow: aliceblue; }\n\n#inputPassword3 {\n  color: #282828; }\n\n.btnBackStyle {\n  float: left;\n  width: 150px;\n  height: 85%; }\n  @media screen and (max-width: 767px) {\n    .btnBackStyle {\n      width: 35%; } }\n\n.has-success .form-control {\n  border-left: 5px solid #a6c733; }\n\n.has-success .form-control:focus {\n  border: 1px solid #a6c733;\n  border-left: 5px solid #a6c733; }\n", ""]);

// exports


/*** EXPORTS FROM exports-loader ***/
module.exports = module.exports.toString();

/***/ }),

/***/ 1158:
/***/ (function(module, exports) {

module.exports = "<div class=\"addUserContainer\">\n    <div class=\"profileContent\">\n        <form [formGroup]=\"form\" (ngSubmit)=\"onSubmit(form.value)\">\n            <div  class=\"col-md-12 row profileForm\">\n                <div class=\"col-md-6 adjustBottom\">\n                    <div>\n                        <label class=\"labelStyle required\"> <b>Name</b> </label>\n                    </div>\n                    <div [ngClass]=\"{'has-error': (form.controls['firstName'].invalid &&\n                    form.controls['firstName'].touched),\n                    'has-success': (form.controls['firstName'].valid &&\n                    form.controls['firstName'].touched)}\">\n                        <input placeholder=\"Name\" maxlength=\"100\"\n                               formControlName=\"firstName\" type=\"text\" class=\"form-control text-capitalize\">\n                    </div>\n                    <div class=\"profileErrorMessage\">\n                         <span *ngIf=\"form.get('firstName').touched && form.get('firstName').invalid \"\n                               class=\"help-block sub-little-signUp-error confpass\">Name is Required </span>\n                    </div>\n                </div>\n\n                <!--<div class=\"col-md-6 adjustBottom\">-->\n                    <!--<div>-->\n                        <!--<label class=\"labelStyle required\"> <b>Last Name</b> </label>-->\n                    <!--</div>-->\n                    <!--<div [ngClass]=\"{'has-error': (form.controls['lastName'].invalid &&-->\n                    <!--form.controls['lastName'].touched),-->\n                    <!--'has-success': (form.controls['lastName'].valid &&-->\n                    <!--form.controls['lastName'].touched)}\">-->\n                        <!--<input placeholder=\"Last Name\" maxlength=\"100\"-->\n                               <!--formControlName=\"lastName\" type=\"text\" class=\"form-control text-capitalize\">-->\n                    <!--</div>-->\n                    <!--<div class=\"profileErrorMessage\">-->\n                         <!--<span *ngIf=\"form.get('lastName').touched && form.get('lastName').invalid\"-->\n                               <!--class=\"help-block sub-little-signUp-error confpass\">Last Name is Required </span>-->\n                    <!--</div>-->\n                <!--</div>-->\n                <div class=\"col-md-6 adjustBottom\">\n                    <div>\n                        <label class=\"labelStyle required\"> <b>Email</b> </label>\n                    </div>\n                    <div [ngClass]=\"{'has-error': (form.controls['email'].invalid && form.controls['email'].touched), 'has-success': (form.controls['email'].valid && form.controls['email'].touched)}\">\n                        <input placeholder=\"Email\" formControlName=\"email\" type=\"text\" class=\"form-control\">\n                    </div>\n                    <div class=\"profileErrorMessage\">\n                        <span *ngIf=\"!form.get('email').valid && form.get('email').touched && form.get('email').value != ''\"\n                              class=\"help-block sub-little-signUp-error confpass\"> Please Enter Valid Email Id </span>\n                        <span *ngIf=\"form.get('email').touched && form.get('email').value == '' \"\n                              class=\"help-block sub-little-signUp-error confpass\">Email Id is Required </span>\n                    </div>\n                </div>\n                <div class=\"col-md-6 adjustBottom\">\n                    <div>\n                        <label class=\"labelStyle\"> <b>Contact Number</b> </label>\n                    </div>\n                    <div [ngClass]=\"{'has-error': (form.controls['phoneNumber'].invalid && form.controls['phoneNumber'].touched), 'has-success': (form.controls['phoneNumber'].valid && form.controls['phoneNumber'].touched)}\">\n                        <input placeholder=\"Contact Number\" [textMask]=\"{mask: numberMask,guide : false}\" formControlName=\"phoneNumber\" type=\"text\" class=\"form-control\">\n                    </div>\n                    <div class=\"profileErrorMessage\">\n                        <span *ngIf=\"!form.get('phoneNumber').valid && form.get('phoneNumber').touched && form.get('phoneNumber').value != ''\"\n                              class=\"help-block sub-little-signUp-error confpass\"> Please Enter Valid Contact Number </span>\n                    </div>\n                </div>\n                <div class=\"col-md-3 adjustBottom\">\n                    <div>\n                        <label class=\"labelStyle required\"> <b>Status</b> </label>\n                    </div>\n                    <div [ngClass]=\"{'has-error': (form.controls['status'].invalid &&\n                    form.controls['status'].touched), 'has-success': (form.controls['status'].valid\n                    && form.controls['status'].touched)}\">\n                        <select formControlName=\"status\" style=\"width: 100%;\" class=\"form-control selectBox\">\n                            <option value=\"\" disabled selected>Select</option>\n                            <option value=\"Active\"> Active </option>\n                            <option value=\"InActive\"> InActive</option>\n                        </select>\n                    </div>\n                    <div class=\"profileErrorMessage\">\n                        <span *ngIf=\"!form.get('status').valid && form.get('status').touched\"\n                              class=\"help-block sub-little-signUp-error confpass\">Status is Required</span>\n                    </div>\n                </div>\n                <div class=\"col-md-3 adjustBottom\">\n                    <div>\n                        <label class=\"labelStyle required\"> <b>Role</b> </label>\n                    </div>\n                    <div [ngClass]=\"{'has-error': (form.controls['role'].invalid &&\n                    form.controls['role'].touched), 'has-success': (form.controls['role'].valid\n                    && form.controls['role'].touched)}\">\n                        <select formControlName=\"role\" style=\"width: 100%;\" class=\"form-control selectBox\">\n                            <option value=\"\" disabled selected>Select</option>\n                            <option value=\"2\"> Admin </option>\n                            <option value=\"1\"> Super-Admin </option>\n                        </select>\n                    </div>\n                    <div class=\"profileErrorMessage\">\n                        <span *ngIf=\"!form.get('role').valid && form.get('role').touched\"\n                              class=\"help-block sub-little-signUp-error confpass\">Role is Required</span>\n                    </div>\n                </div>\n                <div style=\"margin: 0\"  class=\"col-md-12 adjustBottom row\" formGroupName=\"passwords\">\n                    <div style=\"padding-left: 0\" class=\"col-md-6\">\n                        <div>\n                            <label class=\"labelStyle required\"> <b>Password</b> </label>\n                        </div>\n                        <div [ngClass]=\"{'has-error': (!form.get('passwords').get('password').valid\n                    && form.get('passwords').get('password').touched),\n                    'has-success': (form.get('passwords').get('password').valid\n                    && form.get('passwords').get('password').touched)}\">\n\n                            <input formControlName=\"password\" type=\"password\" class=\"form-control right-border\"\n                                   id=\"inputPassword3\" placeholder=\"Password\" autocomplete=\"off\" maxlength=\"16\"\n                                   >\n                        </div>\n                        <div class=\"profileErrorMessage\">\n                        <span *ngIf=\"!form.get('passwords').get('password').valid &&\n                        form.get('passwords').get('password').touched\"\n                              class=\"help-block sub-little-signUp-error confpass\">Password must be 8 characters long.</span>\n                        </div>\n                    </div>\n\n                    <div style=\"padding-right: 0\" class=\"col-md-6\">\n                        <div>\n                            <label class=\"labelStyle required\"> <b>Confirm Password</b> </label>\n                        </div>\n                        <div [ngClass]=\"{'has-error': (!form.get('passwords').valid &&\n                        (form.get('passwords').get('password').touched && form.get('passwords').get('confirm_password').touched)),\n                    'has-success': (form.get('passwords').valid && (form.get('passwords').get('confirm_password').valid\n                    && form.get('passwords').get('confirm_password').touched))}\">\n                            <input formControlName=\"confirm_password\" type=\"password\" class=\"form-control right-border\"\n                                   placeholder=\"Confirm Password\" autocomplete=\"off\" maxlength=\"16\" >\n                        </div>\n                        <div class=\"profileErrorMessage\">\n                        <span *ngIf=\"!form.get('passwords').valid &&\n                        (form.get('passwords').get('password').touched && form.get('passwords').get('confirm_password').touched)\"\n                              class=\"help-block sub-little-signUp-error confpass\">Password doesn't match.</span>\n                        </div>\n                    </div>\n                </div>\n\n\n\n                <div class=\"col-md-12 form-group inputbutton submitButton\">\n                    <button type=\"button\" [routerLink]=\"['/viewUsers']\" class=\"btnBackStyle\"> Cancel </button>\n                    <button [ngClass]=\"{'disableSubmit' : (!form.valid) }\"\n                           [disabled]=\"!form.valid\" type=\"submit\" class=\"btnStyle\">Add User</button>\n                </div>\n\n            </div>\n        </form>\n    </div>\n</div>\n"

/***/ }),

/***/ 826:
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
Object.defineProperty(__webpack_exports__, "__esModule", { value: true });
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_0__angular_core__ = __webpack_require__(2);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_1__angular_common__ = __webpack_require__(10);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_2__angular_forms__ = __webpack_require__(24);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_3__theme_nga_module__ = __webpack_require__(129);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_4__addUser_component__ = __webpack_require__(1000);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_5__addUser_routing__ = __webpack_require__(1054);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_6_angular2_text_mask__ = __webpack_require__(950);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_6_angular2_text_mask___default = __webpack_require__.n(__WEBPACK_IMPORTED_MODULE_6_angular2_text_mask__);
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "AddUserModule", function() { return AddUserModule; });
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};







var AddUserModule = (function () {
    function AddUserModule() {
    }
    return AddUserModule;
}());
AddUserModule = __decorate([
    __webpack_require__.i(__WEBPACK_IMPORTED_MODULE_0__angular_core__["NgModule"])({
        imports: [
            __WEBPACK_IMPORTED_MODULE_1__angular_common__["CommonModule"],
            __WEBPACK_IMPORTED_MODULE_2__angular_forms__["FormsModule"],
            __WEBPACK_IMPORTED_MODULE_3__theme_nga_module__["a" /* NgaModule */],
            __WEBPACK_IMPORTED_MODULE_5__addUser_routing__["a" /* routing */],
            __WEBPACK_IMPORTED_MODULE_6_angular2_text_mask__["TextMaskModule"],
            __WEBPACK_IMPORTED_MODULE_2__angular_forms__["ReactiveFormsModule"]
        ],
        declarations: [
            __WEBPACK_IMPORTED_MODULE_4__addUser_component__["a" /* addUser */]
        ],
        providers: []
    })
], AddUserModule);

//# sourceMappingURL=addUser.module.js.map

/***/ }),

/***/ 899:
/***/ (function(module, exports, __webpack_require__) {

!function(e,r){ true?module.exports=r():"function"==typeof define&&define.amd?define([],r):"object"==typeof exports?exports.textMaskCore=r():e.textMaskCore=r()}(this,function(){return function(e){function r(n){if(t[n])return t[n].exports;var o=t[n]={exports:{},id:n,loaded:!1};return e[n].call(o.exports,o,o.exports,r),o.loaded=!0,o.exports}var t={};return r.m=e,r.c=t,r.p="",r(0)}([function(e,r,t){"use strict";function n(e){return e&&e.__esModule?e:{default:e}}Object.defineProperty(r,"__esModule",{value:!0});var o=t(3);Object.defineProperty(r,"conformToMask",{enumerable:!0,get:function(){return n(o).default}});var i=t(2);Object.defineProperty(r,"adjustCaretPosition",{enumerable:!0,get:function(){return n(i).default}});var a=t(5);Object.defineProperty(r,"createTextMaskInputElement",{enumerable:!0,get:function(){return n(a).default}})},function(e,r){"use strict";Object.defineProperty(r,"__esModule",{value:!0}),r.placeholderChar="_",r.strFunction="function"},function(e,r){"use strict";function t(e){var r=e.previousConformedValue,t=void 0===r?o:r,i=e.previousPlaceholder,a=void 0===i?o:i,u=e.currentCaretPosition,l=void 0===u?0:u,s=e.conformedValue,f=e.rawValue,d=e.placeholderChar,c=e.placeholder,p=e.indexesOfPipedChars,v=void 0===p?n:p,h=e.caretTrapIndexes,m=void 0===h?n:h;if(0===l||!f.length)return 0;var y=f.length,g=t.length,b=c.length,C=s.length,P=y-g,k=P>0,x=0===g,O=P>1&&!k&&!x;if(O)return l;var T=k&&(t===s||s===c),w=0,M=void 0,S=void 0;if(T)w=l-P;else{var j=s.toLowerCase(),_=f.toLowerCase(),V=_.substr(0,l).split(o),A=V.filter(function(e){return j.indexOf(e)!==-1});S=A[A.length-1];var N=a.substr(0,A.length).split(o).filter(function(e){return e!==d}).length,E=c.substr(0,A.length).split(o).filter(function(e){return e!==d}).length,F=E!==N,R=void 0!==a[A.length-1]&&void 0!==c[A.length-2]&&a[A.length-1]!==d&&a[A.length-1]!==c[A.length-1]&&a[A.length-1]===c[A.length-2];!k&&(F||R)&&N>0&&c.indexOf(S)>-1&&void 0!==f[l]&&(M=!0,S=f[l]);for(var I=v.map(function(e){return j[e]}),J=I.filter(function(e){return e===S}).length,W=A.filter(function(e){return e===S}).length,q=c.substr(0,c.indexOf(d)).split(o).filter(function(e,r){return e===S&&f[r]!==e}).length,L=q+W+J+(M?1:0),z=0,B=0;B<C;B++){var D=j[B];if(w=B+1,D===S&&z++,z>=L)break}}if(k){for(var G=w,H=w;H<=b;H++)if(c[H]===d&&(G=H),c[H]===d||m.indexOf(H)!==-1||H===b)return G}else if(M){for(var K=w-1;K>=0;K--)if(s[K]===S||m.indexOf(K)!==-1||0===K)return K}else for(var Q=w;Q>=0;Q--)if(c[Q-1]===d||m.indexOf(Q)!==-1||0===Q)return Q}Object.defineProperty(r,"__esModule",{value:!0}),r.default=t;var n=[],o=""},function(e,r,t){"use strict";function n(){var e=arguments.length>0&&void 0!==arguments[0]?arguments[0]:l,r=arguments.length>1&&void 0!==arguments[1]?arguments[1]:u,t=arguments.length>2&&void 0!==arguments[2]?arguments[2]:{};if(!(0,i.isArray)(r)){if(("undefined"==typeof r?"undefined":o(r))!==a.strFunction)throw new Error("Text-mask:conformToMask; The mask property must be an array.");r=r(e,t),r=(0,i.processCaretTraps)(r).maskWithoutCaretTraps}var n=t.guide,s=void 0===n||n,f=t.previousConformedValue,d=void 0===f?l:f,c=t.placeholderChar,p=void 0===c?a.placeholderChar:c,v=t.placeholder,h=void 0===v?(0,i.convertMaskToPlaceholder)(r,p):v,m=t.currentCaretPosition,y=t.keepCharPositions,g=s===!1&&void 0!==d,b=e.length,C=d.length,P=h.length,k=r.length,x=b-C,O=x>0,T=m+(O?-x:0),w=T+Math.abs(x);if(y===!0&&!O){for(var M=l,S=T;S<w;S++)h[S]===p&&(M+=p);e=e.slice(0,T)+M+e.slice(T,b)}for(var j=e.split(l).map(function(e,r){return{char:e,isNew:r>=T&&r<w}}),_=b-1;_>=0;_--){var V=j[_].char;if(V!==p){var A=_>=T&&C===k;V===h[A?_-x:_]&&j.splice(_,1)}}var N=l,E=!1;e:for(var F=0;F<P;F++){var R=h[F];if(R===p){if(j.length>0)for(;j.length>0;){var I=j.shift(),J=I.char,W=I.isNew;if(J===p&&g!==!0){N+=p;continue e}if(r[F].test(J)){if(y===!0&&W!==!1&&d!==l&&s!==!1&&O){for(var q=j.length,L=null,z=0;z<q;z++){var B=j[z];if(B.char!==p&&B.isNew===!1)break;if(B.char===p){L=z;break}}null!==L?(N+=J,j.splice(L,1)):F--}else N+=J;continue e}E=!0}g===!1&&(N+=h.substr(F,P));break}N+=R}if(g&&O===!1){for(var D=null,G=0;G<N.length;G++)h[G]===p&&(D=G);N=null!==D?N.substr(0,D+1):l}return{conformedValue:N,meta:{someCharsRejected:E}}}Object.defineProperty(r,"__esModule",{value:!0});var o="function"==typeof Symbol&&"symbol"==typeof Symbol.iterator?function(e){return typeof e}:function(e){return e&&"function"==typeof Symbol&&e.constructor===Symbol&&e!==Symbol.prototype?"symbol":typeof e};r.default=n;var i=t(4),a=t(1),u=[],l=""},function(e,r,t){"use strict";function n(){var e=arguments.length>0&&void 0!==arguments[0]?arguments[0]:f,r=arguments.length>1&&void 0!==arguments[1]?arguments[1]:s.placeholderChar;if(!o(e))throw new Error("Text-mask:convertMaskToPlaceholder; The mask property must be an array.");if(e.indexOf(r)!==-1)throw new Error("Placeholder character must not be used as part of the mask. Please specify a character that is not present in your mask as your placeholder character.\n\n"+("The placeholder character that was received is: "+JSON.stringify(r)+"\n\n")+("The mask that was received is: "+JSON.stringify(e)));return e.map(function(e){return e instanceof RegExp?r:e}).join("")}function o(e){return Array.isArray&&Array.isArray(e)||e instanceof Array}function i(e){return"string"==typeof e||e instanceof String}function a(e){return"number"==typeof e&&void 0===e.length&&!isNaN(e)}function u(e){return"undefined"==typeof e||null===e}function l(e){for(var r=[],t=void 0;t=e.indexOf(d),t!==-1;)r.push(t),e.splice(t,1);return{maskWithoutCaretTraps:e,indexes:r}}Object.defineProperty(r,"__esModule",{value:!0}),r.convertMaskToPlaceholder=n,r.isArray=o,r.isString=i,r.isNumber=a,r.isNil=u,r.processCaretTraps=l;var s=t(1),f=[],d="[]"},function(e,r,t){"use strict";function n(e){return e&&e.__esModule?e:{default:e}}function o(e){var r={previousConformedValue:void 0,previousPlaceholder:void 0};return{state:r,update:function(t){var n=arguments.length>1&&void 0!==arguments[1]?arguments[1]:e,o=n.inputElement,s=n.mask,d=n.guide,m=n.pipe,g=n.placeholderChar,b=void 0===g?v.placeholderChar:g,C=n.keepCharPositions,P=void 0!==C&&C,k=n.showMask,x=void 0!==k&&k;if("undefined"==typeof t&&(t=o.value),t!==r.previousConformedValue){("undefined"==typeof s?"undefined":l(s))===y&&void 0!==s.pipe&&void 0!==s.mask&&(m=s.pipe,s=s.mask);var O=void 0,T=void 0;if(s instanceof Array&&(O=(0,p.convertMaskToPlaceholder)(s,b)),s!==!1){var w=a(t),M=o.selectionEnd,S=r.previousConformedValue,j=r.previousPlaceholder,_=void 0;if(("undefined"==typeof s?"undefined":l(s))===v.strFunction){if(T=s(w,{currentCaretPosition:M,previousConformedValue:S,placeholderChar:b}),T===!1)return;var V=(0,p.processCaretTraps)(T),A=V.maskWithoutCaretTraps,N=V.indexes;T=A,_=N,O=(0,p.convertMaskToPlaceholder)(T,b)}else T=s;var E={previousConformedValue:S,guide:d,placeholderChar:b,pipe:m,placeholder:O,currentCaretPosition:M,keepCharPositions:P},F=(0,c.default)(w,T,E),R=F.conformedValue,I=("undefined"==typeof m?"undefined":l(m))===v.strFunction,J={};I&&(J=m(R,u({rawValue:w},E)),J===!1?J={value:S,rejected:!0}:(0,p.isString)(J)&&(J={value:J}));var W=I?J.value:R,q=(0,f.default)({previousConformedValue:S,previousPlaceholder:j,conformedValue:W,placeholder:O,rawValue:w,currentCaretPosition:M,placeholderChar:b,indexesOfPipedChars:J.indexesOfPipedChars,caretTrapIndexes:_}),L=W===O&&0===q,z=x?O:h,B=L?z:W;r.previousConformedValue=B,r.previousPlaceholder=O,o.value!==B&&(o.value=B,i(o,q))}}}}}function i(e,r){document.activeElement===e&&(g?b(function(){return e.setSelectionRange(r,r,m)},0):e.setSelectionRange(r,r,m))}function a(e){if((0,p.isString)(e))return e;if((0,p.isNumber)(e))return String(e);if(void 0===e||null===e)return h;throw new Error("The 'value' provided to Text Mask needs to be a string or a number. The value received was:\n\n "+JSON.stringify(e))}Object.defineProperty(r,"__esModule",{value:!0});var u=Object.assign||function(e){for(var r=1;r<arguments.length;r++){var t=arguments[r];for(var n in t)Object.prototype.hasOwnProperty.call(t,n)&&(e[n]=t[n])}return e},l="function"==typeof Symbol&&"symbol"==typeof Symbol.iterator?function(e){return typeof e}:function(e){return e&&"function"==typeof Symbol&&e.constructor===Symbol&&e!==Symbol.prototype?"symbol":typeof e};r.default=o;var s=t(2),f=n(s),d=t(3),c=n(d),p=t(4),v=t(1),h="",m="none",y="object",g="undefined"!=typeof navigator&&/Android/i.test(navigator.userAgent),b="undefined"!=typeof requestAnimationFrame?requestAnimationFrame:setTimeout}])});

/***/ }),

/***/ 900:
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "a", function() { return BlankSpaceValidator; });
/**
 * Created by lt-68 on 3/11/17.
 */
var BlankSpaceValidator = (function () {
    function BlankSpaceValidator() {
    }
    BlankSpaceValidator.validate = function (c) {
        var isWhitespace = (c.value || '').trim().length === 0;
        var isValid = !isWhitespace;
        return isValid ? null : { validateBlankSpace: { valid: false } };
        // let blankSpace_REGEXP = /.*\S.*/;
        // let blankSpace_REGEXP = /.*\S.*/;
        // return blankSpace_REGEXP.test(c.value) ? null : {validateBlankSpace: {valid: false}};
    };
    return BlankSpaceValidator;
}());

//# sourceMappingURL=blank.validator.js.map

/***/ }),

/***/ 950:
/***/ (function(module, exports, __webpack_require__) {

"use strict";

Object.defineProperty(exports, "__esModule", { value: true });
var core_1 = __webpack_require__(2);
var forms_1 = __webpack_require__(24);
var platform_browser_1 = __webpack_require__(37);
var textMaskCore_1 = __webpack_require__(899);
var TextMaskConfig = /** @class */ (function () {
    function TextMaskConfig() {
    }
    return TextMaskConfig;
}());
exports.TextMaskConfig = TextMaskConfig;
exports.MASKEDINPUT_VALUE_ACCESSOR = {
    provide: forms_1.NG_VALUE_ACCESSOR,
    useExisting: core_1.forwardRef(function () { return MaskedInputDirective; }),
    multi: true
};
/**
 * We must check whether the agent is Android because composition events
 * behave differently between iOS and Android.
 */
function _isAndroid() {
    var userAgent = platform_browser_1.ɵgetDOM() ? platform_browser_1.ɵgetDOM().getUserAgent() : '';
    return /android (\d+)/.test(userAgent.toLowerCase());
}
var MaskedInputDirective = /** @class */ (function () {
    function MaskedInputDirective(_renderer, _elementRef, _compositionMode) {
        this._renderer = _renderer;
        this._elementRef = _elementRef;
        this._compositionMode = _compositionMode;
        this.textMaskConfig = {
            mask: [],
            guide: true,
            placeholderChar: '_',
            pipe: undefined,
            keepCharPositions: false,
        };
        this.onChange = function (_) { };
        this.onTouched = function () { };
        /** Whether the user is creating a composition string (IME events). */
        this._composing = false;
        if (this._compositionMode == null) {
            this._compositionMode = !_isAndroid();
        }
    }
    MaskedInputDirective.prototype.ngOnChanges = function (changes) {
        this._setupMask(true);
        if (this.textMaskInputElement !== undefined) {
            this.textMaskInputElement.update(this.inputElement.value);
        }
    };
    MaskedInputDirective.prototype.writeValue = function (value) {
        this._setupMask();
        // set the initial value for cases where the mask is disabled
        var normalizedValue = value == null ? '' : value;
        this._renderer.setProperty(this.inputElement, 'value', normalizedValue);
        if (this.textMaskInputElement !== undefined) {
            this.textMaskInputElement.update(value);
        }
    };
    MaskedInputDirective.prototype.registerOnChange = function (fn) { this.onChange = fn; };
    MaskedInputDirective.prototype.registerOnTouched = function (fn) { this.onTouched = fn; };
    MaskedInputDirective.prototype.setDisabledState = function (isDisabled) {
        this._renderer.setProperty(this._elementRef.nativeElement, 'disabled', isDisabled);
    };
    MaskedInputDirective.prototype._handleInput = function (value) {
        if (!this._compositionMode || (this._compositionMode && !this._composing)) {
            this._setupMask();
            if (this.textMaskInputElement !== undefined) {
                this.textMaskInputElement.update(value);
                // get the updated value
                value = this.inputElement.value;
                this.onChange(value);
            }
        }
    };
    MaskedInputDirective.prototype._setupMask = function (create) {
        if (create === void 0) { create = false; }
        if (!this.inputElement) {
            if (this._elementRef.nativeElement.tagName.toUpperCase() === 'INPUT') {
                // `textMask` directive is used directly on an input element
                this.inputElement = this._elementRef.nativeElement;
            }
            else {
                // `textMask` directive is used on an abstracted input element, `md-input-container`, etc
                this.inputElement = this._elementRef.nativeElement.getElementsByTagName('INPUT')[0];
            }
        }
        if (this.inputElement && create) {
            this.textMaskInputElement = textMaskCore_1.createTextMaskInputElement(Object.assign({ inputElement: this.inputElement }, this.textMaskConfig));
        }
    };
    MaskedInputDirective.prototype._compositionStart = function () { this._composing = true; };
    MaskedInputDirective.prototype._compositionEnd = function (value) {
        this._composing = false;
        this._compositionMode && this._handleInput(value);
    };
    MaskedInputDirective.decorators = [
        { type: core_1.Directive, args: [{
                    host: {
                        '(input)': '_handleInput($event.target.value)',
                        '(blur)': 'onTouched()',
                        '(compositionstart)': '_compositionStart()',
                        '(compositionend)': '_compositionEnd($event.target.value)'
                    },
                    selector: '[textMask]',
                    exportAs: 'textMask',
                    providers: [exports.MASKEDINPUT_VALUE_ACCESSOR]
                },] },
    ];
    /** @nocollapse */
    MaskedInputDirective.ctorParameters = function () { return [
        { type: core_1.Renderer2, },
        { type: core_1.ElementRef, },
        { type: undefined, decorators: [{ type: core_1.Optional }, { type: core_1.Inject, args: [forms_1.COMPOSITION_BUFFER_MODE,] },] },
    ]; };
    MaskedInputDirective.propDecorators = {
        'textMaskConfig': [{ type: core_1.Input, args: ['textMask',] },],
    };
    return MaskedInputDirective;
}());
exports.MaskedInputDirective = MaskedInputDirective;
var TextMaskModule = /** @class */ (function () {
    function TextMaskModule() {
    }
    TextMaskModule.decorators = [
        { type: core_1.NgModule, args: [{
                    declarations: [MaskedInputDirective],
                    exports: [MaskedInputDirective]
                },] },
    ];
    /** @nocollapse */
    TextMaskModule.ctorParameters = function () { return []; };
    return TextMaskModule;
}());
exports.TextMaskModule = TextMaskModule;
var textMaskCore_2 = __webpack_require__(899);
exports.conformToMask = textMaskCore_2.conformToMask;
//# sourceMappingURL=angular2TextMask.js.map

/***/ })

});
//# sourceMappingURL=42.chunk.js.map