/*
 * Decompiled with CFR 0.152.
 */
package com.upl.fazorstarclub.web.rest;

import com.upl.fazorstarclub.service.WeatherQueryService;
import com.upl.fazorstarclub.service.WeatherService;
import com.upl.fazorstarclub.service.criteria.WeatherCriteria;
import com.upl.fazorstarclub.service.dto.UserFarmWeatherCurrentDetailDTO;
import com.upl.fazorstarclub.service.dto.UserFarmWeatherDetailDTO;
import com.upl.fazorstarclub.service.dto.WeatherDTO;
import com.upl.fazorstarclub.service.utility.I18nUtility;
import com.upl.fazorstarclub.web.rest.errors.BadRequestAlertException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.List;
import java.util.Optional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.http.HttpHeaders;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.servlet.support.ServletUriComponentsBuilder;
import org.springframework.web.util.UriComponentsBuilder;
import tech.jhipster.web.util.HeaderUtil;
import tech.jhipster.web.util.PaginationUtil;
import tech.jhipster.web.util.ResponseUtil;

@RestController
@RequestMapping(value={"/api"})
public class WeatherResource {
    private final Logger log = LoggerFactory.getLogger(WeatherResource.class);
    private static final String ENTITY_NAME = "fazorstarclubWeather";
    @Value(value="${jhipster.clientApp.name}")
    private String applicationName;
    private final WeatherService weatherService;
    private final WeatherQueryService weatherQueryService;
    @Autowired
    private I18nUtility i18nUtility;

    public WeatherResource(WeatherService weatherService, WeatherQueryService weatherQueryService) {
        this.weatherService = weatherService;
        this.weatherQueryService = weatherQueryService;
    }

    @PostMapping(value={"/weathers"})
    public ResponseEntity<WeatherDTO> createWeather(@RequestBody WeatherDTO weatherDTO) throws URISyntaxException {
        this.log.debug("REST request to save Weather : {}", (Object)weatherDTO);
        if (weatherDTO.getId() != null) {
            String message = this.i18nUtility.getMessage("weather.create.id.exception", null);
            throw new BadRequestAlertException(message, ENTITY_NAME, "idexists");
        }
        WeatherDTO result = this.weatherService.save(weatherDTO);
        return ((ResponseEntity.BodyBuilder)ResponseEntity.created((URI)new URI("/api/weathers/" + result.getId())).headers(HeaderUtil.createEntityCreationAlert((String)this.applicationName, (boolean)true, (String)ENTITY_NAME, (String)result.getId().toString()))).body((Object)result);
    }

    @PutMapping(value={"/weathers"})
    public ResponseEntity<WeatherDTO> updateWeather(@RequestBody WeatherDTO weatherDTO) throws URISyntaxException {
        this.log.debug("REST request to update Weather : {}", (Object)weatherDTO);
        if (weatherDTO.getId() == null) {
            String message = this.i18nUtility.getMessage("weather.update.id.exception", null);
            throw new BadRequestAlertException(message, ENTITY_NAME, "idnull");
        }
        WeatherDTO result = this.weatherService.save(weatherDTO);
        return ((ResponseEntity.BodyBuilder)ResponseEntity.ok().headers(HeaderUtil.createEntityUpdateAlert((String)this.applicationName, (boolean)true, (String)ENTITY_NAME, (String)weatherDTO.getId().toString()))).body((Object)result);
    }

    @GetMapping(value={"/weathers"})
    public ResponseEntity<List<WeatherDTO>> getAllWeathers(WeatherCriteria criteria, Pageable pageable) {
        this.log.debug("REST request to get Weathers by criteria: {}", (Object)criteria);
        Page page = this.weatherQueryService.findByCriteria(criteria, pageable);
        HttpHeaders headers = PaginationUtil.generatePaginationHttpHeaders((UriComponentsBuilder)ServletUriComponentsBuilder.fromCurrentRequest(), (Page)page);
        return ((ResponseEntity.BodyBuilder)ResponseEntity.ok().headers(headers)).body((Object)page.getContent());
    }

    @GetMapping(value={"/weathers/count"})
    public ResponseEntity<Long> countWeathers(WeatherCriteria criteria) {
        this.log.debug("REST request to count Weathers by criteria: {}", (Object)criteria);
        return ResponseEntity.ok().body((Object)this.weatherQueryService.countByCriteria(criteria));
    }

    @GetMapping(value={"/weathers/{id}"})
    public ResponseEntity<WeatherDTO> getWeather(@PathVariable Long id) {
        this.log.debug("REST request to get Weather : {}", (Object)id);
        Optional weatherDTO = this.weatherService.findOne(id);
        return ResponseUtil.wrapOrNotFound((Optional)weatherDTO);
    }

    @DeleteMapping(value={"/weathers/{id}"})
    public ResponseEntity<Void> deleteWeather(@PathVariable Long id) {
        this.log.debug("REST request to delete Weather : {}", (Object)id);
        this.weatherService.delete(id);
        return ResponseEntity.noContent().headers(HeaderUtil.createEntityDeletionAlert((String)this.applicationName, (boolean)true, (String)ENTITY_NAME, (String)id.toString())).build();
    }

    @GetMapping(value={"/weather-history/{userFarmId}"})
    public ResponseEntity<List<UserFarmWeatherDetailDTO>> getWeatherHistory(@PathVariable Long userFarmId, String startDate, String endDate) {
        this.log.debug("REST request to get Weather Details");
        List userFarmWeatherDetailDTO = this.weatherService.getWeatherHistory(userFarmId, startDate, endDate);
        return ResponseEntity.ok().body((Object)userFarmWeatherDetailDTO);
    }

    @GetMapping(value={"/weather-forecast/{userFarmId}"})
    public ResponseEntity<List<UserFarmWeatherDetailDTO>> getWeatherForecast(@PathVariable Long userFarmId) {
        this.log.debug("REST request to get Weather Forecast");
        List userFarmWeatherDetailDTOs = this.weatherService.getWeatherForecast(userFarmId);
        return ResponseEntity.ok().body((Object)userFarmWeatherDetailDTOs);
    }

    @GetMapping(value={"/weather-current/{userFarmId}"})
    public ResponseEntity<List<UserFarmWeatherCurrentDetailDTO>> getWeatherCurrent(@PathVariable Long userFarmId) {
        this.log.debug("REST request to get Weather Current");
        List userFarmWeatherDetailDTOs = this.weatherService.getWeatherCurrent(userFarmId);
        return ResponseEntity.ok().body((Object)userFarmWeatherDetailDTOs);
    }
}

