/*
 * Decompiled with CFR 0.152.
 */
package com.upl.fazorstarclub.web.rest;

import com.upl.fazorstarclub.domain.enumeration.MarketType;
import com.upl.fazorstarclub.domain.enumeration.TypeOfSoil;
import com.upl.fazorstarclub.service.UserFarmQueryService;
import com.upl.fazorstarclub.service.UserFarmService;
import com.upl.fazorstarclub.service.criteria.UserFarmCriteria;
import com.upl.fazorstarclub.service.dto.HistoryResponseDTO;
import com.upl.fazorstarclub.service.dto.ObservationMapResponseDTO;
import com.upl.fazorstarclub.service.dto.UserFarmDTO;
import com.upl.fazorstarclub.service.utility.I18nUtility;
import com.upl.fazorstarclub.web.rest.errors.BadRequestAlertException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.http.HttpHeaders;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.servlet.support.ServletUriComponentsBuilder;
import org.springframework.web.util.UriComponentsBuilder;
import tech.jhipster.web.util.HeaderUtil;
import tech.jhipster.web.util.PaginationUtil;
import tech.jhipster.web.util.ResponseUtil;

@RestController
@RequestMapping(value={"/api"})
public class UserFarmResource {
    private final Logger log = LoggerFactory.getLogger(UserFarmResource.class);
    private static final String ENTITY_NAME = "fazorstarclubUserFarm";
    @Value(value="${jhipster.clientApp.name}")
    private String applicationName;
    private final UserFarmService userFarmService;
    private final UserFarmQueryService userFarmQueryService;
    @Autowired
    private I18nUtility i18nUtility;

    public UserFarmResource(UserFarmService userFarmService, UserFarmQueryService userFarmQueryService) {
        this.userFarmService = userFarmService;
        this.userFarmQueryService = userFarmQueryService;
    }

    @PostMapping(value={"/user-farms"})
    public ResponseEntity<UserFarmDTO> createUserFarm(@RequestBody UserFarmDTO userFarmDTO) throws URISyntaxException {
        this.log.debug("REST request to save UserFarm : {}", (Object)userFarmDTO);
        if (userFarmDTO.getId() != null) {
            String message = this.i18nUtility.getMessage("user.farm.create.id.exception", null);
            throw new BadRequestAlertException(message, ENTITY_NAME, "idexists");
        }
        UserFarmDTO result = this.userFarmService.save(userFarmDTO);
        return ((ResponseEntity.BodyBuilder)ResponseEntity.created((URI)new URI("/api/user-farms/" + result.getId())).headers(HeaderUtil.createEntityCreationAlert((String)this.applicationName, (boolean)true, (String)ENTITY_NAME, (String)result.getId().toString()))).body((Object)result);
    }

    @PutMapping(value={"/user-farms"})
    public ResponseEntity<UserFarmDTO> updateUserFarm(@RequestBody UserFarmDTO userFarmDTO) throws URISyntaxException {
        this.log.debug("REST request to update UserFarm : {}", (Object)userFarmDTO);
        if (userFarmDTO.getId() == null) {
            String message = this.i18nUtility.getMessage("user.farm.update.id.exception", null);
            throw new BadRequestAlertException(message, ENTITY_NAME, "idnull");
        }
        UserFarmDTO result = this.userFarmService.save(userFarmDTO);
        return ((ResponseEntity.BodyBuilder)ResponseEntity.ok().headers(HeaderUtil.createEntityUpdateAlert((String)this.applicationName, (boolean)true, (String)ENTITY_NAME, (String)userFarmDTO.getId().toString()))).body((Object)result);
    }

    @GetMapping(value={"/user-farms"})
    public ResponseEntity<List<UserFarmDTO>> getAllUserFarms(UserFarmCriteria criteria, Pageable pageable) {
        this.log.debug("REST request to get UserFarms by criteria: {}", (Object)criteria);
        Page page = this.userFarmQueryService.findByCriteria(criteria, pageable);
        HttpHeaders headers = PaginationUtil.generatePaginationHttpHeaders((UriComponentsBuilder)ServletUriComponentsBuilder.fromCurrentRequest(), (Page)page);
        return ((ResponseEntity.BodyBuilder)ResponseEntity.ok().headers(headers)).body((Object)page.getContent());
    }

    @GetMapping(value={"/user-farms/count"})
    public ResponseEntity<Long> countUserFarms(UserFarmCriteria criteria) {
        this.log.debug("REST request to count UserFarms by criteria: {}", (Object)criteria);
        return ResponseEntity.ok().body((Object)this.userFarmQueryService.countByCriteria(criteria));
    }

    @GetMapping(value={"/user-farms/{id}"})
    public ResponseEntity<UserFarmDTO> getUserFarm(@PathVariable Long id) {
        this.log.debug("REST request to get UserFarm : {}", (Object)id);
        Optional userFarmDTO = this.userFarmService.findOne(id);
        return ResponseUtil.wrapOrNotFound((Optional)userFarmDTO);
    }

    @DeleteMapping(value={"/user-farms/{id}"})
    public ResponseEntity<Void> deleteUserFarm(@PathVariable Long id) {
        this.log.debug("REST request to delete UserFarm : {}", (Object)id);
        this.userFarmService.delete(id);
        return ResponseEntity.noContent().headers(HeaderUtil.createEntityDeletionAlert((String)this.applicationName, (boolean)true, (String)ENTITY_NAME, (String)id.toString())).build();
    }

    @GetMapping(value={"/user-farm/market-type"})
    public ResponseEntity<List<String>> getMarketType() {
        this.log.debug("REST request to get type of market");
        List<String> marketTypeList = Arrays.asList(MarketType.FRESH.getValue(), MarketType.PROCESSED.getValue());
        return ResponseEntity.ok().body(marketTypeList);
    }

    @GetMapping(value={"/user-farm/soil-type"})
    public ResponseEntity<List<String>> getSoilType() {
        this.log.debug("REST request to get type of soil");
        List<String> soilTypeList = Arrays.asList(TypeOfSoil.CLAY.getValue(), TypeOfSoil.CLAY_LOAM.getValue(), TypeOfSoil.LOAM.getValue(), TypeOfSoil.LOAMY_SAND.getValue(), TypeOfSoil.SAND.getValue(), TypeOfSoil.SANDY_CLAY.getValue(), TypeOfSoil.SANDY_CLAY_LOAM.getValue(), TypeOfSoil.SANDY_LOAM.getValue(), TypeOfSoil.SILT.getValue(), TypeOfSoil.SILT_LOAM.getValue(), TypeOfSoil.SILTY_CLAY.getValue(), TypeOfSoil.SILTY_CLAY_LOAM.getValue());
        return ResponseEntity.ok().body(soilTypeList);
    }

    @GetMapping(value={"/user-farm/history/{appUserId}"})
    public ResponseEntity<List<HistoryResponseDTO>> getHistoryData(@PathVariable Long appUserId) {
        this.log.debug("REST request to get history data");
        List response = this.userFarmService.getHistoryData(appUserId);
        return ResponseEntity.ok().body((Object)response);
    }

    @GetMapping(value={"/user-farm/observations/{userFarmId}"})
    public ResponseEntity<List<ObservationMapResponseDTO>> getObservationMapData(@PathVariable Long userFarmId) {
        this.log.debug("REST request to get disease and pest observation data");
        List response = this.userFarmService.getObservationMapData(userFarmId);
        return ResponseEntity.ok().body((Object)response);
    }
}

