/*
 * Decompiled with CFR 0.152.
 */
package com.upl.fazorstarclub.web.rest;

import com.upl.fazorstarclub.domain.enumeration.TopicCategory;
import com.upl.fazorstarclub.service.TopicQueryService;
import com.upl.fazorstarclub.service.TopicService;
import com.upl.fazorstarclub.service.criteria.TopicCriteria;
import com.upl.fazorstarclub.service.dto.TopicDTO;
import com.upl.fazorstarclub.web.rest.errors.BadRequestAlertException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import javax.validation.Valid;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.http.HttpHeaders;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.servlet.support.ServletUriComponentsBuilder;
import org.springframework.web.util.UriComponentsBuilder;
import tech.jhipster.web.util.HeaderUtil;
import tech.jhipster.web.util.PaginationUtil;
import tech.jhipster.web.util.ResponseUtil;

@RestController
@RequestMapping(value={"/api"})
public class TopicResource {
    private final Logger log = LoggerFactory.getLogger(TopicResource.class);
    private static final String ENTITY_NAME = "fazorstarclubTopic";
    @Value(value="${jhipster.clientApp.name}")
    private String applicationName;
    private final TopicService topicService;
    private final TopicQueryService topicQueryService;

    public TopicResource(TopicService topicService, TopicQueryService topicQueryService) {
        this.topicService = topicService;
        this.topicQueryService = topicQueryService;
    }

    @PostMapping(value={"/topics"})
    public ResponseEntity<TopicDTO> createTopic(@Valid @RequestBody TopicDTO topicDTO) throws URISyntaxException {
        this.log.debug("REST request to save Topic : {}", (Object)topicDTO);
        if (topicDTO.getId() != null) {
            throw new BadRequestAlertException("A new topic cannot already have an ID", ENTITY_NAME, "idexists");
        }
        TopicDTO result = this.topicService.save(topicDTO);
        result = (TopicDTO)this.topicService.findOne(result.getId()).get();
        return ((ResponseEntity.BodyBuilder)ResponseEntity.created((URI)new URI("/api/topics/" + result.getId())).headers(HeaderUtil.createEntityCreationAlert((String)this.applicationName, (boolean)true, (String)ENTITY_NAME, (String)result.getId().toString()))).body((Object)result);
    }

    @PutMapping(value={"/topics"})
    public ResponseEntity<TopicDTO> updateTopic(@PathVariable(value="id", required=false) Long id, @Valid @RequestBody TopicDTO topicDTO) throws URISyntaxException {
        this.log.debug("REST request to update Topic : {}", (Object)topicDTO);
        if (topicDTO.getId() == null) {
            throw new BadRequestAlertException("Invalid id", ENTITY_NAME, "idnull");
        }
        TopicDTO result = this.topicService.save(topicDTO);
        return ((ResponseEntity.BodyBuilder)ResponseEntity.ok().headers(HeaderUtil.createEntityUpdateAlert((String)this.applicationName, (boolean)true, (String)ENTITY_NAME, (String)topicDTO.getId().toString()))).body((Object)result);
    }

    @GetMapping(value={"/topics"})
    public ResponseEntity<List<TopicDTO>> getAllTopics(TopicCriteria criteria, Pageable pageable) {
        this.log.debug("REST request to get Topics by criteria: {}", (Object)criteria);
        Page page = this.topicQueryService.findByCriteria(criteria, pageable);
        HttpHeaders headers = PaginationUtil.generatePaginationHttpHeaders((UriComponentsBuilder)ServletUriComponentsBuilder.fromCurrentRequest(), (Page)page);
        return ((ResponseEntity.BodyBuilder)ResponseEntity.ok().headers(headers)).body((Object)page.getContent());
    }

    @GetMapping(value={"/topics/count"})
    public ResponseEntity<Long> countTopics(TopicCriteria criteria) {
        this.log.debug("REST request to count Topics by criteria: {}", (Object)criteria);
        return ResponseEntity.ok().body((Object)this.topicQueryService.countByCriteria(criteria));
    }

    @GetMapping(value={"/topics/{id}"})
    public ResponseEntity<TopicDTO> getTopic(@PathVariable Long id) {
        this.log.debug("REST request to get Topic : {}", (Object)id);
        Optional topicDTO = this.topicService.findOne(id);
        return ResponseUtil.wrapOrNotFound((Optional)topicDTO);
    }

    @DeleteMapping(value={"/topics/{id}"})
    public ResponseEntity<Void> deleteTopic(@PathVariable Long id) {
        this.log.debug("REST request to delete Topic : {}", (Object)id);
        this.topicService.delete(id);
        return ResponseEntity.noContent().headers(HeaderUtil.createEntityDeletionAlert((String)this.applicationName, (boolean)true, (String)ENTITY_NAME, (String)id.toString())).build();
    }

    @GetMapping(value={"/topic/category"})
    public ResponseEntity<List<String>> getTopicCategory() {
        this.log.debug("REST request to get topic category");
        List<String> topicCategoryList = Arrays.asList(TopicCategory.APP_FUNCTIONING.getValue(), TopicCategory.EXPERIENCE_SHARING.getValue(), TopicCategory.FAZOR_START_APPLICATION.getValue(), TopicCategory.POTATOES_QUESTIONS.getValue());
        return ResponseEntity.ok().body(topicCategoryList);
    }
}

