/*
 * Decompiled with CFR 0.152.
 */
package com.upl.fazorstarclub.web.rest;

import com.upl.fazorstarclub.security.SecurityUtils;
import com.upl.fazorstarclub.service.TopicImageService;
import com.upl.fazorstarclub.service.dto.TopicImageDTO;
import com.upl.fazorstarclub.service.utility.I18nUtility;
import com.upl.fazorstarclub.web.rest.errors.BadRequestAlertException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.List;
import java.util.Optional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestPart;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.multipart.MultipartFile;
import tech.jhipster.web.util.HeaderUtil;
import tech.jhipster.web.util.ResponseUtil;

@RestController
@RequestMapping(value={"/api"})
public class TopicImageResource {
    private final Logger log = LoggerFactory.getLogger(TopicImageResource.class);
    private static final String ENTITY_NAME = "fazorstarclubTopicImage";
    @Value(value="${jhipster.clientApp.name}")
    private String applicationName;
    private final TopicImageService topicImageService;
    @Autowired
    private I18nUtility i18nUtility;

    public TopicImageResource(TopicImageService topicImageService) {
        this.topicImageService = topicImageService;
    }

    @PostMapping(value={"/topic-images"})
    public ResponseEntity<TopicImageDTO> createTopicImage(@RequestBody TopicImageDTO topicImageDTO) throws URISyntaxException {
        this.log.debug("REST request to save TopicImage : {}", (Object)topicImageDTO);
        if (topicImageDTO.getId() != null) {
            String message = this.i18nUtility.getMessage("topic.image.create.id.exception", null);
            throw new BadRequestAlertException(message, ENTITY_NAME, "idexists");
        }
        TopicImageDTO result = this.topicImageService.save(topicImageDTO);
        return ((ResponseEntity.BodyBuilder)ResponseEntity.created((URI)new URI("/api/topic-images/" + result.getId())).headers(HeaderUtil.createEntityCreationAlert((String)this.applicationName, (boolean)true, (String)ENTITY_NAME, (String)result.getId().toString()))).body((Object)result);
    }

    @PutMapping(value={"/topic-images"})
    public ResponseEntity<TopicImageDTO> updateTopicImage(@RequestBody TopicImageDTO topicImageDTO) throws URISyntaxException {
        this.log.debug("REST request to update TopicImage : {}", (Object)topicImageDTO);
        if (topicImageDTO.getId() == null) {
            String message = this.i18nUtility.getMessage("topic.image.update.id.exception", null);
            throw new BadRequestAlertException(message, ENTITY_NAME, "idnull");
        }
        TopicImageDTO result = this.topicImageService.save(topicImageDTO);
        return ((ResponseEntity.BodyBuilder)ResponseEntity.ok().headers(HeaderUtil.createEntityUpdateAlert((String)this.applicationName, (boolean)true, (String)ENTITY_NAME, (String)topicImageDTO.getId().toString()))).body((Object)result);
    }

    @GetMapping(value={"/topic-images"})
    public List<TopicImageDTO> getAllTopicImages() {
        this.log.debug("REST request to get all TopicImages");
        return this.topicImageService.findAll();
    }

    @GetMapping(value={"/topic-images/{id}"})
    public ResponseEntity<TopicImageDTO> getTopicImage(@PathVariable Long id) {
        this.log.debug("REST request to get TopicImage : {}", (Object)id);
        Optional topicImageDTO = this.topicImageService.findOne(id);
        return ResponseUtil.wrapOrNotFound((Optional)topicImageDTO);
    }

    @DeleteMapping(value={"/topic-images/{id}"})
    public ResponseEntity<Void> deleteTopicImage(@PathVariable Long id) {
        this.log.debug("REST request to delete TopicImage : {}", (Object)id);
        this.topicImageService.delete(id);
        return ResponseEntity.noContent().headers(HeaderUtil.createEntityDeletionAlert((String)this.applicationName, (boolean)true, (String)ENTITY_NAME, (String)id.toString())).build();
    }

    @PostMapping(value={"/topic-images/file-upload"})
    public ResponseEntity<List<TopicImageDTO>> uploadImageToS3Bucket(@RequestPart(value="files") List<MultipartFile> files) {
        Long appUserId = Long.parseLong((String)SecurityUtils.getCurrentUserLogin().get());
        this.log.debug("REST request to save Image : {}", (Object)appUserId);
        List topImageDTOs = this.topicImageService.uploadImage(files, appUserId);
        return ResponseEntity.ok().body((Object)topImageDTOs);
    }
}

