/*
 * Decompiled with CFR 0.152.
 */
package com.upl.fazorstarclub.web.rest;

import com.upl.fazorstarclub.service.StateQueryService;
import com.upl.fazorstarclub.service.StateService;
import com.upl.fazorstarclub.service.criteria.StateCriteria;
import com.upl.fazorstarclub.service.dto.StateDTO;
import com.upl.fazorstarclub.service.utility.I18nUtility;
import com.upl.fazorstarclub.web.rest.errors.BadRequestAlertException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.List;
import java.util.Optional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.http.ResponseEntity;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;
import tech.jhipster.web.util.HeaderUtil;
import tech.jhipster.web.util.ResponseUtil;

@RestController
@RequestMapping(value={"/api"})
public class StateResource {
    private final Logger log = LoggerFactory.getLogger(StateResource.class);
    private static final String ENTITY_NAME = "fazorState";
    @Value(value="${jhipster.clientApp.name}")
    private String applicationName;
    private final StateService stateService;
    private final StateQueryService stateQueryService;
    @Autowired
    private I18nUtility i18nUtility;

    public StateResource(StateService stateService, StateQueryService stateQueryService) {
        this.stateService = stateService;
        this.stateQueryService = stateQueryService;
    }

    @PostMapping(value={"/states"})
    @PreAuthorize(value="hasAnyAuthority(\"ADMIN\")")
    public ResponseEntity<StateDTO> createState(@RequestBody StateDTO stateDTO) throws URISyntaxException {
        this.log.debug("REST request to save State : {}", (Object)stateDTO);
        if (stateDTO.getId() != null) {
            String message = this.i18nUtility.getMessage("state.create.id.exception", null);
            throw new BadRequestAlertException(message, ENTITY_NAME, "idexists");
        }
        StateDTO result = this.stateService.save(stateDTO);
        return ((ResponseEntity.BodyBuilder)ResponseEntity.created((URI)new URI("/api/states/" + result.getId())).headers(HeaderUtil.createEntityCreationAlert((String)this.applicationName, (boolean)false, (String)ENTITY_NAME, (String)result.getId().toString()))).body((Object)result);
    }

    @PutMapping(value={"/states"})
    @PreAuthorize(value="hasAnyAuthority(\"ADMIN\")")
    public ResponseEntity<StateDTO> updateState(@RequestBody StateDTO stateDTO) throws URISyntaxException {
        this.log.debug("REST request to update State : {}", (Object)stateDTO);
        if (stateDTO.getId() == null) {
            String message = this.i18nUtility.getMessage("state.update.id.exception", null);
            throw new BadRequestAlertException(message, ENTITY_NAME, "idnull");
        }
        StateDTO result = this.stateService.save(stateDTO);
        return ((ResponseEntity.BodyBuilder)ResponseEntity.ok().headers(HeaderUtil.createEntityUpdateAlert((String)this.applicationName, (boolean)false, (String)ENTITY_NAME, (String)stateDTO.getId().toString()))).body((Object)result);
    }

    @GetMapping(value={"/states"})
    public ResponseEntity<List<StateDTO>> getAllStates(StateCriteria criteria) {
        this.log.debug("REST request to get States by criteria: {}", (Object)criteria);
        List entityList = this.stateQueryService.findByCriteria(criteria);
        return ResponseEntity.ok().body((Object)entityList);
    }

    @GetMapping(value={"/states/{id}"})
    public ResponseEntity<StateDTO> getState(@PathVariable Long id) {
        this.log.debug("REST request to get State : {}", (Object)id);
        Optional stateDTO = this.stateService.findOne(id);
        return ResponseUtil.wrapOrNotFound((Optional)stateDTO);
    }

    @DeleteMapping(value={"/states/{id}"})
    @PreAuthorize(value="hasAnyAuthority(\"ADMIN\")")
    public ResponseEntity<Void> deleteState(@PathVariable Long id) {
        this.log.debug("REST request to delete State : {}", (Object)id);
        this.stateService.delete(id);
        return ResponseEntity.noContent().headers(HeaderUtil.createEntityDeletionAlert((String)this.applicationName, (boolean)false, (String)ENTITY_NAME, (String)id.toString())).build();
    }
}

