/*
 * Decompiled with CFR 0.152.
 */
package com.upl.fazorstarclub.web.rest;

import com.upl.fazorstarclub.service.SeedVarietyService;
import com.upl.fazorstarclub.service.dto.SeedVarietyDTO;
import com.upl.fazorstarclub.service.utility.I18nUtility;
import com.upl.fazorstarclub.web.rest.errors.BadRequestAlertException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.List;
import java.util.Optional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;
import tech.jhipster.web.util.HeaderUtil;
import tech.jhipster.web.util.ResponseUtil;

@RestController
@RequestMapping(value={"/api"})
public class SeedVarietyResource {
    private final Logger log = LoggerFactory.getLogger(SeedVarietyResource.class);
    private static final String ENTITY_NAME = "fazorstarclubSeedVariety";
    @Value(value="${jhipster.clientApp.name}")
    private String applicationName;
    private final SeedVarietyService seedVarietyService;
    @Autowired
    private I18nUtility i18nUtility;

    public SeedVarietyResource(SeedVarietyService seedVarietyService) {
        this.seedVarietyService = seedVarietyService;
    }

    @PostMapping(value={"/seed-varieties"})
    public ResponseEntity<SeedVarietyDTO> createSeedVariety(@RequestBody SeedVarietyDTO seedVarietyDTO) throws URISyntaxException {
        this.log.debug("REST request to save SeedVariety : {}", (Object)seedVarietyDTO);
        if (seedVarietyDTO.getId() != null) {
            String message = this.i18nUtility.getMessage("seed.variety.create.id.exception", null);
            throw new BadRequestAlertException(message, ENTITY_NAME, "idexists");
        }
        SeedVarietyDTO result = this.seedVarietyService.save(seedVarietyDTO);
        return ((ResponseEntity.BodyBuilder)ResponseEntity.created((URI)new URI("/api/seed-varieties/" + result.getId())).headers(HeaderUtil.createEntityCreationAlert((String)this.applicationName, (boolean)true, (String)ENTITY_NAME, (String)result.getId().toString()))).body((Object)result);
    }

    @PutMapping(value={"/seed-varieties"})
    public ResponseEntity<SeedVarietyDTO> updateSeedVariety(@RequestBody SeedVarietyDTO seedVarietyDTO) throws URISyntaxException {
        this.log.debug("REST request to update SeedVariety : {}", (Object)seedVarietyDTO);
        if (seedVarietyDTO.getId() == null) {
            String message = this.i18nUtility.getMessage("seed.variety.update.id.exception", null);
            throw new BadRequestAlertException(message, ENTITY_NAME, "idnull");
        }
        SeedVarietyDTO result = this.seedVarietyService.save(seedVarietyDTO);
        return ((ResponseEntity.BodyBuilder)ResponseEntity.ok().headers(HeaderUtil.createEntityUpdateAlert((String)this.applicationName, (boolean)true, (String)ENTITY_NAME, (String)seedVarietyDTO.getId().toString()))).body((Object)result);
    }

    @GetMapping(value={"/seed-varieties"})
    public List<SeedVarietyDTO> getAllSeedVarieties() {
        this.log.debug("REST request to get all SeedVarieties");
        return this.seedVarietyService.findAll();
    }

    @GetMapping(value={"/seed-varieties/{id}"})
    public ResponseEntity<SeedVarietyDTO> getSeedVariety(@PathVariable Long id) {
        this.log.debug("REST request to get SeedVariety : {}", (Object)id);
        Optional seedVarietyDTO = this.seedVarietyService.findOne(id);
        return ResponseUtil.wrapOrNotFound((Optional)seedVarietyDTO);
    }

    @DeleteMapping(value={"/seed-varieties/{id}"})
    public ResponseEntity<Void> deleteSeedVariety(@PathVariable Long id) {
        this.log.debug("REST request to delete SeedVariety : {}", (Object)id);
        this.seedVarietyService.delete(id);
        return ResponseEntity.noContent().headers(HeaderUtil.createEntityDeletionAlert((String)this.applicationName, (boolean)true, (String)ENTITY_NAME, (String)id.toString())).build();
    }
}

