/*
 * Decompiled with CFR 0.152.
 */
package com.upl.fazorstarclub.web.rest;

import com.upl.fazorstarclub.service.ProductApplicationQueryService;
import com.upl.fazorstarclub.service.ProductApplicationService;
import com.upl.fazorstarclub.service.criteria.ProductApplicationCriteria;
import com.upl.fazorstarclub.service.dto.ProductApplicationDTO;
import com.upl.fazorstarclub.service.utility.I18nUtility;
import com.upl.fazorstarclub.web.rest.errors.BadRequestAlertException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.List;
import java.util.Optional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.http.HttpHeaders;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.servlet.support.ServletUriComponentsBuilder;
import org.springframework.web.util.UriComponentsBuilder;
import tech.jhipster.web.util.HeaderUtil;
import tech.jhipster.web.util.PaginationUtil;
import tech.jhipster.web.util.ResponseUtil;

@RestController
@RequestMapping(value={"/api"})
public class ProductApplicationResource {
    private final Logger log = LoggerFactory.getLogger(ProductApplicationResource.class);
    private static final String ENTITY_NAME = "fazorstarclubProductApplication";
    @Value(value="${jhipster.clientApp.name}")
    private String applicationName;
    private final ProductApplicationService productApplicationService;
    private final ProductApplicationQueryService productApplicationQueryService;
    @Autowired
    private I18nUtility i18nUtility;

    public ProductApplicationResource(ProductApplicationService productApplicationService, ProductApplicationQueryService productApplicationQueryService) {
        this.productApplicationService = productApplicationService;
        this.productApplicationQueryService = productApplicationQueryService;
    }

    @PostMapping(value={"/product-applications"})
    public ResponseEntity<ProductApplicationDTO> createProductApplication(@RequestBody ProductApplicationDTO productApplicationDTO) throws URISyntaxException {
        this.log.debug("REST request to save ProductApplication : {}", (Object)productApplicationDTO);
        if (productApplicationDTO.getId() != null) {
            String message = this.i18nUtility.getMessage("product.application.create.id.exception", null);
            throw new BadRequestAlertException(message, ENTITY_NAME, "idexists");
        }
        ProductApplicationDTO result = this.productApplicationService.save(productApplicationDTO);
        return ((ResponseEntity.BodyBuilder)ResponseEntity.created((URI)new URI("/api/product-applications/" + result.getId())).headers(HeaderUtil.createEntityCreationAlert((String)this.applicationName, (boolean)true, (String)ENTITY_NAME, (String)result.getId().toString()))).body((Object)result);
    }

    @PutMapping(value={"/product-applications"})
    public ResponseEntity<ProductApplicationDTO> updateProductApplication(@RequestBody ProductApplicationDTO productApplicationDTO) throws URISyntaxException {
        this.log.debug("REST request to update ProductApplication : {}", (Object)productApplicationDTO);
        if (productApplicationDTO.getId() == null) {
            String message = this.i18nUtility.getMessage("product.application.update.id.exception", null);
            throw new BadRequestAlertException(message, ENTITY_NAME, "idnull");
        }
        ProductApplicationDTO result = this.productApplicationService.save(productApplicationDTO);
        return ((ResponseEntity.BodyBuilder)ResponseEntity.ok().headers(HeaderUtil.createEntityUpdateAlert((String)this.applicationName, (boolean)true, (String)ENTITY_NAME, (String)productApplicationDTO.getId().toString()))).body((Object)result);
    }

    @GetMapping(value={"/product-applications"})
    public ResponseEntity<List<ProductApplicationDTO>> getAllProductApplications(ProductApplicationCriteria criteria, Pageable pageable) {
        this.log.debug("REST request to get ProductApplications by criteria: {}", (Object)criteria);
        Page page = this.productApplicationQueryService.findByCriteria(criteria, pageable);
        HttpHeaders headers = PaginationUtil.generatePaginationHttpHeaders((UriComponentsBuilder)ServletUriComponentsBuilder.fromCurrentRequest(), (Page)page);
        return ((ResponseEntity.BodyBuilder)ResponseEntity.ok().headers(headers)).body((Object)page.getContent());
    }

    @GetMapping(value={"/product-applications/count"})
    public ResponseEntity<Long> countProductApplications(ProductApplicationCriteria criteria) {
        this.log.debug("REST request to count ProductApplications by criteria: {}", (Object)criteria);
        return ResponseEntity.ok().body((Object)this.productApplicationQueryService.countByCriteria(criteria));
    }

    @GetMapping(value={"/product-applications/{id}"})
    public ResponseEntity<ProductApplicationDTO> getProductApplication(@PathVariable Long id) {
        this.log.debug("REST request to get ProductApplication : {}", (Object)id);
        Optional productApplicationDTO = this.productApplicationService.findOne(id);
        return ResponseUtil.wrapOrNotFound((Optional)productApplicationDTO);
    }

    @DeleteMapping(value={"/product-applications/{id}"})
    public ResponseEntity<Void> deleteProductApplication(@PathVariable Long id) {
        this.log.debug("REST request to delete ProductApplication : {}", (Object)id);
        this.productApplicationService.delete(id);
        return ResponseEntity.noContent().headers(HeaderUtil.createEntityDeletionAlert((String)this.applicationName, (boolean)true, (String)ENTITY_NAME, (String)id.toString())).build();
    }
}

