/*
 * Decompiled with CFR 0.152.
 */
package com.upl.fazorstarclub.web.rest;

import com.upl.fazorstarclub.service.PreviousCropService;
import com.upl.fazorstarclub.service.dto.PreviousCropDTO;
import com.upl.fazorstarclub.service.utility.I18nUtility;
import com.upl.fazorstarclub.web.rest.errors.BadRequestAlertException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.List;
import java.util.Optional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;
import tech.jhipster.web.util.HeaderUtil;
import tech.jhipster.web.util.ResponseUtil;

@RestController
@RequestMapping(value={"/api"})
public class PreviousCropResource {
    private final Logger log = LoggerFactory.getLogger(PreviousCropResource.class);
    private static final String ENTITY_NAME = "fazorstarclubPreviousCrop";
    @Value(value="${jhipster.clientApp.name}")
    private String applicationName;
    private final PreviousCropService previousCropService;
    @Autowired
    private I18nUtility i18nUtility;

    public PreviousCropResource(PreviousCropService previousCropService) {
        this.previousCropService = previousCropService;
    }

    @PostMapping(value={"/previous-crops"})
    public ResponseEntity<PreviousCropDTO> createPreviousCrop(@RequestBody PreviousCropDTO previousCropDTO) throws URISyntaxException {
        this.log.debug("REST request to save PreviousCrop : {}", (Object)previousCropDTO);
        if (previousCropDTO.getId() != null) {
            String message = this.i18nUtility.getMessage("previous.crop.create.id.exception", null);
            throw new BadRequestAlertException(message, ENTITY_NAME, "idexists");
        }
        PreviousCropDTO result = this.previousCropService.save(previousCropDTO);
        return ((ResponseEntity.BodyBuilder)ResponseEntity.created((URI)new URI("/api/previous-crops/" + result.getId())).headers(HeaderUtil.createEntityCreationAlert((String)this.applicationName, (boolean)true, (String)ENTITY_NAME, (String)result.getId().toString()))).body((Object)result);
    }

    @PutMapping(value={"/previous-crops"})
    public ResponseEntity<PreviousCropDTO> updatePreviousCrop(@RequestBody PreviousCropDTO previousCropDTO) throws URISyntaxException {
        this.log.debug("REST request to update PreviousCrop : {}", (Object)previousCropDTO);
        if (previousCropDTO.getId() == null) {
            String message = this.i18nUtility.getMessage("previous.crop.update.id.exception", null);
            throw new BadRequestAlertException(message, ENTITY_NAME, "idnull");
        }
        PreviousCropDTO result = this.previousCropService.save(previousCropDTO);
        return ((ResponseEntity.BodyBuilder)ResponseEntity.ok().headers(HeaderUtil.createEntityUpdateAlert((String)this.applicationName, (boolean)true, (String)ENTITY_NAME, (String)previousCropDTO.getId().toString()))).body((Object)result);
    }

    @GetMapping(value={"/previous-crops"})
    public List<PreviousCropDTO> getAllPreviousCrops() {
        this.log.debug("REST request to get all PreviousCrops");
        return this.previousCropService.findAll();
    }

    @GetMapping(value={"/previous-crops/{id}"})
    public ResponseEntity<PreviousCropDTO> getPreviousCrop(@PathVariable Long id) {
        this.log.debug("REST request to get PreviousCrop : {}", (Object)id);
        Optional previousCropDTO = this.previousCropService.findOne(id);
        return ResponseUtil.wrapOrNotFound((Optional)previousCropDTO);
    }

    @DeleteMapping(value={"/previous-crops/{id}"})
    public ResponseEntity<Void> deletePreviousCrop(@PathVariable Long id) {
        this.log.debug("REST request to delete PreviousCrop : {}", (Object)id);
        this.previousCropService.delete(id);
        return ResponseEntity.noContent().headers(HeaderUtil.createEntityDeletionAlert((String)this.applicationName, (boolean)true, (String)ENTITY_NAME, (String)id.toString())).build();
    }
}

