/*
 * Decompiled with CFR 0.152.
 */
package com.upl.fazorstarclub.web.rest;

import com.upl.fazorstarclub.domain.enumeration.LevelOfPressure;
import com.upl.fazorstarclub.service.PestQueryService;
import com.upl.fazorstarclub.service.PestService;
import com.upl.fazorstarclub.service.criteria.PestCriteria;
import com.upl.fazorstarclub.service.dto.PestDTO;
import com.upl.fazorstarclub.service.utility.I18nUtility;
import com.upl.fazorstarclub.web.rest.errors.BadRequestAlertException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.http.HttpHeaders;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.servlet.support.ServletUriComponentsBuilder;
import org.springframework.web.util.UriComponentsBuilder;
import tech.jhipster.web.util.HeaderUtil;
import tech.jhipster.web.util.PaginationUtil;
import tech.jhipster.web.util.ResponseUtil;

@RestController
@RequestMapping(value={"/api"})
public class PestResource {
    private final Logger log = LoggerFactory.getLogger(PestResource.class);
    private static final String ENTITY_NAME = "fazorstarclubPest";
    @Value(value="${jhipster.clientApp.name}")
    private String applicationName;
    private final PestService pestService;
    private final PestQueryService pestQueryService;
    @Autowired
    private I18nUtility i18nUtility;

    public PestResource(PestService pestService, PestQueryService pestQueryService) {
        this.pestService = pestService;
        this.pestQueryService = pestQueryService;
    }

    @PostMapping(value={"/pests"})
    public ResponseEntity<PestDTO> createPest(@RequestBody PestDTO pestDTO) throws URISyntaxException {
        this.log.debug("REST request to save Pest : {}", (Object)pestDTO);
        if (pestDTO.getId() != null) {
            String message = this.i18nUtility.getMessage("pest.create.id.exception", null);
            throw new BadRequestAlertException(message, ENTITY_NAME, "idexists");
        }
        PestDTO result = this.pestService.save(pestDTO);
        return ((ResponseEntity.BodyBuilder)ResponseEntity.created((URI)new URI("/api/pests/" + result.getId())).headers(HeaderUtil.createEntityCreationAlert((String)this.applicationName, (boolean)true, (String)ENTITY_NAME, (String)result.getId().toString()))).body((Object)result);
    }

    @PutMapping(value={"/pests/{id}"})
    public ResponseEntity<PestDTO> updatePest(@RequestBody PestDTO pestDTO) throws URISyntaxException {
        this.log.debug("REST request to update Pest : {}", (Object)pestDTO);
        if (pestDTO.getId() == null) {
            String message = this.i18nUtility.getMessage("pest.update.id.exception", null);
            throw new BadRequestAlertException(message, ENTITY_NAME, "idnull");
        }
        PestDTO result = this.pestService.save(pestDTO);
        return ((ResponseEntity.BodyBuilder)ResponseEntity.ok().headers(HeaderUtil.createEntityUpdateAlert((String)this.applicationName, (boolean)true, (String)ENTITY_NAME, (String)pestDTO.getId().toString()))).body((Object)result);
    }

    @GetMapping(value={"/pests"})
    public ResponseEntity<List<PestDTO>> getAllPests(PestCriteria criteria, Pageable pageable) {
        this.log.debug("REST request to get Pests by criteria: {}", (Object)criteria);
        Page page = this.pestQueryService.findByCriteria(criteria, pageable);
        HttpHeaders headers = PaginationUtil.generatePaginationHttpHeaders((UriComponentsBuilder)ServletUriComponentsBuilder.fromCurrentRequest(), (Page)page);
        return ((ResponseEntity.BodyBuilder)ResponseEntity.ok().headers(headers)).body((Object)page.getContent());
    }

    @GetMapping(value={"/pests/count"})
    public ResponseEntity<Long> countPests(PestCriteria criteria) {
        this.log.debug("REST request to count Pests by criteria: {}", (Object)criteria);
        return ResponseEntity.ok().body((Object)this.pestQueryService.countByCriteria(criteria));
    }

    @GetMapping(value={"/pests/{id}"})
    public ResponseEntity<PestDTO> getPest(@PathVariable Long id) {
        this.log.debug("REST request to get Pest : {}", (Object)id);
        Optional pestDTO = this.pestService.findOne(id);
        return ResponseUtil.wrapOrNotFound((Optional)pestDTO);
    }

    @DeleteMapping(value={"/pests/{id}"})
    public ResponseEntity<Void> deletePest(@PathVariable Long id) {
        this.log.debug("REST request to delete Pest : {}", (Object)id);
        this.pestService.delete(id);
        return ResponseEntity.noContent().headers(HeaderUtil.createEntityDeletionAlert((String)this.applicationName, (boolean)true, (String)ENTITY_NAME, (String)id.toString())).build();
    }

    @GetMapping(value={"/pest/level-of-pressure"})
    public ResponseEntity<List<String>> getLevelOfPressure() {
        this.log.debug("REST request to get level of pressure");
        List<String> levelOfPressureList = Arrays.asList(LevelOfPressure.LOW.getValue(), LevelOfPressure.MEDIUM.getValue(), LevelOfPressure.HIGH.getValue());
        return ResponseEntity.ok().body(levelOfPressureList);
    }
}

