/*
 * Decompiled with CFR 0.152.
 */
package com.upl.fazorstarclub.web.rest;

import com.upl.fazorstarclub.service.NewsService;
import com.upl.fazorstarclub.service.dto.NewsDTO;
import com.upl.fazorstarclub.service.utility.I18nUtility;
import com.upl.fazorstarclub.web.rest.errors.BadRequestAlertException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.List;
import java.util.Optional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.http.HttpHeaders;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.servlet.support.ServletUriComponentsBuilder;
import org.springframework.web.util.UriComponentsBuilder;
import tech.jhipster.web.util.HeaderUtil;
import tech.jhipster.web.util.PaginationUtil;
import tech.jhipster.web.util.ResponseUtil;

@RestController
@RequestMapping(value={"/api"})
public class NewsResource {
    private final Logger log = LoggerFactory.getLogger(NewsResource.class);
    private static final String ENTITY_NAME = "fazorstarclubNews";
    @Value(value="${jhipster.clientApp.name}")
    private String applicationName;
    private final NewsService newsService;
    @Autowired
    private I18nUtility i18nUtility;

    public NewsResource(NewsService newsService) {
        this.newsService = newsService;
    }

    @PostMapping(value={"/news"})
    public ResponseEntity<NewsDTO> createNews(@RequestBody NewsDTO newsDTO) throws URISyntaxException {
        this.log.debug("REST request to save News : {}", (Object)newsDTO);
        if (newsDTO.getId() != null) {
            String message = this.i18nUtility.getMessage("news.create.id.exception", null);
            throw new BadRequestAlertException(message, ENTITY_NAME, "idexists");
        }
        NewsDTO result = this.newsService.save(newsDTO);
        return ((ResponseEntity.BodyBuilder)ResponseEntity.created((URI)new URI("/api/news/" + result.getId())).headers(HeaderUtil.createEntityCreationAlert((String)this.applicationName, (boolean)true, (String)ENTITY_NAME, (String)result.getId().toString()))).body((Object)result);
    }

    @PutMapping(value={"/news/{id}"})
    public ResponseEntity<NewsDTO> updateNews(@PathVariable(value="id", required=false) Long id, @RequestBody NewsDTO newsDTO) throws URISyntaxException {
        this.log.debug("REST request to update News : {}, {}", (Object)id, (Object)newsDTO);
        if (newsDTO.getId() == null) {
            String message = this.i18nUtility.getMessage("news.update.id.exception", null);
            throw new BadRequestAlertException(message, ENTITY_NAME, "idnull");
        }
        NewsDTO result = this.newsService.save(newsDTO);
        return ((ResponseEntity.BodyBuilder)ResponseEntity.ok().headers(HeaderUtil.createEntityUpdateAlert((String)this.applicationName, (boolean)true, (String)ENTITY_NAME, (String)newsDTO.getId().toString()))).body((Object)result);
    }

    @GetMapping(value={"/news"})
    public ResponseEntity<List<NewsDTO>> getAllNews(Pageable pageable) {
        this.log.debug("REST request to get a page of News");
        Page page = this.newsService.findAll(pageable);
        HttpHeaders headers = PaginationUtil.generatePaginationHttpHeaders((UriComponentsBuilder)ServletUriComponentsBuilder.fromCurrentRequest(), (Page)page);
        return ((ResponseEntity.BodyBuilder)ResponseEntity.ok().headers(headers)).body((Object)page.getContent());
    }

    @GetMapping(value={"/news/{id}"})
    public ResponseEntity<NewsDTO> getNews(@PathVariable Long id) {
        this.log.debug("REST request to get News : {}", (Object)id);
        Optional newsDTO = this.newsService.findOne(id);
        return ResponseUtil.wrapOrNotFound((Optional)newsDTO);
    }

    @DeleteMapping(value={"/news/{id}"})
    public ResponseEntity<Void> deleteNews(@PathVariable Long id) {
        this.log.debug("REST request to delete News : {}", (Object)id);
        this.newsService.delete(id);
        return ResponseEntity.noContent().headers(HeaderUtil.createEntityDeletionAlert((String)this.applicationName, (boolean)true, (String)ENTITY_NAME, (String)id.toString())).build();
    }
}

