/*
 * Decompiled with CFR 0.152.
 */
package com.upl.fazorstarclub.web.rest;

import com.upl.fazorstarclub.service.NewsImageService;
import com.upl.fazorstarclub.service.dto.NewsImageDTO;
import com.upl.fazorstarclub.service.utility.I18nUtility;
import com.upl.fazorstarclub.web.rest.errors.BadRequestAlertException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.List;
import java.util.Optional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;
import tech.jhipster.web.util.HeaderUtil;
import tech.jhipster.web.util.ResponseUtil;

@RestController
@RequestMapping(value={"/api"})
public class NewsImageResource {
    private final Logger log = LoggerFactory.getLogger(NewsImageResource.class);
    private static final String ENTITY_NAME = "fazorstarclubNewsImage";
    @Value(value="${jhipster.clientApp.name}")
    private String applicationName;
    private final NewsImageService newsImageService;
    @Autowired
    private I18nUtility i18nUtility;

    public NewsImageResource(NewsImageService newsImageService) {
        this.newsImageService = newsImageService;
    }

    @PostMapping(value={"/news-images"})
    public ResponseEntity<NewsImageDTO> createNewsImage(@RequestBody NewsImageDTO newsImageDTO) throws URISyntaxException {
        this.log.debug("REST request to save NewsImage : {}", (Object)newsImageDTO);
        if (newsImageDTO.getId() != null) {
            String message = this.i18nUtility.getMessage("newsImage.create.id.exception", null);
            throw new BadRequestAlertException(message, ENTITY_NAME, "idexists");
        }
        NewsImageDTO result = this.newsImageService.save(newsImageDTO);
        return ((ResponseEntity.BodyBuilder)ResponseEntity.created((URI)new URI("/api/news-images/" + result.getId())).headers(HeaderUtil.createEntityCreationAlert((String)this.applicationName, (boolean)true, (String)ENTITY_NAME, (String)result.getId().toString()))).body((Object)result);
    }

    @PutMapping(value={"/news-images/{id}"})
    public ResponseEntity<NewsImageDTO> updateNewsImage(@PathVariable(value="id", required=false) Long id, @RequestBody NewsImageDTO newsImageDTO) throws URISyntaxException {
        this.log.debug("REST request to update NewsImage : {}, {}", (Object)id, (Object)newsImageDTO);
        if (newsImageDTO.getId() == null) {
            String message = this.i18nUtility.getMessage("newsImage.update.id.exception", null);
            throw new BadRequestAlertException(message, ENTITY_NAME, "idnull");
        }
        NewsImageDTO result = this.newsImageService.save(newsImageDTO);
        return ((ResponseEntity.BodyBuilder)ResponseEntity.ok().headers(HeaderUtil.createEntityUpdateAlert((String)this.applicationName, (boolean)true, (String)ENTITY_NAME, (String)newsImageDTO.getId().toString()))).body((Object)result);
    }

    @GetMapping(value={"/news-images"})
    public List<NewsImageDTO> getAllNewsImages() {
        this.log.debug("REST request to get all NewsImages");
        return this.newsImageService.findAll();
    }

    @GetMapping(value={"/news-images/{id}"})
    public ResponseEntity<NewsImageDTO> getNewsImage(@PathVariable Long id) {
        this.log.debug("REST request to get NewsImage : {}", (Object)id);
        Optional newsImageDTO = this.newsImageService.findOne(id);
        return ResponseUtil.wrapOrNotFound((Optional)newsImageDTO);
    }

    @DeleteMapping(value={"/news-images/{id}"})
    public ResponseEntity<Void> deleteNewsImage(@PathVariable Long id) {
        this.log.debug("REST request to delete NewsImage : {}", (Object)id);
        this.newsImageService.delete(id);
        return ResponseEntity.noContent().headers(HeaderUtil.createEntityDeletionAlert((String)this.applicationName, (boolean)true, (String)ENTITY_NAME, (String)id.toString())).build();
    }
}

