/*
 * Decompiled with CFR 0.152.
 */
package com.upl.fazorstarclub.web.rest;

import com.upl.fazorstarclub.service.MasterPestService;
import com.upl.fazorstarclub.service.dto.MasterPestDTO;
import com.upl.fazorstarclub.service.utility.I18nUtility;
import com.upl.fazorstarclub.web.rest.errors.BadRequestAlertException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.List;
import java.util.Optional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;
import tech.jhipster.web.util.HeaderUtil;
import tech.jhipster.web.util.ResponseUtil;

@RestController
@RequestMapping(value={"/api"})
public class MasterPestResource {
    private final Logger log = LoggerFactory.getLogger(MasterPestResource.class);
    private static final String ENTITY_NAME = "fazorstarclubMasterPest";
    @Value(value="${jhipster.clientApp.name}")
    private String applicationName;
    private final MasterPestService masterPestService;
    @Autowired
    private I18nUtility i18nUtility;

    public MasterPestResource(MasterPestService masterPestService) {
        this.masterPestService = masterPestService;
    }

    @PostMapping(value={"/master-pests"})
    public ResponseEntity<MasterPestDTO> createMasterPest(@RequestBody MasterPestDTO masterPestDTO) throws URISyntaxException {
        this.log.debug("REST request to save MasterPest : {}", (Object)masterPestDTO);
        if (masterPestDTO.getId() != null) {
            String message = this.i18nUtility.getMessage("master.pest.create.id.exception", null);
            throw new BadRequestAlertException(message, ENTITY_NAME, "idexists");
        }
        MasterPestDTO result = this.masterPestService.save(masterPestDTO);
        return ((ResponseEntity.BodyBuilder)ResponseEntity.created((URI)new URI("/api/master-pests/" + result.getId())).headers(HeaderUtil.createEntityCreationAlert((String)this.applicationName, (boolean)true, (String)ENTITY_NAME, (String)result.getId().toString()))).body((Object)result);
    }

    @PutMapping(value={"/master-pests"})
    public ResponseEntity<MasterPestDTO> updateMasterPest(@RequestBody MasterPestDTO masterPestDTO) throws URISyntaxException {
        this.log.debug("REST request to update MasterPest : {}", (Object)masterPestDTO);
        if (masterPestDTO.getId() == null) {
            String message = this.i18nUtility.getMessage("master.pest.update.id.exception", null);
            throw new BadRequestAlertException(message, ENTITY_NAME, "idnull");
        }
        MasterPestDTO result = this.masterPestService.save(masterPestDTO);
        return ((ResponseEntity.BodyBuilder)ResponseEntity.ok().headers(HeaderUtil.createEntityUpdateAlert((String)this.applicationName, (boolean)true, (String)ENTITY_NAME, (String)masterPestDTO.getId().toString()))).body((Object)result);
    }

    @GetMapping(value={"/master-pests"})
    public List<MasterPestDTO> getAllMasterPests() {
        this.log.debug("REST request to get all MasterPests");
        return this.masterPestService.findAll();
    }

    @GetMapping(value={"/master-pests/{id}"})
    public ResponseEntity<MasterPestDTO> getMasterPest(@PathVariable Long id) {
        this.log.debug("REST request to get MasterPest : {}", (Object)id);
        Optional masterPestDTO = this.masterPestService.findOne(id);
        return ResponseUtil.wrapOrNotFound((Optional)masterPestDTO);
    }

    @DeleteMapping(value={"/master-pests/{id}"})
    public ResponseEntity<Void> deleteMasterPest(@PathVariable Long id) {
        this.log.debug("REST request to delete MasterPest : {}", (Object)id);
        this.masterPestService.delete(id);
        return ResponseEntity.noContent().headers(HeaderUtil.createEntityDeletionAlert((String)this.applicationName, (boolean)true, (String)ENTITY_NAME, (String)id.toString())).build();
    }
}

