/*
 * Decompiled with CFR 0.152.
 */
package com.upl.fazorstarclub.web.rest;

import com.upl.fazorstarclub.service.MasterDiseaseService;
import com.upl.fazorstarclub.service.dto.MasterDiseaseDTO;
import com.upl.fazorstarclub.service.utility.I18nUtility;
import com.upl.fazorstarclub.web.rest.errors.BadRequestAlertException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.List;
import java.util.Optional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;
import tech.jhipster.web.util.HeaderUtil;
import tech.jhipster.web.util.ResponseUtil;

@RestController
@RequestMapping(value={"/api"})
public class MasterDiseaseResource {
    private final Logger log = LoggerFactory.getLogger(MasterDiseaseResource.class);
    private static final String ENTITY_NAME = "fazorstarclubMasterDisease";
    @Value(value="${jhipster.clientApp.name}")
    private String applicationName;
    private final MasterDiseaseService masterDiseaseService;
    @Autowired
    private I18nUtility i18nUtility;

    public MasterDiseaseResource(MasterDiseaseService masterDiseaseService) {
        this.masterDiseaseService = masterDiseaseService;
    }

    @PostMapping(value={"/master-diseases"})
    public ResponseEntity<MasterDiseaseDTO> createMasterDisease(@RequestBody MasterDiseaseDTO masterDiseaseDTO) throws URISyntaxException {
        this.log.debug("REST request to save MasterDisease : {}", (Object)masterDiseaseDTO);
        if (masterDiseaseDTO.getId() != null) {
            String message = this.i18nUtility.getMessage("master.diseases.create.id.exception", null);
            throw new BadRequestAlertException(message, ENTITY_NAME, "idexists");
        }
        MasterDiseaseDTO result = this.masterDiseaseService.save(masterDiseaseDTO);
        return ((ResponseEntity.BodyBuilder)ResponseEntity.created((URI)new URI("/api/master-diseases/" + result.getId())).headers(HeaderUtil.createEntityCreationAlert((String)this.applicationName, (boolean)true, (String)ENTITY_NAME, (String)result.getId().toString()))).body((Object)result);
    }

    @PutMapping(value={"/master-diseases"})
    public ResponseEntity<MasterDiseaseDTO> updateMasterDisease(@RequestBody MasterDiseaseDTO masterDiseaseDTO) throws URISyntaxException {
        this.log.debug("REST request to update MasterDisease : {}", (Object)masterDiseaseDTO);
        if (masterDiseaseDTO.getId() == null) {
            String message = this.i18nUtility.getMessage("master.disease.update.id.exception", null);
            throw new BadRequestAlertException(message, ENTITY_NAME, "idnull");
        }
        MasterDiseaseDTO result = this.masterDiseaseService.save(masterDiseaseDTO);
        return ((ResponseEntity.BodyBuilder)ResponseEntity.ok().headers(HeaderUtil.createEntityUpdateAlert((String)this.applicationName, (boolean)true, (String)ENTITY_NAME, (String)masterDiseaseDTO.getId().toString()))).body((Object)result);
    }

    @GetMapping(value={"/master-diseases"})
    public List<MasterDiseaseDTO> getAllMasterDiseases() {
        this.log.debug("REST request to get all MasterDiseases");
        return this.masterDiseaseService.findAll();
    }

    @GetMapping(value={"/master-diseases/{id}"})
    public ResponseEntity<MasterDiseaseDTO> getMasterDisease(@PathVariable Long id) {
        this.log.debug("REST request to get MasterDisease : {}", (Object)id);
        Optional masterDiseaseDTO = this.masterDiseaseService.findOne(id);
        return ResponseUtil.wrapOrNotFound((Optional)masterDiseaseDTO);
    }

    @DeleteMapping(value={"/master-diseases/{id}"})
    public ResponseEntity<Void> deleteMasterDisease(@PathVariable Long id) {
        this.log.debug("REST request to delete MasterDisease : {}", (Object)id);
        this.masterDiseaseService.delete(id);
        return ResponseEntity.noContent().headers(HeaderUtil.createEntityDeletionAlert((String)this.applicationName, (boolean)true, (String)ENTITY_NAME, (String)id.toString())).build();
    }
}

