/*
 * Decompiled with CFR 0.152.
 */
package com.upl.fazorstarclub.web.rest;

import com.upl.fazorstarclub.service.IrrigationService;
import com.upl.fazorstarclub.service.dto.IrrigationDTO;
import com.upl.fazorstarclub.service.utility.I18nUtility;
import com.upl.fazorstarclub.web.rest.errors.BadRequestAlertException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.List;
import java.util.Optional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;
import tech.jhipster.web.util.HeaderUtil;
import tech.jhipster.web.util.ResponseUtil;

@RestController
@RequestMapping(value={"/api"})
public class IrrigationResource {
    private final Logger log = LoggerFactory.getLogger(IrrigationResource.class);
    private static final String ENTITY_NAME = "fazorstarclubIrrigation";
    @Value(value="${jhipster.clientApp.name}")
    private String applicationName;
    private final IrrigationService irrigationService;
    @Autowired
    private I18nUtility i18nUtility;

    public IrrigationResource(IrrigationService irrigationService) {
        this.irrigationService = irrigationService;
    }

    @PostMapping(value={"/irrigations"})
    public ResponseEntity<IrrigationDTO> createIrrigation(@RequestBody IrrigationDTO irrigationDTO) throws URISyntaxException {
        this.log.debug("REST request to save Irrigation : {}", (Object)irrigationDTO);
        if (irrigationDTO.getId() != null) {
            String message = this.i18nUtility.getMessage("irrigation.create.id.exception", null);
            throw new BadRequestAlertException(message, ENTITY_NAME, "idexists");
        }
        IrrigationDTO result = this.irrigationService.save(irrigationDTO);
        return ((ResponseEntity.BodyBuilder)ResponseEntity.created((URI)new URI("/api/irrigations/" + result.getId())).headers(HeaderUtil.createEntityCreationAlert((String)this.applicationName, (boolean)true, (String)ENTITY_NAME, (String)result.getId().toString()))).body((Object)result);
    }

    @PutMapping(value={"/irrigations"})
    public ResponseEntity<IrrigationDTO> updateIrrigation(@RequestBody IrrigationDTO irrigationDTO) throws URISyntaxException {
        this.log.debug("REST request to update Irrigation : {}", (Object)irrigationDTO);
        if (irrigationDTO.getId() == null) {
            String message = this.i18nUtility.getMessage("irrigation.update.id.exception", null);
            throw new BadRequestAlertException(message, ENTITY_NAME, "idnull");
        }
        IrrigationDTO result = this.irrigationService.save(irrigationDTO);
        return ((ResponseEntity.BodyBuilder)ResponseEntity.ok().headers(HeaderUtil.createEntityUpdateAlert((String)this.applicationName, (boolean)true, (String)ENTITY_NAME, (String)irrigationDTO.getId().toString()))).body((Object)result);
    }

    @GetMapping(value={"/irrigations"})
    public List<IrrigationDTO> getAllIrrigations() {
        this.log.debug("REST request to get all Irrigations");
        return this.irrigationService.findAll();
    }

    @GetMapping(value={"/irrigations/{id}"})
    public ResponseEntity<IrrigationDTO> getIrrigation(@PathVariable Long id) {
        this.log.debug("REST request to get Irrigation : {}", (Object)id);
        Optional irrigationDTO = this.irrigationService.findOne(id);
        return ResponseUtil.wrapOrNotFound((Optional)irrigationDTO);
    }

    @DeleteMapping(value={"/irrigations/{id}"})
    public ResponseEntity<Void> deleteIrrigation(@PathVariable Long id) {
        this.log.debug("REST request to delete Irrigation : {}", (Object)id);
        this.irrigationService.delete(id);
        return ResponseEntity.noContent().headers(HeaderUtil.createEntityDeletionAlert((String)this.applicationName, (boolean)true, (String)ENTITY_NAME, (String)id.toString())).build();
    }
}

