/*
 * Decompiled with CFR 0.152.
 */
package com.upl.fazorstarclub.web.rest;

import com.upl.fazorstarclub.domain.enumeration.LevelOfPressure;
import com.upl.fazorstarclub.service.DiseaseQueryService;
import com.upl.fazorstarclub.service.DiseaseService;
import com.upl.fazorstarclub.service.criteria.DiseaseCriteria;
import com.upl.fazorstarclub.service.dto.DiseaseDTO;
import com.upl.fazorstarclub.service.utility.I18nUtility;
import com.upl.fazorstarclub.web.rest.errors.BadRequestAlertException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.http.HttpHeaders;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.servlet.support.ServletUriComponentsBuilder;
import org.springframework.web.util.UriComponentsBuilder;
import tech.jhipster.web.util.HeaderUtil;
import tech.jhipster.web.util.PaginationUtil;
import tech.jhipster.web.util.ResponseUtil;

@RestController
@RequestMapping(value={"/api"})
public class DiseaseResource {
    private final Logger log = LoggerFactory.getLogger(DiseaseResource.class);
    private static final String ENTITY_NAME = "fazorstarclubDisease";
    @Value(value="${jhipster.clientApp.name}")
    private String applicationName;
    private final DiseaseService diseaseService;
    private final DiseaseQueryService diseaseQueryService;
    @Autowired
    private I18nUtility i18nUtility;

    public DiseaseResource(DiseaseService diseaseService, DiseaseQueryService diseaseQueryService) {
        this.diseaseService = diseaseService;
        this.diseaseQueryService = diseaseQueryService;
    }

    @PostMapping(value={"/diseases"})
    public ResponseEntity<DiseaseDTO> createDisease(@RequestBody DiseaseDTO diseaseDTO) throws URISyntaxException {
        this.log.debug("REST request to save Disease : {}", (Object)diseaseDTO);
        if (diseaseDTO.getId() != null) {
            String message = this.i18nUtility.getMessage("disease.create.id.exception", null);
            throw new BadRequestAlertException(message, ENTITY_NAME, "idexists");
        }
        DiseaseDTO result = this.diseaseService.save(diseaseDTO);
        return ((ResponseEntity.BodyBuilder)ResponseEntity.created((URI)new URI("/api/diseases/" + result.getId())).headers(HeaderUtil.createEntityCreationAlert((String)this.applicationName, (boolean)true, (String)ENTITY_NAME, (String)result.getId().toString()))).body((Object)result);
    }

    @PutMapping(value={"/diseases/{id}"})
    public ResponseEntity<DiseaseDTO> updateDisease(@RequestBody DiseaseDTO diseaseDTO) throws URISyntaxException {
        this.log.debug("REST request to update Disease : {}", (Object)diseaseDTO);
        if (diseaseDTO.getId() == null) {
            String message = this.i18nUtility.getMessage("disease.update.id.exception", null);
            throw new BadRequestAlertException(message, ENTITY_NAME, "idnull");
        }
        DiseaseDTO result = this.diseaseService.save(diseaseDTO);
        return ((ResponseEntity.BodyBuilder)ResponseEntity.ok().headers(HeaderUtil.createEntityUpdateAlert((String)this.applicationName, (boolean)true, (String)ENTITY_NAME, (String)diseaseDTO.getId().toString()))).body((Object)result);
    }

    @GetMapping(value={"/diseases"})
    public ResponseEntity<List<DiseaseDTO>> getAllDiseases(DiseaseCriteria criteria, Pageable pageable) {
        this.log.debug("REST request to get Diseases by criteria: {}", (Object)criteria);
        Page page = this.diseaseQueryService.findByCriteria(criteria, pageable);
        HttpHeaders headers = PaginationUtil.generatePaginationHttpHeaders((UriComponentsBuilder)ServletUriComponentsBuilder.fromCurrentRequest(), (Page)page);
        return ((ResponseEntity.BodyBuilder)ResponseEntity.ok().headers(headers)).body((Object)page.getContent());
    }

    @GetMapping(value={"/diseases/count"})
    public ResponseEntity<Long> countDiseases(DiseaseCriteria criteria) {
        this.log.debug("REST request to count Diseases by criteria: {}", (Object)criteria);
        return ResponseEntity.ok().body((Object)this.diseaseQueryService.countByCriteria(criteria));
    }

    @GetMapping(value={"/diseases/{id}"})
    public ResponseEntity<DiseaseDTO> getDisease(@PathVariable Long id) {
        this.log.debug("REST request to get Disease : {}", (Object)id);
        Optional diseaseDTO = this.diseaseService.findOne(id);
        return ResponseUtil.wrapOrNotFound((Optional)diseaseDTO);
    }

    @DeleteMapping(value={"/diseases/{id}"})
    public ResponseEntity<Void> deleteDisease(@PathVariable Long id) {
        this.log.debug("REST request to delete Disease : {}", (Object)id);
        this.diseaseService.delete(id);
        return ResponseEntity.noContent().headers(HeaderUtil.createEntityDeletionAlert((String)this.applicationName, (boolean)true, (String)ENTITY_NAME, (String)id.toString())).build();
    }

    @GetMapping(value={"/diseases/level-of-pressure"})
    public ResponseEntity<List<String>> getLevelOfPressure() {
        this.log.debug("REST request to get level of pressure");
        List<String> levelOfPressureList = Arrays.asList(LevelOfPressure.LOW.getValue(), LevelOfPressure.MEDIUM.getValue(), LevelOfPressure.HIGH.getValue());
        return ResponseEntity.ok().body(levelOfPressureList);
    }
}

