/*
 * Decompiled with CFR 0.152.
 */
package com.upl.fazorstarclub.web.rest;

import com.upl.fazorstarclub.security.SecurityUtils;
import com.upl.fazorstarclub.service.DebateQueryService;
import com.upl.fazorstarclub.service.DebateService;
import com.upl.fazorstarclub.service.criteria.DebateCriteria;
import com.upl.fazorstarclub.service.dto.DebateDTO;
import com.upl.fazorstarclub.service.dto.DebateTopicLikeDTO;
import com.upl.fazorstarclub.service.utility.I18nUtility;
import com.upl.fazorstarclub.web.rest.errors.BadRequestAlertException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.List;
import java.util.Optional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.http.HttpHeaders;
import org.springframework.http.ResponseEntity;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.servlet.support.ServletUriComponentsBuilder;
import org.springframework.web.util.UriComponentsBuilder;
import tech.jhipster.web.util.HeaderUtil;
import tech.jhipster.web.util.PaginationUtil;
import tech.jhipster.web.util.ResponseUtil;

@RestController
@RequestMapping(value={"/api"})
public class DebateResource {
    private final Logger log = LoggerFactory.getLogger(DebateResource.class);
    private static final String ENTITY_NAME = "fazorstarclubDebate";
    @Value(value="${jhipster.clientApp.name}")
    private String applicationName;
    @Autowired
    private I18nUtility i18nUtility;
    private final DebateService debateService;
    private final DebateQueryService debateQueryService;

    public DebateResource(DebateService debateService, DebateQueryService debateQueryService) {
        this.debateService = debateService;
        this.debateQueryService = debateQueryService;
    }

    @PostMapping(value={"/debates"})
    @PreAuthorize(value="hasAnyAuthority(\"ADMIN\")")
    public ResponseEntity<DebateDTO> createDebate(@RequestBody DebateDTO debateDTO) throws URISyntaxException {
        this.log.debug("REST request to save Debate : {}", (Object)debateDTO);
        if (debateDTO.getId() != null) {
            String message = this.i18nUtility.getMessage("debate.create.id.exception", null);
            throw new BadRequestAlertException(message, ENTITY_NAME, "idexists");
        }
        DebateDTO result = this.debateService.save(debateDTO);
        return ((ResponseEntity.BodyBuilder)ResponseEntity.created((URI)new URI("/api/debates/" + result.getId())).headers(HeaderUtil.createEntityCreationAlert((String)this.applicationName, (boolean)true, (String)ENTITY_NAME, (String)result.getId().toString()))).body((Object)result);
    }

    @PutMapping(value={"/debates/{id}"})
    @PreAuthorize(value="hasAnyAuthority(\"ADMIN\")")
    public ResponseEntity<DebateDTO> updateDebate(@RequestBody DebateDTO debateDTO) throws URISyntaxException {
        this.log.debug("REST request to update Debate : {}", (Object)debateDTO);
        if (debateDTO.getId() == null) {
            String message = this.i18nUtility.getMessage("debate.update.id.exception", null);
            throw new BadRequestAlertException(message, ENTITY_NAME, "idnull");
        }
        DebateDTO result = this.debateService.save(debateDTO);
        return ((ResponseEntity.BodyBuilder)ResponseEntity.ok().headers(HeaderUtil.createEntityUpdateAlert((String)this.applicationName, (boolean)true, (String)ENTITY_NAME, (String)debateDTO.getId().toString()))).body((Object)result);
    }

    @GetMapping(value={"/debates"})
    @PreAuthorize(value="hasAnyAuthority(\"ADMIN\")")
    public ResponseEntity<List<DebateDTO>> getAllDebates(DebateCriteria criteria, Pageable pageable) {
        this.log.debug("REST request to get Debates by criteria: {}", (Object)criteria);
        Page page = this.debateQueryService.findByCriteria(criteria, pageable);
        HttpHeaders headers = PaginationUtil.generatePaginationHttpHeaders((UriComponentsBuilder)ServletUriComponentsBuilder.fromCurrentRequest(), (Page)page);
        return ((ResponseEntity.BodyBuilder)ResponseEntity.ok().headers(headers)).body((Object)page.getContent());
    }

    @GetMapping(value={"/debates/count"})
    @PreAuthorize(value="hasAnyAuthority(\"ADMIN\")")
    public ResponseEntity<Long> countDebates(DebateCriteria criteria) {
        this.log.debug("REST request to count Debates by criteria: {}", (Object)criteria);
        return ResponseEntity.ok().body((Object)this.debateQueryService.countByCriteria(criteria));
    }

    @GetMapping(value={"/debates/{id}"})
    @PreAuthorize(value="hasAnyAuthority(\"ADMIN\")")
    public ResponseEntity<DebateDTO> getDebate(@PathVariable Long id) {
        this.log.debug("REST request to get Debate : {}", (Object)id);
        Optional debateDTO = this.debateService.findOne(id);
        return ResponseUtil.wrapOrNotFound((Optional)debateDTO);
    }

    @DeleteMapping(value={"/debates/{id}"})
    @PreAuthorize(value="hasAnyAuthority(\"ADMIN\")")
    public ResponseEntity<Void> deleteDebate(@PathVariable Long id) {
        this.log.debug("REST request to delete Debate : {}", (Object)id);
        this.debateService.delete(id);
        return ResponseEntity.noContent().headers(HeaderUtil.createEntityDeletionAlert((String)this.applicationName, (boolean)true, (String)ENTITY_NAME, (String)id.toString())).build();
    }

    @PostMapping(value={"/debates/user-like/{topicId}"})
    public ResponseEntity<Void> saveUserLike(@PathVariable Long topicId) {
        this.log.debug("REST request to save user like");
        Long loggedInUserId = Long.parseLong((String)SecurityUtils.getCurrentUserLogin().get());
        this.debateService.saveUserLikeForTopic(topicId, loggedInUserId);
        return ResponseEntity.noContent().build();
    }

    @GetMapping(value={"/debates/user-likes"})
    public ResponseEntity<List<DebateTopicLikeDTO>> getUserLikedTopics() {
        this.log.debug("REST request to get user likes");
        Long loggedInUserId = Long.parseLong((String)SecurityUtils.getCurrentUserLogin().get());
        List response = this.debateService.getAllUserLikedTopics(loggedInUserId);
        return ResponseEntity.ok().body((Object)response);
    }
}

