/*
 * Decompiled with CFR 0.152.
 */
package com.upl.fazorstarclub.web.rest;

import com.upl.fazorstarclub.repository.DebateCommentRepository;
import com.upl.fazorstarclub.service.DebateCommentService;
import com.upl.fazorstarclub.service.dto.DebateCommentDTO;
import com.upl.fazorstarclub.web.rest.errors.BadRequestAlertException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import javax.validation.Valid;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.http.HttpHeaders;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.servlet.support.ServletUriComponentsBuilder;
import org.springframework.web.util.UriComponentsBuilder;
import tech.jhipster.web.util.HeaderUtil;
import tech.jhipster.web.util.PaginationUtil;
import tech.jhipster.web.util.ResponseUtil;

@RestController
@RequestMapping(value={"/api"})
public class DebateCommentResource {
    private final Logger log = LoggerFactory.getLogger(DebateCommentResource.class);
    private static final String ENTITY_NAME = "fazorstarclubDebateComment";
    @Value(value="${jhipster.clientApp.name}")
    private String applicationName;
    private final DebateCommentService debateCommentService;
    private final DebateCommentRepository debateCommentRepository;

    public DebateCommentResource(DebateCommentService debateCommentService, DebateCommentRepository debateCommentRepository) {
        this.debateCommentService = debateCommentService;
        this.debateCommentRepository = debateCommentRepository;
    }

    @PostMapping(value={"/debate-comments"})
    public ResponseEntity<DebateCommentDTO> createDebateComment(@Valid @RequestBody DebateCommentDTO debateCommentDTO) throws URISyntaxException {
        this.log.debug("REST request to save DebateComment : {}", (Object)debateCommentDTO);
        if (debateCommentDTO.getId() != null) {
            throw new BadRequestAlertException("A new debateComment cannot already have an ID", ENTITY_NAME, "idexists");
        }
        DebateCommentDTO result = this.debateCommentService.save(debateCommentDTO);
        return ((ResponseEntity.BodyBuilder)ResponseEntity.created((URI)new URI("/api/debate-comments/" + result.getId())).headers(HeaderUtil.createEntityCreationAlert((String)this.applicationName, (boolean)true, (String)ENTITY_NAME, (String)result.getId().toString()))).body((Object)result);
    }

    @PutMapping(value={"/debate-comments/{id}"})
    public ResponseEntity<DebateCommentDTO> updateDebateComment(@PathVariable(value="id", required=false) Long id, @Valid @RequestBody DebateCommentDTO debateCommentDTO) throws URISyntaxException {
        this.log.debug("REST request to update DebateComment : {}, {}", (Object)id, (Object)debateCommentDTO);
        if (debateCommentDTO.getId() == null) {
            throw new BadRequestAlertException("Invalid id", ENTITY_NAME, "idnull");
        }
        if (!Objects.equals(id, debateCommentDTO.getId())) {
            throw new BadRequestAlertException("Invalid ID", ENTITY_NAME, "idinvalid");
        }
        if (!this.debateCommentRepository.existsById((Object)id)) {
            throw new BadRequestAlertException("Entity not found", ENTITY_NAME, "idnotfound");
        }
        DebateCommentDTO result = this.debateCommentService.save(debateCommentDTO);
        return ((ResponseEntity.BodyBuilder)ResponseEntity.ok().headers(HeaderUtil.createEntityUpdateAlert((String)this.applicationName, (boolean)true, (String)ENTITY_NAME, (String)debateCommentDTO.getId().toString()))).body((Object)result);
    }

    @GetMapping(value={"/debate-comments/topic/{topicId}"})
    public ResponseEntity<List<DebateCommentDTO>> getAllDebateCommentsForTopic(Pageable pageable, @PathVariable Long topicId) {
        this.log.debug("REST request to get a page of DebateComments");
        Page page = this.debateCommentService.findAllByTopicId(pageable, topicId);
        HttpHeaders headers = PaginationUtil.generatePaginationHttpHeaders((UriComponentsBuilder)ServletUriComponentsBuilder.fromCurrentRequest(), (Page)page);
        return ((ResponseEntity.BodyBuilder)ResponseEntity.ok().headers(headers)).body((Object)page.getContent());
    }

    @GetMapping(value={"/debate-comments/{id}"})
    public ResponseEntity<DebateCommentDTO> getDebateComment(@PathVariable Long id) {
        this.log.debug("REST request to get DebateComment : {}", (Object)id);
        Optional debateCommentDTO = this.debateCommentService.findOne(id);
        return ResponseUtil.wrapOrNotFound((Optional)debateCommentDTO);
    }

    @DeleteMapping(value={"/debate-comments/{id}"})
    public ResponseEntity<Void> deleteDebateComment(@PathVariable Long id) {
        this.log.debug("REST request to delete DebateComment : {}", (Object)id);
        this.debateCommentService.delete(id);
        return ResponseEntity.noContent().headers(HeaderUtil.createEntityDeletionAlert((String)this.applicationName, (boolean)true, (String)ENTITY_NAME, (String)id.toString())).build();
    }

    @GetMapping(value={"/debate-comments/user-responses/{topicId}"})
    public ResponseEntity<Long> getUserResponses(@PathVariable Long topicId) {
        this.log.debug("REST request to get user responses");
        Long response = this.debateCommentService.getUserResponses(topicId);
        return ResponseEntity.ok().body((Object)response);
    }
}

