/*
 * Decompiled with CFR 0.152.
 */
package com.upl.fazorstarclub.web.rest;

import com.upl.fazorstarclub.domain.enumeration.Role;
import com.upl.fazorstarclub.service.DataCollectionQueryService;
import com.upl.fazorstarclub.service.DataCollectionService;
import com.upl.fazorstarclub.service.criteria.DataCollectionCriteria;
import com.upl.fazorstarclub.service.dto.DSSResponseDTO;
import com.upl.fazorstarclub.service.dto.DataCollectionDTO;
import com.upl.fazorstarclub.service.dto.UserMapResponseDTO;
import com.upl.fazorstarclub.service.utility.I18nUtility;
import com.upl.fazorstarclub.web.rest.errors.BadRequestAlertException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.List;
import java.util.Optional;
import javax.validation.Valid;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.http.HttpHeaders;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.servlet.support.ServletUriComponentsBuilder;
import org.springframework.web.util.UriComponentsBuilder;
import tech.jhipster.web.util.HeaderUtil;
import tech.jhipster.web.util.PaginationUtil;
import tech.jhipster.web.util.ResponseUtil;

@RestController
@RequestMapping(value={"/api"})
public class DataCollectionResource {
    private final Logger log = LoggerFactory.getLogger(DataCollectionResource.class);
    private static final String ENTITY_NAME = "fazorstarclubDataCollection";
    @Value(value="${jhipster.clientApp.name}")
    private String applicationName;
    private final DataCollectionService dataCollectionService;
    private final DataCollectionQueryService dataCollectionQueryService;
    @Autowired
    private I18nUtility i18nUtility;

    public DataCollectionResource(DataCollectionService dataCollectionService, DataCollectionQueryService dataCollectionQueryService) {
        this.dataCollectionService = dataCollectionService;
        this.dataCollectionQueryService = dataCollectionQueryService;
    }

    @PostMapping(value={"/data-collections"})
    public ResponseEntity<DataCollectionDTO> createDataCollection(@Valid @RequestBody DataCollectionDTO dataCollectionDTO) throws URISyntaxException {
        this.log.debug("REST request to save DataCollection : {}", (Object)dataCollectionDTO);
        if (dataCollectionDTO.getId() != null) {
            String message = this.i18nUtility.getMessage("data.collection.create.id.exception", null);
            throw new BadRequestAlertException(message, ENTITY_NAME, "idexists");
        }
        DataCollectionDTO result = this.dataCollectionService.save(dataCollectionDTO);
        return ((ResponseEntity.BodyBuilder)ResponseEntity.created((URI)new URI("/api/data-collections/" + result.getId())).headers(HeaderUtil.createEntityCreationAlert((String)this.applicationName, (boolean)true, (String)ENTITY_NAME, (String)result.getId().toString()))).body((Object)result);
    }

    @PutMapping(value={"/data-collections"})
    public ResponseEntity<DataCollectionDTO> updateDataCollection(@Valid @RequestBody DataCollectionDTO dataCollectionDTO) throws URISyntaxException {
        this.log.debug("REST request to update DataCollection : {}", (Object)dataCollectionDTO);
        if (dataCollectionDTO.getId() == null) {
            String message = this.i18nUtility.getMessage("data.collection.update.id.exception", null);
            throw new BadRequestAlertException(message, ENTITY_NAME, "idnull");
        }
        DataCollectionDTO result = this.dataCollectionService.save(dataCollectionDTO);
        return ((ResponseEntity.BodyBuilder)ResponseEntity.ok().headers(HeaderUtil.createEntityUpdateAlert((String)this.applicationName, (boolean)true, (String)ENTITY_NAME, (String)dataCollectionDTO.getId().toString()))).body((Object)result);
    }

    @GetMapping(value={"/data-collections"})
    public ResponseEntity<List<DataCollectionDTO>> getAllDataCollections(DataCollectionCriteria criteria, Pageable pageable) {
        this.log.debug("REST request to get DataCollections by criteria: {}", (Object)criteria);
        Page page = this.dataCollectionQueryService.findByCriteria(criteria, pageable);
        HttpHeaders headers = PaginationUtil.generatePaginationHttpHeaders((UriComponentsBuilder)ServletUriComponentsBuilder.fromCurrentRequest(), (Page)page);
        return ((ResponseEntity.BodyBuilder)ResponseEntity.ok().headers(headers)).body((Object)page.getContent());
    }

    @GetMapping(value={"/data-collections/count"})
    public ResponseEntity<Long> countDataCollections(DataCollectionCriteria criteria) {
        this.log.debug("REST request to count DataCollections by criteria: {}", (Object)criteria);
        return ResponseEntity.ok().body((Object)this.dataCollectionQueryService.countByCriteria(criteria));
    }

    @GetMapping(value={"/data-collections/{id}"})
    public ResponseEntity<DataCollectionDTO> getDataCollection(@PathVariable Long id) {
        this.log.debug("REST request to get DataCollection : {}", (Object)id);
        Optional dataCollectionDTO = this.dataCollectionService.findOne(id);
        return ResponseUtil.wrapOrNotFound((Optional)dataCollectionDTO);
    }

    @DeleteMapping(value={"/data-collections/{id}"})
    public ResponseEntity<Void> deleteDataCollection(@PathVariable Long id) {
        this.log.debug("REST request to delete DataCollection : {}", (Object)id);
        this.dataCollectionService.delete(id);
        return ResponseEntity.noContent().headers(HeaderUtil.createEntityDeletionAlert((String)this.applicationName, (boolean)true, (String)ENTITY_NAME, (String)id.toString())).build();
    }

    @GetMapping(value={"/data-collections/user-list"})
    public ResponseEntity<List<UserMapResponseDTO>> getAllUsers(@RequestParam Role role) {
        this.log.debug("REST request to get all users");
        List entityList = this.dataCollectionService.getAllUserList(role);
        return ResponseEntity.ok().body((Object)entityList);
    }

    @GetMapping(value={"/data-collections/potato-emergence-data"})
    public ResponseEntity<List<DSSResponseDTO>> getAllDSSPotatoEmergenceData(@RequestParam Long countryId) {
        this.log.debug("REST request to get all potato emergence data");
        List response = this.dataCollectionService.getAllDSSPotatoEmergenceData(countryId);
        return ResponseEntity.ok().body((Object)response);
    }

    @GetMapping(value={"/data-collections/dss-conditional-data"})
    public ResponseEntity<List<DSSResponseDTO>> getAllDSSConditionalData(@RequestParam Long countryId) {
        this.log.debug("REST request to get all potato emergence data");
        List response = this.dataCollectionService.getAllDSSConditionalData(countryId);
        return ResponseEntity.ok().body((Object)response);
    }
}

