/*
 * Decompiled with CFR 0.152.
 */
package com.upl.fazorstarclub.web.rest;

import com.upl.fazorstarclub.service.CountryQueryService;
import com.upl.fazorstarclub.service.CountryService;
import com.upl.fazorstarclub.service.criteria.CountryCriteria;
import com.upl.fazorstarclub.service.dto.CountryDTO;
import com.upl.fazorstarclub.service.utility.I18nUtility;
import com.upl.fazorstarclub.web.rest.errors.BadRequestAlertException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.List;
import java.util.Optional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.http.ResponseEntity;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;
import tech.jhipster.web.util.HeaderUtil;
import tech.jhipster.web.util.ResponseUtil;

@RestController
@RequestMapping(value={"/api"})
public class CountryResource {
    private final Logger log = LoggerFactory.getLogger(CountryResource.class);
    private static final String ENTITY_NAME = "fazorCountry";
    @Value(value="${jhipster.clientApp.name}")
    private String applicationName;
    private final CountryService countryService;
    private final CountryQueryService countryQueryService;
    @Autowired
    private I18nUtility i18nUtility;

    public CountryResource(CountryService countryService, CountryQueryService countryQueryService) {
        this.countryService = countryService;
        this.countryQueryService = countryQueryService;
    }

    @PostMapping(value={"/countries"})
    @PreAuthorize(value="hasAnyAuthority(\"ADMIN\")")
    public ResponseEntity<CountryDTO> createCountry(@RequestBody CountryDTO countryDTO) throws URISyntaxException {
        this.log.debug("REST request to save Country : {}", (Object)countryDTO);
        if (countryDTO.getId() != null) {
            String message = this.i18nUtility.getMessage("country.create.id.exception", null);
            throw new BadRequestAlertException(message, ENTITY_NAME, "idexists");
        }
        CountryDTO result = this.countryService.save(countryDTO);
        return ((ResponseEntity.BodyBuilder)ResponseEntity.created((URI)new URI("/api/countries/" + result.getId())).headers(HeaderUtil.createEntityCreationAlert((String)this.applicationName, (boolean)false, (String)ENTITY_NAME, (String)result.getId().toString()))).body((Object)result);
    }

    @PutMapping(value={"/countries"})
    @PreAuthorize(value="hasAnyAuthority(\"ADMIN\")")
    public ResponseEntity<CountryDTO> updateCountry(@RequestBody CountryDTO countryDTO) throws URISyntaxException {
        this.log.debug("REST request to update Country : {}", (Object)countryDTO);
        if (countryDTO.getId() == null) {
            String message = this.i18nUtility.getMessage("country.update.id.exception", null);
            throw new BadRequestAlertException(message, ENTITY_NAME, "idnull");
        }
        CountryDTO result = this.countryService.save(countryDTO);
        return ((ResponseEntity.BodyBuilder)ResponseEntity.ok().headers(HeaderUtil.createEntityUpdateAlert((String)this.applicationName, (boolean)false, (String)ENTITY_NAME, (String)countryDTO.getId().toString()))).body((Object)result);
    }

    @GetMapping(value={"/countries"})
    public ResponseEntity<List<CountryDTO>> getAllCountries(CountryCriteria criteria) {
        this.log.debug("REST request to get Countries by criteria: {}", (Object)criteria);
        List entityList = this.countryQueryService.findByCriteria(criteria);
        return ResponseEntity.ok().body((Object)entityList);
    }

    @GetMapping(value={"/countries/{id}"})
    public ResponseEntity<CountryDTO> getCountry(@PathVariable Long id) {
        this.log.debug("REST request to get Country : {}", (Object)id);
        Optional countryDTO = this.countryService.findOne(id);
        return ResponseUtil.wrapOrNotFound((Optional)countryDTO);
    }

    @DeleteMapping(value={"/countries/{id}"})
    @PreAuthorize(value="hasAnyAuthority(\"ADMIN\")")
    public ResponseEntity<Void> deleteCountry(@PathVariable Long id) {
        this.log.debug("REST request to delete Country : {}", (Object)id);
        this.countryService.delete(id);
        return ResponseEntity.noContent().headers(HeaderUtil.createEntityDeletionAlert((String)this.applicationName, (boolean)false, (String)ENTITY_NAME, (String)id.toString())).build();
    }
}

