/*
 * Decompiled with CFR 0.152.
 */
package com.upl.fazorstarclub.web.rest;

import com.upl.fazorstarclub.security.SecurityUtils;
import com.upl.fazorstarclub.security.okta.AuthInfo;
import com.upl.fazorstarclub.security.okta.MobileAuthInfo;
import com.upl.fazorstarclub.service.AuthenticationService;
import com.upl.fazorstarclub.service.dto.AuthenticationDTO;
import com.upl.fazorstarclub.service.dto.JWTTokenDTO;
import com.upl.fazorstarclub.service.utility.I18nUtility;
import com.upl.fazorstarclub.web.rest.errors.BadRequestAlertException;
import com.upl.fazorstarclub.web.rest.vm.JWTTokenVM;
import com.upl.fazorstarclub.web.rest.vm.LoginVM;
import com.upl.fazorstarclub.web.rest.vm.MessageVM;
import com.upl.fazorstarclub.web.rest.vm.MobileAuthenticateVM;
import com.upl.fazorstarclub.web.rest.vm.ResetPasswordVM;
import com.upl.fazorstarclub.web.rest.vm.UpdatePasswordVM;
import com.upl.fazorstarclub.web.rest.vm.UserSignupVM;
import javax.validation.Valid;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/api"})
public class AuthenticationResource {
    private final Logger log = LoggerFactory.getLogger(AuthenticationResource.class);
    @Value(value="${jhipster.clientApp.name}")
    private String applicationName;
    @Autowired
    private I18nUtility i18nUtility;
    private final AuthenticationService authenticationService;

    public AuthenticationResource(AuthenticationService authenticationService) {
        this.authenticationService = authenticationService;
    }

    @PostMapping(value={"/login"})
    public ResponseEntity<JWTTokenDTO> authenticate(@Valid @RequestBody LoginVM loginVM) {
        this.log.debug("REST request to authenticate  : {}", (Object)loginVM);
        JWTTokenDTO jwtTokenDTO = this.authenticationService.authenticate(loginVM.getUsername(), loginVM.getPassword());
        return ResponseEntity.ok().body((Object)jwtTokenDTO);
    }

    @GetMapping(value={"/logout"})
    public ResponseEntity<MessageVM> logout() {
        String token = (String)SecurityUtils.getCurrentUserJWT().get();
        this.log.debug("REST request to logout : {}", (Object)token);
        Boolean result = this.authenticationService.logout(token);
        if (result != null && result.booleanValue()) {
            String message = this.i18nUtility.getMessage("authentication.logout.message", null);
            return ResponseEntity.ok().body((Object)new MessageVM(message));
        }
        String message = this.i18nUtility.getMessage("authentication.logout.token.exception", null);
        throw new BadRequestAlertException(message, "datrixAppUserLogin", "tokennotexists");
    }

    @PostMapping(value={"/authenticate"})
    public ResponseEntity<JWTTokenVM> authenticate(@Valid @RequestBody AuthenticationDTO authenticationDTO) {
        this.log.debug("REST request to authenticate : {}", (Object)authenticationDTO);
        JWTTokenVM jwtTokenVM = new JWTTokenVM(this.authenticationService.authenticate(authenticationDTO));
        return ResponseEntity.ok().body((Object)jwtTokenVM);
    }

    @PostMapping(value={"/mobiles/authenticate"})
    public ResponseEntity<JWTTokenVM> authenticateMobile(@Valid @RequestBody MobileAuthenticateVM mobileAuthenticateVM) {
        this.log.debug("REST request to authenticate mobile user: {}", (Object)mobileAuthenticateVM);
        JWTTokenVM jwtTokenVM = new JWTTokenVM(this.authenticationService.authenticateMobile(mobileAuthenticateVM.getAccessToken()));
        return ResponseEntity.ok().body((Object)jwtTokenVM);
    }

    @GetMapping(value={"/auth-info"})
    public ResponseEntity<AuthInfo> authInfo() {
        this.log.debug("REST request to get authInfo");
        return ResponseEntity.ok().body((Object)this.authenticationService.authInfo());
    }

    @GetMapping(value={"/mobiles/auth-info"})
    public ResponseEntity<MobileAuthInfo> mobileAuthInfo() {
        this.log.debug("REST request to get authInfo");
        return ResponseEntity.ok().body((Object)this.authenticationService.mobileAuthInfo());
    }

    @PostMapping(value={"/user/signup"})
    public ResponseEntity<JWTTokenDTO> userSignup(@Valid @RequestBody UserSignupVM userSignupVM) {
        this.log.debug("REST request to signup user : {}", (Object)userSignupVM);
        JWTTokenDTO jwtTokenDTO = this.authenticationService.userSignup(userSignupVM.getAppUser(), userSignupVM.getUserDevice());
        return ResponseEntity.ok().body((Object)jwtTokenDTO);
    }

    @PostMapping(value={"/reset-password"})
    public ResponseEntity<MessageVM> resetPassword(@Valid @RequestBody ResetPasswordVM resetPasswordVM) {
        this.log.debug("REST request to reset password : {}", (Object)resetPasswordVM);
        Boolean result = this.authenticationService.resetPassword(resetPasswordVM.getEmail(), resetPasswordVM.getgRecaptcha(), resetPasswordVM.getTimeZone());
        String message = null;
        message = result != false ? this.i18nUtility.getMessage("authentication.reset.password.message", null) : this.i18nUtility.getMessage("custom.error.message", null);
        return ResponseEntity.ok().body((Object)new MessageVM(message));
    }

    @PostMapping(value={"/update-password"})
    public ResponseEntity<JWTTokenDTO> updatePassword(@Valid @RequestBody UpdatePasswordVM updatePasswordVM) {
        this.log.debug("REST request to reset password");
        JWTTokenDTO result = this.authenticationService.updatePassword(updatePasswordVM.getNewPassword(), updatePasswordVM.getToken(), updatePasswordVM.getEmail(), updatePasswordVM.getMobileNumber(), updatePasswordVM.getOldPassword(), updatePasswordVM.getgRecaptcha(), updatePasswordVM.getRememberMe());
        return ResponseEntity.ok().body((Object)result);
    }
}

