/*
 * Decompiled with CFR 0.152.
 */
package com.upl.fazorstarclub.web.rest;

import com.upl.fazorstarclub.domain.enumeration.Role;
import com.upl.fazorstarclub.security.SecurityUtils;
import com.upl.fazorstarclub.service.AppUserQueryService;
import com.upl.fazorstarclub.service.AppUserService;
import com.upl.fazorstarclub.service.criteria.AppUserCriteria;
import com.upl.fazorstarclub.service.dto.AppUserDTO;
import com.upl.fazorstarclub.service.dto.AppUserDetailDTO;
import com.upl.fazorstarclub.service.dto.AppUserShortDTO;
import com.upl.fazorstarclub.service.exception.BadRequestException;
import com.upl.fazorstarclub.service.utility.I18nUtility;
import com.upl.fazorstarclub.web.rest.errors.BadRequestAlertException;
import java.io.IOException;
import java.math.BigDecimal;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import javax.validation.Valid;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.http.HttpHeaders;
import org.springframework.http.ResponseEntity;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RequestPart;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.multipart.MultipartFile;
import org.springframework.web.servlet.support.ServletUriComponentsBuilder;
import org.springframework.web.util.UriComponentsBuilder;
import tech.jhipster.service.filter.LongFilter;
import tech.jhipster.web.util.HeaderUtil;
import tech.jhipster.web.util.PaginationUtil;
import tech.jhipster.web.util.ResponseUtil;

@RestController
@RequestMapping(value={"/api"})
public class AppUserResource {
    private final Logger log = LoggerFactory.getLogger(AppUserResource.class);
    private static final String ENTITY_NAME = "fazorstarclubAppUser";
    @Value(value="${jhipster.clientApp.name}")
    private String applicationName;
    private final AppUserService appUserService;
    private final AppUserQueryService appUserQueryService;
    @Autowired
    private I18nUtility i18nUtility;

    public AppUserResource(AppUserService appUserService, AppUserQueryService appUserQueryService) {
        this.appUserService = appUserService;
        this.appUserQueryService = appUserQueryService;
    }

    @PostMapping(value={"/app-users"})
    @PreAuthorize(value="hasAnyAuthority(\"ADMIN\", \"DISTRIBUTOR_ADMIN\", \"TECHNICIEN_AGRI\")")
    public ResponseEntity<AppUserDTO> createAppUser(@Valid @RequestBody AppUserDTO appUserDTO) throws URISyntaxException {
        this.log.debug("REST request to save AppUser : {}", (Object)appUserDTO);
        Long loggedInUserId = Long.parseLong((String)SecurityUtils.getCurrentUserLogin().get());
        this.log.debug("REST request to save AppUser : {}", (Object)appUserDTO);
        if (appUserDTO.getId() != null) {
            String message = this.i18nUtility.getMessage("appuser.create.id.exception", null);
            throw new BadRequestAlertException(message, ENTITY_NAME, "idexists");
        }
        if (SecurityUtils.isCurrentUserInRole((String)"DISTRIBUTOR_ADMIN")) {
            if (!"TECHNICIEN_AGRI".equals(Role.findByString((String)appUserDTO.getRole()).toString()) && !"AGRICULTEUR".equals(Role.findByString((String)appUserDTO.getRole()).toString())) {
                String message = this.i18nUtility.getMessage("appuser.create.role.exception", null);
                throw new BadRequestAlertException(message, ENTITY_NAME, "roleIssue");
            }
        } else if (SecurityUtils.isCurrentUserInRole((String)"ADMIN")) {
            if (!("DISTRIBUTOR_ADMIN".equals(Role.findByString((String)appUserDTO.getRole()).toString()) || "TECHNICIEN_AGRI".equals(Role.findByString((String)appUserDTO.getRole()).toString()) || "AGRICULTEUR".equals(Role.findByString((String)appUserDTO.getRole()).toString()))) {
                String message = this.i18nUtility.getMessage("appuser.create.role.exception", null);
                throw new BadRequestAlertException(message, ENTITY_NAME, "roleIssue");
            }
        } else if (SecurityUtils.isCurrentUserInRole((String)"TECHNICIEN_AGRI")) {
            if (!"AGRICULTEUR".equals(Role.findByString((String)appUserDTO.getRole()).toString())) {
                String message = this.i18nUtility.getMessage("appuser.create.role.exception", null);
                throw new BadRequestAlertException(message, ENTITY_NAME, "roleIssue");
            }
            appUserDTO.setParentId(loggedInUserId);
        }
        AppUserDTO result = this.appUserService.save(appUserDTO);
        return ((ResponseEntity.BodyBuilder)ResponseEntity.created((URI)new URI("/api/app-users/" + result.getId())).headers(HeaderUtil.createEntityCreationAlert((String)this.applicationName, (boolean)true, (String)ENTITY_NAME, (String)result.getId().toString()))).body((Object)result);
    }

    @PutMapping(value={"/app-users"})
    @PreAuthorize(value="hasAnyAuthority(\"ADMIN\", \"DISTRIBUTOR_ADMIN\", \"TECHNICIEN_AGRI\",\"AGRICULTEUR\")")
    public ResponseEntity<AppUserDTO> updateAppUser(@Valid @RequestBody AppUserDTO appUserDTO) throws URISyntaxException {
        this.log.debug("REST request to update AppUser : {}", (Object)appUserDTO);
        if (appUserDTO.getId() == null) {
            String message = this.i18nUtility.getMessage("appuser.update.id.exception", null);
            throw new BadRequestAlertException(message, ENTITY_NAME, "idnull");
        }
        Long loggedInUserId = Long.parseLong((String)SecurityUtils.getCurrentUserLogin().get());
        AppUserDTO result = null;
        if (loggedInUserId.equals(appUserDTO.getId()) || SecurityUtils.isCurrentUserInRole((String)"ADMIN") || SecurityUtils.isCurrentUserInRole((String)"DISTRIBUTOR_ADMIN") || SecurityUtils.isCurrentUserInRole((String)"TECHNICIEN_AGRI")) {
            if (SecurityUtils.isCurrentUserInRole((String)"ADMIN") && !loggedInUserId.equals(appUserDTO.getId())) {
                if (!("DISTRIBUTOR_ADMIN".equals(Role.findByString((String)appUserDTO.getRole()).toString()) || "TECHNICIEN_AGRI".equals(Role.findByString((String)appUserDTO.getRole()).toString()) || "AGRICULTEUR".equals(Role.findByString((String)appUserDTO.getRole()).toString()))) {
                    String message = this.i18nUtility.getMessage("appuser.create.role.exception", null);
                    throw new BadRequestAlertException(message, ENTITY_NAME, "roleIssue");
                }
            } else if (SecurityUtils.isCurrentUserInRole((String)"DISTRIBUTOR_ADMIN") && !loggedInUserId.equals(appUserDTO.getId())) {
                if (!"TECHNICIEN_AGRI".equals(Role.findByString((String)appUserDTO.getRole()).toString()) && !"AGRICULTEUR".equals(Role.findByString((String)appUserDTO.getRole()).toString())) {
                    String message = this.i18nUtility.getMessage("appuser.create.role.exception", null);
                    throw new BadRequestAlertException(message, ENTITY_NAME, "roleIssue");
                }
            } else if (!(!SecurityUtils.isCurrentUserInRole((String)"TECHNICIEN_AGRI") || "AGRICULTEUR".equals(Role.findByString((String)appUserDTO.getRole()).toString()) && loggedInUserId.equals(appUserDTO.getParentId()))) {
                String message = this.i18nUtility.getMessage("appuser.create.role.exception", null);
                throw new BadRequestAlertException(message, ENTITY_NAME, "parentIdIssue");
            }
            result = this.appUserService.save(appUserDTO);
        }
        if (result != null) {
            return ((ResponseEntity.BodyBuilder)ResponseEntity.ok().headers(HeaderUtil.createEntityUpdateAlert((String)this.applicationName, (boolean)true, (String)ENTITY_NAME, (String)appUserDTO.getId().toString()))).body((Object)result);
        }
        String message = this.i18nUtility.getMessage("appuser.update.unauthorized.exception", null);
        throw new BadRequestAlertException(message, ENTITY_NAME, "Unauthorized");
    }

    @PostMapping(value={"/app-users/{id}/profile-image"})
    public ResponseEntity<AppUserDTO> uploadProfileImage(@RequestPart(value="file") MultipartFile file, @PathVariable Long id) throws IOException {
        Long loggedInUserId = Long.parseLong((String)SecurityUtils.getCurrentUserLogin().get());
        if (loggedInUserId.equals(id) || SecurityUtils.isCurrentUserInRole((String)"ADMIN") || SecurityUtils.isCurrentUserInRole((String)"DISTRIBUTOR_ADMIN")) {
            Optional existingAppUserDTO;
            if (SecurityUtils.isCurrentUserInRole((String)"DISTRIBUTOR_ADMIN") && !loggedInUserId.equals(id) && (existingAppUserDTO = this.appUserService.findOne(id)).isPresent() && !((AppUserDTO)existingAppUserDTO.get()).getParentId().equals(loggedInUserId)) {
                String message = this.i18nUtility.getMessage("appuser.image.role.exception", null);
                throw new BadRequestAlertException(message, ENTITY_NAME, "parentIdIssue");
            }
            this.log.debug("profile image upload and save for AppUserId : {}", (Object)id);
            AppUserDTO result = this.appUserService.uploadAndSaveProfileImage(id, file);
            return ResponseEntity.ok().body((Object)result);
        }
        String message = this.i18nUtility.getMessage("appuser.image.unauthorized.exception", null);
        throw new BadRequestAlertException(message, ENTITY_NAME, "Unauthorized");
    }

    @GetMapping(value={"/app-users/all"})
    @PreAuthorize(value="hasAnyAuthority(\"ADMIN\", \"DISTRIBUTOR_ADMIN\", \"TECHNICIEN_AGRI\",\"AGRICULTEUR\")")
    public ResponseEntity<List<AppUserDetailDTO>> getAllAppUsers(AppUserCriteria criteria, Pageable pageable) {
        this.log.debug("REST request to get AppUsers by criteria: {}", (Object)criteria);
        Long loggedInUserId = Long.parseLong((String)SecurityUtils.getCurrentUserLogin().get());
        if (SecurityUtils.isCurrentUserInRole((String)"ADMIN")) {
            if ("ADMIN".equals(((Role)criteria.getRole().getEquals()).toString())) {
                this.log.error("User is not authorized to access admin data");
                String message = this.i18nUtility.getMessage("appuser.create.role.exception", null);
                throw new BadRequestException(message);
            }
        } else if (SecurityUtils.isCurrentUserInRole((String)"DISTRIBUTOR_ADMIN")) {
            if (!"TECHNICIEN_AGRI".equals(((Role)criteria.getRole().getEquals()).toString()) && !"AGRICULTEUR".equals(((Role)criteria.getRole().getEquals()).toString())) {
                this.log.error("User is not authorized to access data");
                String message = this.i18nUtility.getMessage("appuser.create.role.exception", null);
                throw new BadRequestException(message);
            }
        } else if (SecurityUtils.isCurrentUserInRole((String)"TECHNICIEN_AGRI")) {
            if (!"AGRICULTEUR".equals(((Role)criteria.getRole().getEquals()).toString())) {
                this.log.error("User is not authorized to access data");
                String message = this.i18nUtility.getMessage("appuser.create.role.exception", null);
                throw new BadRequestException(message);
            }
            AppUserCriteria.RoleFilter role = new AppUserCriteria.RoleFilter();
            role.setEquals((Object)Role.AGRICULTEUR);
            criteria.setRole(role);
            LongFilter parentId = new LongFilter();
            parentId.setEquals((Object)loggedInUserId);
            criteria.setParentId(parentId);
        }
        Page page = this.appUserQueryService.findByCriteria(criteria, pageable);
        HttpHeaders headers = PaginationUtil.generatePaginationHttpHeaders((UriComponentsBuilder)ServletUriComponentsBuilder.fromCurrentRequest(), (Page)page);
        return ((ResponseEntity.BodyBuilder)ResponseEntity.ok().headers(headers)).body((Object)page.getContent());
    }

    @GetMapping(value={"/app-users"})
    public ResponseEntity<AppUserDTO> getAppUser() {
        Long id = Long.parseLong((String)SecurityUtils.getCurrentUserLogin().get());
        this.log.debug("REST request to get  AppUser : { }", (Object)id);
        Optional appUserDTO = this.appUserService.findOne(id);
        return ResponseUtil.wrapOrNotFound((Optional)appUserDTO);
    }

    @GetMapping(value={"/app-users/count"})
    public ResponseEntity<Long> countAppUsers(AppUserCriteria criteria) {
        this.log.debug("REST request to count AppUsers by criteria: {}", (Object)criteria);
        return ResponseEntity.ok().body((Object)this.appUserQueryService.countByCriteria(criteria));
    }

    @GetMapping(value={"/app-users/{id}"})
    @PreAuthorize(value="hasAnyAuthority(\"ADMIN\", \"DISTRIBUTOR_ADMIN\", \"TECHNICIEN_AGRI\")")
    public ResponseEntity<AppUserDTO> getAppUser(@PathVariable Long id) {
        this.log.debug("REST request to get AppUser : {}", (Object)id);
        Long loggedInUserId = Long.parseLong((String)SecurityUtils.getCurrentUserLogin().get());
        Optional appUserDTO = this.appUserService.findOne(id);
        if (appUserDTO.isPresent() && (SecurityUtils.isCurrentUserInRole((String)"ADMIN") || SecurityUtils.isCurrentUserInRole((String)"DISTRIBUTOR_ADMIN") || SecurityUtils.isCurrentUserInRole((String)"TECHNICIEN_AGRI"))) {
            if (SecurityUtils.isCurrentUserInRole((String)"ADMIN") && !loggedInUserId.equals(((AppUserDTO)appUserDTO.get()).getId())) {
                if (!("DISTRIBUTOR_ADMIN".equals(Role.findByString((String)((AppUserDTO)appUserDTO.get()).getRole()).toString()) || "TECHNICIEN_AGRI".equals(Role.findByString((String)((AppUserDTO)appUserDTO.get()).getRole()).toString()) || "AGRICULTEUR".equals(Role.findByString((String)((AppUserDTO)appUserDTO.get()).getRole()).toString()))) {
                    String message = this.i18nUtility.getMessage("appuser.create.role.exception", null);
                    throw new BadRequestAlertException(message, ENTITY_NAME, "roleIssue");
                }
            } else if (SecurityUtils.isCurrentUserInRole((String)"DISTRIBUTOR_ADMIN") && !loggedInUserId.equals(((AppUserDTO)appUserDTO.get()).getId())) {
                if (!"TECHNICIEN_AGRI".equals(Role.findByString((String)((AppUserDTO)appUserDTO.get()).getRole()).toString()) && !"AGRICULTEUR".equals(Role.findByString((String)((AppUserDTO)appUserDTO.get()).getRole()).toString())) {
                    String message = this.i18nUtility.getMessage("appuser.create.role.exception", null);
                    throw new BadRequestAlertException(message, ENTITY_NAME, "roleIssue");
                }
            } else if (!(!SecurityUtils.isCurrentUserInRole((String)"TECHNICIEN_AGRI") || "AGRICULTEUR".equals(Role.findByString((String)((AppUserDTO)appUserDTO.get()).getRole()).toString()) && loggedInUserId.equals(((AppUserDTO)appUserDTO.get()).getParentId()))) {
                String message = this.i18nUtility.getMessage("appuser.create.role.exception", null);
                throw new BadRequestAlertException(message, ENTITY_NAME, "parentIdIssue");
            }
        }
        return ResponseUtil.wrapOrNotFound((Optional)appUserDTO);
    }

    @DeleteMapping(value={"/app-users/{id}"})
    @PreAuthorize(value="hasAnyAuthority(\"ADMIN\", \"DISTRIBUTOR_ADMIN\", \"TECHNICIEN_AGRI\")")
    public ResponseEntity<Void> deleteAppUser(@PathVariable Long id) {
        this.log.debug("REST request to delete AppUser : {}", (Object)id);
        Long loggedInUserId = Long.parseLong((String)SecurityUtils.getCurrentUserLogin().get());
        Optional appUserDTO = this.appUserService.findOne(id);
        if (appUserDTO.isPresent() && (SecurityUtils.isCurrentUserInRole((String)"ADMIN") || SecurityUtils.isCurrentUserInRole((String)"DISTRIBUTOR_ADMIN") || SecurityUtils.isCurrentUserInRole((String)"TECHNICIEN_AGRI"))) {
            if (SecurityUtils.isCurrentUserInRole((String)"ADMIN") && !loggedInUserId.equals(id)) {
                if (!("DISTRIBUTOR_ADMIN".equals(Role.findByString((String)((AppUserDTO)appUserDTO.get()).getRole()).toString()) || "TECHNICIEN_AGRI".equals(Role.findByString((String)((AppUserDTO)appUserDTO.get()).getRole()).toString()) || "AGRICULTEUR".equals(Role.findByString((String)((AppUserDTO)appUserDTO.get()).getRole()).toString()))) {
                    String message = this.i18nUtility.getMessage("appuser.delete.admin.role.exception", null);
                    throw new BadRequestAlertException(message, ENTITY_NAME, "roleIssue");
                }
            } else if (SecurityUtils.isCurrentUserInRole((String)"DISTRIBUTOR_ADMIN") && !loggedInUserId.equals(id)) {
                if (!"TECHNICIEN_AGRI".equals(Role.findByString((String)((AppUserDTO)appUserDTO.get()).getRole()).toString()) && !"AGRICULTEUR".equals(Role.findByString((String)((AppUserDTO)appUserDTO.get()).getRole()).toString())) {
                    String message = this.i18nUtility.getMessage("appuser.delete.admin.role.exception", null);
                    throw new BadRequestAlertException(message, ENTITY_NAME, "roleIssue");
                }
            } else if (SecurityUtils.isCurrentUserInRole((String)"TECHNICIEN_AGRI") && !loggedInUserId.equals(id) && !"AGRICULTEUR".equals(Role.findByString((String)((AppUserDTO)appUserDTO.get()).getRole()).toString()) && !loggedInUserId.equals(((AppUserDTO)appUserDTO.get()).getParentId())) {
                String message = this.i18nUtility.getMessage("appuser.delete.role.exception", null);
                throw new BadRequestAlertException(message, ENTITY_NAME, "parentIdIssue");
            }
        }
        this.appUserService.delete(id);
        return ResponseEntity.noContent().headers(HeaderUtil.createEntityDeletionAlert((String)this.applicationName, (boolean)true, (String)ENTITY_NAME, (String)id.toString())).build();
    }

    @GetMapping(value={"/app-users/user-type"})
    public ResponseEntity<List<String>> getTypeOfUser() {
        this.log.debug("REST request to get type of user");
        List<String> userTypeList = Arrays.asList(Role.DISTRIBUTOR_ADMIN.getValue().toString(), Role.TECHNICIEN_AGRI.getValue().toString(), Role.AGRICULTEUR.getValue().toString());
        return ResponseEntity.ok().body(userTypeList);
    }

    @GetMapping(value={"/app-users/drop-down"})
    public ResponseEntity<List<AppUserShortDTO>> getAllNearByDistributorsOrTechnicians(@RequestParam Role role, @RequestParam BigDecimal latitude, @RequestParam BigDecimal longitude) {
        this.log.debug("REST request to get all app users");
        List response = this.appUserService.getAllNearByDistributorsOrTechnicians(role, latitude, longitude);
        return ResponseEntity.ok().body((Object)response);
    }
}

