/*
 * Decompiled with CFR 0.152.
 */
package com.upl.fazorstarclub.service.utility;

import com.upl.fazorstarclub.domain.UserFarm;
import com.upl.fazorstarclub.service.dto.UserFarmWeatherCurrentDetailDTO;
import com.upl.fazorstarclub.service.dto.UserFarmWeatherDetailDTO;
import com.upl.fazorstarclub.service.dto.UserFarmWeatherHistoryDetailDTO;
import com.upl.fazorstarclub.service.exception.BadRequestException;
import com.upl.fazorstarclub.service.utility.I18nUtility;
import com.upl.fazorstarclub.service.utility.WeatherAgriDetail;
import com.upl.fazorstarclub.service.utility.WeatherAgriInfo;
import com.upl.fazorstarclub.service.utility.WeatherCurrentDetail;
import com.upl.fazorstarclub.service.utility.WeatherCurrentInfo;
import com.upl.fazorstarclub.service.utility.WeatherDetail;
import com.upl.fazorstarclub.service.utility.WeatherHistoryDetail;
import com.upl.fazorstarclub.service.utility.WeatherHistoryInfo;
import com.upl.fazorstarclub.service.utility.WeatherHistoryTask;
import com.upl.fazorstarclub.service.utility.WeatherInfo;
import java.math.BigDecimal;
import java.text.SimpleDateFormat;
import java.time.LocalDate;
import java.time.temporal.ChronoUnit;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import org.apache.commons.lang3.time.DateUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Component;
import org.springframework.web.client.RestTemplate;

@Component
public class WeatherUtility {
    private final Logger log = LoggerFactory.getLogger(WeatherUtility.class);
    @Value(value="${application.weather-bit-link:}")
    private String weatherBitLink;
    @Value(value="${application.weather-bit-api-key:}")
    private String weatherBitApiKey;
    @Autowired
    private I18nUtility i18nUtility;
    private static final String DATE_FORMATE = "yyyy-MM-dd";

    public List<UserFarmWeatherDetailDTO> fetchWeatherForcastDetails(UserFarm userFarm) {
        RestTemplate restTemplate = new RestTemplate();
        try {
            WeatherInfo weatherInfo = (WeatherInfo)restTemplate.getForObject(this.weatherBitLink + "/forecast/daily?lat=" + userFarm.getLatitude() + "&lon=" + userFarm.getLongitude() + "&days=9&key=" + this.weatherBitApiKey, WeatherInfo.class, new Object[0]);
            WeatherAgriInfo weatherAgriInfo = (WeatherAgriInfo)restTemplate.getForObject(this.weatherBitLink + "/forecast/agweather?lat=" + userFarm.getLatitude() + "&lon=" + userFarm.getLongitude() + "&key=" + this.weatherBitApiKey, WeatherAgriInfo.class, new Object[0]);
            ArrayList<UserFarmWeatherDetailDTO> UserFieldWeatherDetailDTOs = new ArrayList<UserFarmWeatherDetailDTO>();
            for (int responseNumber = 0; responseNumber < weatherAgriInfo.getData().size(); ++responseNumber) {
                UserFarmWeatherDetailDTO userFieldWeatherDetailDTO = this.setWeatherResponseToDto(weatherInfo, weatherAgriInfo, responseNumber);
                UserFieldWeatherDetailDTOs.add(userFieldWeatherDetailDTO);
            }
            return UserFieldWeatherDetailDTOs;
        }
        catch (Exception e) {
            this.log.error("Error while fetch data from weather api {}", (Throwable)e);
            String message = this.i18nUtility.getMessage("weather.fetch.info.response.exception", null);
            throw new BadRequestException(message);
        }
    }

    private UserFarmWeatherDetailDTO setWeatherResponseToDto(WeatherInfo weatherInfo, WeatherAgriInfo weatherAgriInfo, int responseNumber) {
        UserFarmWeatherDetailDTO userFieldWeatherDetailDTO = new UserFarmWeatherDetailDTO();
        userFieldWeatherDetailDTO.setMoonriseTs(((WeatherDetail)weatherInfo.getData().get(responseNumber)).getMoonrise_ts());
        userFieldWeatherDetailDTO.setWindCdir(((WeatherDetail)weatherInfo.getData().get(responseNumber)).getWind_cdir());
        userFieldWeatherDetailDTO.setRh(((WeatherDetail)weatherInfo.getData().get(responseNumber)).getRh());
        userFieldWeatherDetailDTO.setPres(((WeatherDetail)weatherInfo.getData().get(responseNumber)).getPres());
        userFieldWeatherDetailDTO.setHighTemp(((WeatherDetail)weatherInfo.getData().get(responseNumber)).getHigh_temp());
        userFieldWeatherDetailDTO.setOzone(((WeatherDetail)weatherInfo.getData().get(responseNumber)).getOzone());
        userFieldWeatherDetailDTO.setMoonPhase(((WeatherDetail)weatherInfo.getData().get(responseNumber)).getMoon_phase());
        userFieldWeatherDetailDTO.setWindGustSpd(((WeatherDetail)weatherInfo.getData().get(responseNumber)).getWind_gust_spd());
        userFieldWeatherDetailDTO.setSnowDepth(((WeatherDetail)weatherInfo.getData().get(responseNumber)).getSnow_depth());
        userFieldWeatherDetailDTO.setClouds(((WeatherDetail)weatherInfo.getData().get(responseNumber)).getClouds());
        userFieldWeatherDetailDTO.setTs(((WeatherDetail)weatherInfo.getData().get(responseNumber)).getTs());
        userFieldWeatherDetailDTO.setSunriseTs(((WeatherDetail)weatherInfo.getData().get(responseNumber)).getSunrise_ts());
        userFieldWeatherDetailDTO.setAppMinTemp(((WeatherDetail)weatherInfo.getData().get(responseNumber)).getApp_min_temp());
        userFieldWeatherDetailDTO.setWindSpd(((WeatherDetail)weatherInfo.getData().get(responseNumber)).getWind_spd());
        userFieldWeatherDetailDTO.setPop(((WeatherDetail)weatherInfo.getData().get(responseNumber)).getPop());
        userFieldWeatherDetailDTO.setWindCdirFull(((WeatherDetail)weatherInfo.getData().get(responseNumber)).getWind_cdir_full());
        userFieldWeatherDetailDTO.setSlp(((WeatherDetail)weatherInfo.getData().get(responseNumber)).getSlp());
        userFieldWeatherDetailDTO.setMoonPhaseLunation(((WeatherDetail)weatherInfo.getData().get(responseNumber)).getMoon_phase_lunation());
        userFieldWeatherDetailDTO.setAppMaxTemp(((WeatherDetail)weatherInfo.getData().get(responseNumber)).getApp_max_temp());
        userFieldWeatherDetailDTO.setVis(((WeatherDetail)weatherInfo.getData().get(responseNumber)).getVis());
        userFieldWeatherDetailDTO.setDewpt(((WeatherDetail)weatherInfo.getData().get(responseNumber)).getDewpt());
        userFieldWeatherDetailDTO.setSnow(((WeatherDetail)weatherInfo.getData().get(responseNumber)).getSnow());
        userFieldWeatherDetailDTO.setUv(((WeatherDetail)weatherInfo.getData().get(responseNumber)).getUv());
        userFieldWeatherDetailDTO.setIcon(((WeatherDetail)weatherInfo.getData().get(responseNumber)).getWeather().getIcon());
        userFieldWeatherDetailDTO.setCode(((WeatherDetail)weatherInfo.getData().get(responseNumber)).getWeather().getCode());
        userFieldWeatherDetailDTO.setDescription(((WeatherDetail)weatherInfo.getData().get(responseNumber)).getWeather().getDescription());
        userFieldWeatherDetailDTO.setWindDir(((WeatherDetail)weatherInfo.getData().get(responseNumber)).getWind_dir());
        userFieldWeatherDetailDTO.setMaxDhi(((WeatherDetail)weatherInfo.getData().get(responseNumber)).getMax_dhi());
        userFieldWeatherDetailDTO.setCloudsHi(((WeatherDetail)weatherInfo.getData().get(responseNumber)).getClouds_hi());
        userFieldWeatherDetailDTO.setLowTemp(((WeatherDetail)weatherInfo.getData().get(responseNumber)).getLow_temp());
        userFieldWeatherDetailDTO.setMaxTemp(((WeatherDetail)weatherInfo.getData().get(responseNumber)).getMax_temp());
        userFieldWeatherDetailDTO.setMinTemp(((WeatherDetail)weatherInfo.getData().get(responseNumber)).getMin_temp());
        userFieldWeatherDetailDTO.setMoonsetTs(((WeatherDetail)weatherInfo.getData().get(responseNumber)).getMoonset_ts());
        userFieldWeatherDetailDTO.setTemp(((WeatherDetail)weatherInfo.getData().get(responseNumber)).getTemp());
        userFieldWeatherDetailDTO.setCloudsMid(((WeatherDetail)weatherInfo.getData().get(responseNumber)).getClouds_mid());
        userFieldWeatherDetailDTO.setCloudsLow(((WeatherDetail)weatherInfo.getData().get(responseNumber)).getClouds_low());
        userFieldWeatherDetailDTO.setDate(((WeatherAgriDetail)weatherAgriInfo.getData().get(responseNumber)).getValid_date());
        userFieldWeatherDetailDTO.setBulkSoilDensity(((WeatherAgriDetail)weatherAgriInfo.getData().get(responseNumber)).getBulk_soil_density());
        userFieldWeatherDetailDTO.setSkinTempMax(((WeatherAgriDetail)weatherAgriInfo.getData().get(responseNumber)).getSkin_temp_max());
        userFieldWeatherDetailDTO.setSkinTempAvg(((WeatherAgriDetail)weatherAgriInfo.getData().get(responseNumber)).getSkin_temp_avg());
        userFieldWeatherDetailDTO.setSkinTempMin(((WeatherAgriDetail)weatherAgriInfo.getData().get(responseNumber)).getSkin_temp_min());
        userFieldWeatherDetailDTO.setTemp2mAvg(((WeatherAgriDetail)weatherAgriInfo.getData().get(responseNumber)).getTemp_2m_avg());
        userFieldWeatherDetailDTO.setPrecip(((WeatherAgriDetail)weatherAgriInfo.getData().get(responseNumber)).getPrecip());
        userFieldWeatherDetailDTO.setSpecificHumidity(((WeatherAgriDetail)weatherAgriInfo.getData().get(responseNumber)).getSpecific_humidity());
        userFieldWeatherDetailDTO.setEvapotranspiration(((WeatherAgriDetail)weatherAgriInfo.getData().get(responseNumber)).getEvapotranspiration());
        userFieldWeatherDetailDTO.setPresAvg(((WeatherAgriDetail)weatherAgriInfo.getData().get(responseNumber)).getPres_avg());
        userFieldWeatherDetailDTO.setWind10mSpdAvg(((WeatherAgriDetail)weatherAgriInfo.getData().get(responseNumber)).getWind_10m_spd_avg());
        userFieldWeatherDetailDTO.setDlwrfAvg(((WeatherAgriDetail)weatherAgriInfo.getData().get(responseNumber)).getDlwrf_avg());
        userFieldWeatherDetailDTO.setDlwrfMax(((WeatherAgriDetail)weatherAgriInfo.getData().get(responseNumber)).getDlwrf_max());
        userFieldWeatherDetailDTO.setDswrfAvg(((WeatherAgriDetail)weatherAgriInfo.getData().get(responseNumber)).getDswrf_avg());
        userFieldWeatherDetailDTO.setDswrfMax(((WeatherAgriDetail)weatherAgriInfo.getData().get(responseNumber)).getDswrf_max());
        userFieldWeatherDetailDTO.setDswrfNet(((WeatherAgriDetail)weatherAgriInfo.getData().get(responseNumber)).getDswrf_net());
        userFieldWeatherDetailDTO.setDlwrfNet(((WeatherAgriDetail)weatherAgriInfo.getData().get(responseNumber)).getDlwrf_net());
        userFieldWeatherDetailDTO.setSoilm0To10cm(((WeatherAgriDetail)weatherAgriInfo.getData().get(responseNumber)).getSoilm_0_10cm());
        userFieldWeatherDetailDTO.setSoilm10To40cm(((WeatherAgriDetail)weatherAgriInfo.getData().get(responseNumber)).getSoilm_10_40cm());
        userFieldWeatherDetailDTO.setSoilm40To100cm(((WeatherAgriDetail)weatherAgriInfo.getData().get(responseNumber)).getSoilm_40_100cm());
        userFieldWeatherDetailDTO.setSoilm100To200cm(((WeatherAgriDetail)weatherAgriInfo.getData().get(responseNumber)).getSoilm_100_200cm());
        userFieldWeatherDetailDTO.setvSoilm0To10cm(((WeatherAgriDetail)weatherAgriInfo.getData().get(responseNumber)).getV_soilm_0_10cm());
        userFieldWeatherDetailDTO.setvSoilm10To40cm(((WeatherAgriDetail)weatherAgriInfo.getData().get(responseNumber)).getV_soilm_10_40cm());
        userFieldWeatherDetailDTO.setvSoilm40To100cm(((WeatherAgriDetail)weatherAgriInfo.getData().get(responseNumber)).getV_soilm_40_100cm());
        userFieldWeatherDetailDTO.setvSoilm100To200cm(((WeatherAgriDetail)weatherAgriInfo.getData().get(responseNumber)).getV_soilm_100_200cm());
        userFieldWeatherDetailDTO.setSoilt0To10cm(((WeatherAgriDetail)weatherAgriInfo.getData().get(responseNumber)).getSoilt_0_10cm());
        userFieldWeatherDetailDTO.setSoilt10To40cm(((WeatherAgriDetail)weatherAgriInfo.getData().get(responseNumber)).getSoilt_10_40cm());
        userFieldWeatherDetailDTO.setSoilt40To100cm(((WeatherAgriDetail)weatherAgriInfo.getData().get(responseNumber)).getSoilt_40_100cm());
        userFieldWeatherDetailDTO.setSoilt100To200cm(((WeatherAgriDetail)weatherAgriInfo.getData().get(responseNumber)).getSoilt_100_200cm());
        userFieldWeatherDetailDTO.setLatitude(weatherAgriInfo.getLat());
        userFieldWeatherDetailDTO.setLongitude(weatherAgriInfo.getLon());
        userFieldWeatherDetailDTO.setProcessFlag(Boolean.valueOf(false));
        Double averageSoilMoisture = this.getAverage(userFieldWeatherDetailDTO.getSoilm0To10cm(), userFieldWeatherDetailDTO.getSoilm10To40cm(), userFieldWeatherDetailDTO.getSoilm40To100cm(), userFieldWeatherDetailDTO.getSoilm100To200cm());
        Double averageVolumetricSoilMoisture = this.getAverage(userFieldWeatherDetailDTO.getvSoilm0To10cm(), userFieldWeatherDetailDTO.getvSoilm10To40cm(), userFieldWeatherDetailDTO.getvSoilm40To100cm(), userFieldWeatherDetailDTO.getvSoilm100To200cm());
        Double averageSoilTemperature = this.getAverage(userFieldWeatherDetailDTO.getSoilt0To10cm(), userFieldWeatherDetailDTO.getSoilt10To40cm(), userFieldWeatherDetailDTO.getSoilt40To100cm(), userFieldWeatherDetailDTO.getSoilt100To200cm());
        userFieldWeatherDetailDTO.setAverageSoilMoisture(averageSoilMoisture);
        userFieldWeatherDetailDTO.setAverageVolumetricSoilMoisture(averageVolumetricSoilMoisture);
        userFieldWeatherDetailDTO.setAverageSoilTemperature(averageSoilTemperature);
        return userFieldWeatherDetailDTO;
    }

    private Double getAverage(Double soil0To10cm, Double soil10To40cm, Double soil40To100cm, Double soil100To200cm) {
        Double average = (soil0To10cm + soil10To40cm + soil40To100cm + soil100To200cm) / 4.0;
        return average;
    }

    public List<UserFarmWeatherCurrentDetailDTO> fetchWeatherCurrentDetails(UserFarm userFarm) {
        RestTemplate restTemplate = new RestTemplate();
        try {
            WeatherCurrentInfo weatherCurrentInfo = (WeatherCurrentInfo)restTemplate.getForObject(this.weatherBitLink + "/forecast/hourly?lat=" + userFarm.getLatitude() + "&lon=" + userFarm.getLongitude() + "&hours=24&key=" + this.weatherBitApiKey, WeatherCurrentInfo.class, new Object[0]);
            ArrayList<UserFarmWeatherCurrentDetailDTO> userFieldWeatherCurrentDetailDTOs = new ArrayList<UserFarmWeatherCurrentDetailDTO>();
            for (int responseNumber = 0; responseNumber < weatherCurrentInfo.getData().size(); ++responseNumber) {
                UserFarmWeatherCurrentDetailDTO userFieldWeatherCurrentDetailDTO = this.setWeatherCurrentResponseToDto(weatherCurrentInfo, responseNumber);
                userFieldWeatherCurrentDetailDTOs.add(userFieldWeatherCurrentDetailDTO);
            }
            return userFieldWeatherCurrentDetailDTOs;
        }
        catch (Exception e) {
            this.log.error("Error while fetch data from weather api {}", (Throwable)e);
            String message = this.i18nUtility.getMessage("weather.fetch.info.response.exception", null);
            throw new BadRequestException(message);
        }
    }

    private UserFarmWeatherCurrentDetailDTO setWeatherCurrentResponseToDto(WeatherCurrentInfo weatherCurrentInfo, int responseNumber) {
        UserFarmWeatherCurrentDetailDTO userFieldWeatherCurrentDetailDTO = new UserFarmWeatherCurrentDetailDTO();
        userFieldWeatherCurrentDetailDTO.setWindCdir(((WeatherCurrentDetail)weatherCurrentInfo.getData().get(responseNumber)).getWind_cdir());
        userFieldWeatherCurrentDetailDTO.setRh(((WeatherCurrentDetail)weatherCurrentInfo.getData().get(responseNumber)).getRh());
        userFieldWeatherCurrentDetailDTO.setPod(((WeatherCurrentDetail)weatherCurrentInfo.getData().get(responseNumber)).getPod());
        userFieldWeatherCurrentDetailDTO.setTimestampUtc(((WeatherCurrentDetail)weatherCurrentInfo.getData().get(responseNumber)).getTimestamp_utc());
        userFieldWeatherCurrentDetailDTO.setPres(((WeatherCurrentDetail)weatherCurrentInfo.getData().get(responseNumber)).getPres());
        userFieldWeatherCurrentDetailDTO.setSolarRad(((WeatherCurrentDetail)weatherCurrentInfo.getData().get(responseNumber)).getSolar_rad());
        userFieldWeatherCurrentDetailDTO.setOzone(((WeatherCurrentDetail)weatherCurrentInfo.getData().get(responseNumber)).getOzone());
        userFieldWeatherCurrentDetailDTO.setIcon(((WeatherCurrentDetail)weatherCurrentInfo.getData().get(responseNumber)).getWeather().getIcon());
        userFieldWeatherCurrentDetailDTO.setCode(((WeatherCurrentDetail)weatherCurrentInfo.getData().get(responseNumber)).getWeather().getCode());
        userFieldWeatherCurrentDetailDTO.setDescription(((WeatherCurrentDetail)weatherCurrentInfo.getData().get(responseNumber)).getWeather().getDescription());
        userFieldWeatherCurrentDetailDTO.setWindGustSpd(((WeatherCurrentDetail)weatherCurrentInfo.getData().get(responseNumber)).getWind_gust_spd());
        userFieldWeatherCurrentDetailDTO.setTimestampLocal(((WeatherCurrentDetail)weatherCurrentInfo.getData().get(responseNumber)).getTimestamp_local());
        userFieldWeatherCurrentDetailDTO.setSnowDepth(((WeatherCurrentDetail)weatherCurrentInfo.getData().get(responseNumber)).getSnow_depth());
        userFieldWeatherCurrentDetailDTO.setClouds(((WeatherCurrentDetail)weatherCurrentInfo.getData().get(responseNumber)).getClouds());
        userFieldWeatherCurrentDetailDTO.setTs(((WeatherCurrentDetail)weatherCurrentInfo.getData().get(responseNumber)).getTs());
        userFieldWeatherCurrentDetailDTO.setWindSpd(((WeatherCurrentDetail)weatherCurrentInfo.getData().get(responseNumber)).getWind_spd());
        userFieldWeatherCurrentDetailDTO.setPop(((WeatherCurrentDetail)weatherCurrentInfo.getData().get(responseNumber)).getPop());
        userFieldWeatherCurrentDetailDTO.setWindCdirFull(((WeatherCurrentDetail)weatherCurrentInfo.getData().get(responseNumber)).getWind_cdir_full());
        userFieldWeatherCurrentDetailDTO.setSlp(((WeatherCurrentDetail)weatherCurrentInfo.getData().get(responseNumber)).getSlp());
        userFieldWeatherCurrentDetailDTO.setDni(((WeatherCurrentDetail)weatherCurrentInfo.getData().get(responseNumber)).getDni());
        userFieldWeatherCurrentDetailDTO.setDewpt(((WeatherCurrentDetail)weatherCurrentInfo.getData().get(responseNumber)).getDewpt());
        userFieldWeatherCurrentDetailDTO.setSnow(((WeatherCurrentDetail)weatherCurrentInfo.getData().get(responseNumber)).getSnow());
        userFieldWeatherCurrentDetailDTO.setUv(((WeatherCurrentDetail)weatherCurrentInfo.getData().get(responseNumber)).getUv());
        userFieldWeatherCurrentDetailDTO.setWindDir(((WeatherCurrentDetail)weatherCurrentInfo.getData().get(responseNumber)).getWind_dir());
        userFieldWeatherCurrentDetailDTO.setCloudsHi(((WeatherCurrentDetail)weatherCurrentInfo.getData().get(responseNumber)).getClouds_hi());
        userFieldWeatherCurrentDetailDTO.setPrecip(((WeatherCurrentDetail)weatherCurrentInfo.getData().get(responseNumber)).getPrecip());
        userFieldWeatherCurrentDetailDTO.setVis(((WeatherCurrentDetail)weatherCurrentInfo.getData().get(responseNumber)).getVis());
        userFieldWeatherCurrentDetailDTO.setDhi(((WeatherCurrentDetail)weatherCurrentInfo.getData().get(responseNumber)).getDhi());
        userFieldWeatherCurrentDetailDTO.setAppTemp(((WeatherCurrentDetail)weatherCurrentInfo.getData().get(responseNumber)).getApp_temp());
        userFieldWeatherCurrentDetailDTO.setDatetime(((WeatherCurrentDetail)weatherCurrentInfo.getData().get(responseNumber)).getDatetime());
        userFieldWeatherCurrentDetailDTO.setTemp(((WeatherCurrentDetail)weatherCurrentInfo.getData().get(responseNumber)).getTemp());
        userFieldWeatherCurrentDetailDTO.setGhi(((WeatherCurrentDetail)weatherCurrentInfo.getData().get(responseNumber)).getGhi());
        userFieldWeatherCurrentDetailDTO.setCloudsMid(((WeatherCurrentDetail)weatherCurrentInfo.getData().get(responseNumber)).getClouds_mid());
        userFieldWeatherCurrentDetailDTO.setCloudsLow(((WeatherCurrentDetail)weatherCurrentInfo.getData().get(responseNumber)).getClouds_low());
        userFieldWeatherCurrentDetailDTO.setCityName(weatherCurrentInfo.getCity_name());
        userFieldWeatherCurrentDetailDTO.setLon(weatherCurrentInfo.getLon());
        userFieldWeatherCurrentDetailDTO.setLat(weatherCurrentInfo.getLat());
        userFieldWeatherCurrentDetailDTO.setTimezone(weatherCurrentInfo.getTimezone());
        userFieldWeatherCurrentDetailDTO.setCountryCode(weatherCurrentInfo.getCountry_code());
        userFieldWeatherCurrentDetailDTO.setStateCode(weatherCurrentInfo.getState_code());
        return userFieldWeatherCurrentDetailDTO;
    }

    public List<UserFarmWeatherHistoryDetailDTO> fetchWeatherHistoryDetails(BigDecimal latitude, BigDecimal longitude, String startDate, String endDate) {
        try {
            Date sDate = new SimpleDateFormat(DATE_FORMATE).parse(startDate);
            Date eDate = new SimpleDateFormat(DATE_FORMATE).parse(endDate);
            startDate = new SimpleDateFormat(DATE_FORMATE).format(sDate);
            endDate = new SimpleDateFormat(DATE_FORMATE).format(eDate);
            long months = ChronoUnit.MONTHS.between(LocalDate.parse(startDate), LocalDate.parse(endDate));
            System.out.println(months);
            ArrayList<UserFarmWeatherHistoryDetailDTO> userFieldWeatherHistoryDetailDTOs = new ArrayList<UserFarmWeatherHistoryDetailDTO>();
            ArrayList<String> dates = new ArrayList<String>();
            int i = 0;
            while ((long)i <= months) {
                eDate = i == 0 ? (months == 0L ? eDate : DateUtils.addMonths((Date)sDate, (int)1)) : eDate;
                String startingDate = new SimpleDateFormat(DATE_FORMATE).format(sDate);
                String endingDate = new SimpleDateFormat(DATE_FORMATE).format(eDate);
                if (!sDate.after(new Date())) {
                    dates.add(startingDate + "," + endingDate);
                    Date date = new SimpleDateFormat(DATE_FORMATE).parse(startingDate);
                    Date d2 = new SimpleDateFormat(DATE_FORMATE).parse(endingDate);
                    long differentInTime = d2.getTime() - date.getTime();
                    Long lastDays = differentInTime / 86400000L % 365L;
                    if (lastDays == 0L) break;
                    if (lastDays < 30L) {
                        sDate = DateUtils.addDays((Date)eDate, (int)1);
                        eDate = DateUtils.addDays((Date)eDate, (int)lastDays.intValue());
                    } else {
                        sDate = DateUtils.addDays((Date)eDate, (int)1);
                        eDate = DateUtils.addMonths((Date)sDate, (int)1);
                    }
                }
                ++i;
            }
            ArrayList results = new ArrayList();
            ExecutorService executorService = Executors.newFixedThreadPool(12);
            for (int i2 = 0; i2 < dates.size(); ++i2) {
                WeatherHistoryTask weatherHistoryTask = new WeatherHistoryTask(latitude, longitude, (String)dates.get(i2), this.weatherBitLink, this.weatherBitApiKey);
                Future result = executorService.submit(weatherHistoryTask);
                results.add(result);
            }
            for (Future future : results) {
                userFieldWeatherHistoryDetailDTOs.addAll((Collection)future.get());
            }
            executorService.shutdown();
            return userFieldWeatherHistoryDetailDTOs;
        }
        catch (Exception e) {
            this.log.error("Error while fetch data from weather api {}", (Throwable)e);
            String message = this.i18nUtility.getMessage("weather.fetch.info.response.exception", null);
            throw new BadRequestException(message);
        }
    }

    public UserFarmWeatherHistoryDetailDTO setWeatherHistoryResponseToDto(WeatherHistoryInfo weatherHistoryInfo, WeatherAgriInfo weatherAgriInfo, int responseNumber) {
        UserFarmWeatherHistoryDetailDTO userFieldWeatherHistoryDetailDTO = new UserFarmWeatherHistoryDetailDTO();
        userFieldWeatherHistoryDetailDTO.setRh(((WeatherHistoryDetail)weatherHistoryInfo.getData().get(responseNumber)).getRh());
        userFieldWeatherHistoryDetailDTO.setMaxWindSpdTs(((WeatherHistoryDetail)weatherHistoryInfo.getData().get(responseNumber)).getMax_wind_spd_ts());
        userFieldWeatherHistoryDetailDTO.settGhi(((WeatherHistoryDetail)weatherHistoryInfo.getData().get(responseNumber)).getT_ghi());
        userFieldWeatherHistoryDetailDTO.setMaxWindSpd(((WeatherHistoryDetail)weatherHistoryInfo.getData().get(responseNumber)).getMax_wind_spd());
        userFieldWeatherHistoryDetailDTO.setSolarRad(((WeatherHistoryDetail)weatherHistoryInfo.getData().get(responseNumber)).getSolar_rad());
        userFieldWeatherHistoryDetailDTO.setWindGustSpd(((WeatherHistoryDetail)weatherHistoryInfo.getData().get(responseNumber)).getWind_gust_spd());
        userFieldWeatherHistoryDetailDTO.setMaxTempTs(((WeatherHistoryDetail)weatherHistoryInfo.getData().get(responseNumber)).getMax_temp_ts());
        userFieldWeatherHistoryDetailDTO.setMinTempTs(((WeatherHistoryDetail)weatherHistoryInfo.getData().get(responseNumber)).getMin_temp_ts());
        userFieldWeatherHistoryDetailDTO.setClouds(((WeatherHistoryDetail)weatherHistoryInfo.getData().get(responseNumber)).getClouds());
        userFieldWeatherHistoryDetailDTO.setMaxDni(((WeatherHistoryDetail)weatherHistoryInfo.getData().get(responseNumber)).getMax_dni());
        userFieldWeatherHistoryDetailDTO.setPrecipGpm(((WeatherHistoryDetail)weatherHistoryInfo.getData().get(responseNumber)).getPrecip_gpm());
        userFieldWeatherHistoryDetailDTO.setWindSpd(((WeatherHistoryDetail)weatherHistoryInfo.getData().get(responseNumber)).getWind_spd());
        userFieldWeatherHistoryDetailDTO.setSlp(((WeatherHistoryDetail)weatherHistoryInfo.getData().get(responseNumber)).getSlp());
        userFieldWeatherHistoryDetailDTO.setTs(((WeatherHistoryDetail)weatherHistoryInfo.getData().get(responseNumber)).getTs());
        userFieldWeatherHistoryDetailDTO.setMaxGhi(((WeatherHistoryDetail)weatherHistoryInfo.getData().get(responseNumber)).getMax_ghi());
        userFieldWeatherHistoryDetailDTO.setTemp(((WeatherHistoryDetail)weatherHistoryInfo.getData().get(responseNumber)).getTemp());
        userFieldWeatherHistoryDetailDTO.setPres(((WeatherHistoryDetail)weatherHistoryInfo.getData().get(responseNumber)).getPres());
        userFieldWeatherHistoryDetailDTO.setDni(((WeatherHistoryDetail)weatherHistoryInfo.getData().get(responseNumber)).getDni());
        userFieldWeatherHistoryDetailDTO.setDewpt(((WeatherHistoryDetail)weatherHistoryInfo.getData().get(responseNumber)).getDewpt());
        userFieldWeatherHistoryDetailDTO.setSnow(((WeatherHistoryDetail)weatherHistoryInfo.getData().get(responseNumber)).getSnow());
        userFieldWeatherHistoryDetailDTO.setDhi(((WeatherHistoryDetail)weatherHistoryInfo.getData().get(responseNumber)).getDhi());
        userFieldWeatherHistoryDetailDTO.setWindDir(((WeatherHistoryDetail)weatherHistoryInfo.getData().get(responseNumber)).getWind_dir());
        userFieldWeatherHistoryDetailDTO.setMaxDhi(((WeatherHistoryDetail)weatherHistoryInfo.getData().get(responseNumber)).getMax_dhi());
        userFieldWeatherHistoryDetailDTO.setGhi(((WeatherHistoryDetail)weatherHistoryInfo.getData().get(responseNumber)).getGhi());
        userFieldWeatherHistoryDetailDTO.setMaxtemp(((WeatherHistoryDetail)weatherHistoryInfo.getData().get(responseNumber)).getMax_temp());
        userFieldWeatherHistoryDetailDTO.settDni(((WeatherHistoryDetail)weatherHistoryInfo.getData().get(responseNumber)).getDni());
        userFieldWeatherHistoryDetailDTO.setMaxUv(((WeatherHistoryDetail)weatherHistoryInfo.getData().get(responseNumber)).getMax_uv());
        userFieldWeatherHistoryDetailDTO.settDhi(((WeatherHistoryDetail)weatherHistoryInfo.getData().get(responseNumber)).getT_dhi());
        userFieldWeatherHistoryDetailDTO.setDatetime(((WeatherHistoryDetail)weatherHistoryInfo.getData().get(responseNumber)).getDatetime());
        userFieldWeatherHistoryDetailDTO.settSolarRad(((WeatherHistoryDetail)weatherHistoryInfo.getData().get(responseNumber)).getT_solar_rad());
        userFieldWeatherHistoryDetailDTO.setMinTemp(((WeatherHistoryDetail)weatherHistoryInfo.getData().get(responseNumber)).getMin_temp());
        userFieldWeatherHistoryDetailDTO.setMaxWindDir(((WeatherHistoryDetail)weatherHistoryInfo.getData().get(responseNumber)).getMax_wind_dir());
        userFieldWeatherHistoryDetailDTO.setSnowDepth(((WeatherHistoryDetail)weatherHistoryInfo.getData().get(responseNumber)).getSnow_depth());
        userFieldWeatherHistoryDetailDTO.setDate(((WeatherAgriDetail)weatherAgriInfo.getData().get(responseNumber)).getValid_date());
        userFieldWeatherHistoryDetailDTO.setBulkSoilDensity(((WeatherAgriDetail)weatherAgriInfo.getData().get(responseNumber)).getBulk_soil_density());
        userFieldWeatherHistoryDetailDTO.setSkinTempMax(((WeatherAgriDetail)weatherAgriInfo.getData().get(responseNumber)).getSkin_temp_max());
        userFieldWeatherHistoryDetailDTO.setSkinTempAvg(((WeatherAgriDetail)weatherAgriInfo.getData().get(responseNumber)).getSkin_temp_avg());
        userFieldWeatherHistoryDetailDTO.setSkinTempMin(((WeatherAgriDetail)weatherAgriInfo.getData().get(responseNumber)).getSkin_temp_min());
        userFieldWeatherHistoryDetailDTO.setTemp2mAvg(((WeatherAgriDetail)weatherAgriInfo.getData().get(responseNumber)).getTemp_2m_avg());
        userFieldWeatherHistoryDetailDTO.setPrecip(((WeatherAgriDetail)weatherAgriInfo.getData().get(responseNumber)).getPrecip());
        userFieldWeatherHistoryDetailDTO.setSpecificHumidity(((WeatherAgriDetail)weatherAgriInfo.getData().get(responseNumber)).getSpecific_humidity());
        userFieldWeatherHistoryDetailDTO.setEvapotranspiration(((WeatherAgriDetail)weatherAgriInfo.getData().get(responseNumber)).getEvapotranspiration());
        userFieldWeatherHistoryDetailDTO.setPresAvg(((WeatherAgriDetail)weatherAgriInfo.getData().get(responseNumber)).getPres_avg());
        userFieldWeatherHistoryDetailDTO.setWind10mSpdAvg(((WeatherAgriDetail)weatherAgriInfo.getData().get(responseNumber)).getWind_10m_spd_avg());
        userFieldWeatherHistoryDetailDTO.setDlwrfAvg(((WeatherAgriDetail)weatherAgriInfo.getData().get(responseNumber)).getDlwrf_avg());
        userFieldWeatherHistoryDetailDTO.setDlwrfMax(((WeatherAgriDetail)weatherAgriInfo.getData().get(responseNumber)).getDlwrf_max());
        userFieldWeatherHistoryDetailDTO.setDswrfAvg(((WeatherAgriDetail)weatherAgriInfo.getData().get(responseNumber)).getDswrf_avg());
        userFieldWeatherHistoryDetailDTO.setDswrfMax(((WeatherAgriDetail)weatherAgriInfo.getData().get(responseNumber)).getDswrf_max());
        userFieldWeatherHistoryDetailDTO.setDswrfNet(((WeatherAgriDetail)weatherAgriInfo.getData().get(responseNumber)).getDswrf_net());
        userFieldWeatherHistoryDetailDTO.setDlwrfNet(((WeatherAgriDetail)weatherAgriInfo.getData().get(responseNumber)).getDlwrf_net());
        userFieldWeatherHistoryDetailDTO.setSoilm0To10cm(((WeatherAgriDetail)weatherAgriInfo.getData().get(responseNumber)).getSoilm_0_10cm());
        userFieldWeatherHistoryDetailDTO.setSoilm10To40cm(((WeatherAgriDetail)weatherAgriInfo.getData().get(responseNumber)).getSoilm_10_40cm());
        userFieldWeatherHistoryDetailDTO.setSoilm40To100cm(((WeatherAgriDetail)weatherAgriInfo.getData().get(responseNumber)).getSoilm_40_100cm());
        userFieldWeatherHistoryDetailDTO.setSoilm100To200cm(((WeatherAgriDetail)weatherAgriInfo.getData().get(responseNumber)).getSoilm_100_200cm());
        userFieldWeatherHistoryDetailDTO.setvSoilm0To10cm(((WeatherAgriDetail)weatherAgriInfo.getData().get(responseNumber)).getV_soilm_0_10cm());
        userFieldWeatherHistoryDetailDTO.setvSoilm10To40cm(((WeatherAgriDetail)weatherAgriInfo.getData().get(responseNumber)).getV_soilm_10_40cm());
        userFieldWeatherHistoryDetailDTO.setvSoilm40To100cm(((WeatherAgriDetail)weatherAgriInfo.getData().get(responseNumber)).getV_soilm_40_100cm());
        userFieldWeatherHistoryDetailDTO.setvSoilm100To200cm(((WeatherAgriDetail)weatherAgriInfo.getData().get(responseNumber)).getV_soilm_100_200cm());
        userFieldWeatherHistoryDetailDTO.setSoilt0To10cm(((WeatherAgriDetail)weatherAgriInfo.getData().get(responseNumber)).getSoilt_0_10cm());
        userFieldWeatherHistoryDetailDTO.setSoilt10To40cm(((WeatherAgriDetail)weatherAgriInfo.getData().get(responseNumber)).getSoilt_10_40cm());
        userFieldWeatherHistoryDetailDTO.setSoilt40To100cm(((WeatherAgriDetail)weatherAgriInfo.getData().get(responseNumber)).getSoilt_40_100cm());
        userFieldWeatherHistoryDetailDTO.setSoilt100To200cm(((WeatherAgriDetail)weatherAgriInfo.getData().get(responseNumber)).getSoilt_100_200cm());
        userFieldWeatherHistoryDetailDTO.setLatitude(weatherAgriInfo.getLat());
        userFieldWeatherHistoryDetailDTO.setLongitude(weatherAgriInfo.getLon());
        Double averageSoilMoisture = this.getAverage(userFieldWeatherHistoryDetailDTO.getSoilm0To10cm(), userFieldWeatherHistoryDetailDTO.getSoilm10To40cm(), userFieldWeatherHistoryDetailDTO.getSoilm40To100cm(), userFieldWeatherHistoryDetailDTO.getSoilm100To200cm());
        Double averageVolumetricSoilMoisture = this.getAverage(userFieldWeatherHistoryDetailDTO.getvSoilm0To10cm(), userFieldWeatherHistoryDetailDTO.getvSoilm10To40cm(), userFieldWeatherHistoryDetailDTO.getvSoilm40To100cm(), userFieldWeatherHistoryDetailDTO.getvSoilm100To200cm());
        Double averageSoilTemperature = this.getAverage(userFieldWeatherHistoryDetailDTO.getSoilt0To10cm(), userFieldWeatherHistoryDetailDTO.getSoilt10To40cm(), userFieldWeatherHistoryDetailDTO.getSoilt40To100cm(), userFieldWeatherHistoryDetailDTO.getSoilt100To200cm());
        userFieldWeatherHistoryDetailDTO.setAverageSoilMoisture(averageSoilMoisture);
        userFieldWeatherHistoryDetailDTO.setAverageVolumetricSoilMoisture(averageVolumetricSoilMoisture);
        userFieldWeatherHistoryDetailDTO.setAverageSoilTemperature(averageSoilTemperature);
        return userFieldWeatherHistoryDetailDTO;
    }

    public UserFarmWeatherDetailDTO convHistoryToWeatherDetailDTO(UserFarmWeatherHistoryDetailDTO userFarmWeatherHistoryDetailDTO, BigDecimal latitude, BigDecimal longitude, UserFarm userFarm) {
        UserFarmWeatherDetailDTO userFarmWeatherDetailDTO = new UserFarmWeatherDetailDTO();
        userFarmWeatherDetailDTO.setRh(userFarmWeatherHistoryDetailDTO.getRh());
        userFarmWeatherDetailDTO.setPres(userFarmWeatherHistoryDetailDTO.getPres());
        userFarmWeatherDetailDTO.setWindGustSpd(userFarmWeatherHistoryDetailDTO.getWindGustSpd());
        userFarmWeatherDetailDTO.setSnowDepth(userFarmWeatherHistoryDetailDTO.getSnowDepth());
        userFarmWeatherDetailDTO.setClouds(userFarmWeatherHistoryDetailDTO.getClouds());
        userFarmWeatherDetailDTO.setTs(userFarmWeatherHistoryDetailDTO.getTs());
        userFarmWeatherDetailDTO.setWindSpd(userFarmWeatherHistoryDetailDTO.getWindSpd());
        userFarmWeatherDetailDTO.setSlp(userFarmWeatherHistoryDetailDTO.getSlp());
        userFarmWeatherDetailDTO.setDewpt(userFarmWeatherHistoryDetailDTO.getDewpt());
        userFarmWeatherDetailDTO.setSnow(userFarmWeatherHistoryDetailDTO.getSnow());
        userFarmWeatherDetailDTO.setWindDir(userFarmWeatherHistoryDetailDTO.getWindDir());
        userFarmWeatherDetailDTO.setMaxDhi(userFarmWeatherHistoryDetailDTO.getMaxDhi());
        userFarmWeatherDetailDTO.setMaxTemp(userFarmWeatherHistoryDetailDTO.getMaxtemp());
        userFarmWeatherDetailDTO.setMinTemp(userFarmWeatherHistoryDetailDTO.getMinTemp());
        userFarmWeatherDetailDTO.setTemp(userFarmWeatherHistoryDetailDTO.getTemp());
        userFarmWeatherDetailDTO.setDate(userFarmWeatherHistoryDetailDTO.getDate());
        userFarmWeatherDetailDTO.setBulkSoilDensity(userFarmWeatherHistoryDetailDTO.getBulkSoilDensity());
        userFarmWeatherDetailDTO.setSkinTempMax(userFarmWeatherHistoryDetailDTO.getSkinTempMax());
        userFarmWeatherDetailDTO.setSkinTempAvg(userFarmWeatherHistoryDetailDTO.getSkinTempAvg());
        userFarmWeatherDetailDTO.setSkinTempMin(userFarmWeatherHistoryDetailDTO.getSkinTempMin());
        userFarmWeatherDetailDTO.setTemp2mAvg(userFarmWeatherHistoryDetailDTO.getTemp2mAvg());
        userFarmWeatherDetailDTO.setPrecip(userFarmWeatherHistoryDetailDTO.getPrecip());
        userFarmWeatherDetailDTO.setSpecificHumidity(userFarmWeatherHistoryDetailDTO.getSpecificHumidity());
        userFarmWeatherDetailDTO.setEvapotranspiration(userFarmWeatherHistoryDetailDTO.getEvapotranspiration());
        userFarmWeatherDetailDTO.setPresAvg(userFarmWeatherHistoryDetailDTO.getPresAvg());
        userFarmWeatherDetailDTO.setWind10mSpdAvg(userFarmWeatherHistoryDetailDTO.getWind10mSpdAvg());
        userFarmWeatherDetailDTO.setDlwrfAvg(userFarmWeatherHistoryDetailDTO.getDlwrfAvg());
        userFarmWeatherDetailDTO.setDlwrfMax(userFarmWeatherHistoryDetailDTO.getDlwrfMax());
        userFarmWeatherDetailDTO.setDswrfAvg(userFarmWeatherHistoryDetailDTO.getDswrfAvg());
        userFarmWeatherDetailDTO.setDswrfMax(userFarmWeatherHistoryDetailDTO.getDswrfMax());
        userFarmWeatherDetailDTO.setDswrfNet(userFarmWeatherHistoryDetailDTO.getDswrfNet());
        userFarmWeatherDetailDTO.setDlwrfNet(userFarmWeatherHistoryDetailDTO.getDlwrfNet());
        userFarmWeatherDetailDTO.setSoilm0To10cm(userFarmWeatherHistoryDetailDTO.getSoilm0To10cm());
        userFarmWeatherDetailDTO.setSoilm10To40cm(userFarmWeatherHistoryDetailDTO.getSoilm10To40cm());
        userFarmWeatherDetailDTO.setSoilm40To100cm(userFarmWeatherHistoryDetailDTO.getSoilm40To100cm());
        userFarmWeatherDetailDTO.setSoilm100To200cm(userFarmWeatherHistoryDetailDTO.getSoilm100To200cm());
        userFarmWeatherDetailDTO.setvSoilm0To10cm(userFarmWeatherHistoryDetailDTO.getvSoilm0To10cm());
        userFarmWeatherDetailDTO.setvSoilm10To40cm(userFarmWeatherHistoryDetailDTO.getvSoilm10To40cm());
        userFarmWeatherDetailDTO.setvSoilm40To100cm(userFarmWeatherHistoryDetailDTO.getvSoilm40To100cm());
        userFarmWeatherDetailDTO.setvSoilm100To200cm(userFarmWeatherHistoryDetailDTO.getvSoilm100To200cm());
        userFarmWeatherDetailDTO.setSoilt0To10cm(userFarmWeatherHistoryDetailDTO.getSoilt0To10cm());
        userFarmWeatherDetailDTO.setSoilt10To40cm(userFarmWeatherHistoryDetailDTO.getSoilt10To40cm());
        userFarmWeatherDetailDTO.setSoilt40To100cm(userFarmWeatherHistoryDetailDTO.getSoilt40To100cm());
        userFarmWeatherDetailDTO.setSoilt100To200cm(userFarmWeatherHistoryDetailDTO.getSoilt100To200cm());
        userFarmWeatherDetailDTO.setLatitude(latitude);
        userFarmWeatherDetailDTO.setLongitude(longitude);
        userFarmWeatherDetailDTO.setUserFarmId(userFarm.getId());
        userFarmWeatherDetailDTO.setProcessFlag(Boolean.valueOf(false));
        Double averageSoilMoisture = this.getAverage(userFarmWeatherDetailDTO.getSoilm0To10cm(), userFarmWeatherDetailDTO.getSoilm10To40cm(), userFarmWeatherDetailDTO.getSoilm40To100cm(), userFarmWeatherDetailDTO.getSoilm100To200cm());
        Double averageVolumetricSoilMoisture = this.getAverage(userFarmWeatherDetailDTO.getvSoilm0To10cm(), userFarmWeatherDetailDTO.getvSoilm10To40cm(), userFarmWeatherDetailDTO.getvSoilm40To100cm(), userFarmWeatherDetailDTO.getvSoilm100To200cm());
        Double averageSoilTemperature = this.getAverage(userFarmWeatherDetailDTO.getSoilt0To10cm(), userFarmWeatherDetailDTO.getSoilt10To40cm(), userFarmWeatherDetailDTO.getSoilt40To100cm(), userFarmWeatherDetailDTO.getSoilt100To200cm());
        userFarmWeatherDetailDTO.setAverageSoilMoisture(averageSoilMoisture);
        userFarmWeatherDetailDTO.setAverageVolumetricSoilMoisture(averageVolumetricSoilMoisture);
        userFarmWeatherDetailDTO.setAverageSoilTemperature(averageSoilTemperature);
        return userFarmWeatherDetailDTO;
    }
}

