/*
 * Decompiled with CFR 0.152.
 */
package com.upl.fazorstarclub.service.utility;

import com.upl.fazorstarclub.service.dto.UserFarmWeatherHistoryDetailDTO;
import com.upl.fazorstarclub.service.utility.WeatherAgriInfo;
import com.upl.fazorstarclub.service.utility.WeatherHistoryInfo;
import com.upl.fazorstarclub.service.utility.WeatherUtility;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.Callable;
import org.springframework.web.client.RestTemplate;

public class WeatherHistoryTask
implements Callable<List<UserFarmWeatherHistoryDetailDTO>> {
    private String dates;
    private BigDecimal latitude;
    private BigDecimal longitude;
    private String weatherBitLink;
    private String weatherBitApiKey;

    public WeatherHistoryTask(BigDecimal latitude, BigDecimal longitude, String dates, String weatherBitLink, String weatherBitApiKey) {
        this.latitude = latitude;
        this.longitude = longitude;
        this.dates = dates;
        this.weatherBitLink = weatherBitLink;
        this.weatherBitApiKey = weatherBitApiKey;
    }

    @Override
    public List<UserFarmWeatherHistoryDetailDTO> call() throws Exception {
        String startingDate = this.dates.split(",")[0];
        String endingDate = this.dates.split(",")[1];
        RestTemplate restTemplate = new RestTemplate();
        WeatherUtility weatherUtility = new WeatherUtility();
        ArrayList<UserFarmWeatherHistoryDetailDTO> userFieldWeatherHistoryDetailDTOs = new ArrayList<UserFarmWeatherHistoryDetailDTO>();
        WeatherHistoryInfo weatherHistoryInfo = (WeatherHistoryInfo)restTemplate.getForObject(this.weatherBitLink + "/history/daily?lat=" + this.latitude + "&lon=" + this.longitude + "&start_date=" + startingDate + "&end_date=" + endingDate + "&key=" + this.weatherBitApiKey, WeatherHistoryInfo.class, new Object[0]);
        WeatherAgriInfo weatherAgriInfo = (WeatherAgriInfo)restTemplate.getForObject(this.weatherBitLink + "/history/agweather?lat=" + this.latitude + "&lon=" + this.longitude + "&start_date=" + startingDate + "&end_date=" + endingDate + "&key=" + this.weatherBitApiKey, WeatherAgriInfo.class, new Object[0]);
        for (int responseNumber = 0; responseNumber < weatherAgriInfo.getData().size(); ++responseNumber) {
            UserFarmWeatherHistoryDetailDTO userFieldWeatherHistoryDetailDTO = weatherUtility.setWeatherHistoryResponseToDto(weatherHistoryInfo, weatherAgriInfo, responseNumber);
            userFieldWeatherHistoryDetailDTOs.add(userFieldWeatherHistoryDetailDTO);
        }
        return userFieldWeatherHistoryDetailDTOs;
    }
}

