/*
 * Decompiled with CFR 0.152.
 */
package com.upl.fazorstarclub.service.utility;

import com.upl.fazorstarclub.domain.AppUser;
import com.upl.fazorstarclub.service.utility.I18nUtility;
import java.nio.charset.StandardCharsets;
import java.util.Calendar;
import java.util.Locale;
import javax.mail.MessagingException;
import javax.mail.internet.MimeMessage;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.MessageSource;
import org.springframework.core.io.InputStreamSource;
import org.springframework.mail.MailException;
import org.springframework.mail.javamail.JavaMailSender;
import org.springframework.mail.javamail.MimeMessageHelper;
import org.springframework.scheduling.annotation.Async;
import org.springframework.stereotype.Service;
import org.thymeleaf.context.Context;
import org.thymeleaf.context.IContext;
import org.thymeleaf.spring5.SpringTemplateEngine;
import tech.jhipster.config.JHipsterProperties;

@Service
public class MailUtility {
    private final Logger log = LoggerFactory.getLogger(MailUtility.class);
    private static final String USER = "user";
    private static final String BASE_URL = "baseUrl";
    private final JHipsterProperties jHipsterProperties;
    private final JavaMailSender javaMailSender;
    private final MessageSource messageSource;
    private final SpringTemplateEngine templateEngine;
    @Value(value="${application.contactus-email-recipients:}")
    private String contactusEmailRecipients;
    @Value(value="${application.bcc-email-recipients:}")
    private String bccEmailRecipients;
    @Value(value="${application.web-url:}")
    private String webUrl;
    @Value(value="${application.default-language:}")
    private String defaultLanguage;
    @Value(value="${application.image-base-path:}")
    private String imageBasePath;
    @Value(value="${application.upload-base-path:}")
    private String uploadBasePath;
    @Autowired
    private I18nUtility i18nUtility;

    public MailUtility(JHipsterProperties jHipsterProperties, JavaMailSender javaMailSender, MessageSource messageSource, SpringTemplateEngine templateEngine) {
        this.jHipsterProperties = jHipsterProperties;
        this.javaMailSender = javaMailSender;
        this.messageSource = messageSource;
        this.templateEngine = templateEngine;
    }

    @Async(value="taskExecutor")
    public void sendEmailFromTemplate(String[] to, String templateName, String titleKey, Context context, Object[] args, Locale locale) {
        context.setVariable(BASE_URL, (Object)this.jHipsterProperties.getMail().getBaseUrl());
        String content = this.templateEngine.process(templateName, (IContext)context);
        String subject = this.messageSource.getMessage(titleKey, args, locale);
        this.sendEmail(to, subject, content, false, true, null, null, null);
    }

    @Async(value="taskExecutor")
    public void sendEmail(String[] to, String subject, String content, boolean isMultipart, boolean isHtml, InputStreamSource inputStream, String fileName, String contentType) {
        this.log.debug("Send email[multipart '{}' and html '{}'] to '{}' with subject '{}' and content={}", new Object[]{isMultipart, isHtml, to, subject, content});
        String[] bcc = this.bccEmailRecipients.split(",");
        MimeMessage mimeMessage = this.javaMailSender.createMimeMessage();
        try {
            MimeMessageHelper message = new MimeMessageHelper(mimeMessage, isMultipart, StandardCharsets.UTF_8.name());
            message.setTo(to);
            message.setBcc(bcc);
            message.setFrom(this.jHipsterProperties.getMail().getFrom());
            message.setSubject(subject);
            message.setText(content, isHtml);
            if (isMultipart) {
                message.addAttachment(fileName, inputStream, contentType);
            }
            this.javaMailSender.send(mimeMessage);
            this.log.info("Sent email to User '{}'", (Object)to.toString(), (Object)bcc.toString());
        }
        catch (MessagingException | MailException e) {
            this.log.error("Email could not be sent to user '{}'", new Object[]{to, bcc, e});
        }
    }

    @Async(value="taskExecutor")
    public void sendPasswordResetEmailLink(AppUser appUser, String timeZone, String passwordResetURL) {
        if (appUser.getEmail() == null) {
            this.log.debug("Email doesn't exist for user '{}'", (Object)appUser);
            return;
        }
        this.log.debug("Sending update user password email to '{}'", (Object)appUser.getEmail());
        Locale locale = Locale.forLanguageTag(this.defaultLanguage);
        Context context = new Context(locale);
        context.setVariable(USER, (Object)appUser);
        context.setVariable("date", (Object)timeZone);
        context.setVariable("passwordResetURL", (Object)passwordResetURL);
        context.setVariable("facebook", (Object)this.i18nUtility.getMessage("email.footer.logo.facebook", new Object[]{this.imageBasePath + this.uploadBasePath}));
        context.setVariable("instagram", (Object)this.i18nUtility.getMessage("email.footer.logo.instagram", new Object[]{this.imageBasePath + this.uploadBasePath}));
        context.setVariable("youtube", (Object)this.i18nUtility.getMessage("email.footer.logo.youtube", new Object[]{this.imageBasePath + this.uploadBasePath}));
        context.setVariable("linkedin", (Object)this.i18nUtility.getMessage("email.footer.logo.linkedin", new Object[]{this.imageBasePath + this.uploadBasePath}));
        context.setVariable("twitter", (Object)this.i18nUtility.getMessage("email.footer.logo.twitter", new Object[]{this.imageBasePath + this.uploadBasePath}));
        context.setVariable("header", (Object)this.i18nUtility.getMessage("email.header.image", new Object[]{this.imageBasePath + this.uploadBasePath}));
        context.setVariable("logo", (Object)this.i18nUtility.getMessage("email.footer.application.logo", new Object[]{this.imageBasePath + this.uploadBasePath}));
        context.setVariable("year", (Object)Calendar.getInstance().get(1));
        context.setVariable("facebookPageURL", (Object)this.i18nUtility.getMessage("email.footer.facebook.page", null));
        context.setVariable("instagramPageURL", (Object)this.i18nUtility.getMessage("email.footer.instagram.page", null));
        context.setVariable("youtubePageURL", (Object)this.i18nUtility.getMessage("email.footer.youtube.page", null));
        context.setVariable("linkedinPageURL", (Object)this.i18nUtility.getMessage("email.footer.linkedin.page", null));
        context.setVariable("twitterPageURL", (Object)this.i18nUtility.getMessage("email.footer.twitter.page", null));
        String templatePath = this.i18nUtility.getMessage("mail.template.path", null);
        this.sendEmailFromTemplate(new String[]{appUser.getEmail()}, templatePath + "/forgotPassword", "email.reset.title", context, new Object[]{this.i18nUtility.getMessage("email.signup.application.name", null)}, locale);
    }

    @Async(value="taskExecutor")
    public void sendSignUpEmail(AppUser appUser, String password) {
        if (appUser.getEmail() == null) {
            this.log.debug("Email doesn't exist for user '{}'", (Object)appUser);
            return;
        }
        this.log.debug("Sending signUp email to '{}'", (Object)appUser.getEmail());
        Locale locale = Locale.forLanguageTag(this.defaultLanguage);
        Context context = new Context(locale);
        context.setVariable(USER, (Object)appUser);
        context.setVariable("password", (Object)password);
        context.setVariable("facebook", (Object)this.i18nUtility.getMessage("email.footer.logo.facebook", new Object[]{this.imageBasePath + this.uploadBasePath}));
        context.setVariable("instagram", (Object)this.i18nUtility.getMessage("email.footer.logo.instagram", new Object[]{this.imageBasePath + this.uploadBasePath}));
        context.setVariable("youtube", (Object)this.i18nUtility.getMessage("email.footer.logo.youtube", new Object[]{this.imageBasePath + this.uploadBasePath}));
        context.setVariable("linkedin", (Object)this.i18nUtility.getMessage("email.footer.logo.linkedin", new Object[]{this.imageBasePath + this.uploadBasePath}));
        context.setVariable("twitter", (Object)this.i18nUtility.getMessage("email.footer.logo.twitter", new Object[]{this.imageBasePath + this.uploadBasePath}));
        context.setVariable("header", (Object)this.i18nUtility.getMessage("email.header.image", new Object[]{this.imageBasePath + this.uploadBasePath}));
        context.setVariable("logo", (Object)this.i18nUtility.getMessage("email.footer.application.logo", new Object[]{this.imageBasePath + this.uploadBasePath}));
        context.setVariable("year", (Object)Calendar.getInstance().get(1));
        context.setVariable("facebookPageURL", (Object)this.i18nUtility.getMessage("email.footer.facebook.page", null));
        context.setVariable("instagramPageURL", (Object)this.i18nUtility.getMessage("email.footer.instagram.page", null));
        context.setVariable("youtubePageURL", (Object)this.i18nUtility.getMessage("email.footer.youtube.page", null));
        context.setVariable("linkedinPageURL", (Object)this.i18nUtility.getMessage("email.footer.linkedin.page", null));
        context.setVariable("twitterPageURL", (Object)this.i18nUtility.getMessage("email.footer.twitter.page", null));
        context.setVariable("applicationName", (Object)this.i18nUtility.getMessage("email.signup.application.name", null));
        String templatePath = this.i18nUtility.getMessage("mail.template.path", null);
        this.sendEmailFromTemplate(new String[]{appUser.getEmail()}, templatePath + "/signUpEmail", "email.sign.up.title", context, new Object[]{this.i18nUtility.getMessage("email.signup.application.name", null)}, locale);
    }

    @Async(value="taskExecutor")
    public void sendUserupdatePasswordEmail(AppUser user, String password) {
        if (user.getEmail() == null) {
            this.log.debug("Email doesn't exist for user '{}'", (Object)user);
            return;
        }
        this.log.debug("Sending update user password email to '{}'", (Object)user.getEmail());
        Locale locale = Locale.forLanguageTag(this.defaultLanguage);
        Context context = new Context(locale);
        context.setVariable(USER, (Object)user);
        context.setVariable("password", (Object)password);
        String templatePath = this.i18nUtility.getMessage("mail.template.path", null);
        this.sendEmailFromTemplate(new String[]{user.getEmail()}, templatePath + "/updateUserPasswordEmail", "email.update.user.password.title", context, null, locale);
    }
}

