/*
 * Decompiled with CFR 0.152.
 */
package com.upl.fazorstarclub.service.utility;

import java.util.Locale;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.MessageSource;
import org.springframework.context.i18n.LocaleContextHolder;
import org.springframework.stereotype.Component;

@Component
public class I18nUtility {
    private final Logger log = LoggerFactory.getLogger(I18nUtility.class);
    private final MessageSource messageSource;
    @Value(value="${application.default-language:}")
    private String defaultLanguage;

    public I18nUtility(MessageSource messageSource) {
        this.messageSource = messageSource;
    }

    public String getMessage(String key, Object[] args) {
        this.log.debug("Request for key : {}", (Object)key);
        Locale locale = LocaleContextHolder.getLocale();
        String value = this.messageSource.getMessage(key, args, StringUtils.isBlank((CharSequence)locale.getCountry()) ? locale : Locale.forLanguageTag(this.defaultLanguage));
        return value;
    }

    public String getDefaultMessage(String key, Object[] args) {
        this.log.debug("Request for key : {}", (Object)key);
        Locale locale = Locale.forLanguageTag(this.defaultLanguage);
        String value = this.messageSource.getMessage(key, args, locale);
        return value;
    }

    public Locale getLocale() {
        return LocaleContextHolder.getLocale();
    }

    public Locale getDefaultLocale() {
        return Locale.forLanguageTag(this.defaultLanguage);
    }

    public static void main(String[] args) {
    }
}

