/*
 * Decompiled with CFR 0.152.
 */
package com.upl.fazorstarclub.service.utility;

import com.google.maps.GeoApiContext;
import com.google.maps.GeocodingApi;
import com.google.maps.errors.ApiException;
import com.google.maps.model.AddressComponent;
import com.google.maps.model.GeocodingResult;
import com.google.maps.model.LatLng;
import com.upl.fazorstarclub.service.utility.GeoUtility;
import java.io.IOException;
import java.math.BigDecimal;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import javax.annotation.PostConstruct;
import net.sf.geographiclib.Geodesic;
import net.sf.geographiclib.PolygonArea;
import net.sf.geographiclib.PolygonResult;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.scheduling.annotation.Async;
import org.springframework.stereotype.Component;

@Component
public class GeoUtility {
    private final Logger log = LoggerFactory.getLogger(GeoUtility.class);
    @Value(value="${application.google-geocode-api-key:}")
    private String googleGeocodeApiKey;
    private GeoApiContext geoApiContext;

    @PostConstruct
    private void initializeGeoApi() {
        if (StringUtils.isNotEmpty((CharSequence)this.googleGeocodeApiKey)) {
            this.geoApiContext = new GeoApiContext.Builder().apiKey(this.googleGeocodeApiKey).build();
        }
    }

    @Async(value="taskExecutor")
    public CompletableFuture<Location> getGeoLocationByAddress(String address) {
        Location location = new Location(this);
        if (address.contains("null")) {
            return CompletableFuture.completedFuture(location);
        }
        this.log.debug("Requested to address : {}", (Object)address);
        try {
            GeocodingResult[] results = (GeocodingResult[])GeocodingApi.geocode((GeoApiContext)this.geoApiContext, (String)address).await();
            if (results.length > 0) {
                GeocodingResult result = results[0];
                location.setLatitude(BigDecimal.valueOf(result.geometry.location.lat));
                location.setLongitude(BigDecimal.valueOf(result.geometry.location.lng));
                this.log.debug("Requested to address Lat:{} Lng:{}", (Object)location.getLatitude(), (Object)location.getLongitude());
            }
        }
        catch (ApiException | IOException | InterruptedException e) {
            this.log.error(e.getMessage());
        }
        return CompletableFuture.completedFuture(location);
    }

    @Async(value="taskExecutor")
    public CompletableFuture<Address> getAddressFromGeoLocation(double latitude, double longitude) {
        Address address = new Address(this);
        this.log.debug("Requested to lat lng : {}", (Object)(latitude + " " + longitude));
        try {
            GeocodingResult[] results = (GeocodingResult[])GeocodingApi.reverseGeocode((GeoApiContext)this.geoApiContext, (LatLng)new LatLng(latitude, longitude)).await();
            if (results.length > 0) {
                GeocodingResult result = results[0];
                AddressComponent[] addressComponents = result.addressComponents;
                for (int j = 0; j < addressComponents.length; ++j) {
                    if (addressComponents[j].types.length > 0) {
                        String type = addressComponents[j].types[0].name();
                        String value = addressComponents[j].longName;
                        if ("administrative_area_level_1".equalsIgnoreCase(type)) {
                            address.setState(value);
                            continue;
                        }
                        if ("administrative_area_level_2".equalsIgnoreCase(type)) {
                            address.setDistrict(value);
                            continue;
                        }
                        if ("country".equalsIgnoreCase(type)) {
                            address.setCountry(value);
                            continue;
                        }
                        if ("postal_code".equalsIgnoreCase(type)) {
                            address.setPostalCode(value);
                            continue;
                        }
                        if ("route".equalsIgnoreCase(type) || "bus_station".equalsIgnoreCase(type)) {
                            address.setStreet(value);
                            continue;
                        }
                        if ("sublocality".equalsIgnoreCase(type)) {
                            address.setVillage(value);
                            continue;
                        }
                        if (!"locality".equalsIgnoreCase(type)) continue;
                        address.setVillage(value);
                        address.setTown(value);
                        continue;
                    }
                    this.log.error("Unable to fetch address {}.", (Object)(latitude + " " + longitude));
                }
            } else {
                this.log.error("Unable to fetch address {}.", (Object)(latitude + " " + longitude));
            }
        }
        catch (ApiException | IOException | InterruptedException e) {
            this.log.error(e.getMessage());
        }
        return CompletableFuture.completedFuture(address);
    }

    public double getDistance(double lat1, double lat2, double lon1, double lon2) {
        int R = 6371;
        double latDistance = Math.toRadians(lat2 - lat1);
        double lonDistance = Math.toRadians(lon2 - lon1);
        double a = Math.sin(latDistance / 2.0) * Math.sin(latDistance / 2.0) + Math.cos(Math.toRadians(lat1)) * Math.cos(Math.toRadians(lat2)) * Math.sin(lonDistance / 2.0) * Math.sin(lonDistance / 2.0);
        double c = 2.0 * Math.atan2(Math.sqrt(a), Math.sqrt(1.0 - a));
        double distance = 6371.0 * c * 1000.0;
        double height = 0.0;
        distance = Math.pow(distance, 2.0) + Math.pow(height, 2.0);
        return Math.sqrt(distance) / 1000.0;
    }

    public double polygonArea(List<Double> latitude, List<Double> longitude, int vertices) {
        PolygonArea p = new PolygonArea(Geodesic.WGS84, false);
        for (int i = 0; i < vertices; ++i) {
            p.AddPoint(latitude.get(i).doubleValue(), longitude.get(i).doubleValue());
        }
        PolygonResult r = p.Compute();
        return Math.abs(r.area);
    }
}

