/*
 * Decompiled with CFR 0.152.
 */
package com.upl.fazorstarclub.service.utility;

import com.upl.fazorstarclub.service.utility.GeoUtility;
import java.math.BigDecimal;
import java.util.concurrent.Callable;
import java.util.concurrent.CompletableFuture;

public class GeoLocationTask
implements Callable<Double> {
    private GeoUtility geoUtility;
    private String stateName;
    private String countryName;
    private BigDecimal latitude;
    private BigDecimal longitude;

    public GeoLocationTask(GeoUtility geoUtility, String stateName, String countryName, BigDecimal latitude, BigDecimal longitude) {
        this.geoUtility = geoUtility;
        this.stateName = stateName;
        this.countryName = countryName;
        this.latitude = latitude;
        this.longitude = longitude;
    }

    @Override
    public Double call() throws Exception {
        Double distance = null;
        StringBuilder address = new StringBuilder();
        address.append(this.stateName).append(",").append(this.countryName);
        CompletableFuture locationFuture = this.geoUtility.getGeoLocationByAddress(address.toString());
        if (((GeoUtility.Location)locationFuture.get()).getLatitude() != null && ((GeoUtility.Location)locationFuture.get()).getLongitude() != null) {
            distance = this.geoUtility.getDistance(this.latitude.doubleValue(), ((GeoUtility.Location)locationFuture.get()).getLatitude().doubleValue(), this.longitude.doubleValue(), ((GeoUtility.Location)locationFuture.get()).getLatitude().doubleValue());
        }
        return distance;
    }
}

