/*
 * Decompiled with CFR 0.152.
 */
package com.upl.fazorstarclub.service.utility;

import com.amazonaws.AmazonClientException;
import com.amazonaws.ClientConfiguration;
import com.amazonaws.auth.AWSCredentials;
import com.amazonaws.auth.AWSCredentialsProvider;
import com.amazonaws.auth.AWSStaticCredentialsProvider;
import com.amazonaws.auth.BasicAWSCredentials;
import com.amazonaws.regions.Regions;
import com.amazonaws.services.s3.AmazonS3;
import com.amazonaws.services.s3.AmazonS3ClientBuilder;
import com.amazonaws.services.s3.model.DeleteObjectRequest;
import com.amazonaws.services.s3.model.S3Object;
import com.amazonaws.services.s3.model.S3ObjectInputStream;
import com.upl.fazorstarclub.service.exception.BadRequestException;
import com.upl.fazorstarclub.service.utility.AmazonUtility;
import com.upl.fazorstarclub.service.utility.I18nUtility;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Date;
import javax.annotation.PostConstruct;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Component;
import org.springframework.web.multipart.MultipartFile;

@Component
public class AmazonUtility {
    private final Logger log = LoggerFactory.getLogger(AmazonUtility.class);
    @Value(value="${application.aws.s3.region:}")
    private String region;
    @Value(value="${application.aws.s3.bucketName:}")
    private String bucketName;
    @Value(value="${application.aws.s3.secretKey:}")
    private String secretKey;
    @Value(value="${application.aws.s3.accessKey:}")
    private String accessKey;
    @Value(value="${application.upload-base-path:}")
    private String uploadBasePath;
    @Value(value="${application.image-base-path:}")
    private String imageBasePath;
    @Value(value="${application.video-base-path:}")
    private String videoBasePath;
    @Value(value="${application.allowed-image-content-types:}")
    private String allowedImageContentTypes;
    @Value(value="${application.aws.s3.maxConnections:}")
    private Integer maxConnections;
    private AmazonS3 s3client;
    @Autowired
    private I18nUtility i18nUtility;

    @PostConstruct
    private void initializeAmazon() {
        if (StringUtils.isNotEmpty((CharSequence)this.accessKey) && StringUtils.isNotEmpty((CharSequence)this.secretKey) && StringUtils.isNotEmpty((CharSequence)this.region)) {
            ClientConfiguration clientConfiguration = new ClientConfiguration();
            clientConfiguration.setMaxConnections(this.maxConnections.intValue());
            BasicAWSCredentials credentials = new BasicAWSCredentials(this.accessKey, this.secretKey);
            this.s3client = (AmazonS3)((AmazonS3ClientBuilder)((AmazonS3ClientBuilder)((AmazonS3ClientBuilder)AmazonS3ClientBuilder.standard().withRegion(Regions.fromName((String)this.region))).withClientConfiguration(clientConfiguration)).withCredentials((AWSCredentialsProvider)new AWSStaticCredentialsProvider((AWSCredentials)credentials))).build();
        }
    }

    public String uploadFile(MultipartFile multipartFile, String directory) {
        File file = null;
        try {
            file = this.convertMultiPartToFile(multipartFile);
            String fileName = this.generateFileName(multipartFile, this.uploadBasePath + "/" + directory);
            this.uploadFileTos3bucket(fileName, file);
            this.log.debug("Uploaded " + fileName + " to the bucket.");
            if (multipartFile.getContentType().contains("video")) {
                String string = this.videoBasePath + fileName;
                return string;
            }
            String string = this.imageBasePath + fileName;
            return string;
        }
        catch (Exception e) {
            this.log.error("Error while uploading file to S3 bucket {}", (Throwable)e);
            throw new BadRequestException("Something went wrong. Please try again later");
        }
        finally {
            file.delete();
        }
    }

    public File convertMultiPartToFile(MultipartFile file) throws IOException {
        File convFile = new File(file.getOriginalFilename());
        FileOutputStream fos = new FileOutputStream(convFile);
        fos.write(file.getBytes());
        fos.close();
        return convFile;
    }

    private String generateFileName(MultipartFile multiPart, String directory) {
        return directory + "/" + new Date().getTime() + "-" + multiPart.getOriginalFilename().replace(" ", "_");
    }

    private void uploadFileTos3bucket(String fileName, File file) {
        this.s3client.putObject(this.bucketName, fileName, file);
    }

    public String moveFile(String sourcePath, String destinationPath) {
        String privateS3Path = this.getPrivateS3Path(sourcePath);
        this.s3client.copyObject(this.bucketName, privateS3Path, this.bucketName, this.uploadBasePath + "/" + destinationPath);
        this.deleteFileFromS3Bucket(privateS3Path);
        String filePath = (sourcePath.contains(this.imageBasePath) ? this.imageBasePath : this.videoBasePath) + "" + this.uploadBasePath + "/" + destinationPath;
        return filePath;
    }

    public boolean deleteFileFromS3Bucket(String fileName) {
        this.log.debug("deleting file " + fileName + " from the bucket.");
        fileName = this.getPrivateS3Path(fileName);
        this.s3client.deleteObject(new DeleteObjectRequest(this.bucketName, fileName));
        this.log.debug("deleted file " + fileName + " from the bucket.");
        return true;
    }

    public ImageResponse getFileFromS3Bucket(String fileName) {
        ByteArrayInputStream is = null;
        S3Object s3Obj = null;
        try {
            ImageResponse imageResponse;
            block16: {
                s3Obj = this.s3client.getObject(this.bucketName, fileName);
                S3ObjectInputStream stream = s3Obj.getObjectContent();
                try {
                    ByteArrayOutputStream temp = new ByteArrayOutputStream();
                    IOUtils.copy((InputStream)stream, (OutputStream)temp);
                    is = new ByteArrayInputStream(temp.toByteArray());
                    String contentType = s3Obj.getObjectMetadata().getContentType();
                    Long contentSize = s3Obj.getObjectMetadata().getContentLength();
                    imageResponse = new ImageResponse(this, (InputStream)is, contentType, contentSize);
                    if (stream == null) break block16;
                }
                catch (Throwable temp) {
                    try {
                        if (stream != null) {
                            try {
                                stream.close();
                            }
                            catch (Throwable throwable) {
                                temp.addSuppressed(throwable);
                            }
                        }
                        throw temp;
                    }
                    catch (AmazonClientException | IOException ex) {
                        this.log.error(ex.getMessage(), ex);
                        String message = this.i18nUtility.getMessage("amazon.get.file.from.S3.bucket.exception", null);
                        throw new BadRequestException(message);
                    }
                }
                stream.close();
            }
            return imageResponse;
        }
        finally {
            if (s3Obj != null) {
                try {
                    s3Obj.close();
                }
                catch (IOException e) {
                    this.log.error("Unable to close S3 object: {}", (Object)e.getMessage(), (Object)e);
                }
            }
        }
    }

    public String getPublicS3Path(String key) {
        return this.imageBasePath + key;
    }

    public String getPrivateS3Path(String key) {
        String[] splits;
        if (key != null && (key.contains(this.imageBasePath) || key.contains(this.videoBasePath)) && (splits = key.split(key.contains(this.imageBasePath) ? this.imageBasePath : this.videoBasePath)).length > 1) {
            key = splits[1];
        }
        return key;
    }
}

