/*
 * Decompiled with CFR 0.152.
 */
package com.upl.fazorstarclub.service.mapper;

import com.upl.fazorstarclub.domain.AppUser;
import com.upl.fazorstarclub.domain.Country;
import com.upl.fazorstarclub.domain.Irrigation;
import com.upl.fazorstarclub.domain.PreviousCrop;
import com.upl.fazorstarclub.domain.SeedVariety;
import com.upl.fazorstarclub.domain.State;
import com.upl.fazorstarclub.domain.UserFarm;
import com.upl.fazorstarclub.service.dto.PreviousCropDTO;
import com.upl.fazorstarclub.service.dto.SeedVarietyDTO;
import com.upl.fazorstarclub.service.dto.UserFarmDTO;
import com.upl.fazorstarclub.service.mapper.IrrigationMapper;
import com.upl.fazorstarclub.service.mapper.PreviousCropMapper;
import com.upl.fazorstarclub.service.mapper.SeedVarietyMapper;
import com.upl.fazorstarclub.service.mapper.UserFarmMapper;
import java.util.ArrayList;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class UserFarmMapperImpl
implements UserFarmMapper {
    @Autowired
    private SeedVarietyMapper seedVarietyMapper;
    @Autowired
    private PreviousCropMapper previousCropMapper;
    @Autowired
    private IrrigationMapper irrigationMapper;

    public List<UserFarm> toEntity(List<UserFarmDTO> dtoList) {
        if (dtoList == null) {
            return null;
        }
        ArrayList<UserFarm> list = new ArrayList<UserFarm>(dtoList.size());
        for (UserFarmDTO userFarmDTO : dtoList) {
            list.add(this.toEntity(userFarmDTO));
        }
        return list;
    }

    public List<UserFarmDTO> toDto(List<UserFarm> entityList) {
        if (entityList == null) {
            return null;
        }
        ArrayList<UserFarmDTO> list = new ArrayList<UserFarmDTO>(entityList.size());
        for (UserFarm userFarm : entityList) {
            list.add(this.toDto(userFarm));
        }
        return list;
    }

    public UserFarmDTO toDto(UserFarm userFarm) {
        if (userFarm == null) {
            return null;
        }
        UserFarmDTO userFarmDTO = new UserFarmDTO();
        userFarmDTO.setCountryId(this.userFarmCountryId(userFarm));
        userFarmDTO.setStateId(this.userFarmStateId(userFarm));
        userFarmDTO.setCountryName(this.userFarmCountryName(userFarm));
        userFarmDTO.setStateName(this.userFarmStateName(userFarm));
        userFarmDTO.setAppUserId(this.userFarmAppUserId(userFarm));
        userFarmDTO.setCreatedBy(userFarm.getCreatedBy());
        userFarmDTO.setCreatedDate(userFarm.getCreatedDate());
        userFarmDTO.setLastModifiedBy(userFarm.getLastModifiedBy());
        userFarmDTO.setLastModifiedDate(userFarm.getLastModifiedDate());
        userFarmDTO.setId(userFarm.getId());
        userFarmDTO.setPlantingDate(userFarm.getPlantingDate());
        userFarmDTO.setPlotName(userFarm.getPlotName());
        userFarmDTO.setLatitude(userFarm.getLatitude());
        userFarmDTO.setLongitude(userFarm.getLongitude());
        userFarmDTO.setInterRow(userFarm.getInterRow());
        userFarmDTO.setDistributorName(userFarm.getDistributorName());
        userFarmDTO.setMarketType(this.MarketTypeEnumToString(userFarm.getMarketType()));
        userFarmDTO.setTypeOfSoil(this.TypeOfSoilEnumToString(userFarm.getTypeOfSoil()));
        userFarmDTO.setSeedVariety((SeedVarietyDTO)this.seedVarietyMapper.toDto((Object)userFarm.getSeedVariety()));
        userFarmDTO.setPreviousCrop((PreviousCropDTO)this.previousCropMapper.toDto((Object)userFarm.getPreviousCrop()));
        userFarmDTO.setIrrigation(this.irrigationMapper.toDto(userFarm.getIrrigation()));
        userFarmDTO.setPincode(userFarm.getPincode());
        userFarmDTO.setCity(userFarm.getCity());
        userFarmDTO.setStreet(userFarm.getStreet());
        userFarmDTO.setDistrict(userFarm.getDistrict());
        userFarmDTO.setStatus(userFarm.getStatus());
        return userFarmDTO;
    }

    public UserFarm toEntity(UserFarmDTO userFarm) {
        if (userFarm == null) {
            return null;
        }
        UserFarm userFarm1 = new UserFarm();
        userFarm1.setCountry(this.userFarmDTOToCountry(userFarm));
        userFarm1.setState(this.userFarmDTOToState(userFarm));
        userFarm1.setAppUser(this.userFarmDTOToAppUser(userFarm));
        userFarm1.setCreatedBy(userFarm.getCreatedBy());
        userFarm1.setCreatedDate(userFarm.getCreatedDate());
        userFarm1.setLastModifiedBy(userFarm.getLastModifiedBy());
        userFarm1.setLastModifiedDate(userFarm.getLastModifiedDate());
        userFarm1.setId(userFarm.getId());
        userFarm1.setPlantingDate(userFarm.getPlantingDate());
        userFarm1.setPlotName(userFarm.getPlotName());
        userFarm1.setLatitude(userFarm.getLatitude());
        userFarm1.setLongitude(userFarm.getLongitude());
        userFarm1.setInterRow(userFarm.getInterRow());
        userFarm1.setDistributorName(userFarm.getDistributorName());
        userFarm1.setMarketType(this.MarketTypeStringToEnum(userFarm.getMarketType()));
        userFarm1.setTypeOfSoil(this.TypeOfSoilStringToEnum(userFarm.getTypeOfSoil()));
        userFarm1.seedVariety((SeedVariety)this.seedVarietyMapper.toEntity((Object)userFarm.getSeedVariety()));
        userFarm1.previousCrop((PreviousCrop)this.previousCropMapper.toEntity((Object)userFarm.getPreviousCrop()));
        userFarm1.irrigation((Irrigation)this.irrigationMapper.toEntity((Object)userFarm.getIrrigation()));
        userFarm1.setStatus(userFarm.getStatus());
        userFarm1.setPincode(userFarm.getPincode());
        userFarm1.setCity(userFarm.getCity());
        userFarm1.setStreet(userFarm.getStreet());
        userFarm1.setDistrict(userFarm.getDistrict());
        return userFarm1;
    }

    private Long userFarmCountryId(UserFarm userFarm) {
        if (userFarm == null) {
            return null;
        }
        Country country = userFarm.getCountry();
        if (country == null) {
            return null;
        }
        Long id = country.getId();
        if (id == null) {
            return null;
        }
        return id;
    }

    private Long userFarmStateId(UserFarm userFarm) {
        if (userFarm == null) {
            return null;
        }
        State state = userFarm.getState();
        if (state == null) {
            return null;
        }
        Long id = state.getId();
        if (id == null) {
            return null;
        }
        return id;
    }

    private String userFarmCountryName(UserFarm userFarm) {
        if (userFarm == null) {
            return null;
        }
        Country country = userFarm.getCountry();
        if (country == null) {
            return null;
        }
        String name = country.getName();
        if (name == null) {
            return null;
        }
        return name;
    }

    private String userFarmStateName(UserFarm userFarm) {
        if (userFarm == null) {
            return null;
        }
        State state = userFarm.getState();
        if (state == null) {
            return null;
        }
        String name = state.getName();
        if (name == null) {
            return null;
        }
        return name;
    }

    private Long userFarmAppUserId(UserFarm userFarm) {
        if (userFarm == null) {
            return null;
        }
        AppUser appUser = userFarm.getAppUser();
        if (appUser == null) {
            return null;
        }
        Long id = appUser.getId();
        if (id == null) {
            return null;
        }
        return id;
    }

    protected Country userFarmDTOToCountry(UserFarmDTO userFarmDTO) {
        if (userFarmDTO == null) {
            return null;
        }
        Country country = new Country();
        country.setId(userFarmDTO.getCountryId());
        return country;
    }

    protected State userFarmDTOToState(UserFarmDTO userFarmDTO) {
        if (userFarmDTO == null) {
            return null;
        }
        State state = new State();
        state.setId(userFarmDTO.getStateId());
        return state;
    }

    protected AppUser userFarmDTOToAppUser(UserFarmDTO userFarmDTO) {
        if (userFarmDTO == null) {
            return null;
        }
        AppUser appUser = new AppUser();
        appUser.setId(userFarmDTO.getAppUserId());
        return appUser;
    }
}

