/*
 * Decompiled with CFR 0.152.
 */
package com.upl.fazorstarclub.service.mapper;

import com.upl.fazorstarclub.domain.Topic;
import com.upl.fazorstarclub.domain.TopicImage;
import com.upl.fazorstarclub.service.dto.TopicDTO;
import com.upl.fazorstarclub.service.dto.TopicImageDTO;
import com.upl.fazorstarclub.service.mapper.TopicImageMapper;
import com.upl.fazorstarclub.service.mapper.TopicMapper;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class TopicMapperImpl
implements TopicMapper {
    @Autowired
    private TopicImageMapper topicImageMapper;

    public List<Topic> toEntity(List<TopicDTO> dtoList) {
        if (dtoList == null) {
            return null;
        }
        ArrayList<Topic> list = new ArrayList<Topic>(dtoList.size());
        for (TopicDTO topicDTO : dtoList) {
            list.add(this.toEntity(topicDTO));
        }
        return list;
    }

    public List<TopicDTO> toDto(List<Topic> entityList) {
        if (entityList == null) {
            return null;
        }
        ArrayList<TopicDTO> list = new ArrayList<TopicDTO>(entityList.size());
        for (Topic topic : entityList) {
            list.add(this.toDto(topic));
        }
        return list;
    }

    public TopicDTO toDto(Topic topic) {
        if (topic == null) {
            return null;
        }
        TopicDTO topicDTO = new TopicDTO();
        topicDTO.setCreatedBy(topic.getCreatedBy());
        topicDTO.setCreatedDate(topic.getCreatedDate());
        topicDTO.setLastModifiedBy(topic.getLastModifiedBy());
        topicDTO.setLastModifiedDate(topic.getLastModifiedDate());
        topicDTO.setId(topic.getId());
        topicDTO.setStatus(topic.getStatus());
        topicDTO.setTopicName(topic.getTopicName());
        topicDTO.setDescription(topic.getDescription());
        topicDTO.setTopicCategory(this.EnumToString(topic.getTopicCategory()));
        topicDTO.setTopicImages(this.topicImageSetToTopicImageDTOList(topic.getTopicImages()));
        return topicDTO;
    }

    public Topic toEntity(TopicDTO topicDTO) {
        if (topicDTO == null) {
            return null;
        }
        Topic topic = new Topic();
        topic.setCreatedBy(topicDTO.getCreatedBy());
        topic.setCreatedDate(topicDTO.getCreatedDate());
        topic.setLastModifiedBy(topicDTO.getLastModifiedBy());
        topic.setLastModifiedDate(topicDTO.getLastModifiedDate());
        topic.setId(topicDTO.getId());
        topic.setStatus(topicDTO.getStatus());
        topic.setTopicName(topicDTO.getTopicName());
        topic.setDescription(topicDTO.getDescription());
        topic.setTopicCategory(this.StringToEnum(topicDTO.getTopicCategory()));
        topic.topicImages(this.topicImageDTOListToTopicImageSet(topicDTO.getTopicImages()));
        return topic;
    }

    protected List<TopicImageDTO> topicImageSetToTopicImageDTOList(Set<TopicImage> set) {
        if (set == null) {
            return null;
        }
        ArrayList<TopicImageDTO> list = new ArrayList<TopicImageDTO>(set.size());
        for (TopicImage topicImage : set) {
            list.add(this.topicImageMapper.toDto(topicImage));
        }
        return list;
    }

    protected Set<TopicImage> topicImageDTOListToTopicImageSet(List<TopicImageDTO> list) {
        if (list == null) {
            return null;
        }
        HashSet<TopicImage> set = new HashSet<TopicImage>(Math.max((int)((float)list.size() / 0.75f) + 1, 16));
        for (TopicImageDTO topicImageDTO : list) {
            set.add(this.topicImageMapper.toEntity(topicImageDTO));
        }
        return set;
    }
}

