/*
 * Decompiled with CFR 0.152.
 */
package com.upl.fazorstarclub.service.mapper;

import com.upl.fazorstarclub.domain.Country;
import com.upl.fazorstarclub.domain.State;
import com.upl.fazorstarclub.service.dto.StateDTO;
import com.upl.fazorstarclub.service.mapper.CountryMapper;
import com.upl.fazorstarclub.service.mapper.StateMapper;
import java.util.ArrayList;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class StateMapperImpl
implements StateMapper {
    @Autowired
    private CountryMapper countryMapper;

    public List<State> toEntity(List<StateDTO> dtoList) {
        if (dtoList == null) {
            return null;
        }
        ArrayList<State> list = new ArrayList<State>(dtoList.size());
        for (StateDTO stateDTO : dtoList) {
            list.add(this.toEntity(stateDTO));
        }
        return list;
    }

    public List<StateDTO> toDto(List<State> entityList) {
        if (entityList == null) {
            return null;
        }
        ArrayList<StateDTO> list = new ArrayList<StateDTO>(entityList.size());
        for (State state : entityList) {
            list.add(this.toDto(state));
        }
        return list;
    }

    public StateDTO toDto(State state) {
        if (state == null) {
            return null;
        }
        StateDTO stateDTO = new StateDTO();
        stateDTO.setCountryId(this.stateCountryId(state));
        stateDTO.setId(state.getId());
        stateDTO.setName(state.getName());
        stateDTO.setCode(state.getCode());
        stateDTO.setStatus(state.getStatus());
        return stateDTO;
    }

    public State toEntity(StateDTO stateDTO) {
        if (stateDTO == null) {
            return null;
        }
        State state = new State();
        state.country(this.countryMapper.fromId(stateDTO.getCountryId()));
        state.setId(stateDTO.getId());
        state.setName(stateDTO.getName());
        state.setCode(stateDTO.getCode());
        state.setStatus(stateDTO.getStatus());
        return state;
    }

    private Long stateCountryId(State state) {
        if (state == null) {
            return null;
        }
        Country country = state.getCountry();
        if (country == null) {
            return null;
        }
        Long id = country.getId();
        if (id == null) {
            return null;
        }
        return id;
    }
}

