/*
 * Decompiled with CFR 0.152.
 */
package com.upl.fazorstarclub.service.mapper;

import com.upl.fazorstarclub.domain.MasterPest;
import com.upl.fazorstarclub.domain.Pest;
import com.upl.fazorstarclub.domain.UserFarm;
import com.upl.fazorstarclub.service.dto.MasterPestDTO;
import com.upl.fazorstarclub.service.dto.PestDTO;
import com.upl.fazorstarclub.service.mapper.MasterPestMapper;
import com.upl.fazorstarclub.service.mapper.PestMapper;
import java.util.ArrayList;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class PestMapperImpl
implements PestMapper {
    @Autowired
    private MasterPestMapper masterPestMapper;

    public List<Pest> toEntity(List<PestDTO> dtoList) {
        if (dtoList == null) {
            return null;
        }
        ArrayList<Pest> list = new ArrayList<Pest>(dtoList.size());
        for (PestDTO pestDTO : dtoList) {
            list.add(this.toEntity(pestDTO));
        }
        return list;
    }

    public List<PestDTO> toDto(List<Pest> entityList) {
        if (entityList == null) {
            return null;
        }
        ArrayList<PestDTO> list = new ArrayList<PestDTO>(entityList.size());
        for (Pest pest : entityList) {
            list.add(this.toDto(pest));
        }
        return list;
    }

    public PestDTO toDto(Pest pest) {
        if (pest == null) {
            return null;
        }
        PestDTO pestDTO = new PestDTO();
        pestDTO.setUserFarmId(this.pestUserFarmId(pest));
        pestDTO.setCreatedBy(pest.getCreatedBy());
        pestDTO.setCreatedDate(pest.getCreatedDate());
        pestDTO.setLastModifiedBy(pest.getLastModifiedBy());
        pestDTO.setLastModifiedDate(pest.getLastModifiedDate());
        pestDTO.setId(pest.getId());
        pestDTO.setName(pest.getName());
        pestDTO.setStatus(pest.getStatus());
        pestDTO.setLevelOfPressure(this.EnumToString(pest.getLevelOfPressure()));
        pestDTO.setMasterPest((MasterPestDTO)this.masterPestMapper.toDto((Object)pest.getMasterPest()));
        pestDTO.setLatitude(pest.getLatitude());
        pestDTO.setLongitude(pest.getLongitude());
        return pestDTO;
    }

    public Pest toEntity(PestDTO pestDTO) {
        if (pestDTO == null) {
            return null;
        }
        Pest pest = new Pest();
        pest.userFarm(this.pestDTOToUserFarm(pestDTO));
        pest.setCreatedBy(pestDTO.getCreatedBy());
        pest.setCreatedDate(pestDTO.getCreatedDate());
        pest.setLastModifiedBy(pestDTO.getLastModifiedBy());
        pest.setLastModifiedDate(pestDTO.getLastModifiedDate());
        pest.setId(pestDTO.getId());
        pest.setName(pestDTO.getName());
        pest.setStatus(pestDTO.getStatus());
        pest.setLatitude(pestDTO.getLatitude());
        pest.setLongitude(pestDTO.getLongitude());
        pest.setLevelOfPressure(this.StringToEnum(pestDTO.getLevelOfPressure()));
        pest.masterPest((MasterPest)this.masterPestMapper.toEntity((Object)pestDTO.getMasterPest()));
        return pest;
    }

    private Long pestUserFarmId(Pest pest) {
        if (pest == null) {
            return null;
        }
        UserFarm userFarm = pest.getUserFarm();
        if (userFarm == null) {
            return null;
        }
        Long id = userFarm.getId();
        if (id == null) {
            return null;
        }
        return id;
    }

    protected UserFarm pestDTOToUserFarm(PestDTO pestDTO) {
        if (pestDTO == null) {
            return null;
        }
        UserFarm userFarm = new UserFarm();
        userFarm.setId(pestDTO.getUserFarmId());
        return userFarm;
    }
}

